
//Change this to true for a stretchy canvas!
//
var RESIZEABLE_CANVAS=false;

//Start us up!
//
window.onload=function( e ){

	if( RESIZEABLE_CANVAS ){
		window.onresize=function( e ){
			var canvas=document.getElementById( "GameCanvas" );

			//This vs window.innerWidth, which apparently doesn't account for scrollbar?
			var width=document.body.clientWidth;
			
			//This vs document.body.clientHeight, which does weird things - document seems to 'grow'...perhaps canvas resize pushing page down?
			var height=window.innerHeight;			

			canvas.width=width;
			canvas.height=height;
		}
		window.onresize( null );
	}

	BBMonkeyGame.Main( document.getElementById( "GameCanvas" ) );
}

//${CONFIG_BEGIN}
CFG_BINARY_FILES="*.bin|*.dat";
CFG_BRL_GAMETARGET_IMPLEMENTED="1";
CFG_BRL_THREAD_IMPLEMENTED="1";
CFG_CD="";
CFG_CONFIG="debug";
CFG_HOST="linux";
CFG_IMAGE_FILES="*.png|*.jpg";
CFG_LANG="js";
CFG_MODPATH=".;/root/Dropbox/monkeygames/spriter;/root/Dropbox/Monkey/modules;/root/Dropbox/Monkey/targets/html5/modules";
CFG_MOJO_AUTO_SUSPEND_ENABLED="0";
CFG_MONKEYDIR="";
CFG_MUSIC_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_OPENGL_GLES20_ENABLED="0";
CFG_SAFEMODE="0";
CFG_SOUND_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_TARGET="html5";
CFG_TEXT_FILES="*.txt|*.xml|*.json";
CFG_TRANSDIR="";
//${CONFIG_END}

//${METADATA_BEGIN}
var META_DATA="[mojo_font.png];type=image/png;width=864;height=13;\n[arialblack.png];type=image/png;width=128;height=128;\n[black.png];type=image/png;width=16;height=16;\n[blue.png];type=image/png;width=16;height=16;\n[bluedark.png];type=image/png;width=16;height=16;\n[cyan.png];type=image/png;width=16;height=16;\n[cyandark.png];type=image/png;width=16;height=16;\n[green.png];type=image/png;width=16;height=16;\n[greendark.png];type=image/png;width=16;height=16;\n[guiskin/border.png];type=image/png;width=32;height=32;\n[guiskin/button.png];type=image/png;width=128;height=32;\n[guiskin/buttonfiber.png];type=image/png;width=128;height=32;\n[guiskin/buttonleather.png];type=image/png;width=128;height=32;\n[guiskin/buttonpressed.png];type=image/png;width=128;height=32;\n[guiskin/downarrow.png];type=image/png;width=25;height=25;\n[guiskin/paper.png];type=image/png;width=128;height=128;\n[guiskin/uparrow.png];type=image/png;width=25;height=25;\n[guiskin/window.png];type=image/png;width=128;height=128;\n[magenta.png];type=image/png;width=16;height=16;\n[magentadark.png];type=image/png;width=16;height=16;\n[mediumarial.png];type=image/png;width=256;height=128;\n[red.png];type=image/png;width=16;height=16;\n[reddark.png];type=image/png;width=16;height=16;\n[white.png];type=image/png;width=16;height=16;\n[whitedark.png];type=image/png;width=16;height=16;\n[yellow.png];type=image/png;width=16;height=16;\n[yellowdark.png];type=image/png;width=16;height=16;\n";
//${METADATA_END}

//${TRANSCODE_BEGIN}

// Javascript Monkey runtime.
//
// Placed into the public domain 24/02/2011.
// No warranty implied; use at your own risk.

//***** JavaScript Runtime *****

var D2R=0.017453292519943295;
var R2D=57.29577951308232;

var err_info="";
var err_stack=[];

var dbg_index=0;

function push_err(){
	err_stack.push( err_info );
}

function pop_err(){
	err_info=err_stack.pop();
}

function stackTrace(){
	if( !err_info.length ) return "";
	var str=err_info+"\n";
	for( var i=err_stack.length-1;i>0;--i ){
		str+=err_stack[i]+"\n";
	}
	return str;
}

function print( str ){
	var cons=document.getElementById( "GameConsole" );
	if( cons ){
		cons.value+=str+"\n";
		cons.scrollTop=cons.scrollHeight-cons.clientHeight;
	}else if( window.console!=undefined ){
		window.console.log( str );
	}
	return 0;
}

function alertError( err ){
	if( typeof(err)=="string" && err=="" ) return;
	alert( "Monkey Runtime Error : "+err.toString()+"\n\n"+stackTrace() );
}

function error( err ){
	throw err;
}

function debugLog( str ){
	print( str );
}

function debugStop(){
	error( "STOP" );
}

function dbg_object( obj ){
	if( obj ) return obj;
	error( "Null object access" );
}

function dbg_array( arr,index ){
	if( index<0 || index>=arr.length ) error( "Array index out of range" );
	dbg_index=index;
	return arr;
}

function new_bool_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=false;
	return arr;
}

function new_number_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=0;
	return arr;
}

function new_string_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]='';
	return arr;
}

function new_array_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=[];
	return arr;
}

function new_object_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=null;
	return arr;
}

function resize_bool_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=false;
	return arr;
}

function resize_number_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=0;
	return arr;
}

function resize_string_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]="";
	return arr;
}

function resize_array_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=[];
	return arr;
}

function resize_object_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=null;
	return arr;
}

function string_compare( lhs,rhs ){
	var n=Math.min( lhs.length,rhs.length ),i,t;
	for( i=0;i<n;++i ){
		t=lhs.charCodeAt(i)-rhs.charCodeAt(i);
		if( t ) return t;
	}
	return lhs.length-rhs.length;
}

function string_replace( str,find,rep ){	//no unregex replace all?!?
	var i=0;
	for(;;){
		i=str.indexOf( find,i );
		if( i==-1 ) return str;
		str=str.substring( 0,i )+rep+str.substring( i+find.length );
		i+=rep.length;
	}
}

function string_trim( str ){
	var i=0,i2=str.length;
	while( i<i2 && str.charCodeAt(i)<=32 ) i+=1;
	while( i2>i && str.charCodeAt(i2-1)<=32 ) i2-=1;
	return str.slice( i,i2 );
}

function string_startswith( str,substr ){
	return substr.length<=str.length && str.slice(0,substr.length)==substr;
}

function string_endswith( str,substr ){
	return substr.length<=str.length && str.slice(str.length-substr.length,str.length)==substr;
}

function string_tochars( str ){
	var arr=new Array( str.length );
	for( var i=0;i<str.length;++i ) arr[i]=str.charCodeAt(i);
	return arr;
}

function string_fromchars( chars ){
	var str="",i;
	for( i=0;i<chars.length;++i ){
		str+=String.fromCharCode( chars[i] );
	}
	return str;
}

function object_downcast( obj,clas ){
	if( obj instanceof clas ) return obj;
	return null;
}

function object_implements( obj,iface ){
	if( obj && obj.implments && obj.implments[iface] ) return obj;
	return null;
}

function extend_class( clas ){
	var tmp=function(){};
	tmp.prototype=clas.prototype;
	return new tmp;
}

function ThrowableObject(){
}

ThrowableObject.prototype.toString=function(){ 
	return "Uncaught Monkey Exception"; 
}

function BBGameEvent(){}
BBGameEvent.KeyDown=1;
BBGameEvent.KeyUp=2;
BBGameEvent.KeyChar=3;
BBGameEvent.MouseDown=4;
BBGameEvent.MouseUp=5;
BBGameEvent.MouseMove=6;
BBGameEvent.TouchDown=7;
BBGameEvent.TouchUp=8;
BBGameEvent.TouchMove=9;
BBGameEvent.MotionAccel=10;

function BBGameDelegate(){}
BBGameDelegate.prototype.StartGame=function(){}
BBGameDelegate.prototype.SuspendGame=function(){}
BBGameDelegate.prototype.ResumeGame=function(){}
BBGameDelegate.prototype.UpdateGame=function(){}
BBGameDelegate.prototype.RenderGame=function(){}
BBGameDelegate.prototype.KeyEvent=function( ev,data ){}
BBGameDelegate.prototype.MouseEvent=function( ev,data,x,y ){}
BBGameDelegate.prototype.TouchEvent=function( ev,data,x,y ){}
BBGameDelegate.prototype.MotionEvent=function( ev,data,x,y,z ){}
BBGameDelegate.prototype.DiscardGraphics=function(){}

function BBGame(){
	BBGame._game=this;
	this._delegate=null;
	this._keyboardEnabled=false;
	this._updateRate=0;
	this._started=false;
	this._suspended=false;
	this._debugExs=(CFG_CONFIG=="debug");
	this._startms=Date.now();
}

BBGame.Game=function(){
	return BBGame._game;
}

BBGame.prototype.SetDelegate=function( delegate ){
	this._delegate=delegate;
}

BBGame.prototype.Delegate=function(){
	return this._delegate;
}

BBGame.prototype.SetUpdateRate=function( updateRate ){
	this._updateRate=updateRate;
}

BBGame.prototype.SetKeyboardEnabled=function( keyboardEnabled ){
	this._keyboardEnabled=keyboardEnabled;
}

BBGame.prototype.Started=function(){
	return this._started;
}

BBGame.prototype.Suspended=function(){
	return this._suspended;
}

BBGame.prototype.Millisecs=function(){
	return Date.now()-this._startms;
}

BBGame.prototype.GetDate=function( date ){
	var n=date.length;
	if( n>0 ){
		var t=new Date();
		date[0]=t.getFullYear();
		if( n>1 ){
			date[1]=t.getMonth()+1;
			if( n>2 ){
				date[2]=t.getDate();
				if( n>3 ){
					date[3]=t.getHours();
					if( n>4 ){
						date[4]=t.getMinutes();
						if( n>5 ){
							date[5]=t.getSeconds();
							if( n>6 ){
								date[6]=t.getMilliseconds();
							}
						}
					}
				}
			}
		}
	}
}

BBGame.prototype.SaveState=function( state ){
	localStorage.setItem( "monkeystate@"+document.URL,state );	//key can't start with dot in Chrome!
	return 1;
}

BBGame.prototype.LoadState=function(){
	var state=localStorage.getItem( "monkeystate@"+document.URL );
	if( state ) return state;
	return "";
}

BBGame.prototype.LoadString=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );
	
	xhr.send( null );
	
	if( xhr.status==200 || xhr.status==0 ) return xhr.responseText;
	
	return "";
}

BBGame.prototype.PollJoystick=function( port,joyx,joyy,joyz,buttons ){
	return false;
}

BBGame.prototype.OpenUrl=function( url ){
	window.location=url;
}

BBGame.prototype.SetMouseVisible=function( visible ){
	if( visible ){
		this._canvas.style.cursor='default';	
	}else{
		this._canvas.style.cursor="url('data:image/cur;base64,AAACAAEAICAAAAAAAACoEAAAFgAAACgAAAAgAAAAQAAAAAEAIAAAAAAAgBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA55ZXBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOeWVxAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADnllcGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////9////////////////////+////////f/////////8%3D'), auto";
	}
}

BBGame.prototype.PathToUrl=function( path ){
	return path;
}

BBGame.prototype.LoadData=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );

	if( xhr.overrideMimeType ) xhr.overrideMimeType( "text/plain; charset=x-user-defined" );

	xhr.send( null );
	if( xhr.status!=200 && xhr.status!=0 ) return null;

	var r=xhr.responseText;
	var buf=new ArrayBuffer( r.length );
	var bytes=new Int8Array( buf );
	for( var i=0;i<r.length;++i ){
		bytes[i]=r.charCodeAt( i );
	}
	return buf;
}

//***** INTERNAL ******

BBGame.prototype.Die=function( ex ){

	this._delegate=new BBGameDelegate();
	
	if( !ex.toString() ){
		return;
	}
	
	if( this._debugExs ){
		print( "Monkey Runtime Error : "+ex.toString() );
		print( stackTrace() );
	}
	
	throw ex;
}

BBGame.prototype.StartGame=function(){

	if( this._started ) return;
	this._started=true;
	
	if( this._debugExs ){
		try{
			this._delegate.StartGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.StartGame();
	}
}

BBGame.prototype.SuspendGame=function(){

	if( !this._started || this._suspended ) return;
	this._suspended=true;
	
	if( this._debugExs ){
		try{
			this._delegate.SuspendGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.SuspendGame();
	}
}

BBGame.prototype.ResumeGame=function(){

	if( !this._started || !this._suspended ) return;
	this._suspended=false;
	
	if( this._debugExs ){
		try{
			this._delegate.ResumeGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.ResumeGame();
	}
}

BBGame.prototype.UpdateGame=function(){

	if( !this._started || this._suspended ) return;

	if( this._debugExs ){
		try{
			this._delegate.UpdateGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.UpdateGame();
	}
}

BBGame.prototype.RenderGame=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.RenderGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.RenderGame();
	}
}

BBGame.prototype.KeyEvent=function( ev,data ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.KeyEvent( ev,data );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.KeyEvent( ev,data );
	}
}

BBGame.prototype.MouseEvent=function( ev,data,x,y ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MouseEvent( ev,data,x,y );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MouseEvent( ev,data,x,y );
	}
}

BBGame.prototype.TouchEvent=function( ev,data,x,y ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.TouchEvent( ev,data,x,y );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.TouchEvent( ev,data,x,y );
	}
}

BBGame.prototype.MotionEvent=function( ev,data,x,y,z ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MotionEvent( ev,data,x,y,z );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MotionEvent( ev,data,x,y,z );
	}
}

BBGame.prototype.DiscardGraphics=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.DiscardGraphics();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.DiscardGraphics();
	}
}

function BBHtml5Game( canvas ){
	BBGame.call( this );
	BBHtml5Game._game=this;
	this._canvas=canvas;
	this._loading=0;
	this._timerSeq=0;
	this._gl=null;
	if( CFG_OPENGL_GLES20_ENABLED=="1" ){
		this._gl=this._canvas.getContext( "webgl" );
		if( !this._gl ) this._gl=this._canvas.getContext( "experimental-webgl" );
		if( !this._gl ) this.Die( "Can't create WebGL" );
		gl=this._gl;
	}
}

BBHtml5Game.prototype=extend_class( BBGame );

BBHtml5Game.Html5Game=function(){
	return BBHtml5Game._game;
}

BBHtml5Game.prototype.ValidateUpdateTimer=function(){

	++this._timerSeq;

	if( !this._updateRate || this._suspended ) return;
	
	var game=this;
	var updatePeriod=1000.0/this._updateRate;
	var nextUpdate=Date.now()+updatePeriod;
	var seq=game._timerSeq;
	
	function timeElapsed(){
		if( seq!=game._timerSeq ) return;

		var time;		
		var updates;
		
		for( updates=0;updates<4;++updates ){
		
			nextUpdate+=updatePeriod;
			
			game.UpdateGame();
			if( seq!=game._timerSeq ) return;
			
			if( nextUpdate-Date.now()>0 ) break;
		}
		
		game.RenderGame();
		if( seq!=game._timerSeq ) return;
		
		if( updates==4 ){
			nextUpdate=Date.now();
			setTimeout( timeElapsed,0 );
		}else{
			var delay=nextUpdate-Date.now();
			setTimeout( timeElapsed,delay>0 ? delay : 0 );
		}
	}

	setTimeout( timeElapsed,updatePeriod );
}

//***** BBGame methods *****

BBHtml5Game.prototype.SetUpdateRate=function( updateRate ){

	BBGame.prototype.SetUpdateRate.call( this,updateRate );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.GetMetaData=function( path,key ){
	if( path.indexOf( "monkey://data/" )!=0 ) return "";
	path=path.slice(14);

	var i=META_DATA.indexOf( "["+path+"]" );
	if( i==-1 ) return "";
	i+=path.length+2;

	var e=META_DATA.indexOf( "\n",i );
	if( e==-1 ) e=META_DATA.length;

	i=META_DATA.indexOf( ";"+key+"=",i )
	if( i==-1 || i>=e ) return "";
	i+=key.length+2;

	e=META_DATA.indexOf( ";",i );
	if( e==-1 ) return "";

	return META_DATA.slice( i,e );
}

BBHtml5Game.prototype.PathToUrl=function( path ){
	if( path.indexOf( "monkey:" )!=0 ){
		return path;
	}else if( path.indexOf( "monkey://data/" )==0 ) {
		return "data/"+path.slice( 14 );
	}
	return "";
}

BBHtml5Game.prototype.GetLoading=function(){
	return this._loading;
}

BBHtml5Game.prototype.IncLoading=function(){
	++this._loading;
	return this._loading;
}

BBHtml5Game.prototype.DecLoading=function(){
	--this._loading;
	return this._loading;
}

BBHtml5Game.prototype.GetCanvas=function(){
	return this._canvas;
}

BBHtml5Game.prototype.GetWebGL=function(){
	return this._gl;
}

//***** INTERNAL *****

BBHtml5Game.prototype.UpdateGame=function(){

	if( !this._loading ) BBGame.prototype.UpdateGame.call( this );
}

BBHtml5Game.prototype.SuspendGame=function(){

	BBGame.prototype.SuspendGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.ResumeGame=function(){

	BBGame.prototype.ResumeGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.Run=function(){

	var game=this;
	var canvas=game._canvas;
	
	var touchIds=new Array( 32 );
	for( i=0;i<32;++i ) touchIds[i]=-1;
	
	function eatEvent( e ){
		if( e.stopPropagation ){
			e.stopPropagation();
			e.preventDefault();
		}else{
			e.cancelBubble=true;
			e.returnValue=false;
		}
	}
	
	function keyToChar( key ){
		switch( key ){
		case 8:case 9:case 13:case 27:case 32:return key;
		case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 45:return key|0x10000;
		case 46:return 127;
		}
		return 0;
	}
	
	function mouseX( e ){
		var x=e.clientX+document.body.scrollLeft;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x;
	}
	
	function mouseY( e ){
		var y=e.clientY+document.body.scrollTop;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y;
	}

	function touchX( touch ){
		var x=touch.pageX;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x;
	}			
	
	function touchY( touch ){
		var y=touch.pageY;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y;
	}
	
	canvas.onkeydown=function( e ){
		game.KeyEvent( BBGameEvent.KeyDown,e.keyCode );
		var chr=keyToChar( e.keyCode );
		if( chr ) game.KeyEvent( BBGameEvent.KeyChar,chr );
		if( e.keyCode<48 || (e.keyCode>111 && e.keyCode<122) ) eatEvent( e );
	}

	canvas.onkeyup=function( e ){
		game.KeyEvent( BBGameEvent.KeyUp,e.keyCode );
	}

	canvas.onkeypress=function( e ){
		if( e.charCode ){
			game.KeyEvent( BBGameEvent.KeyChar,e.charCode );
		}else if( e.which ){
			game.KeyEvent( BBGameEvent.KeyChar,e.which );
		}
	}

	canvas.onmousedown=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseDown,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseDown,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseDown,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmouseup=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmousemove=function( e ){
		game.MouseEvent( BBGameEvent.MouseMove,-1,mouseX(e),mouseY(e) );
		eatEvent( e );
	}

	canvas.onmouseout=function( e ){
		game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );
		eatEvent( e );
	}

	canvas.ontouchstart=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=-1 ) continue;
				touchIds[j]=touch.identifier;
				game.TouchEvent( BBGameEvent.TouchDown,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchmove=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				game.TouchEvent( BBGameEvent.TouchMove,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchend=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				touchIds[j]=-1;
				game.TouchEvent( BBGameEvent.TouchUp,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	window.ondevicemotion=function( e ){
		var tx=e.accelerationIncludingGravity.x/9.81;
		var ty=e.accelerationIncludingGravity.y/9.81;
		var tz=e.accelerationIncludingGravity.z/9.81;
		var x,y;
		switch( window.orientation ){
		case   0:x=+tx;y=-ty;break;
		case 180:x=-tx;y=+ty;break;
		case  90:x=-ty;y=-tx;break;
		case -90:x=+ty;y=+tx;break;
		}
		game.MotionEvent( BBGameEvent.MotionAccel,0,x,y,tz );
		eatEvent( e );
	}

	canvas.onfocus=function( e ){
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.ResumeGame();
		}
	}
	
	canvas.onblur=function( e ){
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.SuspendGame();
		}
	}
	
	canvas.focus();
	
	game.StartGame();

	game.RenderGame();
}

function BBMonkeyGame( canvas ){
	BBHtml5Game.call( this,canvas );
}

BBMonkeyGame.prototype=extend_class( BBHtml5Game );

BBMonkeyGame.Main=function( canvas ){

	var game=new BBMonkeyGame( canvas );

	try{

		bbInit();
		bbMain();

	}catch( ex ){
	
		game.Die( ex );
		return;
	}

	if( !game.Delegate() ) return;
	
	game.Run();
}

// HTML5 mojo runtime.
//
// Copyright 2011 Mark Sibly, all rights reserved.
// No warranty implied; use at your own risk.

//***** gxtkGraphics class *****

function gxtkGraphics(){
	this.game=BBHtml5Game.Html5Game();
	this.canvas=this.game.GetCanvas()
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	this.gl=null;
	this.gc=this.canvas.getContext( '2d' );
	this.tmpCanvas=null;
	this.r=255;
	this.b=255;
	this.g=255;
	this.white=true;
	this.color="rgb(255,255,255)"
	this.alpha=1;
	this.blend="source-over";
	this.ix=1;this.iy=0;
	this.jx=0;this.jy=1;
	this.tx=0;this.ty=0;
	this.tformed=false;
	this.scissorX=0;
	this.scissorY=0;
	this.scissorWidth=0;
	this.scissorHeight=0;
	this.clipped=false;
}

gxtkGraphics.prototype.BeginRender=function(){
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	if( !this.gc ) return 0;
	this.gc.save();
	if( this.game.GetLoading() ) return 2;
	return 1;
}

gxtkGraphics.prototype.EndRender=function(){
	if( this.gc ) this.gc.restore();
}

gxtkGraphics.prototype.Width=function(){
	return this.width;
}

gxtkGraphics.prototype.Height=function(){
	return this.height;
}

gxtkGraphics.prototype.LoadSurface=function( path ){
	var game=this.game;

	var ty=game.GetMetaData( path,"type" );
	if( ty.indexOf( "image/" )!=0 ) return null;
	
	function onloadfun(){
		game.DecLoading();
	}
	
	game.IncLoading();

	var image=new Image();
	image.onload=onloadfun;
	image.meta_width=parseInt( game.GetMetaData( path,"width" ) );
	image.meta_height=parseInt( game.GetMetaData( path,"height" ) );
	image.src=game.PathToUrl( path );

	return new gxtkSurface( image,this );
}

gxtkGraphics.prototype.CreateSurface=function( width,height ){
	var canvas=document.createElement( 'canvas' );
	
	canvas.width=width;
	canvas.height=height;
	canvas.meta_width=width;
	canvas.meta_height=height;
	canvas.complete=true;
	
	var surface=new gxtkSurface( canvas,this );
	
	surface.gc=canvas.getContext( '2d' );
	
	return surface;
}

gxtkGraphics.prototype.SetAlpha=function( alpha ){
	this.alpha=alpha;
	this.gc.globalAlpha=alpha;
}

gxtkGraphics.prototype.SetColor=function( r,g,b ){
	this.r=r;
	this.g=g;
	this.b=b;
	this.white=(r==255 && g==255 && b==255);
	this.color="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;
}

gxtkGraphics.prototype.SetBlend=function( blend ){
	switch( blend ){
	case 1:
		this.blend="lighter";
		break;
	default:
		this.blend="source-over";
	}
	this.gc.globalCompositeOperation=this.blend;
}

gxtkGraphics.prototype.SetScissor=function( x,y,w,h ){
	this.scissorX=x;
	this.scissorY=y;
	this.scissorWidth=w;
	this.scissorHeight=h;
	this.clipped=(x!=0 || y!=0 || w!=this.canvas.width || h!=this.canvas.height);
	this.gc.restore();
	this.gc.save();
	if( this.clipped ){
		this.gc.beginPath();
		this.gc.rect( x,y,w,h );
		this.gc.clip();
		this.gc.closePath();
	}
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.SetMatrix=function( ix,iy,jx,jy,tx,ty ){
	this.ix=ix;this.iy=iy;
	this.jx=jx;this.jy=jy;
	this.tx=tx;this.ty=ty;
	this.gc.setTransform( ix,iy,jx,jy,tx,ty );
	this.tformed=(ix!=1 || iy!=0 || jx!=0 || jy!=1 || tx!=0 || ty!=0);
}

gxtkGraphics.prototype.Cls=function( r,g,b ){
	if( this.tformed ) this.gc.setTransform( 1,0,0,1,0,0 );
	this.gc.fillStyle="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.globalAlpha=1;
	this.gc.globalCompositeOperation="source-over";
	this.gc.fillRect( 0,0,this.canvas.width,this.canvas.height );
	this.gc.fillStyle=this.color;
	this.gc.globalAlpha=this.alpha;
	this.gc.globalCompositeOperation=this.blend;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.DrawPoint=function( x,y ){
	if( this.tformed ){
		var px=x;
		x=px * this.ix + y * this.jx + this.tx;
		y=px * this.iy + y * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
		this.gc.fillRect( x,y,1,1 );
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
		this.gc.fillRect( x,y,1,1 );
	}
}

gxtkGraphics.prototype.DrawRect=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
	this.gc.fillRect( x,y,w,h );
}

gxtkGraphics.prototype.DrawLine=function( x1,y1,x2,y2 ){
	if( this.tformed ){
		var x1_t=x1 * this.ix + y1 * this.jx + this.tx;
		var y1_t=x1 * this.iy + y1 * this.jy + this.ty;
		var x2_t=x2 * this.ix + y2 * this.jx + this.tx;
		var y2_t=x2 * this.iy + y2 * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1_t,y1_t );
	  	this.gc.lineTo( x2_t,y2_t );
	  	this.gc.stroke();
	  	this.gc.closePath();
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1,y1 );
	  	this.gc.lineTo( x2,y2 );
	  	this.gc.stroke();
	  	this.gc.closePath();
	}
}

gxtkGraphics.prototype.DrawOval=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
  	var w2=w/2,h2=h/2;
	this.gc.save();
	this.gc.translate( x+w2,y+h2 );
	this.gc.scale( w2,h2 );
  	this.gc.beginPath();
	this.gc.arc( 0,0,1,0,Math.PI*2,false );
	this.gc.fill();
  	this.gc.closePath();
	this.gc.restore();
}

gxtkGraphics.prototype.DrawPoly=function( verts ){
	if( verts.length<6 ) return;
	this.gc.beginPath();
	this.gc.moveTo( verts[0],verts[1] );
	for( var i=2;i<verts.length;i+=2 ){
		this.gc.lineTo( verts[i],verts[i+1] );
	}
	this.gc.fill();
	this.gc.closePath();
}

gxtkGraphics.prototype.DrawSurface=function( surface,x,y ){
	if( !surface.image.complete ) return;
	
	if( this.white ){
		this.gc.drawImage( surface.image,x,y );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,0,0,surface.swidth,surface.sheight );
}

gxtkGraphics.prototype.DrawSurface2=function( surface,x,y,srcx,srcy,srcw,srch ){
	if( !surface.image.complete ) return;

	if( srcw<0 ){ srcx+=srcw;srcw=-srcw; }
	if( srch<0 ){ srcy+=srch;srch=-srch; }
	if( srcw<=0 || srch<=0 ) return;

	if( this.white ){
		this.gc.drawImage( surface.image,srcx,srcy,srcw,srch,x,y,srcw,srch );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,srcx,srcy,srcw,srch  );
}

gxtkGraphics.prototype.DrawImageTinted=function( image,dx,dy,sx,sy,sw,sh ){

	if( !this.tmpCanvas ){
		this.tmpCanvas=document.createElement( "canvas" );
	}

	if( sw>this.tmpCanvas.width || sh>this.tmpCanvas.height ){
		this.tmpCanvas.width=Math.max( sw,this.tmpCanvas.width );
		this.tmpCanvas.height=Math.max( sh,this.tmpCanvas.height );
	}
	
	var tmpGC=this.tmpCanvas.getContext( "2d" );
	tmpGC.globalCompositeOperation="copy";
	
	tmpGC.drawImage( image,sx,sy,sw,sh,0,0,sw,sh );
	
	var imgData=tmpGC.getImageData( 0,0,sw,sh );
	
	var p=imgData.data,sz=sw*sh*4,i;
	
	for( i=0;i<sz;i+=4 ){
		p[i]=p[i]*this.r/255;
		p[i+1]=p[i+1]*this.g/255;
		p[i+2]=p[i+2]*this.b/255;
	}
	
	tmpGC.putImageData( imgData,0,0 );
	
	this.gc.drawImage( this.tmpCanvas,0,0,sw,sh,dx,dy,sw,sh );
}

gxtkGraphics.prototype.ReadPixels=function( pixels,x,y,width,height,offset,pitch ){

	var imgData=this.gc.getImageData( x,y,width,height );
	
	var p=imgData.data,i=0,j=offset,px,py;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			pixels[j++]=(p[i+3]<<24)|(p[i]<<16)|(p[i+1]<<8)|p[i+2];
			i+=4;
		}
		j+=pitch-width;
	}
}

gxtkGraphics.prototype.WritePixels2=function( surface,pixels,x,y,width,height,offset,pitch ){

	if( !surface.gc ){
		if( !surface.image.complete ) return;
		var canvas=document.createElement( "canvas" );
		canvas.width=surface.swidth;
		canvas.height=surface.sheight;
		surface.gc=canvas.getContext( "2d" );
		surface.gc.globalCompositeOperation="copy";
		surface.gc.drawImage( surface.image,0,0 );
		surface.image=canvas;
	}

	var imgData=surface.gc.createImageData( width,height );

	var p=imgData.data,i=0,j=offset,px,py,argb;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			argb=pixels[j++];
			p[i]=(argb>>16) & 0xff;
			p[i+1]=(argb>>8) & 0xff;
			p[i+2]=argb & 0xff;
			p[i+3]=(argb>>24) & 0xff;
			i+=4;
		}
		j+=pitch-width;
	}
	
	surface.gc.putImageData( imgData,x,y );
}

//***** gxtkSurface class *****

function gxtkSurface( image,graphics ){
	this.image=image;
	this.graphics=graphics;
	this.swidth=image.meta_width;
	this.sheight=image.meta_height;
}

//***** GXTK API *****

gxtkSurface.prototype.Discard=function(){
	if( this.image ){
		this.image=null;
	}
}

gxtkSurface.prototype.Width=function(){
	return this.swidth;
}

gxtkSurface.prototype.Height=function(){
	return this.sheight;
}

gxtkSurface.prototype.Loaded=function(){
	return this.image.complete;
}

gxtkSurface.prototype.OnUnsafeLoadComplete=function(){
	return true;
}

//***** gxtkChannel class *****
function gxtkChannel(){
	this.sample=null;
	this.audio=null;
	this.volume=1;
	this.pan=0;
	this.rate=1;
	this.flags=0;
	this.state=0;
}

//***** gxtkAudio class *****
function gxtkAudio(){
	this.game=BBHtml5Game.Html5Game();
	this.okay=typeof(Audio)!="undefined";
	this.nextchan=0;
	this.music=null;
	this.channels=new Array(33);
	for( var i=0;i<33;++i ){
		this.channels[i]=new gxtkChannel();
	}
}

gxtkAudio.prototype.Suspend=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==1 ) chan.audio.pause();
	}
}

gxtkAudio.prototype.Resume=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==1 ) chan.audio.play();
	}
}

gxtkAudio.prototype.LoadSample=function( path ){

	var audio=new Audio( this.game.PathToUrl( path ) );
	if( !audio ) return null;
	
	return new gxtkSample( audio );
}

gxtkAudio.prototype.PlaySample=function( sample,channel,flags ){
	if( !this.okay ) return;

	var chan=this.channels[channel];

	if( chan.state!=0 ){
		chan.audio.pause();
		chan.state=0;
	}
	
	for( var i=0;i<33;++i ){
		var chan2=this.channels[i];
		if( chan2.state==1 && chan2.audio.ended && !chan2.audio.loop ) chan.state=0;
		if( chan2.state==0 && chan2.sample ){
			chan2.sample.FreeAudio( chan2.audio );
			chan2.sample=null;
			chan2.audio=null;
		}
	}

	var audio=sample.AllocAudio();
	if( !audio ) return;
	
	audio.loop=(flags&1)!=0;
	audio.volume=chan.volume;
	audio.play();

	chan.sample=sample;
	chan.audio=audio;
	chan.flags=flags;
	chan.state=1;
}

gxtkAudio.prototype.StopChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state!=0 ){
		chan.audio.pause();
		chan.state=0;
	}
}

gxtkAudio.prototype.PauseChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==1 ){
		if( chan.audio.ended && !chan.audio.loop ){
			chan.state=0;
		}else{
			chan.audio.pause();
			chan.state=2;
		}
	}
}

gxtkAudio.prototype.ResumeChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==2 ){
		chan.audio.play();
		chan.state=1;
	}
}

gxtkAudio.prototype.ChannelState=function( channel ){
	var chan=this.channels[channel];
	if( chan.state==1 && chan.audio.ended && !chan.audio.loop ) chan.state=0;
	return chan.state;
}

gxtkAudio.prototype.SetVolume=function( channel,volume ){
	var chan=this.channels[channel];
	if( chan.state!=0 ) chan.audio.volume=volume;
	chan.volume=volume;
}

gxtkAudio.prototype.SetPan=function( channel,pan ){
	var chan=this.channels[channel];
	chan.pan=pan;
}

gxtkAudio.prototype.SetRate=function( channel,rate ){
	var chan=this.channels[channel];
	chan.rate=rate;
}

gxtkAudio.prototype.PlayMusic=function( path,flags ){
	this.StopMusic();
	
	this.music=this.LoadSample( path );
	if( !this.music ) return;
	
	this.PlaySample( this.music,32,flags );
}

gxtkAudio.prototype.StopMusic=function(){
	this.StopChannel( 32 );

	if( this.music ){
		this.music.Discard();
		this.music=null;
	}
}

gxtkAudio.prototype.PauseMusic=function(){
	this.PauseChannel( 32 );
}

gxtkAudio.prototype.ResumeMusic=function(){
	this.ResumeChannel( 32 );
}

gxtkAudio.prototype.MusicState=function(){
	return this.ChannelState( 32 );
}

gxtkAudio.prototype.SetMusicVolume=function( volume ){
	this.SetVolume( 32,volume );
}

//***** gxtkSample class *****

function gxtkSample( audio ){
	this.audio=audio;
	this.free=new Array();
	this.insts=new Array();
}

gxtkSample.prototype.FreeAudio=function( audio ){
	this.free.push( audio );
}

gxtkSample.prototype.AllocAudio=function(){
	var audio;
	while( this.free.length ){
		audio=this.free.pop();
		try{
			audio.currentTime=0;
			return audio;
		}catch( ex ){
			print( "AUDIO ERROR1!" );
		}
	}
	
	//Max out?
	if( this.insts.length==8 ) return null;
	
	audio=new Audio( this.audio.src );
	
	//yucky loop handler for firefox!
	//
	audio.addEventListener( 'ended',function(){
		if( this.loop ){
			try{
				this.currentTime=0;
				this.play();
			}catch( ex ){
				print( "AUDIO ERROR2!" );
			}
		}
	},false );

	this.insts.push( audio );
	return audio;
}

gxtkSample.prototype.Discard=function(){
}

function BBThread(){
	this.running=false;
}

BBThread.prototype.Start=function(){
	this.running=true;
	this.Run__UNSAFE__();
}

BBThread.prototype.IsRunning=function(){
	return this.running;
}

BBThread.prototype.Run__UNSAFE__=function(){
	this.running=false;
}

function BBAsyncImageLoaderThread(){
	BBThread.call(this);
}

BBAsyncImageLoaderThread.prototype=extend_class( BBThread );

BBAsyncImageLoaderThread.prototype.Start=function(){

	var thread=this;

	var image=new Image();
	
	image.onload=function( e ){
		image.meta_width=image.width;
		image.meta_height=image.height;
		thread._surface=new gxtkSurface( image,thread._device )
		thread.running=false;
	}
	
	image.onerror=function( e ){
		thread._surface=null;
		thread.running=false;
	}
	
	thread.running=true;
	
	image.src=BBGame.Game().PathToUrl( thread._path );
}


function BBAsyncSoundLoaderThread(){
	BBThread.call(this);
}

BBAsyncSoundLoaderThread.prototype=extend_class( BBThread );

BBAsyncSoundLoaderThread.prototype.Start=function(){
	this._sample=this._device.LoadSample( this._path );
}
function c_App(){
	Object.call(this);
}
c_App.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<103>";
	if((bb_app__app)!=null){
		err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<103>";
		error("App has already been created");
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<104>";
	bb_app__app=this;
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<106>";
	bb_app__delegate=c_GameDelegate.m_new.call(new c_GameDelegate);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<107>";
	bb_app__game.SetDelegate(bb_app__delegate);
	pop_err();
	return this;
}
c_App.prototype.p_OnCreate=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnSuspend=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnResume=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnUpdate=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnLoading=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnRender=function(){
	push_err();
	pop_err();
	return 0;
}
function c_spriter(){
	c_App.call(this);
	this.m_s=null;
}
c_spriter.prototype=extend_class(c_App);
c_spriter.m_new=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<102>";
	c_App.m_new.call(this);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<102>";
	pop_err();
	return this;
}
c_spriter.prototype.p_OnUpdate=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<105>";
	bb_customgui_time=bb_app_Millisecs();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<106>";
	bb_customgui_check_mouse();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<109>";
	if(bb_customgui_mouse_down1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<110>";
		if(dbg_object(dbg_object(bb_spriter_sp).m_delete_button).m_active==false){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<111>";
			var t_xattr=((bb_customgui_mouse_x/10)|0);
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<112>";
			var t_yattr=((bb_customgui_mouse_y/10)|0);
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<114>";
			if(t_xattr<dbg_object(this.m_s).m_width*8){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<115>";
				if(t_yattr<dbg_object(this.m_s).m_height*8){
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<118>";
					for(var t_x=0;t_x<=dbg_object(this.m_s).m_width-1;t_x=t_x+1){
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<119>";
						for(var t_y=0;t_y<=dbg_object(this.m_s).m_height-1;t_y=t_y+1){
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<122>";
							if(t_xattr>=((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_xpos/10)|0)){
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<123>";
								if(t_yattr>=((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_ypos/10)|0)){
									err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<124>";
									if(t_xattr<((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_xpos/10)|0)+8){
										err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<125>";
										if(t_yattr<((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_ypos/10)|0)+8){
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<126>";
											var t_dotx=t_xattr-((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_xpos/10)|0);
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<127>";
											var t_doty=t_yattr-((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_ypos/10)|0);
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<128>";
											dbg_array(dbg_array(dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_dots,t_dotx)[dbg_index],t_doty)[dbg_index]=true
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<129>";
											dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_ink=bb_spriter_current_ink;
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<130>";
											dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x)[dbg_index],t_y)[dbg_index]).m_paper=bb_spriter_current_paper;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<146>";
	if(bb_customgui_mouse_down1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<147>";
		if(dbg_object(dbg_object(bb_spriter_sp).m_delete_button).m_active==true){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<149>";
			var t_xattr2=((bb_customgui_mouse_x/10)|0);
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<150>";
			var t_yattr2=((bb_customgui_mouse_y/10)|0);
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<152>";
			if(t_xattr2<dbg_object(this.m_s).m_width*8){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<153>";
				if(t_yattr2<dbg_object(this.m_s).m_height*8){
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<156>";
					for(var t_x2=0;t_x2<=dbg_object(this.m_s).m_width-1;t_x2=t_x2+1){
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<157>";
						for(var t_y2=0;t_y2<=dbg_object(this.m_s).m_height-1;t_y2=t_y2+1){
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<160>";
							if(t_xattr2>=((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x2)[dbg_index],t_y2)[dbg_index]).m_xpos/10)|0)){
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<161>";
								if(t_yattr2>=((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x2)[dbg_index],t_y2)[dbg_index]).m_ypos/10)|0)){
									err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<162>";
									if(t_xattr2<((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x2)[dbg_index],t_y2)[dbg_index]).m_xpos/10)|0)+8){
										err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<163>";
										if(t_yattr2<((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x2)[dbg_index],t_y2)[dbg_index]).m_ypos/10)|0)+8){
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<164>";
											var t_dotx2=t_xattr2-((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x2)[dbg_index],t_y2)[dbg_index]).m_xpos/10)|0);
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<165>";
											var t_doty2=t_yattr2-((dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x2)[dbg_index],t_y2)[dbg_index]).m_ypos/10)|0);
											err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<166>";
											dbg_array(dbg_array(dbg_object(dbg_array(dbg_array(dbg_object(this.m_s).m_attributes,t_x2)[dbg_index],t_y2)[dbg_index]).m_dots,t_dotx2)[dbg_index],t_doty2)[dbg_index]=false
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<180>";
	c_gui_element.m_clicked=false;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<181>";
	c_gui_element.m_highlighted_any=false;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<182>";
	c_gui_element.m_highlighted_element=null;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<184>";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<184>";
	var t_=c_gui_element.m_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<184>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<184>";
		var t_i=t_.p_NextObject();
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<185>";
		if(dbg_object(t_i).m_hidden==false){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<186>";
			t_i.p_update();
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<196>";
	pop_err();
	return 0;
}
c_spriter.prototype.p_OnRender=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<201>";
	bb_autofit_UpdateVirtualDisplay(true,true);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<203>";
	bb_graphics_Cls(.0,.0,.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<204>";
	this.m_s.p_render();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<205>";
	this.m_s.p_render_small();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<206>";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<206>";
	var t_=c_gui_element.m_list.p_Backwards().p_ObjectEnumerator();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<206>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<206>";
		var t_t=t_.p_NextObject();
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<207>";
		if(dbg_object(t_t).m_hidden==false){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<208>";
			t_t.p_renderme();
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<211>";
	pop_err();
	return 0;
}
c_spriter.prototype.p_OnCreate=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<215>";
	bb_app_SetUpdateRate(30);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<216>";
	bb_autofit_SetVirtualDisplay(640,480,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<218>";
	this.m_s=c_sprite.m_new.call(new c_sprite,2,2);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<219>";
	bb_spriter_medium_font=c_mediumarialfont.m_new.call(new c_mediumarialfont);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<220>";
	bb_spriter_small_font=c_arialfont.m_new.call(new c_arialfont);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<221>";
	c_gui_class.m_init_gui(255,255,255);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<222>";
	bb_spriter_red_img=bb_graphics_LoadImage("red.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<223>";
	bb_spriter_green_img=bb_graphics_LoadImage("green.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<224>";
	bb_spriter_blue_img=bb_graphics_LoadImage("blue.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<225>";
	bb_spriter_cyan_img=bb_graphics_LoadImage("cyan.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<226>";
	bb_spriter_magenta_img=bb_graphics_LoadImage("magenta.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<227>";
	bb_spriter_yellow_img=bb_graphics_LoadImage("yellow.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<228>";
	bb_spriter_white_img=bb_graphics_LoadImage("white.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<229>";
	bb_spriter_black_img=bb_graphics_LoadImage("black.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<238>";
	bb_spriter_sp=c_spriter_screen.m_new.call(new c_spriter_screen);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<239>";
	bb_customgui_change_state(bb_spriter_sp);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<240>";
	pop_err();
	return 0;
}
var bb_app__app=null;
function c_GameDelegate(){
	BBGameDelegate.call(this);
	this.m__graphics=null;
	this.m__audio=null;
	this.m__input=null;
}
c_GameDelegate.prototype=extend_class(BBGameDelegate);
c_GameDelegate.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<30>";
	pop_err();
	return this;
}
c_GameDelegate.prototype.StartGame=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<39>";
	this.m__graphics=(new gxtkGraphics);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<40>";
	bb_graphics_SetGraphicsDevice(this.m__graphics);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<41>";
	bb_graphics_SetFont(null,32);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<43>";
	this.m__audio=(new gxtkAudio);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<44>";
	bb_audio_SetAudioDevice(this.m__audio);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<46>";
	this.m__input=c_InputDevice.m_new.call(new c_InputDevice);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<47>";
	bb_input_SetInputDevice(this.m__input);
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<49>";
	bb_app__app.p_OnCreate();
	pop_err();
}
c_GameDelegate.prototype.SuspendGame=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<53>";
	bb_app__app.p_OnSuspend();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<54>";
	this.m__audio.Suspend();
	pop_err();
}
c_GameDelegate.prototype.ResumeGame=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<58>";
	this.m__audio.Resume();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<59>";
	bb_app__app.p_OnResume();
	pop_err();
}
c_GameDelegate.prototype.UpdateGame=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<63>";
	this.m__input.p_BeginUpdate();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<64>";
	bb_app__app.p_OnUpdate();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<65>";
	this.m__input.p_EndUpdate();
	pop_err();
}
c_GameDelegate.prototype.RenderGame=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<69>";
	var t_mode=this.m__graphics.BeginRender();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<70>";
	if((t_mode)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<70>";
		bb_graphics_BeginRender();
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<71>";
	if(t_mode==2){
		err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<71>";
		bb_app__app.p_OnLoading();
	}else{
		err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<71>";
		bb_app__app.p_OnRender();
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<72>";
	if((t_mode)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<72>";
		bb_graphics_EndRender();
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<73>";
	this.m__graphics.EndRender();
	pop_err();
}
c_GameDelegate.prototype.KeyEvent=function(t_event,t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<77>";
	this.m__input.p_KeyEvent(t_event,t_data);
	pop_err();
}
c_GameDelegate.prototype.MouseEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<81>";
	this.m__input.p_MouseEvent(t_event,t_data,t_x,t_y);
	pop_err();
}
c_GameDelegate.prototype.TouchEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<85>";
	this.m__input.p_TouchEvent(t_event,t_data,t_x,t_y);
	pop_err();
}
c_GameDelegate.prototype.MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<89>";
	this.m__input.p_MotionEvent(t_event,t_data,t_x,t_y,t_z);
	pop_err();
}
c_GameDelegate.prototype.DiscardGraphics=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<93>";
	this.m__graphics.DiscardGraphics();
	pop_err();
}
var bb_app__delegate=null;
var bb_app__game=null;
var bb_spriter_spr=null;
function bbMain(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<738>";
	bb_spriter_spr=c_spriter.m_new.call(new c_spriter);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<739>";
	pop_err();
	return 0;
}
var bb_graphics_device=null;
function bb_graphics_SetGraphicsDevice(t_dev){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<58>";
	bb_graphics_device=t_dev;
	pop_err();
	return 0;
}
function c_Image(){
	Object.call(this);
	this.m_surface=null;
	this.m_width=0;
	this.m_height=0;
	this.m_frames=[];
	this.m_flags=0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_source=null;
}
c_Image.m_DefaultFlags=0;
c_Image.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<65>";
	pop_err();
	return this;
}
c_Image.prototype.p_SetHandle=function(t_tx,t_ty){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<109>";
	dbg_object(this).m_tx=t_tx;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<110>";
	dbg_object(this).m_ty=t_ty;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<111>";
	dbg_object(this).m_flags=dbg_object(this).m_flags&-2;
	pop_err();
	return 0;
}
c_Image.prototype.p_ApplyFlags=function(t_iflags){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<184>";
	this.m_flags=t_iflags;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<186>";
	if((this.m_flags&2)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<187>";
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<187>";
		var t_=this.m_frames;
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<187>";
		var t_2=0;
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<187>";
		while(t_2<t_.length){
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<187>";
			var t_f=dbg_array(t_,t_2)[dbg_index];
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<187>";
			t_2=t_2+1;
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<188>";
			dbg_object(t_f).m_x+=1;
		}
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<190>";
		this.m_width-=2;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<193>";
	if((this.m_flags&4)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<194>";
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<194>";
		var t_3=this.m_frames;
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<194>";
		var t_4=0;
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<194>";
		while(t_4<t_3.length){
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<194>";
			var t_f2=dbg_array(t_3,t_4)[dbg_index];
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<194>";
			t_4=t_4+1;
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<195>";
			dbg_object(t_f2).m_y+=1;
		}
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<197>";
		this.m_height-=2;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<200>";
	if((this.m_flags&1)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<201>";
		this.p_SetHandle((this.m_width)/2.0,(this.m_height)/2.0);
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<204>";
	if(this.m_frames.length==1 && dbg_object(dbg_array(this.m_frames,0)[dbg_index]).m_x==0 && dbg_object(dbg_array(this.m_frames,0)[dbg_index]).m_y==0 && this.m_width==this.m_surface.Width() && this.m_height==this.m_surface.Height()){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<205>";
		this.m_flags|=65536;
	}
	pop_err();
	return 0;
}
c_Image.prototype.p_Init=function(t_surf,t_nframes,t_iflags){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<142>";
	this.m_surface=t_surf;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<144>";
	this.m_width=((this.m_surface.Width()/t_nframes)|0);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<145>";
	this.m_height=this.m_surface.Height();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<147>";
	this.m_frames=new_object_array(t_nframes);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<148>";
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<149>";
		dbg_array(this.m_frames,t_i)[dbg_index]=c_Frame.m_new.call(new c_Frame,t_i*this.m_width,0)
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<152>";
	this.p_ApplyFlags(t_iflags);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<153>";
	pop_err();
	return this;
}
c_Image.prototype.p_Grab=function(t_x,t_y,t_iwidth,t_iheight,t_nframes,t_iflags,t_source){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<157>";
	dbg_object(this).m_source=t_source;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<158>";
	this.m_surface=dbg_object(t_source).m_surface;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<160>";
	this.m_width=t_iwidth;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<161>";
	this.m_height=t_iheight;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<163>";
	this.m_frames=new_object_array(t_nframes);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<165>";
	var t_ix=t_x;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<165>";
	var t_iy=t_y;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<167>";
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<168>";
		if(t_ix+this.m_width>dbg_object(t_source).m_width){
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<169>";
			t_ix=0;
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<170>";
			t_iy+=this.m_height;
		}
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<172>";
		if(t_ix+this.m_width>dbg_object(t_source).m_width || t_iy+this.m_height>dbg_object(t_source).m_height){
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<173>";
			error("Image frame outside surface");
		}
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<175>";
		dbg_array(this.m_frames,t_i)[dbg_index]=c_Frame.m_new.call(new c_Frame,t_ix+dbg_object(dbg_array(dbg_object(t_source).m_frames,0)[dbg_index]).m_x,t_iy+dbg_object(dbg_array(dbg_object(t_source).m_frames,0)[dbg_index]).m_y)
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<176>";
		t_ix+=this.m_width;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<179>";
	this.p_ApplyFlags(t_iflags);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<180>";
	pop_err();
	return this;
}
c_Image.prototype.p_GrabImage=function(t_x,t_y,t_width,t_height,t_frames,t_flags){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<104>";
	if(dbg_object(this).m_frames.length!=1){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<104>";
		pop_err();
		return null;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<105>";
	var t_=(c_Image.m_new.call(new c_Image)).p_Grab(t_x,t_y,t_width,t_height,t_frames,t_flags,this);
	pop_err();
	return t_;
}
c_Image.prototype.p_Width=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<76>";
	pop_err();
	return this.m_width;
}
c_Image.prototype.p_Height=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<80>";
	pop_err();
	return this.m_height;
}
function c_GraphicsContext(){
	Object.call(this);
	this.m_defaultFont=null;
	this.m_font=null;
	this.m_firstChar=0;
	this.m_matrixSp=0;
	this.m_ix=1.0;
	this.m_iy=.0;
	this.m_jx=.0;
	this.m_jy=1.0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_tformed=0;
	this.m_matDirty=0;
	this.m_color_r=.0;
	this.m_color_g=.0;
	this.m_color_b=.0;
	this.m_alpha=.0;
	this.m_blend=0;
	this.m_scissor_x=.0;
	this.m_scissor_y=.0;
	this.m_scissor_width=.0;
	this.m_scissor_height=.0;
	this.m_matrixStack=new_number_array(192);
}
c_GraphicsContext.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<24>";
	pop_err();
	return this;
}
c_GraphicsContext.prototype.p_Validate=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<35>";
	if((this.m_matDirty)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<36>";
		bb_graphics_renderDevice.SetMatrix(dbg_object(bb_graphics_context).m_ix,dbg_object(bb_graphics_context).m_iy,dbg_object(bb_graphics_context).m_jx,dbg_object(bb_graphics_context).m_jy,dbg_object(bb_graphics_context).m_tx,dbg_object(bb_graphics_context).m_ty);
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<37>";
		this.m_matDirty=0;
	}
	pop_err();
	return 0;
}
var bb_graphics_context=null;
function bb_data_FixDataPath(t_path){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/data.monkey<3>";
	var t_i=t_path.indexOf(":/",0);
	err_info="/root/Dropbox/Monkey/modules/mojo/data.monkey<4>";
	if(t_i!=-1 && t_path.indexOf("/",0)==t_i+1){
		err_info="/root/Dropbox/Monkey/modules/mojo/data.monkey<4>";
		pop_err();
		return t_path;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/data.monkey<5>";
	if(string_startswith(t_path,"./") || string_startswith(t_path,"/")){
		err_info="/root/Dropbox/Monkey/modules/mojo/data.monkey<5>";
		pop_err();
		return t_path;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/data.monkey<6>";
	var t_="monkey://data/"+t_path;
	pop_err();
	return t_;
}
function c_Frame(){
	Object.call(this);
	this.m_x=0;
	this.m_y=0;
}
c_Frame.m_new=function(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<18>";
	dbg_object(this).m_x=t_x;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<19>";
	dbg_object(this).m_y=t_y;
	pop_err();
	return this;
}
c_Frame.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<13>";
	pop_err();
	return this;
}
function bb_graphics_LoadImage(t_path,t_frameCount,t_flags){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<234>";
	var t_surf=bb_graphics_device.LoadSurface(bb_data_FixDataPath(t_path));
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<235>";
	if((t_surf)!=null){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<235>";
		var t_=(c_Image.m_new.call(new c_Image)).p_Init(t_surf,t_frameCount,t_flags);
		pop_err();
		return t_;
	}
	pop_err();
	return null;
}
function bb_graphics_LoadImage2(t_path,t_frameWidth,t_frameHeight,t_frameCount,t_flags){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<239>";
	var t_atlas=bb_graphics_LoadImage(t_path,1,0);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<240>";
	if((t_atlas)!=null){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<240>";
		var t_=t_atlas.p_GrabImage(0,0,t_frameWidth,t_frameHeight,t_frameCount,t_flags);
		pop_err();
		return t_;
	}
	pop_err();
	return null;
}
function bb_graphics_SetFont(t_font,t_firstChar){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<532>";
	if(!((t_font)!=null)){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<533>";
		if(!((dbg_object(bb_graphics_context).m_defaultFont)!=null)){
			err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<534>";
			dbg_object(bb_graphics_context).m_defaultFont=bb_graphics_LoadImage("mojo_font.png",96,2);
		}
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<536>";
		t_font=dbg_object(bb_graphics_context).m_defaultFont;
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<537>";
		t_firstChar=32;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<539>";
	dbg_object(bb_graphics_context).m_font=t_font;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<540>";
	dbg_object(bb_graphics_context).m_firstChar=t_firstChar;
	pop_err();
	return 0;
}
var bb_audio_device=null;
function bb_audio_SetAudioDevice(t_dev){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/audio.monkey<18>";
	bb_audio_device=t_dev;
	pop_err();
	return 0;
}
function c_InputDevice(){
	Object.call(this);
	this.m__joyStates=new_object_array(4);
	this.m__keyDown=new_bool_array(512);
	this.m__keyHit=new_number_array(512);
	this.m__keyHitPut=0;
	this.m__keyHitQueue=new_number_array(33);
	this.m__charGet=0;
	this.m__charPut=0;
	this.m__charQueue=new_number_array(32);
	this.m__mouseX=.0;
	this.m__mouseY=.0;
	this.m__touchX=new_number_array(32);
	this.m__touchY=new_number_array(32);
	this.m__accelX=.0;
	this.m__accelY=.0;
	this.m__accelZ=.0;
}
c_InputDevice.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<22>";
	for(var t_i=0;t_i<4;t_i=t_i+1){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<23>";
		dbg_array(this.m__joyStates,t_i)[dbg_index]=c_JoyState.m_new.call(new c_JoyState)
	}
	pop_err();
	return this;
}
c_InputDevice.prototype.p_BeginUpdate=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<192>";
	for(var t_i=0;t_i<4;t_i=t_i+1){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<193>";
		var t_state=dbg_array(this.m__joyStates,t_i)[dbg_index];
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<194>";
		if(!BBGame.Game().PollJoystick(t_i,dbg_object(t_state).m_joyx,dbg_object(t_state).m_joyy,dbg_object(t_state).m_joyz,dbg_object(t_state).m_buttons)){
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<194>";
			break;
		}
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<195>";
		for(var t_j=0;t_j<32;t_j=t_j+1){
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<196>";
			var t_key=256+t_i*32+t_j;
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<197>";
			if(dbg_array(dbg_object(t_state).m_buttons,t_j)[dbg_index]){
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<198>";
				if(!dbg_array(this.m__keyDown,t_key)[dbg_index]){
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<199>";
					dbg_array(this.m__keyDown,t_key)[dbg_index]=true
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<200>";
					dbg_array(this.m__keyHit,t_key)[dbg_index]+=1
				}
			}else{
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<203>";
				dbg_array(this.m__keyDown,t_key)[dbg_index]=false
			}
		}
	}
	pop_err();
}
c_InputDevice.prototype.p_EndUpdate=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<210>";
	for(var t_i=0;t_i<this.m__keyHitPut;t_i=t_i+1){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<211>";
		dbg_array(this.m__keyHit,dbg_array(this.m__keyHitQueue,t_i)[dbg_index])[dbg_index]=0
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<213>";
	this.m__keyHitPut=0;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<214>";
	this.m__charGet=0;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<215>";
	this.m__charPut=0;
	pop_err();
}
c_InputDevice.prototype.p_KeyEvent=function(t_event,t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<107>";
	var t_=t_event;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<108>";
	if(t_==1){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<109>";
		if(!dbg_array(this.m__keyDown,t_data)[dbg_index]){
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<110>";
			if(this.m__keyHitPut>=this.m__keyHitQueue.length-1){
				pop_err();
				return;
			}
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<111>";
			dbg_array(this.m__keyDown,t_data)[dbg_index]=true
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<112>";
			dbg_array(this.m__keyHit,t_data)[dbg_index]+=1
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<113>";
			dbg_array(this.m__keyHitQueue,this.m__keyHitPut)[dbg_index]=t_data
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<114>";
			this.m__keyHitPut+=1;
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<115>";
			if(t_data==1){
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<116>";
				dbg_array(this.m__keyDown,384)[dbg_index]=true
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<117>";
				dbg_array(this.m__keyHit,384)[dbg_index]+=1
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<118>";
				dbg_array(this.m__keyHitQueue,this.m__keyHitPut)[dbg_index]=384
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<119>";
				this.m__keyHitPut+=1;
			}else{
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<120>";
				if(t_data==384){
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<121>";
					dbg_array(this.m__keyDown,1)[dbg_index]=true
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<122>";
					dbg_array(this.m__keyHit,1)[dbg_index]+=1
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<123>";
					dbg_array(this.m__keyHitQueue,this.m__keyHitPut)[dbg_index]=1
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<124>";
					this.m__keyHitPut+=1;
				}
			}
		}
	}else{
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<127>";
		if(t_==2){
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<128>";
			if(dbg_array(this.m__keyDown,t_data)[dbg_index]){
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<129>";
				dbg_array(this.m__keyDown,t_data)[dbg_index]=false
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<130>";
				if(t_data==1){
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<131>";
					dbg_array(this.m__keyDown,384)[dbg_index]=false
				}else{
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<132>";
					if(t_data==384){
						err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<133>";
						dbg_array(this.m__keyDown,1)[dbg_index]=false
					}
				}
			}
		}else{
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<136>";
			if(t_==3){
				err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<137>";
				if(this.m__charPut<this.m__charQueue.length){
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<138>";
					dbg_array(this.m__charQueue,this.m__charPut)[dbg_index]=t_data
					err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<139>";
					this.m__charPut+=1;
				}
			}
		}
	}
	pop_err();
}
c_InputDevice.prototype.p_MouseEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<145>";
	var t_=t_event;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<146>";
	if(t_==4){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<147>";
		this.p_KeyEvent(1,1+t_data);
	}else{
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<148>";
		if(t_==5){
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<149>";
			this.p_KeyEvent(2,1+t_data);
			pop_err();
			return;
		}else{
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<151>";
			if(t_==6){
			}else{
				pop_err();
				return;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<155>";
	this.m__mouseX=t_x;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<156>";
	this.m__mouseY=t_y;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<157>";
	dbg_array(this.m__touchX,0)[dbg_index]=t_x
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<158>";
	dbg_array(this.m__touchY,0)[dbg_index]=t_y
	pop_err();
}
c_InputDevice.prototype.p_TouchEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<162>";
	var t_=t_event;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<163>";
	if(t_==7){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<164>";
		this.p_KeyEvent(1,384+t_data);
	}else{
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<165>";
		if(t_==8){
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<166>";
			this.p_KeyEvent(2,384+t_data);
			pop_err();
			return;
		}else{
			err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<168>";
			if(t_==9){
			}else{
				pop_err();
				return;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<172>";
	dbg_array(this.m__touchX,t_data)[dbg_index]=t_x
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<173>";
	dbg_array(this.m__touchY,t_data)[dbg_index]=t_y
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<174>";
	if(t_data==0){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<175>";
		this.m__mouseX=t_x;
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<176>";
		this.m__mouseY=t_y;
	}
	pop_err();
}
c_InputDevice.prototype.p_MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<181>";
	var t_=t_event;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<182>";
	if(t_==10){
	}else{
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<186>";
	this.m__accelX=t_x;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<187>";
	this.m__accelY=t_y;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<188>";
	this.m__accelZ=t_z;
	pop_err();
}
c_InputDevice.prototype.p_KeyHit=function(t_key){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<48>";
	if(t_key>0 && t_key<512){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<48>";
		var t_=dbg_array(this.m__keyHit,t_key)[dbg_index];
		pop_err();
		return t_;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<49>";
	pop_err();
	return 0;
}
c_InputDevice.prototype.p_KeyDown=function(t_key){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<43>";
	if(t_key>0 && t_key<512){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<43>";
		var t_=dbg_array(this.m__keyDown,t_key)[dbg_index];
		pop_err();
		return t_;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<44>";
	pop_err();
	return false;
}
c_InputDevice.prototype.p_TouchX=function(t_index){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<73>";
	if(t_index>=0 && t_index<32){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<73>";
		var t_=dbg_array(this.m__touchX,t_index)[dbg_index];
		pop_err();
		return t_;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<74>";
	pop_err();
	return .0;
}
c_InputDevice.prototype.p_TouchY=function(t_index){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<78>";
	if(t_index>=0 && t_index<32){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<78>";
		var t_=dbg_array(this.m__touchY,t_index)[dbg_index];
		pop_err();
		return t_;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<79>";
	pop_err();
	return .0;
}
c_InputDevice.prototype.p_GetChar=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<53>";
	if(this.m__charGet==this.m__charPut){
		err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<53>";
		pop_err();
		return 0;
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<54>";
	var t_chr=dbg_array(this.m__charQueue,this.m__charGet)[dbg_index];
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<55>";
	this.m__charGet+=1;
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<56>";
	pop_err();
	return t_chr;
}
function c_JoyState(){
	Object.call(this);
	this.m_joyx=new_number_array(2);
	this.m_joyy=new_number_array(2);
	this.m_joyz=new_number_array(2);
	this.m_buttons=new_bool_array(32);
}
c_JoyState.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/inputdevice.monkey<10>";
	pop_err();
	return this;
}
var bb_input_device=null;
function bb_input_SetInputDevice(t_dev){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/input.monkey<18>";
	bb_input_device=t_dev;
	pop_err();
	return 0;
}
var bb_graphics_renderDevice=null;
function bb_graphics_SetMatrix(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<307>";
	dbg_object(bb_graphics_context).m_ix=t_ix;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<308>";
	dbg_object(bb_graphics_context).m_iy=t_iy;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<309>";
	dbg_object(bb_graphics_context).m_jx=t_jx;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<310>";
	dbg_object(bb_graphics_context).m_jy=t_jy;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<311>";
	dbg_object(bb_graphics_context).m_tx=t_tx;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<312>";
	dbg_object(bb_graphics_context).m_ty=t_ty;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<313>";
	dbg_object(bb_graphics_context).m_tformed=((t_ix!=1.0 || t_iy!=.0 || t_jx!=.0 || t_jy!=1.0 || t_tx!=.0 || t_ty!=.0)?1:0);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<314>";
	dbg_object(bb_graphics_context).m_matDirty=1;
	pop_err();
	return 0;
}
function bb_graphics_SetMatrix2(t_m){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<303>";
	bb_graphics_SetMatrix(dbg_array(t_m,0)[dbg_index],dbg_array(t_m,1)[dbg_index],dbg_array(t_m,2)[dbg_index],dbg_array(t_m,3)[dbg_index],dbg_array(t_m,4)[dbg_index],dbg_array(t_m,5)[dbg_index]);
	pop_err();
	return 0;
}
function bb_graphics_SetColor(t_r,t_g,t_b){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<249>";
	dbg_object(bb_graphics_context).m_color_r=t_r;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<250>";
	dbg_object(bb_graphics_context).m_color_g=t_g;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<251>";
	dbg_object(bb_graphics_context).m_color_b=t_b;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<252>";
	bb_graphics_renderDevice.SetColor(t_r,t_g,t_b);
	pop_err();
	return 0;
}
function bb_graphics_SetAlpha(t_alpha){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<266>";
	dbg_object(bb_graphics_context).m_alpha=t_alpha;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<267>";
	bb_graphics_renderDevice.SetAlpha(t_alpha);
	pop_err();
	return 0;
}
function bb_graphics_SetBlend(t_blend){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<275>";
	dbg_object(bb_graphics_context).m_blend=t_blend;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<276>";
	bb_graphics_renderDevice.SetBlend(t_blend);
	pop_err();
	return 0;
}
function bb_graphics_DeviceWidth(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<226>";
	var t_=bb_graphics_device.Width();
	pop_err();
	return t_;
}
function bb_graphics_DeviceHeight(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<230>";
	var t_=bb_graphics_device.Height();
	pop_err();
	return t_;
}
function bb_graphics_SetScissor(t_x,t_y,t_width,t_height){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<284>";
	dbg_object(bb_graphics_context).m_scissor_x=t_x;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<285>";
	dbg_object(bb_graphics_context).m_scissor_y=t_y;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<286>";
	dbg_object(bb_graphics_context).m_scissor_width=t_width;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<287>";
	dbg_object(bb_graphics_context).m_scissor_height=t_height;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<288>";
	bb_graphics_renderDevice.SetScissor(((t_x)|0),((t_y)|0),((t_width)|0),((t_height)|0));
	pop_err();
	return 0;
}
function bb_graphics_BeginRender(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<212>";
	bb_graphics_renderDevice=bb_graphics_device;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<213>";
	dbg_object(bb_graphics_context).m_matrixSp=0;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<214>";
	bb_graphics_SetMatrix(1.0,.0,.0,1.0,.0,.0);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<215>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<216>";
	bb_graphics_SetAlpha(1.0);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<217>";
	bb_graphics_SetBlend(0);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<218>";
	bb_graphics_SetScissor(.0,.0,(bb_graphics_DeviceWidth()),(bb_graphics_DeviceHeight()));
	pop_err();
	return 0;
}
function bb_graphics_EndRender(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<222>";
	bb_graphics_renderDevice=null;
	pop_err();
	return 0;
}
function c_BBGameEvent(){
	Object.call(this);
}
function bb_app_Millisecs(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<152>";
	var t_=bb_app__game.Millisecs();
	pop_err();
	return t_;
}
var bb_customgui_time=0;
function bb_input_TouchHit(t_index){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/input.monkey<84>";
	var t_=bb_input_device.p_KeyHit(384+t_index);
	pop_err();
	return t_;
}
var bb_customgui_mouse_hit1=false;
var bb_customgui_mouse_hit2=false;
function bb_input_TouchDown(t_index){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/input.monkey<80>";
	var t_=((bb_input_device.p_KeyDown(384+t_index))?1:0);
	pop_err();
	return t_;
}
var bb_customgui_mouse_down1=false;
var bb_customgui_mouse_down2=false;
function c_VirtualDisplay(){
	Object.call(this);
	this.m_multi=.0;
	this.m_vzoom=.0;
	this.m_vwidth=.0;
	this.m_vheight=.0;
	this.m_lastdevicewidth=0;
	this.m_lastdeviceheight=0;
	this.m_device_changed=0;
	this.m_fdw=.0;
	this.m_fdh=.0;
	this.m_dratio=.0;
	this.m_vratio=.0;
	this.m_heightborder=.0;
	this.m_widthborder=.0;
	this.m_lastvzoom=.0;
	this.m_zoom_changed=0;
	this.m_realx=.0;
	this.m_realy=.0;
	this.m_offx=.0;
	this.m_offy=.0;
	this.m_sx=.0;
	this.m_sw=.0;
	this.m_sy=.0;
	this.m_sh=.0;
	this.m_scaledw=.0;
	this.m_scaledh=.0;
	this.m_vxoff=.0;
	this.m_vyoff=.0;
}
c_VirtualDisplay.m_Display=null;
c_VirtualDisplay.prototype.p_VTouchX=function(t_index,t_limit){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<370>";
	var t_touchoffset=bb_input_TouchX(t_index)-(bb_graphics_DeviceWidth())*0.5;
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<374>";
	var t_x=t_touchoffset/this.m_multi/this.m_vzoom+bb_autofit_VDeviceWidth()*0.5;
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<378>";
	if(t_limit){
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<380>";
		var t_widthlimit=this.m_vwidth-1.0;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<382>";
		if(t_x>.0){
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<383>";
			if(t_x<t_widthlimit){
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<384>";
				pop_err();
				return t_x;
			}else{
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<386>";
				pop_err();
				return t_widthlimit;
			}
		}else{
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<389>";
			pop_err();
			return .0;
		}
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<393>";
		pop_err();
		return t_x;
	}
}
c_VirtualDisplay.prototype.p_VTouchY=function(t_index,t_limit){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<404>";
	var t_touchoffset=bb_input_TouchY(t_index)-(bb_graphics_DeviceHeight())*0.5;
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<408>";
	var t_y=t_touchoffset/this.m_multi/this.m_vzoom+bb_autofit_VDeviceHeight()*0.5;
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<412>";
	if(t_limit){
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<414>";
		var t_heightlimit=this.m_vheight-1.0;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<416>";
		if(t_y>.0){
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<417>";
			if(t_y<t_heightlimit){
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<418>";
				pop_err();
				return t_y;
			}else{
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<420>";
				pop_err();
				return t_heightlimit;
			}
		}else{
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<423>";
			pop_err();
			return .0;
		}
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<427>";
		pop_err();
		return t_y;
	}
}
c_VirtualDisplay.prototype.p_UpdateVirtualDisplay=function(t_zoomborders,t_keepborders){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<444>";
	if(bb_graphics_DeviceWidth()!=this.m_lastdevicewidth || bb_graphics_DeviceHeight()!=this.m_lastdeviceheight){
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<445>";
		this.m_lastdevicewidth=bb_graphics_DeviceWidth();
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<446>";
		this.m_lastdeviceheight=bb_graphics_DeviceHeight();
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<447>";
		this.m_device_changed=1;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<454>";
	if((this.m_device_changed)!=0){
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<459>";
		this.m_fdw=(bb_graphics_DeviceWidth());
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<460>";
		this.m_fdh=(bb_graphics_DeviceHeight());
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<465>";
		this.m_dratio=this.m_fdh/this.m_fdw;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<469>";
		if(this.m_dratio>this.m_vratio){
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<478>";
			this.m_multi=this.m_fdw/this.m_vwidth;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<482>";
			this.m_heightborder=(this.m_fdh-this.m_vheight*this.m_multi)*0.5;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<483>";
			this.m_widthborder=.0;
		}else{
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<494>";
			this.m_multi=this.m_fdh/this.m_vheight;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<498>";
			this.m_widthborder=(this.m_fdw-this.m_vwidth*this.m_multi)*0.5;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<499>";
			this.m_heightborder=.0;
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<509>";
	if(this.m_vzoom!=this.m_lastvzoom){
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<510>";
		this.m_lastvzoom=this.m_vzoom;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<511>";
		this.m_zoom_changed=1;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<518>";
	if(((this.m_zoom_changed)!=0) || ((this.m_device_changed)!=0)){
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<520>";
		if(t_zoomborders){
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<524>";
			this.m_realx=this.m_vwidth*this.m_vzoom*this.m_multi;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<525>";
			this.m_realy=this.m_vheight*this.m_vzoom*this.m_multi;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<529>";
			this.m_offx=(this.m_fdw-this.m_realx)*0.5;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<530>";
			this.m_offy=(this.m_fdh-this.m_realy)*0.5;
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<532>";
			if(t_keepborders){
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<538>";
				if(this.m_offx<this.m_widthborder){
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<539>";
					this.m_sx=this.m_widthborder;
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<540>";
					this.m_sw=this.m_fdw-this.m_widthborder*2.0;
				}else{
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<542>";
					this.m_sx=this.m_offx;
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<543>";
					this.m_sw=this.m_fdw-this.m_offx*2.0;
				}
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<546>";
				if(this.m_offy<this.m_heightborder){
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<547>";
					this.m_sy=this.m_heightborder;
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<548>";
					this.m_sh=this.m_fdh-this.m_heightborder*2.0;
				}else{
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<550>";
					this.m_sy=this.m_offy;
					err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<551>";
					this.m_sh=this.m_fdh-this.m_offy*2.0;
				}
			}else{
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<556>";
				this.m_sx=this.m_offx;
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<557>";
				this.m_sw=this.m_fdw-this.m_offx*2.0;
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<559>";
				this.m_sy=this.m_offy;
				err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<560>";
				this.m_sh=this.m_fdh-this.m_offy*2.0;
			}
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<566>";
			this.m_sx=bb_math_Max2(0.0,this.m_sx);
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<567>";
			this.m_sy=bb_math_Max2(0.0,this.m_sy);
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<568>";
			this.m_sw=bb_math_Min2(this.m_sw,this.m_fdw);
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<569>";
			this.m_sh=bb_math_Min2(this.m_sh,this.m_fdh);
		}else{
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<575>";
			this.m_sx=bb_math_Max2(0.0,this.m_widthborder);
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<576>";
			this.m_sy=bb_math_Max2(0.0,this.m_heightborder);
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<577>";
			this.m_sw=bb_math_Min2(this.m_fdw-this.m_widthborder*2.0,this.m_fdw);
			err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<578>";
			this.m_sh=bb_math_Min2(this.m_fdh-this.m_heightborder*2.0,this.m_fdh);
		}
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<584>";
		this.m_scaledw=this.m_vwidth*this.m_multi*this.m_vzoom;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<585>";
		this.m_scaledh=this.m_vheight*this.m_multi*this.m_vzoom;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<589>";
		this.m_vxoff=(this.m_fdw-this.m_scaledw)*0.5;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<590>";
		this.m_vyoff=(this.m_fdh-this.m_scaledh)*0.5;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<594>";
		this.m_vxoff=this.m_vxoff/this.m_multi/this.m_vzoom;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<595>";
		this.m_vyoff=this.m_vyoff/this.m_multi/this.m_vzoom;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<599>";
		this.m_device_changed=0;
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<600>";
		this.m_zoom_changed=0;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<608>";
	bb_graphics_SetScissor(.0,.0,(bb_graphics_DeviceWidth()),(bb_graphics_DeviceHeight()));
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<609>";
	bb_graphics_Cls(.0,.0,.0);
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<615>";
	bb_graphics_SetScissor(this.m_sx,this.m_sy,this.m_sw,this.m_sh);
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<621>";
	bb_graphics_Scale(this.m_multi*this.m_vzoom,this.m_multi*this.m_vzoom);
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<627>";
	if((this.m_vzoom)!=0.0){
		err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<627>";
		bb_graphics_Translate(this.m_vxoff,this.m_vyoff);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<629>";
	pop_err();
	return 0;
}
c_VirtualDisplay.m_new=function(t_width,t_height,t_zoom){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<266>";
	this.m_vwidth=(t_width);
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<267>";
	this.m_vheight=(t_height);
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<269>";
	this.m_vzoom=t_zoom;
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<270>";
	this.m_lastvzoom=this.m_vzoom+1.0;
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<274>";
	this.m_vratio=this.m_vheight/this.m_vwidth;
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<278>";
	c_VirtualDisplay.m_Display=this;
	pop_err();
	return this;
}
c_VirtualDisplay.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<216>";
	pop_err();
	return this;
}
function bb_input_TouchX(t_index){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/input.monkey<72>";
	var t_=bb_input_device.p_TouchX(t_index);
	pop_err();
	return t_;
}
function bb_autofit_VDeviceWidth(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<206>";
	pop_err();
	return dbg_object(c_VirtualDisplay.m_Display).m_vwidth;
}
function bb_autofit_VTouchX(t_index,t_limit){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<196>";
	var t_=c_VirtualDisplay.m_Display.p_VTouchX(t_index,t_limit);
	pop_err();
	return t_;
}
var bb_customgui_mouse_x=0;
function bb_input_TouchY(t_index){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/input.monkey<76>";
	var t_=bb_input_device.p_TouchY(t_index);
	pop_err();
	return t_;
}
function bb_autofit_VDeviceHeight(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<210>";
	pop_err();
	return dbg_object(c_VirtualDisplay.m_Display).m_vheight;
}
function bb_autofit_VTouchY(t_index,t_limit){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<200>";
	var t_=c_VirtualDisplay.m_Display.p_VTouchY(t_index,t_limit);
	pop_err();
	return t_;
}
var bb_customgui_mouse_y=0;
function bb_customgui_check_mouse(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<29>";
	if((bb_input_TouchHit(0))!=0){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<30>";
		bb_customgui_mouse_hit1=true;
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<32>";
		bb_customgui_mouse_hit1=false;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<34>";
	if((bb_input_TouchHit(1))!=0){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<35>";
		bb_customgui_mouse_hit2=true;
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<37>";
		bb_customgui_mouse_hit2=false;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<40>";
	if(bb_input_TouchDown(0)==1){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<41>";
		bb_customgui_mouse_down1=true;
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<43>";
		bb_customgui_mouse_down1=false;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<45>";
	if(bb_input_TouchDown(1)==1){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<46>";
		bb_customgui_mouse_down2=true;
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<48>";
		bb_customgui_mouse_down2=false;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<51>";
	bb_customgui_mouse_x=((bb_autofit_VTouchX(0,true))|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<52>";
	bb_customgui_mouse_y=((bb_autofit_VTouchY(0,true))|0);
	pop_err();
}
function c_gui_element(){
	Object.call(this);
	this.m_active=false;
	this.m_hidden=false;
	this.m_highlighted=false;
	this.m_x=0;
	this.m_width=.0;
	this.m_y=0;
	this.m_height=.0;
	this.m_mouse_over=false;
	this.m_pressed=false;
	this.m_mouse_down=false;
	this.m_repeatable=false;
	this.m_pressed_timer=0;
	this.m_red=0;
	this.m_blue=0;
	this.m_green=0;
	this.m_fading_in=false;
	this.m_alpha=.0;
	this.m_parent=null;
	this.m_fading_out=false;
	this.m_gadget_list=null;
	this.m_text="";
	this.m_font=null;
	this.m_rendered=false;
	this.m_up_arrow=null;
	this.m_down_arrow=null;
	this.m_name="";
	this.m_radio_list=null;
}
c_gui_element.m_clicked=false;
c_gui_element.m_highlighted_any=false;
c_gui_element.m_highlighted_element=null;
c_gui_element.m_list=null;
c_gui_element.prototype.p_detect_mouse_over=function(t_mouse_x,t_mouse_y,t_mouse_hit1){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<264>";
	dbg_object(this).m_highlighted=false;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<267>";
	if(t_mouse_x>this.m_x){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<268>";
		if((t_mouse_x)<(this.m_x)+this.m_width){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<269>";
			if(t_mouse_y>this.m_y){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<270>";
				if((t_mouse_y)<(this.m_y)+this.m_height){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<271>";
					if(c_gui_element.m_highlighted_any==false){
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<272>";
						c_gui_element.m_highlighted_any=true;
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<273>";
						dbg_object(this).m_highlighted=true;
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<274>";
						c_gui_element.m_highlighted_element=this;
					}
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<276>";
					pop_err();
					return true;
				}
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<282>";
	pop_err();
	return false;
}
c_gui_element.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<190>";
	if(this.p_detect_mouse_over(bb_customgui_mouse_x,bb_customgui_mouse_y,bb_customgui_mouse_hit1)){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<191>";
		this.m_mouse_over=true;
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<193>";
		this.m_mouse_over=false;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<196>";
	dbg_object(this).m_pressed=false;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<197>";
	dbg_object(this).m_mouse_down=false;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<199>";
	if(dbg_object(this).m_mouse_over==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<200>";
		if(c_gui_element.m_clicked==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<202>";
			if(this.m_repeatable==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<203>";
				if(bb_customgui_mouse_down1){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<204>";
					dbg_object(this).m_mouse_down=true;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<205>";
					this.m_pressed=true;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<206>";
					c_gui_element.m_clicked=true;
				}
			}
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<210>";
			if(bb_customgui_mouse_hit1){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<211>";
				this.m_pressed_timer=bb_app_Millisecs();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<212>";
				this.m_pressed=true;
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<213>";
				c_gui_element.m_clicked=true;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<219>";
	if(dbg_object(this).m_red<255){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<220>";
		dbg_object(this).m_red=dbg_object(this).m_red+6;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<222>";
	if(dbg_object(this).m_blue<255){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<223>";
		dbg_object(this).m_blue=dbg_object(this).m_blue+6;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<225>";
	if(dbg_object(this).m_green<255){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<226>";
		dbg_object(this).m_green=dbg_object(this).m_green+6;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<229>";
	if(this.m_fading_in==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<231>";
		dbg_object(this).m_alpha=dbg_object(this).m_alpha+0.01;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<233>";
		if(dbg_object(this).m_alpha>1.0){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<234>";
			dbg_object(this).m_alpha=1.0;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<235>";
			this.m_fading_in=false;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<236>";
			this.m_hidden=false;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<237>";
			if(this.m_parent!=null){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<238>";
				dbg_object(this.m_parent).m_hidden=false;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<244>";
	if(this.m_fading_out==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<245>";
		dbg_object(this).m_alpha=dbg_object(this).m_alpha-0.01;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<246>";
		if(dbg_object(this).m_alpha<0.0){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<247>";
			dbg_object(this).m_alpha=0.0;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<248>";
			this.m_fading_out=false;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<249>";
			this.m_hidden=true;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<250>";
			if(this.m_parent!=null){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<251>";
				dbg_object(this.m_parent).m_hidden=true;
			}
		}
	}
	pop_err();
}
c_gui_element.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<288>";
	bb_graphics_SetColor(255.0,255.0,100.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<289>";
	if((object_downcast((this),c_screen))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<290>";
		var t_b=object_downcast((this),c_screen);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<291>";
		t_b.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<294>";
	if((object_downcast((this),c_label))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<295>";
		var t_b2=object_downcast((this),c_label);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<296>";
		t_b2.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<299>";
	if((object_downcast((this),c_background_img))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<300>";
		var t_b3=object_downcast((this),c_background_img);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<301>";
		t_b3.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<304>";
	if((object_downcast((this),c_img))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<305>";
		var t_b4=object_downcast((this),c_img);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<306>";
		t_b4.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<309>";
	if((object_downcast((this),c_img_button))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<310>";
		var t_b5=object_downcast((this),c_img_button);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<311>";
		t_b5.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<314>";
	if((object_downcast((this),c_button))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<315>";
		var t_b6=object_downcast((this),c_button);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<316>";
		t_b6.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<319>";
	if((object_downcast((this),c_Inputbox))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<320>";
		var t_b7=object_downcast((this),c_Inputbox);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<321>";
		t_b7.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<324>";
	if((object_downcast((this),c_textbox))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<325>";
		var t_b8=object_downcast((this),c_textbox);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<326>";
		t_b8.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<329>";
	if((object_downcast((this),c_draggable_image))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<330>";
		var t_b9=object_downcast((this),c_draggable_image);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<331>";
		t_b9.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<334>";
	if((object_downcast((this),c_gadget_scroller))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<335>";
		var t_b10=object_downcast((this),c_gadget_scroller);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<336>";
		t_b10.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<339>";
	if((object_downcast((this),c_up_arrow))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<340>";
		var t_b11=object_downcast((this),c_up_arrow);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<341>";
		t_b11.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<344>";
	if((object_downcast((this),c_down_arrow))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<345>";
		var t_b12=object_downcast((this),c_down_arrow);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<346>";
		t_b12.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<349>";
	if((object_downcast((this),c_toggle_button))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<350>";
		var t_b13=object_downcast((this),c_toggle_button);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<351>";
		t_b13.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<354>";
	if((object_downcast((this),c_table))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<355>";
		var t_b14=object_downcast((this),c_table);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<356>";
		t_b14.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<359>";
	if((object_downcast((this),c_table_column))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<360>";
		var t_b15=object_downcast((this),c_table_column);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<361>";
		t_b15.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<364>";
	if((object_downcast((this),c_table_cell))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<365>";
		var t_b16=object_downcast((this),c_table_cell);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<366>";
		t_b16.p_renderme();
		pop_err();
		return;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<369>";
	if((object_downcast((this),c_arrow_chooser))!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<370>";
		var t_b17=object_downcast((this),c_arrow_chooser);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<371>";
		t_b17.p_renderme();
		pop_err();
		return;
	}
	pop_err();
}
c_gui_element.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<182>";
	dbg_object(this).m_red=255;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<183>";
	dbg_object(this).m_blue=255;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<184>";
	dbg_object(this).m_green=255;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<185>";
	dbg_object(this).m_alpha=1.0;
	pop_err();
	return this;
}
c_gui_element.prototype.p_hide=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<103>";
	dbg_object(this).m_hidden=true;
	pop_err();
}
c_gui_element.prototype.p_show=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<107>";
	dbg_object(this).m_hidden=false;
	pop_err();
}
c_gui_element.prototype.p_ispressed=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<169>";
	if(dbg_object(this).m_pressed==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<170>";
		dbg_object(this).m_pressed=false;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<171>";
		pop_err();
		return true;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<173>";
	pop_err();
	return false;
}
c_gui_element.prototype.p_add_gadget=function(t_i,t_radio,t_column){
	push_err();
	pop_err();
}
c_gui_element.prototype.p_get_dimensions=function(){
	push_err();
	pop_err();
}
c_gui_element.prototype.p_destroy=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<156>";
	c_gui_element.m_list.p_RemoveEach(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<157>";
	if(this.m_parent!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<158>";
		if(dbg_object(this.m_parent).m_gadget_list!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<159>";
			dbg_object(this.m_parent).m_gadget_list.p_RemoveEach(this);
		}
	}
	pop_err();
}
function c_screen(){
	c_gui_element.call(this);
}
c_screen.prototype=extend_class(c_gui_element);
c_screen.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<433>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<433>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<433>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<433>";
		var t_i=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<434>";
		if(dbg_object(t_i).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<435>";
			t_i.p_renderme();
		}
	}
	pop_err();
}
c_screen.m_list=null;
c_screen.prototype.p_setup=function(){
	push_err();
	pop_err();
}
c_screen.m_new=function(t_the_font){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<383>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<384>";
	this.m_gadget_list=c_List.m_new.call(new c_List);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<385>";
	c_gui_element.m_list.p_AddLast(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<386>";
	if(c_screen.m_list==null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<387>";
		c_screen.m_list=c_List3.m_new.call(new c_List3);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<389>";
	this.p_setup();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<390>";
	dbg_object(this).m_hidden=true;
	pop_err();
	return this;
}
c_screen.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<424>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<424>";
	var t_=dbg_object(this).m_gadget_list.p_Backwards().p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<424>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<424>";
		var t_t=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<425>";
		if(dbg_object(t_t).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<426>";
			t_t.p_update();
		}
	}
	pop_err();
}
c_screen.prototype.p_add_gadget=function(t_o,t_radio,t_column){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<397>";
	if(dbg_object(t_o).m_parent!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<398>";
		dbg_object(dbg_object(t_o).m_parent).m_gadget_list.p_RemoveEach(t_o);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<401>";
	c_gui_element.m_list.p_RemoveEach(t_o);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<403>";
	this.m_gadget_list.p_AddLast(t_o);
	pop_err();
}
function c_spriter_screen(){
	c_screen.call(this);
	this.m_delete_button=null;
	this.m_poke_button=null;
	this.m_binary_button=null;
	this.m_cyan_button=null;
	this.m_black_button=null;
	this.m_white_button=null;
	this.m_yellow_button=null;
	this.m_magenta_button=null;
	this.m_red_button=null;
	this.m_green_button=null;
	this.m_blue_button=null;
	this.m_cyan_paper_button=null;
	this.m_black_paper_button=null;
	this.m_white_paper_button=null;
	this.m_yellow_paper_button=null;
	this.m_magenta_paper_button=null;
	this.m_red_paper_button=null;
	this.m_green_paper_button=null;
	this.m_blue_paper_button=null;
	this.m_bright_toggle=null;
	this.m_overall_table=null;
}
c_spriter_screen.prototype=extend_class(c_screen);
c_spriter_screen.m_new=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<245>";
	c_screen.m_new.call(this,null);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<245>";
	pop_err();
	return this;
}
c_spriter_screen.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<289>";
	c_screen.prototype.p_update.call(this);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<290>";
	if(this.m_poke_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<294>";
		print(dbg_object(bb_spriter_spr).m_s.p_Tostring());
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<297>";
	if(this.m_binary_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<301>";
		print(dbg_object(bb_spriter_spr).m_s.p_Tobin());
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<305>";
	if(this.m_cyan_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<306>";
		bb_spriter_current_ink=5;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<308>";
	if(this.m_black_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<309>";
		bb_spriter_current_ink=8;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<311>";
	if(this.m_white_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<312>";
		bb_spriter_current_ink=7;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<314>";
	if(this.m_yellow_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<315>";
		bb_spriter_current_ink=6;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<317>";
	if(this.m_magenta_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<318>";
		bb_spriter_current_ink=3;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<320>";
	if(this.m_red_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<321>";
		bb_spriter_current_ink=2;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<323>";
	if(this.m_green_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<324>";
		bb_spriter_current_ink=4;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<326>";
	if(this.m_blue_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<327>";
		bb_spriter_current_ink=1;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<330>";
	if(this.m_cyan_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<331>";
		bb_spriter_current_paper=5;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<333>";
	if(this.m_black_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<334>";
		bb_spriter_current_paper=8;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<336>";
	if(this.m_white_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<337>";
		bb_spriter_current_paper=7;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<339>";
	if(this.m_yellow_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<340>";
		bb_spriter_current_paper=6;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<342>";
	if(this.m_magenta_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<343>";
		bb_spriter_current_paper=3;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<345>";
	if(this.m_red_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<346>";
		bb_spriter_current_paper=2;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<348>";
	if(this.m_green_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<349>";
		bb_spriter_current_paper=4;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<351>";
	if(this.m_blue_paper_button.p_ispressed()==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<352>";
		bb_spriter_current_paper=1;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<354>";
	if(dbg_object(this.m_bright_toggle).m_active==true){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<355>";
		bb_spriter_current_bright=1;
	}else{
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<357>";
		bb_spriter_current_bright=0;
	}
	pop_err();
}
c_spriter_screen.prototype.p_setup=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<368>";
	dbg_object(this).m_text="spriter screen";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<372>";
	this.m_overall_table=c_table.m_new.call(new c_table,0,210,0,(this));
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<373>";
	var t_column1=c_table_column.m_new.call(new c_table_column,this.m_overall_table,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<375>";
	var t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<376>";
	var t_ink_label=c_label.m_new.call(new c_label,0,0,"Ink",(t_mycell),(bb_spriter_small_font),255,255,255,1,0,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<378>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<379>";
	this.m_red_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_red_img,bb_spriter_red_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<382>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<383>";
	this.m_green_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_green_img,bb_spriter_green_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<386>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<387>";
	this.m_blue_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_blue_img,bb_spriter_blue_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<390>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<391>";
	this.m_cyan_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_cyan_img,bb_spriter_cyan_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<394>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<395>";
	this.m_magenta_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_magenta_img,bb_spriter_magenta_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<398>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<399>";
	this.m_yellow_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_yellow_img,bb_spriter_yellow_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<402>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<403>";
	this.m_white_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_white_img,bb_spriter_white_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<405>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,true);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<406>";
	this.m_black_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_black_img,bb_spriter_black_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<410>";
	var t_column2=c_table_column.m_new.call(new c_table_column,this.m_overall_table,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<411>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column2,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<412>";
	t_ink_label=c_label.m_new.call(new c_label,0,0,"",(t_mycell),(bb_spriter_small_font),255,255,255,1,0,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<430>";
	t_column1=c_table_column.m_new.call(new c_table_column,this.m_overall_table,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<432>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<433>";
	var t_paper_label=c_label.m_new.call(new c_label,0,0,"Paper",(t_mycell),(bb_spriter_small_font),255,255,255,1,0,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<435>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<436>";
	this.m_red_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_red_img,bb_spriter_red_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<439>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<440>";
	this.m_green_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_green_img,bb_spriter_green_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<443>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<444>";
	this.m_blue_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_blue_img,bb_spriter_blue_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<447>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<448>";
	this.m_cyan_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_cyan_img,bb_spriter_cyan_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<451>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<452>";
	this.m_magenta_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_magenta_img,bb_spriter_magenta_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<455>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<456>";
	this.m_yellow_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_yellow_img,bb_spriter_yellow_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<459>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<460>";
	this.m_white_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_white_img,bb_spriter_white_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<462>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column1,true);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<463>";
	this.m_black_paper_button=c_img_button.m_new.call(new c_img_button,0,0,bb_spriter_black_img,bb_spriter_black_img,"",(t_mycell),(bb_spriter_small_font),null,false,1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<467>";
	t_column2=c_table_column.m_new.call(new c_table_column,this.m_overall_table,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<468>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column2,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<469>";
	t_ink_label=c_label.m_new.call(new c_label,0,0,"",(t_mycell),(bb_spriter_small_font),255,255,255,1,0,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<486>";
	t_column2=c_table_column.m_new.call(new c_table_column,this.m_overall_table,0,0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<487>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column2,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<488>";
	this.m_bright_toggle=c_toggle_button.m_new.call(new c_toggle_button,0,0,60.0,20.0,"Bright",(t_mycell),(bb_spriter_small_font),null,null);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<490>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column2,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<491>";
	this.m_poke_button=c_button.m_new.call(new c_button,0,0,60.0,20.0,"Pokes",(t_mycell),(bb_spriter_small_font),null,null,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<493>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column2,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<494>";
	this.m_binary_button=c_button.m_new.call(new c_button,0,0,60.0,20.0,"Binary",(t_mycell),(bb_spriter_small_font),null,null,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<496>";
	t_mycell=c_table_cell.m_new.call(new c_table_cell,t_column2,false);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<497>";
	this.m_delete_button=c_toggle_button.m_new.call(new c_toggle_button,0,0,60.0,20.0,"Delete",(t_mycell),(bb_spriter_small_font),null,null);
	pop_err();
}
c_spriter_screen.prototype.p_show=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<503>";
	c_gui_element.prototype.p_show.call(this);
	pop_err();
}
var bb_spriter_sp=null;
function c_toggle_button(){
	c_gui_element.call(this);
	this.m_obj=null;
}
c_toggle_button.prototype=extend_class(c_gui_element);
c_toggle_button.m_img=null;
c_toggle_button.m_img2=null;
c_toggle_button.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1676>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1677>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1678>";
	bb_graphics_Translate((this.m_x),(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1679>";
	bb_graphics_Scale(dbg_object(this).m_width/(c_toggle_button.m_img.p_Width()),this.m_height/(c_toggle_button.m_img.p_Height()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1680>";
	if(this.m_active==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1681>";
		bb_graphics_DrawImage(c_toggle_button.m_img2,.0,.0,0);
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1683>";
		bb_graphics_DrawImage(c_toggle_button.m_img,.0,.0,0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1685>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1688>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1689>";
	if(this.m_active==false && this.m_mouse_over==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1690>";
		bb_graphics_SetColor((dbg_object(c_gui_class.m_gui_pointer).m_textr),(dbg_object(c_gui_class.m_gui_pointer).m_textg),(dbg_object(c_gui_class.m_gui_pointer).m_textb));
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1692>";
		bb_graphics_SetColor(255.0,.0,.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1694>";
	var t_draw_x=(this.m_x)+this.m_width/2.0-((dbg_object(this).m_font.p_TextWidth(this.m_text)/2)|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1695>";
	var t_draw_y=(this.m_y)+this.m_height/2.0-((dbg_object(dbg_object(this).m_font).m_fontheight/2)|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1696>";
	dbg_object(this).m_font.p_draw(this.m_text,((t_draw_x)|0),((t_draw_y)|0),1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1697>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1698>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_toggle_button.m_new=function(t_x,t_y,t_width,t_height,t_text,t_parent,t_the_font,t_radio_list,t_ob){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1639>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1640>";
	dbg_object(this).m_x=t_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1641>";
	dbg_object(this).m_y=t_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1642>";
	dbg_object(this).m_name="toggle button";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1643>";
	dbg_object(this).m_width=t_width;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1644>";
	dbg_object(this).m_height=t_height;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1645>";
	dbg_object(this).m_text=t_text;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1646>";
	dbg_object(this).m_font=t_the_font;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1647>";
	if(c_toggle_button.m_img==null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1648>";
		c_toggle_button.m_img=dbg_object(c_gui_class.m_gui_pointer).m_button_img;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1649>";
		c_toggle_button.m_img2=dbg_object(c_gui_class.m_gui_pointer).m_button_over_img;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1651>";
	if(t_parent!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1652>";
		dbg_object(t_parent).m_gadget_list.p_AddLast(this);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1654>";
	if(t_radio_list!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1655>";
		t_radio_list.p_AddLast(this);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1657>";
	dbg_object(this).m_obj=t_ob;
	pop_err();
	return this;
}
c_toggle_button.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1633>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1633>";
	pop_err();
	return this;
}
c_toggle_button.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1661>";
	c_gui_element.prototype.p_update.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1665>";
	if(this.m_pressed==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1666>";
		if(dbg_object(this).m_active==true){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1667>";
			dbg_object(this).m_active=false;
		}else{
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1669>";
			dbg_object(this).m_active=true;
		}
	}
	pop_err();
}
function c_sprite(){
	Object.call(this);
	this.m_width=0;
	this.m_height=0;
	this.m_attributes=[];
	this.m_scale=.0;
}
c_sprite.prototype.p_render=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<820>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<821>";
	bb_graphics_Scale(this.m_scale,this.m_scale);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<822>";
	for(var t_x=0;t_x<=this.m_width-1;t_x=t_x+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<823>";
		for(var t_y=0;t_y<=this.m_height-1;t_y=t_y+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<824>";
			dbg_array(dbg_array(dbg_object(this).m_attributes,t_x)[dbg_index],t_y)[dbg_index].p_render();
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<827>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_sprite.prototype.p_render_small=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<808>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<809>";
	bb_graphics_Scale(1.0,1.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<810>";
	for(var t_x=0;t_x<=this.m_width-1;t_x=t_x+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<811>";
		for(var t_y=0;t_y<=this.m_height-1;t_y=t_y+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<812>";
			dbg_array(dbg_array(dbg_object(this).m_attributes,t_x)[dbg_index],t_y)[dbg_index].p_render_small();
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<816>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_sprite.m_new=function(t_wid,t_hei){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<793>";
	dbg_object(this).m_scale=1.0;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<794>";
	dbg_object(this).m_width=t_wid;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<795>";
	dbg_object(this).m_height=t_hei;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<796>";
	dbg_object(this).m_attributes=new_array_array(this.m_width);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<797>";
	for(var t_ind=0;t_ind<=this.m_width-1;t_ind=t_ind+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<798>";
		dbg_array(dbg_object(this).m_attributes,t_ind)[dbg_index]=new_object_array(this.m_height)
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<800>";
	for(var t_xx=0;t_xx<=dbg_object(this).m_width-1;t_xx=t_xx+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<801>";
		for(var t_yy=0;t_yy<=dbg_object(this).m_height-1;t_yy=t_yy+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<803>";
			dbg_array(dbg_array(dbg_object(this).m_attributes,t_xx)[dbg_index],t_yy)[dbg_index]=c_attr.m_new.call(new c_attr,t_xx*80,t_yy*80)
		}
	}
	pop_err();
	return this;
}
c_sprite.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<742>";
	pop_err();
	return this;
}
c_sprite.prototype.p_Tostring=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<749>";
	var t_outer="";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<750>";
	t_outer=t_outer+"DIM mysprite (0 To 3,0 To 7) AS uByte => {_\n";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<751>";
	for(var t_y=0;t_y<=this.m_width-1;t_y=t_y+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<752>";
		for(var t_x=0;t_x<=this.m_height-1;t_x=t_x+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<753>";
			t_outer=t_outer+dbg_array(dbg_array(dbg_object(this).m_attributes,t_x)[dbg_index],t_y)[dbg_index].p_Tostring();
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<754>";
			if(t_x!=this.m_width-1 || t_y!=this.m_height-1){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<755>";
				t_outer=t_outer+",_\n";
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<759>";
	t_outer=t_outer+"}\n";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<760>";
	pop_err();
	return t_outer;
}
c_sprite.prototype.p_Tobin=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<763>";
	var t_outer="";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<764>";
	t_outer=t_outer+"MyUdgBlock:\n";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<765>";
	t_outer=t_outer+"ASM\n";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<766>";
	t_outer=t_outer+"\ndefb ";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<768>";
	for(var t_y=0;t_y<=this.m_height-1;t_y=t_y+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<769>";
		for(var t_x=0;t_x<=this.m_width-1;t_x=t_x+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<772>";
			t_outer=t_outer+dbg_array(dbg_array(dbg_object(this).m_attributes,t_x)[dbg_index],t_y)[dbg_index].p_Tobin();
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<773>";
			t_outer=t_outer+",";
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<787>";
	t_outer=t_outer+"\nENDASM\n";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<789>";
	pop_err();
	return t_outer;
}
function c_attr(){
	Object.call(this);
	this.m_xpos=0;
	this.m_ypos=0;
	this.m_dots=[];
	this.m_ink=0;
	this.m_paper=0;
	this.m_bright=0;
}
c_attr.prototype.p_render=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<711>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<712>";
	for(var t_x=0;t_x<=8;t_x=t_x+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<713>";
		bb_graphics_DrawLine((this.m_xpos+t_x*10),(this.m_ypos),(this.m_xpos+t_x*10),(this.m_ypos+80));
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<715>";
	for(var t_y=0;t_y<=8;t_y=t_y+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<716>";
		bb_graphics_DrawLine((this.m_xpos),(this.m_ypos+t_y*10),(this.m_xpos+80),(this.m_ypos+t_y*10));
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<718>";
	for(var t_x2=0;t_x2<=7;t_x2=t_x2+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<719>";
		for(var t_y2=0;t_y2<=7;t_y2=t_y2+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<721>";
			if(dbg_array(dbg_array(dbg_object(this).m_dots,t_x2)[dbg_index],t_y2)[dbg_index]==true){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<722>";
				bb_graphics_SetColor((bb_spriter_red_from_color(this.m_ink,this.m_bright)),(bb_spriter_green_from_color(this.m_ink,this.m_bright)),(bb_spriter_blue_from_color(this.m_ink,this.m_bright)));
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<723>";
				bb_graphics_DrawRect((this.m_xpos+t_x2*10),(this.m_ypos+t_y2*10),10.0,10.0);
			}
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<725>";
			if(dbg_array(dbg_array(dbg_object(this).m_dots,t_x2)[dbg_index],t_y2)[dbg_index]==false){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<726>";
				bb_graphics_SetColor((bb_spriter_red_from_color(this.m_paper,this.m_bright)),(bb_spriter_green_from_color(this.m_paper,this.m_bright)),(bb_spriter_blue_from_color(this.m_paper,this.m_bright)));
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<727>";
				bb_graphics_DrawRect((this.m_xpos+t_x2*10),(this.m_ypos+t_y2*10),10.0,10.0);
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<732>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	pop_err();
}
c_attr.prototype.p_render_small=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<688>";
	for(var t_x=0;t_x<=7;t_x=t_x+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<689>";
		for(var t_y=0;t_y<=7;t_y=t_y+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<691>";
			if(dbg_array(dbg_array(dbg_object(this).m_dots,t_x)[dbg_index],t_y)[dbg_index]==false){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<692>";
				bb_graphics_SetColor((bb_spriter_red_from_color(this.m_paper,this.m_bright)),(bb_spriter_green_from_color(this.m_paper,this.m_bright)),(bb_spriter_blue_from_color(this.m_paper,this.m_bright)));
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<693>";
				bb_graphics_DrawRect((((this.m_xpos/10)|0)+t_x+200),(((this.m_ypos/10)|0)+t_y+200),1.0,1.0);
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<694>";
				bb_graphics_DrawRect((((this.m_xpos/5)|0)+t_x*2+250),(((this.m_ypos/5)|0)+t_y*2+200),2.0,2.0);
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<695>";
				bb_graphics_DrawRect((((this.m_xpos/2)|0)+t_x*5+350),(((this.m_ypos/2)|0)+t_y*5+200),5.0,5.0);
			}
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<698>";
			if(dbg_array(dbg_array(dbg_object(this).m_dots,t_x)[dbg_index],t_y)[dbg_index]==true){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<699>";
				bb_graphics_SetColor((bb_spriter_red_from_color(this.m_ink,this.m_bright)),(bb_spriter_green_from_color(this.m_ink,this.m_bright)),(bb_spriter_blue_from_color(this.m_ink,this.m_bright)));
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<700>";
				bb_graphics_DrawRect((((this.m_xpos/10)|0)+t_x+200),(((this.m_ypos/10)|0)+t_y+200),1.0,1.0);
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<701>";
				bb_graphics_DrawRect((((this.m_xpos/5)|0)+t_x*2+250),(((this.m_ypos/5)|0)+t_y*2+200),2.0,2.0);
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<702>";
				bb_graphics_DrawRect((((this.m_xpos/2)|0)+t_x*5+350),(((this.m_ypos/2)|0)+t_y*5+200),5.0,5.0);
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<707>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	pop_err();
}
c_attr.m_new=function(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<679>";
	dbg_object(this).m_dots=new_array_array(8);
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<680>";
	for(var t_ind=0;t_ind<=7;t_ind=t_ind+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<681>";
		dbg_array(dbg_object(this).m_dots,t_ind)[dbg_index]=new_bool_array(8)
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<683>";
	dbg_object(this).m_xpos=t_x;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<684>";
	dbg_object(this).m_ypos=t_y;
	pop_err();
	return this;
}
c_attr.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<509>";
	pop_err();
	return this;
}
c_attr.prototype.p_Tostring=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<626>";
	var t_the_str="{";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<627>";
	var t_line_str="";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<628>";
	for(var t_y=0;t_y<=7;t_y=t_y+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<629>";
		for(var t_x=0;t_x<=7;t_x=t_x+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<630>";
			t_line_str=t_line_str+(String((dbg_array(dbg_array(dbg_object(this).m_dots,t_x)[dbg_index],t_y)[dbg_index])?1:0)+",");
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<633>";
		t_the_str=t_the_str+String(bb_spriter_bin2int(t_line_str));
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<634>";
		if(t_y!=7){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<635>";
			t_the_str=t_the_str+",";
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<637>";
		t_line_str="";
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<640>";
	t_the_str=t_the_str+"}";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<641>";
	pop_err();
	return t_the_str;
}
c_attr.prototype.p_Tobin=function(){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<607>";
	var t_line_str="";
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<608>";
	for(var t_y=0;t_y<=7;t_y=t_y+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<609>";
		for(var t_x=0;t_x<=7;t_x=t_x+1){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<610>";
			var t_the_int=0;
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<611>";
			if(dbg_array(dbg_array(dbg_object(this).m_dots,t_x)[dbg_index],t_y)[dbg_index]==false){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<612>";
				t_the_int=0;
			}else{
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<614>";
				t_the_int=1;
			}
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<616>";
			t_line_str=t_line_str+(String(t_the_int)+",");
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<619>";
		t_line_str=String(bb_spriter_bin2int(t_line_str));
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<620>";
		print(t_line_str);
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<622>";
	pop_err();
	return t_line_str;
}
var bb_spriter_current_ink=0;
var bb_spriter_current_paper=0;
function c_List(){
	Object.call(this);
	this.m__head=(c_HeadNode.m_new.call(new c_HeadNode));
}
c_List.prototype.p_ObjectEnumerator=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<168>";
	var t_=c_Enumerator.m_new.call(new c_Enumerator,this);
	pop_err();
	return t_;
}
c_List.prototype.p_Backwards=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<172>";
	var t_=c_BackwardsList.m_new.call(new c_BackwardsList,this);
	pop_err();
	return t_;
}
c_List.m_new=function(){
	push_err();
	pop_err();
	return this;
}
c_List.prototype.p_AddLast=function(t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<126>";
	var t_=c_Node.m_new.call(new c_Node,this.m__head,dbg_object(this.m__head).m__pred,t_data);
	pop_err();
	return t_;
}
c_List.m_new2=function(t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	var t_=t_data;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	var t_2=0;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	while(t_2<t_.length){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
		var t_t=dbg_array(t_,t_2)[dbg_index];
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
		t_2=t_2+1;
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<14>";
		this.p_AddLast(t_t);
	}
	pop_err();
	return this;
}
c_List.prototype.p_Equals=function(t_lhs,t_rhs){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<28>";
	var t_=t_lhs==t_rhs;
	pop_err();
	return t_;
}
c_List.prototype.p_RemoveEach=function(t_value){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<113>";
	var t_node=dbg_object(this.m__head).m__succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<114>";
	while(t_node!=this.m__head){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<115>";
		var t_succ=dbg_object(t_node).m__succ;
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<116>";
		if(this.p_Equals(dbg_object(t_node).m__data,t_value)){
			err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<116>";
			t_node.p_Remove();
		}
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<117>";
		t_node=t_succ;
	}
	pop_err();
	return 0;
}
c_List.prototype.p_Count=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<41>";
	var t_n=0;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<41>";
	var t_node=dbg_object(this.m__head).m__succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<42>";
	while(t_node!=this.m__head){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<43>";
		t_node=dbg_object(t_node).m__succ;
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<44>";
		t_n+=1;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<46>";
	pop_err();
	return t_n;
}
c_List.prototype.p_Clear=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<36>";
	dbg_object(this.m__head).m__succ=this.m__head;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<37>";
	dbg_object(this.m__head).m__pred=this.m__head;
	pop_err();
	return 0;
}
function c_Enumerator(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_Enumerator.m_new=function(t_list){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<308>";
	this.m__list=t_list;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<309>";
	this.m__curr=dbg_object(dbg_object(t_list).m__head).m__succ;
	pop_err();
	return this;
}
c_Enumerator.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<305>";
	pop_err();
	return this;
}
c_Enumerator.prototype.p_HasNext=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<313>";
	while(dbg_object(dbg_object(this.m__curr).m__succ).m__pred!=this.m__curr){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<314>";
		this.m__curr=dbg_object(this.m__curr).m__succ;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<316>";
	var t_=this.m__curr!=dbg_object(this.m__list).m__head;
	pop_err();
	return t_;
}
c_Enumerator.prototype.p_NextObject=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<320>";
	var t_data=dbg_object(this.m__curr).m__data;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<321>";
	this.m__curr=dbg_object(this.m__curr).m__succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<322>";
	pop_err();
	return t_data;
}
function c_Node(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data=null;
}
c_Node.m_new=function(t_succ,t_pred,t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<243>";
	this.m__succ=t_succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<244>";
	this.m__pred=t_pred;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<245>";
	dbg_object(this.m__succ).m__pred=this;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<246>";
	dbg_object(this.m__pred).m__succ=this;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<247>";
	this.m__data=t_data;
	pop_err();
	return this;
}
c_Node.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<240>";
	pop_err();
	return this;
}
c_Node.prototype.p_Remove=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<256>";
	if(dbg_object(this.m__succ).m__pred!=this){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<256>";
		error("Illegal operation on removed node");
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<258>";
	dbg_object(this.m__succ).m__pred=this.m__pred;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<259>";
	dbg_object(this.m__pred).m__succ=this.m__succ;
	pop_err();
	return 0;
}
function c_HeadNode(){
	c_Node.call(this);
}
c_HeadNode.prototype=extend_class(c_Node);
c_HeadNode.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<292>";
	c_Node.m_new2.call(this);
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<293>";
	this.m__succ=(this);
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<294>";
	this.m__pred=(this);
	pop_err();
	return this;
}
function bb_math_Max(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<56>";
	if(t_x>t_y){
		err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<56>";
		pop_err();
		return t_x;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<57>";
	pop_err();
	return t_y;
}
function bb_math_Max2(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<83>";
	if(t_x>t_y){
		err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<83>";
		pop_err();
		return t_x;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<84>";
	pop_err();
	return t_y;
}
function bb_math_Min(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<51>";
	if(t_x<t_y){
		err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<51>";
		pop_err();
		return t_x;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<52>";
	pop_err();
	return t_y;
}
function bb_math_Min2(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<78>";
	if(t_x<t_y){
		err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<78>";
		pop_err();
		return t_x;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/math.monkey<79>";
	pop_err();
	return t_y;
}
function bb_graphics_DebugRenderDevice(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<48>";
	if(!((bb_graphics_renderDevice)!=null)){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<48>";
		error("Rendering operations can only be performed inside OnRender");
	}
	pop_err();
	return 0;
}
function bb_graphics_Cls(t_r,t_g,t_b){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<372>";
	bb_graphics_DebugRenderDevice();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<374>";
	bb_graphics_renderDevice.Cls(t_r,t_g,t_b);
	pop_err();
	return 0;
}
function bb_graphics_Transform(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<349>";
	var t_ix2=t_ix*dbg_object(bb_graphics_context).m_ix+t_iy*dbg_object(bb_graphics_context).m_jx;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<350>";
	var t_iy2=t_ix*dbg_object(bb_graphics_context).m_iy+t_iy*dbg_object(bb_graphics_context).m_jy;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<351>";
	var t_jx2=t_jx*dbg_object(bb_graphics_context).m_ix+t_jy*dbg_object(bb_graphics_context).m_jx;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<352>";
	var t_jy2=t_jx*dbg_object(bb_graphics_context).m_iy+t_jy*dbg_object(bb_graphics_context).m_jy;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<353>";
	var t_tx2=t_tx*dbg_object(bb_graphics_context).m_ix+t_ty*dbg_object(bb_graphics_context).m_jx+dbg_object(bb_graphics_context).m_tx;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<354>";
	var t_ty2=t_tx*dbg_object(bb_graphics_context).m_iy+t_ty*dbg_object(bb_graphics_context).m_jy+dbg_object(bb_graphics_context).m_ty;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<355>";
	bb_graphics_SetMatrix(t_ix2,t_iy2,t_jx2,t_jy2,t_tx2,t_ty2);
	pop_err();
	return 0;
}
function bb_graphics_Transform2(t_m){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<345>";
	bb_graphics_Transform(dbg_array(t_m,0)[dbg_index],dbg_array(t_m,1)[dbg_index],dbg_array(t_m,2)[dbg_index],dbg_array(t_m,3)[dbg_index],dbg_array(t_m,4)[dbg_index],dbg_array(t_m,5)[dbg_index]);
	pop_err();
	return 0;
}
function bb_graphics_Scale(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<363>";
	bb_graphics_Transform(t_x,.0,.0,t_y,.0,.0);
	pop_err();
	return 0;
}
function bb_graphics_Translate(t_x,t_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<359>";
	bb_graphics_Transform(1.0,.0,.0,1.0,t_x,t_y);
	pop_err();
	return 0;
}
function bb_autofit_UpdateVirtualDisplay(t_zoomborders,t_keepborders){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<171>";
	c_VirtualDisplay.m_Display.p_UpdateVirtualDisplay(t_zoomborders,t_keepborders);
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<172>";
	pop_err();
	return 0;
}
function bb_graphics_PushMatrix(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<328>";
	var t_sp=dbg_object(bb_graphics_context).m_matrixSp;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<329>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+0)[dbg_index]=dbg_object(bb_graphics_context).m_ix
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<330>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+1)[dbg_index]=dbg_object(bb_graphics_context).m_iy
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<331>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+2)[dbg_index]=dbg_object(bb_graphics_context).m_jx
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<332>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+3)[dbg_index]=dbg_object(bb_graphics_context).m_jy
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<333>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+4)[dbg_index]=dbg_object(bb_graphics_context).m_tx
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<334>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+5)[dbg_index]=dbg_object(bb_graphics_context).m_ty
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<335>";
	dbg_object(bb_graphics_context).m_matrixSp=t_sp+6;
	pop_err();
	return 0;
}
function bb_graphics_DrawLine(t_x1,t_y1,t_x2,t_y2){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<395>";
	bb_graphics_DebugRenderDevice();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<397>";
	bb_graphics_context.p_Validate();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<398>";
	bb_graphics_renderDevice.DrawLine(t_x1,t_y1,t_x2,t_y2);
	pop_err();
	return 0;
}
function bb_spriter_red_from_color(t_col,t_bright){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<833>";
	var t_voltage=0;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<834>";
	if(t_bright==1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<835>";
		t_voltage=255;
	}else{
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<837>";
		t_voltage=191;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<840>";
	var t_=t_col;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<841>";
	if(t_==5){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<842>";
		pop_err();
		return 0;
	}else{
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<843>";
		if(t_==8){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<844>";
			pop_err();
			return 0;
		}else{
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<845>";
			if(t_==7){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<846>";
				pop_err();
				return t_voltage;
			}else{
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<847>";
				if(t_==6){
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<848>";
					pop_err();
					return t_voltage;
				}else{
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<849>";
					if(t_==3){
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<850>";
						pop_err();
						return t_voltage;
					}else{
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<851>";
						if(t_==2){
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<852>";
							pop_err();
							return t_voltage;
						}else{
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<853>";
							if(t_==4){
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<854>";
								pop_err();
								return 0;
							}else{
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<855>";
								if(t_==1){
									err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<856>";
									pop_err();
									return 0;
								}
							}
						}
					}
				}
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<858>";
	pop_err();
	return 0;
}
function bb_spriter_green_from_color(t_col,t_bright){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<862>";
	var t_voltage=0;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<863>";
	if(t_bright==1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<864>";
		t_voltage=255;
	}else{
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<866>";
		t_voltage=191;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<869>";
	var t_=t_col;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<870>";
	if(t_==5){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<871>";
		pop_err();
		return t_voltage;
	}else{
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<872>";
		if(t_==8){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<873>";
			pop_err();
			return 0;
		}else{
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<874>";
			if(t_==7){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<875>";
				pop_err();
				return t_voltage;
			}else{
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<876>";
				if(t_==6){
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<877>";
					pop_err();
					return t_voltage;
				}else{
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<878>";
					if(t_==3){
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<879>";
						pop_err();
						return 0;
					}else{
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<880>";
						if(t_==2){
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<881>";
							pop_err();
							return 0;
						}else{
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<882>";
							if(t_==4){
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<883>";
								pop_err();
								return t_voltage;
							}else{
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<884>";
								if(t_==1){
									err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<885>";
									pop_err();
									return 0;
								}
							}
						}
					}
				}
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<887>";
	pop_err();
	return 0;
}
function bb_spriter_blue_from_color(t_col,t_bright){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<891>";
	var t_voltage=0;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<892>";
	if(t_bright==1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<893>";
		t_voltage=255;
	}else{
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<895>";
		t_voltage=191;
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<898>";
	var t_=t_col;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<899>";
	if(t_==5){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<900>";
		pop_err();
		return t_voltage;
	}else{
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<901>";
		if(t_==8){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<902>";
			pop_err();
			return 0;
		}else{
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<903>";
			if(t_==7){
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<904>";
				pop_err();
				return t_voltage;
			}else{
				err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<905>";
				if(t_==6){
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<906>";
					pop_err();
					return 0;
				}else{
					err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<907>";
					if(t_==3){
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<908>";
						pop_err();
						return t_voltage;
					}else{
						err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<909>";
						if(t_==2){
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<910>";
							pop_err();
							return 0;
						}else{
							err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<911>";
							if(t_==4){
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<912>";
								pop_err();
								return 0;
							}else{
								err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<913>";
								if(t_==1){
									err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<914>";
									pop_err();
									return t_voltage;
								}
							}
						}
					}
				}
			}
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<916>";
	pop_err();
	return 0;
}
function bb_graphics_DrawRect(t_x,t_y,t_w,t_h){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<387>";
	bb_graphics_DebugRenderDevice();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<389>";
	bb_graphics_context.p_Validate();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<390>";
	bb_graphics_renderDevice.DrawRect(t_x,t_y,t_w,t_h);
	pop_err();
	return 0;
}
function bb_graphics_PopMatrix(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<339>";
	var t_sp=dbg_object(bb_graphics_context).m_matrixSp-6;
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<340>";
	bb_graphics_SetMatrix(dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+0)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+1)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+2)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+3)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+4)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+5)[dbg_index]);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<341>";
	dbg_object(bb_graphics_context).m_matrixSp=t_sp;
	pop_err();
	return 0;
}
function c_BackwardsList(){
	Object.call(this);
	this.m__list=null;
}
c_BackwardsList.m_new=function(t_list){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<335>";
	this.m__list=t_list;
	pop_err();
	return this;
}
c_BackwardsList.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<332>";
	pop_err();
	return this;
}
c_BackwardsList.prototype.p_ObjectEnumerator=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<339>";
	var t_=c_BackwardsEnumerator.m_new.call(new c_BackwardsEnumerator,this.m__list);
	pop_err();
	return t_;
}
function c_BackwardsEnumerator(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_BackwardsEnumerator.m_new=function(t_list){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<351>";
	this.m__list=t_list;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<352>";
	this.m__curr=dbg_object(dbg_object(t_list).m__head).m__pred;
	pop_err();
	return this;
}
c_BackwardsEnumerator.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<348>";
	pop_err();
	return this;
}
c_BackwardsEnumerator.prototype.p_HasNext=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<356>";
	while(dbg_object(dbg_object(this.m__curr).m__pred).m__succ!=this.m__curr){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<357>";
		this.m__curr=dbg_object(this.m__curr).m__pred;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<359>";
	var t_=this.m__curr!=dbg_object(this.m__list).m__head;
	pop_err();
	return t_;
}
c_BackwardsEnumerator.prototype.p_NextObject=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<363>";
	var t_data=dbg_object(this.m__curr).m__data;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<364>";
	this.m__curr=dbg_object(this.m__curr).m__pred;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<365>";
	pop_err();
	return t_data;
}
function c_label(){
	c_gui_element.call(this);
	this.m_backgrr=0;
	this.m_backgrg=0;
	this.m_backgrb=0;
	this.m_r=0;
	this.m_g=0;
	this.m_b=0;
	this.m_pos=0;
}
c_label.prototype=extend_class(c_gui_element);
c_label.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<455>";
	if(this.m_backgrr>0 || this.m_backgrg>0 || this.m_backgrb>0){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<456>";
		bb_graphics_SetColor((this.m_backgrr),(this.m_backgrg),(this.m_backgrb));
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<457>";
		bb_graphics_DrawRect((dbg_object(this).m_x),(dbg_object(this).m_y),dbg_object(this).m_width,dbg_object(this).m_height+5.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<460>";
	bb_graphics_SetColor((dbg_object(this).m_r),(dbg_object(this).m_g),(dbg_object(this).m_b));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<461>";
	if(this.m_pos==2){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<462>";
		dbg_object(this).m_font.p_draw(dbg_object(this).m_text,dbg_object(this).m_x-((dbg_object(this).m_font.p_TextWidth(dbg_object(this).m_text)/2)|0),dbg_object(this).m_y-((dbg_object(this).m_font.p_TextHeight(dbg_object(this).m_text)/2)|0)+5,1.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<464>";
	if(this.m_pos==1){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<465>";
		dbg_object(this).m_font.p_draw(dbg_object(this).m_text,dbg_object(this).m_x,dbg_object(this).m_y,1.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<467>";
	if(this.m_pos==3){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<468>";
		dbg_object(this).m_font.p_draw(dbg_object(this).m_text,(((dbg_object(this).m_x)+dbg_object(dbg_object(this).m_parent).m_width-(dbg_object(this).m_font.p_TextWidth(dbg_object(this).m_text)+5))|0),dbg_object(this).m_y,1.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<471>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	pop_err();
}
c_label.m_new=function(t_x,t_y,t_text,t_parent,t_the_font,t_the_r,t_the_g,t_the_b,t_poz,t_br,t_bg,t_bb){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<474>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<475>";
	dbg_object(this).m_x=t_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<476>";
	dbg_object(this).m_y=t_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<477>";
	dbg_object(this).m_pos=t_poz;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<478>";
	dbg_object(this).m_r=t_the_r;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<479>";
	dbg_object(this).m_g=t_the_g;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<480>";
	dbg_object(this).m_b=t_the_b;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<481>";
	dbg_object(this).m_backgrr=t_br;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<482>";
	dbg_object(this).m_backgrg=t_bg;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<483>";
	dbg_object(this).m_backgrb=t_bb;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<484>";
	dbg_object(this).m_name="label";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<485>";
	dbg_object(this).m_font=t_the_font;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<486>";
	dbg_object(this).m_text=t_text;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<487>";
	dbg_object(this).m_height=(dbg_object(this).m_font.p_TextHeight(t_text));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<488>";
	dbg_object(this).m_width=(dbg_object(this).m_font.p_TextWidth(t_text));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<489>";
	if(t_parent!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<490>";
		dbg_object(this).m_parent=t_parent;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<491>";
		dbg_object(this).m_parent.p_add_gadget((this),false,1);
	}
	pop_err();
	return this;
}
c_label.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<444>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<444>";
	pop_err();
	return this;
}
c_label.prototype.p_get_dimensions=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<496>";
	dbg_object(this).m_height=(dbg_object(this).m_font.p_TextHeight(this.m_text));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<497>";
	dbg_object(this).m_width=(dbg_object(this).m_font.p_TextWidth(this.m_text)+10);
	pop_err();
}
function c_keeffont(){
	Object.call(this);
	this.m_charmap=null;
	this.m_fontheight=0;
	this.m_img=null;
	this.m_width=0;
	this.m_height=0;
}
c_keeffont.prototype.p_get_char=function(t_Chr){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<101>";
	var t_=this.m_charmap.p_Get(t_Chr);
	pop_err();
	return t_;
}
c_keeffont.prototype.p_TextWidth=function(t_str){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<25>";
	var t_width=0;
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<27>";
	for(var t_x=1;t_x<=t_str.length;t_x=t_x+1){
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<29>";
		var t_char=t_str.slice(t_x-1,t_x);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<31>";
		var t_f=this.p_get_char(t_char);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<33>";
		if(t_f!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<34>";
			t_width+=dbg_object(t_f).m_xadvance;
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<35>";
			t_width+=-dbg_object(t_f).m_xoffset;
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<39>";
	pop_err();
	return t_width;
}
c_keeffont.prototype.p_TextHeight=function(t_str){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<43>";
	var t_height=0;
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<45>";
	for(var t_x=1;t_x<=t_str.length;t_x=t_x+1){
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<47>";
		var t_char=t_str.slice(t_x-1,t_x);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<49>";
		var t_f=this.p_get_char(t_char);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<51>";
		if(t_f!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<52>";
			if(dbg_object(t_f).m_height+dbg_object(t_f).m_yoffset>t_height){
				err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<53>";
				t_height=dbg_object(t_f).m_height+dbg_object(t_f).m_yoffset;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<58>";
	pop_err();
	return t_height;
}
c_keeffont.prototype.p_draw=function(t_txt,t_x_pos,t_y_pos,t_text_scale){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<64>";
	var t_x_place=0;
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<65>";
	var t_highest_char=0;
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<66>";
	var t_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<67>";
	for(t_x=1;t_x<=t_txt.length;t_x=t_x+1){
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<68>";
		var t_char=t_txt.slice(t_x-1,t_x);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<69>";
		var t_f=this.p_get_char(t_char);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<70>";
		if(t_f!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<71>";
			if(dbg_object(t_f).m_height>t_highest_char){
				err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<72>";
				t_highest_char=dbg_object(t_f).m_height;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<77>";
	for(t_x=1;t_x<=t_txt.length;t_x=t_x+1){
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<79>";
		var t_char2=t_txt.slice(t_x-1,t_x);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<80>";
		var t_f2=this.p_get_char(t_char2);
		err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<82>";
		if(t_f2!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<83>";
			var t_y=0;
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<84>";
			var t_y_place=t_y+dbg_object(t_f2).m_yoffset;
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<85>";
			bb_graphics_PushMatrix();
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<86>";
			bb_graphics_Translate((t_x_pos),(t_y_pos));
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<87>";
			bb_graphics_Translate((t_x_place),(t_y_place));
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<88>";
			bb_graphics_Scale(t_text_scale,t_text_scale);
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<89>";
			if(dbg_object(t_f2).m_img!=null){
				err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<90>";
				bb_graphics_DrawImage(dbg_object(t_f2).m_img,.0,.0,0);
			}
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<92>";
			bb_graphics_PopMatrix();
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<93>";
			t_x_place+=dbg_object(t_f2).m_xadvance;
			err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<94>";
			t_x_place=t_x_place+-dbg_object(t_f2).m_xoffset;
		}
	}
	pop_err();
}
c_keeffont.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<16>";
	pop_err();
	return this;
}
function c_Char(){
	Object.call(this);
	this.m_xadvance=0;
	this.m_xoffset=0;
	this.m_height=0;
	this.m_yoffset=0;
	this.m_img=null;
	this.m_name="";
	this.m_ascnum=0;
	this.m_width=0;
	this.m_x=0;
	this.m_y=0;
}
c_Char.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/keeffontclass/keeffontclass.monkey<3>";
	pop_err();
	return this;
}
function c_Map(){
	Object.call(this);
	this.m_root=null;
}
c_Map.prototype.p_Compare=function(t_lhs,t_rhs){
}
c_Map.prototype.p_FindNode=function(t_key){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<157>";
	var t_node=this.m_root;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<159>";
	while((t_node)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<160>";
		var t_cmp=this.p_Compare(t_key,dbg_object(t_node).m_key);
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<161>";
		if(t_cmp>0){
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<162>";
			t_node=dbg_object(t_node).m_right;
		}else{
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<163>";
			if(t_cmp<0){
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<164>";
				t_node=dbg_object(t_node).m_left;
			}else{
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<166>";
				pop_err();
				return t_node;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<169>";
	pop_err();
	return t_node;
}
c_Map.prototype.p_Get=function(t_key){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<101>";
	var t_node=this.p_FindNode(t_key);
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<102>";
	if((t_node)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<102>";
		pop_err();
		return dbg_object(t_node).m_value;
	}
	pop_err();
	return null;
}
c_Map.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<7>";
	pop_err();
	return this;
}
c_Map.prototype.p_RotateLeft=function(t_node){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<251>";
	var t_child=dbg_object(t_node).m_right;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<252>";
	dbg_object(t_node).m_right=dbg_object(t_child).m_left;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<253>";
	if((dbg_object(t_child).m_left)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<254>";
		dbg_object(dbg_object(t_child).m_left).m_parent=t_node;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<256>";
	dbg_object(t_child).m_parent=dbg_object(t_node).m_parent;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<257>";
	if((dbg_object(t_node).m_parent)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<258>";
		if(t_node==dbg_object(dbg_object(t_node).m_parent).m_left){
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<259>";
			dbg_object(dbg_object(t_node).m_parent).m_left=t_child;
		}else{
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<261>";
			dbg_object(dbg_object(t_node).m_parent).m_right=t_child;
		}
	}else{
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<264>";
		this.m_root=t_child;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<266>";
	dbg_object(t_child).m_left=t_node;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<267>";
	dbg_object(t_node).m_parent=t_child;
	pop_err();
	return 0;
}
c_Map.prototype.p_RotateRight=function(t_node){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<271>";
	var t_child=dbg_object(t_node).m_left;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<272>";
	dbg_object(t_node).m_left=dbg_object(t_child).m_right;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<273>";
	if((dbg_object(t_child).m_right)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<274>";
		dbg_object(dbg_object(t_child).m_right).m_parent=t_node;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<276>";
	dbg_object(t_child).m_parent=dbg_object(t_node).m_parent;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<277>";
	if((dbg_object(t_node).m_parent)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<278>";
		if(t_node==dbg_object(dbg_object(t_node).m_parent).m_right){
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<279>";
			dbg_object(dbg_object(t_node).m_parent).m_right=t_child;
		}else{
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<281>";
			dbg_object(dbg_object(t_node).m_parent).m_left=t_child;
		}
	}else{
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<284>";
		this.m_root=t_child;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<286>";
	dbg_object(t_child).m_right=t_node;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<287>";
	dbg_object(t_node).m_parent=t_child;
	pop_err();
	return 0;
}
c_Map.prototype.p_InsertFixup=function(t_node){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<212>";
	while(((dbg_object(t_node).m_parent)!=null) && dbg_object(dbg_object(t_node).m_parent).m_color==-1 && ((dbg_object(dbg_object(t_node).m_parent).m_parent)!=null)){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<213>";
		if(dbg_object(t_node).m_parent==dbg_object(dbg_object(dbg_object(t_node).m_parent).m_parent).m_left){
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<214>";
			var t_uncle=dbg_object(dbg_object(dbg_object(t_node).m_parent).m_parent).m_right;
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<215>";
			if(((t_uncle)!=null) && dbg_object(t_uncle).m_color==-1){
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<216>";
				dbg_object(dbg_object(t_node).m_parent).m_color=1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<217>";
				dbg_object(t_uncle).m_color=1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<218>";
				dbg_object(dbg_object(t_uncle).m_parent).m_color=-1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<219>";
				t_node=dbg_object(t_uncle).m_parent;
			}else{
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<221>";
				if(t_node==dbg_object(dbg_object(t_node).m_parent).m_right){
					err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<222>";
					t_node=dbg_object(t_node).m_parent;
					err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<223>";
					this.p_RotateLeft(t_node);
				}
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<225>";
				dbg_object(dbg_object(t_node).m_parent).m_color=1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<226>";
				dbg_object(dbg_object(dbg_object(t_node).m_parent).m_parent).m_color=-1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<227>";
				this.p_RotateRight(dbg_object(dbg_object(t_node).m_parent).m_parent);
			}
		}else{
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<230>";
			var t_uncle2=dbg_object(dbg_object(dbg_object(t_node).m_parent).m_parent).m_left;
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<231>";
			if(((t_uncle2)!=null) && dbg_object(t_uncle2).m_color==-1){
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<232>";
				dbg_object(dbg_object(t_node).m_parent).m_color=1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<233>";
				dbg_object(t_uncle2).m_color=1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<234>";
				dbg_object(dbg_object(t_uncle2).m_parent).m_color=-1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<235>";
				t_node=dbg_object(t_uncle2).m_parent;
			}else{
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<237>";
				if(t_node==dbg_object(dbg_object(t_node).m_parent).m_left){
					err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<238>";
					t_node=dbg_object(t_node).m_parent;
					err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<239>";
					this.p_RotateRight(t_node);
				}
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<241>";
				dbg_object(dbg_object(t_node).m_parent).m_color=1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<242>";
				dbg_object(dbg_object(dbg_object(t_node).m_parent).m_parent).m_color=-1;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<243>";
				this.p_RotateLeft(dbg_object(dbg_object(t_node).m_parent).m_parent);
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<247>";
	dbg_object(this.m_root).m_color=1;
	pop_err();
	return 0;
}
c_Map.prototype.p_Set=function(t_key,t_value){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<29>";
	var t_node=this.m_root;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<30>";
	var t_parent=null;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<30>";
	var t_cmp=0;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<32>";
	while((t_node)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<33>";
		t_parent=t_node;
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<34>";
		t_cmp=this.p_Compare(t_key,dbg_object(t_node).m_key);
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<35>";
		if(t_cmp>0){
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<36>";
			t_node=dbg_object(t_node).m_right;
		}else{
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<37>";
			if(t_cmp<0){
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<38>";
				t_node=dbg_object(t_node).m_left;
			}else{
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<40>";
				dbg_object(t_node).m_value=t_value;
				err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<41>";
				pop_err();
				return false;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<45>";
	t_node=c_Node2.m_new.call(new c_Node2,t_key,t_value,-1,t_parent);
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<47>";
	if((t_parent)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<48>";
		if(t_cmp>0){
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<49>";
			dbg_object(t_parent).m_right=t_node;
		}else{
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<51>";
			dbg_object(t_parent).m_left=t_node;
		}
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<53>";
		this.p_InsertFixup(t_node);
	}else{
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<55>";
		this.m_root=t_node;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<57>";
	pop_err();
	return true;
}
c_Map.prototype.p_Values=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<117>";
	var t_=c_MapValues.m_new.call(new c_MapValues,this);
	pop_err();
	return t_;
}
c_Map.prototype.p_FirstNode=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<137>";
	if(!((this.m_root)!=null)){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<137>";
		pop_err();
		return null;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<139>";
	var t_node=this.m_root;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<140>";
	while((dbg_object(t_node).m_left)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<141>";
		t_node=dbg_object(t_node).m_left;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<143>";
	pop_err();
	return t_node;
}
function c_StringMap(){
	c_Map.call(this);
}
c_StringMap.prototype=extend_class(c_Map);
c_StringMap.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<551>";
	c_Map.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<551>";
	pop_err();
	return this;
}
c_StringMap.prototype.p_Compare=function(t_lhs,t_rhs){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<554>";
	var t_=string_compare(t_lhs,t_rhs);
	pop_err();
	return t_;
}
function c_Node2(){
	Object.call(this);
	this.m_key="";
	this.m_right=null;
	this.m_left=null;
	this.m_value=null;
	this.m_color=0;
	this.m_parent=null;
}
c_Node2.m_new=function(t_key,t_value,t_color,t_parent){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<364>";
	dbg_object(this).m_key=t_key;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<365>";
	dbg_object(this).m_value=t_value;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<366>";
	dbg_object(this).m_color=t_color;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<367>";
	dbg_object(this).m_parent=t_parent;
	pop_err();
	return this;
}
c_Node2.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<361>";
	pop_err();
	return this;
}
c_Node2.prototype.p_NextNode=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<385>";
	var t_node=null;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<386>";
	if((this.m_right)!=null){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<387>";
		t_node=this.m_right;
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<388>";
		while((dbg_object(t_node).m_left)!=null){
			err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<389>";
			t_node=dbg_object(t_node).m_left;
		}
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<391>";
		pop_err();
		return t_node;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<393>";
	t_node=this;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<394>";
	var t_parent=dbg_object(this).m_parent;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<395>";
	while(((t_parent)!=null) && t_node==dbg_object(t_parent).m_right){
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<396>";
		t_node=t_parent;
		err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<397>";
		t_parent=dbg_object(t_parent).m_parent;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<399>";
	pop_err();
	return t_parent;
}
function bb_graphics_DrawImage(t_image,t_x,t_y,t_frame){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<436>";
	bb_graphics_DebugRenderDevice();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<437>";
	if(t_frame<0 || t_frame>=dbg_object(t_image).m_frames.length){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<437>";
		error("Invalid image frame");
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<440>";
	var t_f=dbg_array(dbg_object(t_image).m_frames,t_frame)[dbg_index];
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<442>";
	bb_graphics_context.p_Validate();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<444>";
	if((dbg_object(t_image).m_flags&65536)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<445>";
		bb_graphics_renderDevice.DrawSurface(dbg_object(t_image).m_surface,t_x-dbg_object(t_image).m_tx,t_y-dbg_object(t_image).m_ty);
	}else{
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<447>";
		bb_graphics_renderDevice.DrawSurface2(dbg_object(t_image).m_surface,t_x-dbg_object(t_image).m_tx,t_y-dbg_object(t_image).m_ty,dbg_object(t_f).m_x,dbg_object(t_f).m_y,dbg_object(t_image).m_width,dbg_object(t_image).m_height);
	}
	pop_err();
	return 0;
}
function bb_graphics_Rotate(t_angle){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<367>";
	bb_graphics_Transform(Math.cos((t_angle)*D2R),-Math.sin((t_angle)*D2R),Math.sin((t_angle)*D2R),Math.cos((t_angle)*D2R),.0,.0);
	pop_err();
	return 0;
}
function bb_graphics_DrawImage2(t_image,t_x,t_y,t_rotation,t_scaleX,t_scaleY,t_frame){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<454>";
	bb_graphics_DebugRenderDevice();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<455>";
	if(t_frame<0 || t_frame>=dbg_object(t_image).m_frames.length){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<455>";
		error("Invalid image frame");
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<458>";
	var t_f=dbg_array(dbg_object(t_image).m_frames,t_frame)[dbg_index];
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<460>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<462>";
	bb_graphics_Translate(t_x,t_y);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<463>";
	bb_graphics_Rotate(t_rotation);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<464>";
	bb_graphics_Scale(t_scaleX,t_scaleY);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<466>";
	bb_graphics_Translate(-dbg_object(t_image).m_tx,-dbg_object(t_image).m_ty);
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<468>";
	bb_graphics_context.p_Validate();
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<470>";
	if((dbg_object(t_image).m_flags&65536)!=0){
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<471>";
		bb_graphics_renderDevice.DrawSurface(dbg_object(t_image).m_surface,.0,.0);
	}else{
		err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<473>";
		bb_graphics_renderDevice.DrawSurface2(dbg_object(t_image).m_surface,.0,.0,dbg_object(t_f).m_x,dbg_object(t_f).m_y,dbg_object(t_image).m_width,dbg_object(t_image).m_height);
	}
	err_info="/root/Dropbox/Monkey/modules/mojo/graphics.monkey<476>";
	bb_graphics_PopMatrix();
	pop_err();
	return 0;
}
function c_background_img(){
	c_gui_element.call(this);
	this.m_tiled=false;
	this.m_scalex=.0;
	this.m_scaley=.0;
	this.m_image=null;
}
c_background_img.prototype=extend_class(c_gui_element);
c_background_img.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<528>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<529>";
	if(dbg_object(this).m_tiled==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<530>";
		for(var t_x=0;(t_x)<=(bb_graphics_DeviceWidth())/dbg_object(this).m_width;t_x=t_x+1){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<531>";
			for(var t_y=0;(t_y)<=(bb_graphics_DeviceHeight())/dbg_object(this).m_height;t_y=t_y+1){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<532>";
				bb_graphics_PushMatrix();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<533>";
				bb_graphics_Translate((t_x)*dbg_object(this).m_width,(t_y)*dbg_object(this).m_height);
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<534>";
				bb_graphics_Scale(this.m_scalex,this.m_scaley);
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<535>";
				bb_graphics_DrawImage(this.m_image,.0,.0,0);
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<536>";
				bb_graphics_PopMatrix();
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<540>";
	if(dbg_object(this).m_tiled==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<541>";
		bb_graphics_PushMatrix();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<542>";
		bb_graphics_Translate((this.m_x),(this.m_y));
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<543>";
		bb_graphics_Scale(this.m_scalex,this.m_scaley);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<544>";
		bb_graphics_DrawImage(this.m_image,.0,.0,0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<545>";
		bb_graphics_PopMatrix();
	}
	pop_err();
}
c_background_img.prototype.p_get_dimensions=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<519>";
	dbg_object(this).m_height=(this.m_image.p_Height())*this.m_scalex;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<520>";
	dbg_object(this).m_width=(this.m_image.p_Width())*this.m_scaley;
	pop_err();
}
function c_img(){
	c_gui_element.call(this);
	this.m_angle=0;
	this.m_image=null;
}
c_img.prototype=extend_class(c_gui_element);
c_img.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<581>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<583>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<584>";
	bb_graphics_Translate((this.m_x),(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<585>";
	bb_graphics_Rotate(dbg_object(this).m_angle);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<586>";
	bb_graphics_Scale(dbg_object(this).m_width/(this.m_image.p_Width()),this.m_height/(this.m_image.p_Height()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<587>";
	var t_draw_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<588>";
	var t_draw_y=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<590>";
	bb_graphics_DrawImage(this.m_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<591>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_img.prototype.p_get_dimensions=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<556>";
	dbg_object(this).m_height=(this.m_image.p_Height());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<557>";
	dbg_object(this).m_width=(this.m_image.p_Width());
	pop_err();
}
function c_img_button(){
	c_gui_element.call(this);
	this.m_scalex=.0;
	this.m_scaley=.0;
	this.m_image=null;
	this.m_over_image=null;
	this.m_toggle=false;
}
c_img_button.prototype=extend_class(c_gui_element);
c_img_button.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<657>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<658>";
	var t_draw_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<659>";
	var t_draw_y=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<662>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<671>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<673>";
	if(this.m_pressed_timer+300>bb_app_Millisecs()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<674>";
		bb_graphics_Translate((this.m_x),(this.m_y+2));
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<675>";
		bb_graphics_Scale(this.m_scalex,this.m_scaley);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<677>";
		bb_graphics_DrawImage(this.m_image,.0,.0,0);
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<682>";
		bb_graphics_Translate((this.m_x),(this.m_y));
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<683>";
		bb_graphics_Scale(this.m_scalex,this.m_scaley);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<685>";
		if(this.m_active==false || this.m_over_image==null){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<686>";
			bb_graphics_DrawImage(this.m_image,.0,.0,0);
		}else{
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<688>";
			if(this.m_toggle==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<689>";
				bb_graphics_SetColor(255.0,.0,.0);
			}
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<691>";
			bb_graphics_DrawImage(this.m_over_image,.0,.0,0);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<692>";
			bb_graphics_SetColor(255.0,255.0,255.0);
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<695>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<697>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<699>";
	if(this.m_active==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<700>";
		print("button is active");
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<701>";
		bb_graphics_SetColor(100.0,100.0,100.0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<702>";
		bb_graphics_DrawRect((dbg_object(this).m_x),(dbg_object(this).m_y),(this.m_image.p_Width()),5.0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<703>";
		bb_graphics_SetColor(160.0,160.0,160.0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<704>";
		bb_graphics_DrawRect((dbg_object(this).m_x),(dbg_object(this).m_y),5.0,(this.m_image.p_Height()));
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<705>";
		bb_graphics_SetColor(160.0,160.0,160.0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<706>";
		bb_graphics_DrawRect((dbg_object(this).m_x),(dbg_object(this).m_y+(this.m_image.p_Height()-5)),(this.m_image.p_Height()),5.0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<707>";
		bb_graphics_SetColor(220.0,220.0,220.0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<708>";
		bb_graphics_DrawRect((dbg_object(this).m_x+this.m_image.p_Width()-5),(dbg_object(this).m_y),5.0,(this.m_image.p_Height()));
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<711>";
	if(this.m_active==false && this.m_mouse_over==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<712>";
		bb_graphics_SetColor((dbg_object(c_gui_class.m_gui_pointer).m_textr),(dbg_object(c_gui_class.m_gui_pointer).m_textg),(dbg_object(c_gui_class.m_gui_pointer).m_textb));
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<719>";
	if(this.m_text!=""){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<720>";
		t_draw_x=(((this.m_x)+this.m_width/2.0-((this.m_font.p_TextWidth(this.m_text)/2)|0))|0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<721>";
		t_draw_y=(((this.m_y)+this.m_height/2.0-((this.m_font.p_TextHeight(this.m_text)/2)|0))|0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<722>";
		this.m_font.p_draw(this.m_text,t_draw_x,t_draw_y,1.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<724>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<726>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<727>";
	bb_graphics_SetAlpha(1.0);
	pop_err();
}
c_img_button.m_new=function(t_x,t_y,t_used_image,t_overimage,t_text,t_parent,t_the_font,t_rad_list,t_tog,t_scale_x,t_scale_y){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<602>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<603>";
	dbg_object(this).m_name="img button";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<604>";
	dbg_object(this).m_x=t_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<605>";
	dbg_object(this).m_y=t_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<606>";
	dbg_object(this).m_font=t_the_font;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<607>";
	dbg_object(this).m_text=t_text;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<608>";
	dbg_object(this).m_toggle=t_tog;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<609>";
	dbg_object(this).m_image=t_used_image;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<610>";
	dbg_object(this).m_over_image=t_overimage;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<611>";
	dbg_object(this).m_scalex=t_scale_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<612>";
	dbg_object(this).m_scaley=t_scale_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<614>";
	dbg_object(this).m_width=(t_used_image.p_Width())*this.m_scalex;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<615>";
	dbg_object(this).m_height=(t_used_image.p_Height())*this.m_scaley;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<617>";
	if(t_parent!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<618>";
		dbg_object(this).m_parent=t_parent;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<619>";
		dbg_object(this).m_parent.p_add_gadget((this),false,1);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<621>";
	if(t_rad_list!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<622>";
		dbg_object(this).m_radio_list=t_rad_list;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<623>";
		dbg_object(this).m_radio_list.p_AddLast(this);
	}
	pop_err();
	return this;
}
c_img_button.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<596>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<596>";
	pop_err();
	return this;
}
c_img_button.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<635>";
	c_gui_element.prototype.p_update.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<636>";
	if(this.m_pressed==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<637>";
		if(this.m_toggle==true){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<638>";
			if(dbg_object(this).m_active==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<639>";
				dbg_object(this).m_active=false;
			}else{
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<641>";
				dbg_object(this).m_active=true;
			}
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<645>";
		if(dbg_object(this).m_radio_list!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<646>";
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<646>";
			var t_=dbg_object(this).m_radio_list.p_ObjectEnumerator();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<646>";
			while(t_.p_HasNext()){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<646>";
				var t_t=t_.p_NextObject();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<647>";
				dbg_object(t_t).m_active=false;
			}
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<649>";
			dbg_object(this).m_active=true;
		}
	}
	pop_err();
}
c_img_button.prototype.p_get_dimensions=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<629>";
	dbg_object(this).m_height=(this.m_image.p_Height())*this.m_scalex;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<630>";
	dbg_object(this).m_width=(this.m_image.p_Width())*this.m_scaley;
	pop_err();
}
function c_gui_class(){
	Object.call(this);
	this.m_textr=0;
	this.m_textg=0;
	this.m_textb=0;
	this.m_window_image=null;
	this.m_border_image=null;
	this.m_up_arrow=null;
	this.m_down_arrow=null;
	this.m_button_img=null;
	this.m_button_over_img=null;
}
c_gui_class.m_gui_pointer=null;
c_gui_class.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<56>";
	pop_err();
	return this;
}
c_gui_class.m_init_gui=function(t_r,t_g,t_b){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<71>";
	c_gui_class.m_gui_pointer=c_gui_class.m_new.call(new c_gui_class);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<73>";
	dbg_object(c_gui_class.m_gui_pointer).m_down_arrow=bb_graphics_LoadImage("guiskin/downarrow.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<74>";
	dbg_object(c_gui_class.m_gui_pointer).m_up_arrow=bb_graphics_LoadImage("guiskin/uparrow.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<75>";
	dbg_object(c_gui_class.m_gui_pointer).m_window_image=bb_graphics_LoadImage("guiskin/paper.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<76>";
	dbg_object(c_gui_class.m_gui_pointer).m_button_img=bb_graphics_LoadImage("guiskin/button.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<77>";
	dbg_object(c_gui_class.m_gui_pointer).m_button_over_img=bb_graphics_LoadImage("guiskin/buttonpressed.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<78>";
	dbg_object(c_gui_class.m_gui_pointer).m_border_image=bb_graphics_LoadImage("guiskin/border.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<79>";
	dbg_object(c_gui_class.m_gui_pointer).m_textr=t_r;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<80>";
	dbg_object(c_gui_class.m_gui_pointer).m_textg=t_g;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<81>";
	dbg_object(c_gui_class.m_gui_pointer).m_textb=t_b;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<86>";
	c_gui_element.m_list=c_List.m_new.call(new c_List);
	pop_err();
}
function c_button(){
	c_gui_element.call(this);
	this.m_disabled=false;
}
c_button.prototype=extend_class(c_gui_element);
c_button.m_img=null;
c_button.m_img2=null;
c_button.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<821>";
	var t_scalex=.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<822>";
	var t_scaley=.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<824>";
	bb_graphics_SetAlpha(dbg_object(this).m_alpha);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<825>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<826>";
	var t_draw_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<827>";
	var t_draw_y=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<830>";
	if(this.m_pressed_timer+300>bb_app_Millisecs() && this.m_mouse_down==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<831>";
		bb_graphics_PushMatrix();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<832>";
		bb_graphics_Translate((this.m_x),(this.m_y+5));
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<833>";
		t_scalex=dbg_object(this).m_width/(c_button.m_img.p_Width());
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<834>";
		t_scaley=this.m_height/(c_button.m_img.p_Height());
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<835>";
		bb_graphics_Scale(t_scalex,t_scaley);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<836>";
		bb_graphics_DrawImage(c_button.m_img2,.0,.0,0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<837>";
		bb_graphics_PopMatrix();
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<839>";
		bb_graphics_PushMatrix();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<840>";
		bb_graphics_Translate((this.m_x),(this.m_y));
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<841>";
		t_scalex=dbg_object(this).m_width/(c_button.m_img.p_Width());
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<842>";
		t_scaley=this.m_height/(c_button.m_img.p_Height());
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<843>";
		bb_graphics_Scale(t_scalex,t_scaley);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<844>";
		bb_graphics_DrawImage(c_button.m_img,.0,.0,0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<845>";
		bb_graphics_PopMatrix();
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<850>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<852>";
	if(this.m_active==false && this.m_mouse_over==false && this.m_disabled==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<853>";
		bb_graphics_SetColor((dbg_object(c_gui_class.m_gui_pointer).m_textr),(dbg_object(c_gui_class.m_gui_pointer).m_textg),(dbg_object(c_gui_class.m_gui_pointer).m_textb));
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<856>";
	if(dbg_object(this).m_highlighted==true && this.m_disabled==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<857>";
		bb_graphics_SetColor(170.0,.0,.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<860>";
	if(this.m_disabled==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<861>";
		bb_graphics_SetColor(50.0,50.0,50.0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<864>";
	t_draw_x=(((this.m_x)+this.m_width/2.0-((this.m_font.p_TextWidth(this.m_text)/2)|0))|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<865>";
	t_draw_y=(((this.m_y)+this.m_height/2.0-((this.m_font.p_TextHeight(this.m_text)/2)|0))|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<866>";
	this.m_font.p_draw(this.m_text,t_draw_x,t_draw_y,1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<867>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<868>";
	bb_graphics_SetAlpha(1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<869>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_button.m_new=function(t_x,t_y,t_width,t_height,t_text,t_parent,t_the_font,t_rad_list,t_imag,t_buttondown){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<770>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<771>";
	dbg_object(this).m_x=t_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<772>";
	dbg_object(this).m_y=t_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<773>";
	dbg_object(this).m_repeatable=t_buttondown;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<774>";
	dbg_object(this).m_name="button";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<775>";
	dbg_object(this).m_font=t_the_font;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<776>";
	dbg_object(this).m_width=t_width;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<777>";
	dbg_object(this).m_height=t_height;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<778>";
	dbg_object(this).m_text=t_text;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<779>";
	c_button.m_img=t_imag;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<780>";
	if(c_button.m_img==null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<781>";
		c_button.m_img=dbg_object(c_gui_class.m_gui_pointer).m_button_img;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<782>";
		c_button.m_img2=dbg_object(c_gui_class.m_gui_pointer).m_button_over_img;
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<784>";
		c_button.m_img2=t_imag;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<786>";
	if(t_rad_list!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<787>";
		dbg_object(this).m_radio_list=t_rad_list;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<788>";
		dbg_object(this).m_radio_list.p_AddLast(this);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<791>";
	if(t_parent!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<792>";
		dbg_object(this).m_parent=t_parent;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<793>";
		dbg_object(dbg_object(this).m_parent).m_gadget_list.p_AddLast(this);
	}
	pop_err();
	return this;
}
c_button.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<758>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<758>";
	pop_err();
	return this;
}
c_button.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<799>";
	c_gui_element.prototype.p_update.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<801>";
	if(this.m_pressed==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<806>";
		dbg_object(this).m_active=true;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<810>";
		if(dbg_object(this).m_radio_list!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<811>";
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<811>";
			var t_=dbg_object(this).m_radio_list.p_ObjectEnumerator();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<811>";
			while(t_.p_HasNext()){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<811>";
				var t_t=t_.p_NextObject();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<812>";
				dbg_object(t_t).m_active=false;
			}
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<814>";
			dbg_object(this).m_active=true;
		}
	}
	pop_err();
}
function c_Inputbox(){
	c_gui_element.call(this);
	this.m_has_focus=false;
	this.m_blink=false;
	this.m_the_string="";
	this.m_lastinput=0;
}
c_Inputbox.prototype=extend_class(c_gui_element);
c_Inputbox.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<905>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<907>";
	var t_end_string="";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<909>";
	if(this.m_has_focus==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<910>";
		if(this.m_blink==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<911>";
			this.m_blink=true;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<912>";
			t_end_string="|";
		}else{
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<914>";
			this.m_blink=false;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<915>";
			t_end_string="";
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<919>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<923>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<924>";
	bb_graphics_SetColor((dbg_object(c_gui_class.m_gui_pointer).m_textr),(dbg_object(c_gui_class.m_gui_pointer).m_textg),(dbg_object(c_gui_class.m_gui_pointer).m_textb));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<925>";
	var t_x1=this.m_x+10;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<926>";
	var t_y1=this.m_y+5;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<927>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<928>";
	if((dbg_object(this).m_font.p_TextWidth(this.m_the_string))<this.m_width-10.0){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<929>";
		dbg_object(this).m_font.p_draw(this.m_the_string+t_end_string,t_x1,t_y1,1.0);
	}else{
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<932>";
		for(var t_x=1;t_x<=this.m_the_string.length;t_x=t_x+1){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<933>";
			var t_temp_string=this.m_the_string.slice(t_x);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<934>";
			if((dbg_object(this).m_font.p_TextWidth(t_temp_string))>this.m_width-10.0){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<935>";
				dbg_object(this).m_font.p_draw(t_temp_string.slice(t_temp_string.length-1)+t_end_string,t_x1,t_y1,1.0);
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<936>";
				break;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<942>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<943>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_Inputbox.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<949>";
	c_gui_element.prototype.p_update.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<951>";
	dbg_object(this).m_pressed=false;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<953>";
	if(c_gui_element.m_clicked==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<954>";
		if(bb_customgui_mouse_hit1){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<955>";
			if(this.m_mouse_over==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<956>";
				dbg_object(this).m_pressed=true;
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<957>";
				c_gui_element.m_clicked=true;
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<958>";
				this.m_has_focus=true;
			}else{
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<960>";
				this.m_has_focus=false;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<964>";
	if(this.m_has_focus==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<965>";
		var t_char=bb_input_GetChar();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<968>";
		this.m_lastinput=t_char;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<969>";
		if(t_char>8 && t_char!=13){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<970>";
			this.m_the_string=this.m_the_string+String.fromCharCode(t_char);
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<973>";
		if(t_char==8){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<974>";
			this.m_the_string=this.m_the_string.slice(0,this.m_the_string.length-1);
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<977>";
		dbg_object(this).m_text=this.m_the_string;
	}
	pop_err();
}
function c_textbox(){
	c_gui_element.call(this);
	this.m_line_list=null;
	this.m_current_line=0;
}
c_textbox.prototype=extend_class(c_gui_element);
c_textbox.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1117>";
	var t_scalex=.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1118>";
	var t_scaley=.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1120>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1121>";
	bb_graphics_SetAlpha(dbg_object(this).m_alpha);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1122>";
	bb_graphics_SetColor((dbg_object(this).m_red),(dbg_object(this).m_green),(dbg_object(this).m_blue));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1123>";
	t_scalex=this.m_width/(dbg_object(c_gui_class.m_gui_pointer).m_window_image.p_Width());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1124>";
	t_scaley=this.m_height/(dbg_object(c_gui_class.m_gui_pointer).m_window_image.p_Height());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1125>";
	bb_graphics_Translate((this.m_x),(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1126>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1127>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_window_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1128>";
	var t_border_width=10.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1129>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1131>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1132>";
	t_scalex=t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1133>";
	t_scaley=this.m_height/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Height());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1134>";
	bb_graphics_Translate((this.m_x)-t_border_width,(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1135>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1136>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1137>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1138>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1139>";
	bb_graphics_Translate((this.m_x)+dbg_object(this).m_width,(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1140>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1141>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1142>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1144>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1145>";
	t_scalex=this.m_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1146>";
	t_scaley=t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Height());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1147>";
	bb_graphics_Translate((this.m_x),(this.m_y)-t_border_width);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1148>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1149>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1150>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1152>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1153>";
	bb_graphics_Translate((this.m_x),(this.m_y)+dbg_object(this).m_height);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1154>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1155>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1156>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1158>";
	t_scalex=t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1159>";
	t_scaley=t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1161>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1162>";
	bb_graphics_Translate((this.m_x),(this.m_y)+dbg_object(this).m_height);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1163>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1164>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1165>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1167>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1168>";
	bb_graphics_Translate((this.m_x)-t_border_width,(this.m_y)-t_border_width);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1169>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1170>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1171>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1173>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1174>";
	bb_graphics_Translate((this.m_x)+this.m_width,(this.m_y)-t_border_width);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1175>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1176>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1177>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1180>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1181>";
	bb_graphics_Translate((this.m_x)-t_border_width,(this.m_y)+this.m_height);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1182>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1183>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1184>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1187>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1188>";
	bb_graphics_Translate((this.m_x)+this.m_width,(this.m_y)+this.m_height);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1189>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1190>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1191>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1194>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1195>";
	bb_graphics_SetColor((dbg_object(c_gui_class.m_gui_pointer).m_textr),(dbg_object(c_gui_class.m_gui_pointer).m_textg),(dbg_object(c_gui_class.m_gui_pointer).m_textb));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1196>";
	var t_line_position=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1197>";
	var t_iter=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1198>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1198>";
	var t_=this.m_line_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1198>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1198>";
		var t_a=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1199>";
		if(t_line_position>this.m_current_line-1){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1200>";
			if((t_line_position)<(this.m_current_line)+this.m_height/(dbg_object(this).m_font.p_TextHeight(t_a))-1.0){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1201>";
				dbg_object(this).m_font.p_draw(t_a,this.m_x+9,this.m_y+(t_iter*dbg_object(this).m_font.p_TextHeight("HA")+2),1.0);
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1202>";
				t_iter=t_iter+1;
			}
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1206>";
		t_line_position=t_line_position+1;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1208>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1209>";
	bb_graphics_SetAlpha(1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1210>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1212>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1212>";
	var t_2=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1212>";
	while(t_2.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1212>";
		var t_t=t_2.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1213>";
		t_t.p_renderme();
	}
	pop_err();
}
c_textbox.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1078>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1078>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1078>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1078>";
		var t_t=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1079>";
		t_t.p_update();
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1082>";
	c_gui_element.prototype.p_update.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1084>";
	if(bb_customgui_mouse_hit1==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1085>";
		if(dbg_object(dbg_object(this).m_up_arrow).m_mouse_over==true){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1086>";
			c_gui_element.m_clicked=true;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1087>";
			if(this.m_current_line>0){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1088>";
				this.m_current_line=this.m_current_line-1;
			}
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1093>";
		if(dbg_object(dbg_object(this).m_down_arrow).m_mouse_over==true){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1094>";
			c_gui_element.m_clicked=true;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1095>";
			if(this.m_current_line<this.m_line_list.p_Count()-1){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1096>";
				this.m_current_line=this.m_current_line+1;
			}
		}
	}
	pop_err();
}
function c_List2(){
	Object.call(this);
	this.m__head=(c_HeadNode2.m_new.call(new c_HeadNode2));
}
c_List2.prototype.p_ObjectEnumerator=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<168>";
	var t_=c_Enumerator2.m_new.call(new c_Enumerator2,this);
	pop_err();
	return t_;
}
c_List2.prototype.p_Count=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<41>";
	var t_n=0;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<41>";
	var t_node=dbg_object(this.m__head).m__succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<42>";
	while(t_node!=this.m__head){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<43>";
		t_node=dbg_object(t_node).m__succ;
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<44>";
		t_n+=1;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<46>";
	pop_err();
	return t_n;
}
function c_StringList(){
	c_List2.call(this);
}
c_StringList.prototype=extend_class(c_List2);
function c_Enumerator2(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_Enumerator2.m_new=function(t_list){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<308>";
	this.m__list=t_list;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<309>";
	this.m__curr=dbg_object(dbg_object(t_list).m__head).m__succ;
	pop_err();
	return this;
}
c_Enumerator2.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<305>";
	pop_err();
	return this;
}
c_Enumerator2.prototype.p_HasNext=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<313>";
	while(dbg_object(dbg_object(this.m__curr).m__succ).m__pred!=this.m__curr){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<314>";
		this.m__curr=dbg_object(this.m__curr).m__succ;
	}
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<316>";
	var t_=this.m__curr!=dbg_object(this.m__list).m__head;
	pop_err();
	return t_;
}
c_Enumerator2.prototype.p_NextObject=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<320>";
	var t_data=dbg_object(this.m__curr).m__data;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<321>";
	this.m__curr=dbg_object(this.m__curr).m__succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<322>";
	pop_err();
	return t_data;
}
function c_Node3(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data="";
}
c_Node3.m_new=function(t_succ,t_pred,t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<243>";
	this.m__succ=t_succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<244>";
	this.m__pred=t_pred;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<245>";
	dbg_object(this.m__succ).m__pred=this;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<246>";
	dbg_object(this.m__pred).m__succ=this;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<247>";
	this.m__data=t_data;
	pop_err();
	return this;
}
c_Node3.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<240>";
	pop_err();
	return this;
}
function c_HeadNode2(){
	c_Node3.call(this);
}
c_HeadNode2.prototype=extend_class(c_Node3);
c_HeadNode2.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<292>";
	c_Node3.m_new2.call(this);
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<293>";
	this.m__succ=(this);
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<294>";
	this.m__pred=(this);
	pop_err();
	return this;
}
function c_draggable_image(){
	c_gui_element.call(this);
	this.m_being_dragged=false;
	this.m_image=null;
	this.m_offset_x=0;
	this.m_offset_y=0;
	this.m_dropped=false;
}
c_draggable_image.prototype=extend_class(c_gui_element);
c_draggable_image.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1250>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1251>";
	bb_graphics_Scale(1.0,1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1252>";
	bb_graphics_Rotate(.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1254>";
	if(this.m_being_dragged==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1255>";
		bb_graphics_DrawImage(this.m_image,(bb_customgui_mouse_x),(bb_customgui_mouse_y),0);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1258>";
	bb_graphics_DrawImage(this.m_image,(this.m_x+this.m_offset_x),(this.m_y+this.m_offset_y),0);
	pop_err();
}
c_draggable_image.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1265>";
	c_gui_element.prototype.p_update.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1267>";
	if(this.m_being_dragged==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1268>";
		if(!bb_customgui_mouse_down1){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1269>";
			this.m_being_dragged=false;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1270>";
			this.m_dropped=true;
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1274>";
	var t_an_image_dragged=false;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1276>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1276>";
	var t_=dbg_object(dbg_object(this).m_parent).m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1276>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1276>";
		var t_f=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1277>";
		if((object_downcast((t_f),c_draggable_image))!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1278>";
			var t_d=object_downcast((t_f),c_draggable_image);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1279>";
			if(dbg_object(t_d).m_being_dragged==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1280>";
				t_an_image_dragged=true;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1285>";
	if(t_an_image_dragged==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1286>";
		if(this.m_mouse_over==true){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1287>";
			if(bb_customgui_mouse_down1==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1288>";
				if(this.m_being_dragged==false){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1289>";
					this.m_being_dragged=true;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1290>";
					this.m_pressed_timer=bb_customgui_time;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1291>";
					this.m_pressed=true;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1292>";
					c_gui_element.m_clicked=true;
				}
			}
		}
	}
	pop_err();
}
function c_gadget_scroller(){
	c_gui_element.call(this);
	this.m_current_gadget=null;
}
c_gadget_scroller.prototype=extend_class(c_gui_element);
c_gadget_scroller.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1412>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1413>";
	var t_arrow_width=bb_customgui_arrow_size;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1414>";
	var t_border_width=10.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1416>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1417>";
	bb_graphics_Translate((this.m_x)+t_border_width,(this.m_y)+t_border_width);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1418>";
	bb_graphics_Scale((this.m_width-t_border_width-(t_arrow_width))/(dbg_object(c_gui_class.m_gui_pointer).m_window_image.p_Width()),(this.m_height-t_border_width)/(dbg_object(c_gui_class.m_gui_pointer).m_window_image.p_Height()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1419>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_window_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1420>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1422>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1423>";
	bb_graphics_Translate((this.m_x),(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1424>";
	bb_graphics_Scale(t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width()),this.m_height/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Height()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1425>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1426>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1428>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1429>";
	bb_graphics_Translate((this.m_x)+this.m_width-(t_arrow_width)-t_border_width,(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1430>";
	bb_graphics_Scale(t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width()),this.m_height/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Height()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1431>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1432>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1434>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1435>";
	bb_graphics_Translate((this.m_x),(this.m_y));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1436>";
	bb_graphics_Scale((this.m_width-t_border_width-(t_arrow_width))/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width()),t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Height()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1437>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1438>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1439>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1441>";
	bb_graphics_Translate((this.m_x),(this.m_y)+this.m_height-t_border_width);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1442>";
	bb_graphics_Scale((this.m_width-t_border_width-(t_arrow_width))/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Width()),t_border_width/(dbg_object(c_gui_class.m_gui_pointer).m_border_image.p_Height()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1443>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_border_image,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1444>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1446>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1446>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1446>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1446>";
		var t_o=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1447>";
		dbg_object(t_o).m_rendered=false;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1450>";
	var t_render_height=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1451>";
	var t_render_width=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1452>";
	var t_found_first=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1454>";
	bb_graphics_SetScissor((this.m_x+10),(this.m_y+10),this.m_width-t_border_width-(t_arrow_width),this.m_height-15.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1457>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1457>";
	var t_2=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1457>";
	while(t_2.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1457>";
		var t_o2=t_2.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1458>";
		if(dbg_object(t_o2).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1460>";
			if(t_o2==dbg_object(this).m_current_gadget){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1461>";
				t_found_first=1;
			}
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1464>";
			if(t_found_first==1){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1465>";
				if(this.m_height-(t_render_height)>dbg_object(t_o2).m_height){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1466>";
					dbg_object(t_o2).m_y=(((t_render_height)+t_border_width+(this.m_y))|0);
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1468>";
					dbg_object(t_o2).m_x=(((dbg_object(this).m_x)+t_border_width)|0);
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1470>";
					if((object_downcast((t_o2),c_toggle_button))!=null){
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1471>";
						var t_t=object_downcast((t_o2),c_toggle_button);
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1472>";
						t_t.p_renderme();
					}
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1474>";
					if((object_downcast((t_o2),c_button))!=null){
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1475>";
						var t_t2=object_downcast((t_o2),c_button);
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1476>";
						t_t2.p_renderme();
					}
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1480>";
					dbg_object(t_o2).m_rendered=true;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1481>";
					t_render_height=(((t_render_height)+dbg_object(t_o2).m_height+3.0)|0);
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1483>";
					if(dbg_object(t_o2).m_width>(t_render_width)){
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1484>";
						t_render_width=((dbg_object(t_o2).m_width)|0);
					}
				}
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1494>";
	bb_graphics_SetScissor(.0,.0,(bb_graphics_DeviceWidth()),(bb_graphics_DeviceHeight()));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1508>";
	dbg_object(this).m_up_arrow.p_renderme();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1509>";
	dbg_object(this).m_down_arrow.p_renderme();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1510>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	pop_err();
}
c_gadget_scroller.prototype.p_add_gadget=function(t_o,t_radio,t_column){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1336>";
	if(dbg_object(t_o).m_parent!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1337>";
		dbg_object(dbg_object(t_o).m_parent).m_gadget_list.p_RemoveEach(t_o);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1340>";
	if(this.m_gadget_list.p_Count()==0 && t_radio==true){
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1344>";
	if(t_radio==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1345>";
		this.m_gadget_list.p_AddLast(t_o);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1348>";
	if(t_radio==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1349>";
		dbg_object(this).m_radio_list.p_AddLast(t_o);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1350>";
		this.m_gadget_list.p_AddLast(t_o);
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1353>";
	if(this.m_current_gadget==null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1354>";
		this.m_current_gadget=t_o;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1357>";
	dbg_object(t_o).m_x=this.m_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1358>";
	dbg_object(t_o).m_y=this.m_y;
	pop_err();
}
c_gadget_scroller.prototype.p_deactivate_gadgets=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1515>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1515>";
	var t_=this.m_radio_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1515>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1515>";
		var t_j=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1516>";
		dbg_object(t_j).m_active=false;
	}
	pop_err();
}
c_gadget_scroller.prototype.p_get_previous_gadget=function(t_go){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1364>";
	var t_prev_gadget=null;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1365>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1365>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1365>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1365>";
		var t_g=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1366>";
		if(t_g==t_go){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1367>";
			pop_err();
			return t_prev_gadget;
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1369>";
		t_prev_gadget=t_g;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1371>";
	pop_err();
	return null;
}
c_gadget_scroller.prototype.p_get_next_gadget=function(t_go){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1375>";
	var t_retrieve=false;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1376>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1376>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1376>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1376>";
		var t_g=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1377>";
		if(t_retrieve==true){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1378>";
			pop_err();
			return t_g;
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1380>";
		if(t_g==t_go){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1381>";
			t_retrieve=true;
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1384>";
	pop_err();
	return null;
}
c_gadget_scroller.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1521>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1521>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1521>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1521>";
		var t_o=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1522>";
		if(dbg_object(t_o).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1523>";
			if(dbg_object(t_o).m_rendered==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1524>";
				t_o.p_update();
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1529>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1529>";
	var t_2=this.m_radio_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1529>";
	while(t_2.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1529>";
		var t_o2=t_2.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1530>";
		if(dbg_object(t_o2).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1531>";
			if(dbg_object(t_o2).m_rendered==true){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1532>";
				if(t_o2.p_ispressed()){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1533>";
					dbg_object(t_o2).m_pressed=true;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1534>";
					this.p_deactivate_gadgets();
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1535>";
					dbg_object(t_o2).m_active=true;
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1536>";
					break;
				}
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1542>";
	dbg_object(dbg_object(this).m_down_arrow).m_x=(((this.m_x)+this.m_width-(bb_customgui_arrow_size))|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1543>";
	dbg_object(dbg_object(this).m_down_arrow).m_y=(((this.m_y)+this.m_height-(bb_customgui_arrow_size))|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1544>";
	dbg_object(dbg_object(this).m_up_arrow).m_x=(((this.m_x)+this.m_width-(bb_customgui_arrow_size))|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1545>";
	dbg_object(dbg_object(this).m_up_arrow).m_y=this.m_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1547>";
	dbg_object(this).m_down_arrow.p_update();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1548>";
	dbg_object(this).m_up_arrow.p_update();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1550>";
	if(dbg_object(this).m_up_arrow.p_ispressed()==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1551>";
		if(this.m_current_gadget!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1552>";
			var t_prev_gadget=this.p_get_previous_gadget(this.m_current_gadget);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1553>";
			if(t_prev_gadget!=null){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1554>";
				this.m_current_gadget=t_prev_gadget;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1559>";
	if(dbg_object(this).m_down_arrow.p_ispressed()==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1560>";
		if(this.m_current_gadget!=null){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1561>";
			var t_next_gadget=this.p_get_next_gadget(this.m_current_gadget);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1562>";
			if(t_next_gadget!=null){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1563>";
				this.m_current_gadget=t_next_gadget;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1568>";
	if(this.p_detect_mouse_over(bb_customgui_mouse_x,bb_customgui_mouse_y,bb_customgui_mouse_hit1)==true){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1569>";
		c_gui_element.m_clicked=true;
	}
	pop_err();
}
var bb_customgui_arrow_size=0;
function c_up_arrow(){
	c_gui_element.call(this);
}
c_up_arrow.prototype=extend_class(c_gui_element);
c_up_arrow.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1590>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1591>";
	bb_graphics_SetAlpha(dbg_object(this).m_alpha);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1592>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_up_arrow,(this.m_x),(this.m_y),0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1593>";
	bb_graphics_SetAlpha(1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1594>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_up_arrow.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1600>";
	c_gui_element.prototype.p_update.call(this);
	pop_err();
}
function c_down_arrow(){
	c_gui_element.call(this);
}
c_down_arrow.prototype=extend_class(c_gui_element);
c_down_arrow.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1618>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1619>";
	bb_graphics_SetAlpha(dbg_object(this).m_alpha);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1620>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_down_arrow,(this.m_x),(this.m_y),0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1621>";
	bb_graphics_SetAlpha(1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1622>";
	bb_graphics_PopMatrix();
	pop_err();
}
c_down_arrow.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1627>";
	c_gui_element.prototype.p_update.call(this);
	pop_err();
}
function c_table(){
	c_gui_element.call(this);
	this.m_border=0;
}
c_table.prototype=extend_class(c_gui_element);
c_table.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1718>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1718>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1718>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1718>";
		var t_i=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1719>";
		t_i.p_renderme();
	}
	pop_err();
}
c_table.m_new=function(t_x,t_y,t_border,t_parent){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1707>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1708>";
	dbg_object(this).m_x=t_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1709>";
	dbg_object(this).m_y=t_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1710>";
	dbg_object(this).m_name="table";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1711>";
	dbg_object(this).m_gadget_list=c_List.m_new.call(new c_List);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1712>";
	dbg_object(this).m_border=t_border;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1713>";
	dbg_object(t_parent).m_gadget_list.p_AddLast(this);
	pop_err();
	return this;
}
c_table.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1704>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1704>";
	pop_err();
	return this;
}
c_table.prototype.p_add_column=function(t_t){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1806>";
	dbg_object(this).m_gadget_list.p_AddLast(t_t);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1807>";
	dbg_object(t_t).m_parent=(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1808>";
	dbg_object(t_t).m_parent.p_update();
	pop_err();
}
c_table.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1725>";
	dbg_object(this).m_width=.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1726>";
	dbg_object(this).m_height=.0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1728>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1728>";
	var t_=dbg_object(this).m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1728>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1728>";
		var t_t=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1729>";
		if(dbg_object(t_t).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1730>";
			t_t.p_update();
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1734>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1734>";
	var t_2=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1734>";
	while(t_2.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1734>";
		var t_go=t_2.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1737>";
		var t_co=object_downcast((t_go),c_table_column);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1739>";
		dbg_object(t_co).m_x=((dbg_object(this).m_width+(dbg_object(this).m_x)+(dbg_object(this).m_border))|0);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1740>";
		dbg_object(t_co).m_width=.0;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1741>";
		dbg_object(t_co).m_height=.0;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1743>";
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1743>";
		var t_3=dbg_object(t_co).m_gadget_list.p_ObjectEnumerator();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1743>";
		while(t_3.p_HasNext()){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1743>";
			var t_ge=t_3.p_NextObject();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1744>";
			var t_ce=object_downcast((t_ge),c_table_cell);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1745>";
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1745>";
			var t_4=dbg_object(t_ce).m_gadget_list.p_ObjectEnumerator();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1745>";
			while(t_4.p_HasNext()){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1745>";
				var t_go2=t_4.p_NextObject();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1746>";
				t_go2.p_get_dimensions();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1747>";
				dbg_object(t_ce).m_width=dbg_object(t_go2).m_width+2.0+(dbg_object(t_co).m_padding_x);
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1748>";
				dbg_object(t_ce).m_height=dbg_object(t_go2).m_height+(dbg_object(t_co).m_padding_y);
			}
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1752>";
		var t_highest_cell_height=0;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1753>";
		var t_widest_cell_width=0;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1754>";
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1754>";
		var t_5=dbg_object(t_co).m_gadget_list.p_ObjectEnumerator();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1754>";
		while(t_5.p_HasNext()){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1754>";
			var t_ge2=t_5.p_NextObject();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1755>";
			var t_ce2=object_downcast((t_ge2),c_table_cell);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1756>";
			if((t_highest_cell_height)<dbg_object(t_ce2).m_height){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1757>";
				t_highest_cell_height=((dbg_object(t_ce2).m_height)|0);
			}
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1762>";
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1762>";
		var t_6=dbg_object(t_co).m_gadget_list.p_ObjectEnumerator();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1762>";
		while(t_6.p_HasNext()){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1762>";
			var t_ge3=t_6.p_NextObject();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1763>";
			var t_ce3=object_downcast((t_ge3),c_table_cell);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1764>";
			if(dbg_object(t_ce3).m_width>(t_widest_cell_width)){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1765>";
				t_widest_cell_width=((dbg_object(t_ce3).m_width)|0);
			}
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1771>";
		var t_cell_iter=1;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1772>";
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1772>";
		var t_7=dbg_object(t_co).m_gadget_list.p_ObjectEnumerator();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1772>";
		while(t_7.p_HasNext()){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1772>";
			var t_ge4=t_7.p_NextObject();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1773>";
			var t_ce4=object_downcast((t_ge4),c_table_cell);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1774>";
			t_ce4.p_adjust_height_for_row(t_cell_iter);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1775>";
			t_cell_iter=t_cell_iter+1;
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1778>";
		var t_y_pos=0;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1779>";
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1779>";
		var t_8=dbg_object(t_co).m_gadget_list.p_ObjectEnumerator();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1779>";
		while(t_8.p_HasNext()){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1779>";
			var t_ge5=t_8.p_NextObject();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1780>";
			var t_ce5=object_downcast((t_ge5),c_table_cell);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1781>";
			dbg_object(t_ce5).m_y=t_y_pos+dbg_object(this).m_y;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1783>";
			dbg_object(t_ce5).m_x=dbg_object(t_co).m_x;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1784>";
			dbg_object(t_ce5).m_width=(t_widest_cell_width);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1786>";
			dbg_object(t_co).m_height=dbg_object(t_co).m_height+(dbg_object(this).m_border)+dbg_object(t_ce5).m_height;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1787>";
			dbg_object(t_co).m_width=(t_widest_cell_width);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1790>";
			t_y_pos=(((t_y_pos)+dbg_object(t_ce5).m_height)|0);
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1795>";
		dbg_object(this).m_width=dbg_object(this).m_width+dbg_object(t_co).m_width;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1797>";
		if(dbg_object(t_co).m_height>dbg_object(this).m_height){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1798>";
			dbg_object(this).m_height=dbg_object(t_co).m_height;
		}
	}
	pop_err();
}
function c_table_column(){
	c_gui_element.call(this);
	this.m_padding_x=0;
	this.m_padding_y=0;
}
c_table_column.prototype=extend_class(c_gui_element);
c_table_column.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1953>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1953>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1953>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1953>";
		var t_i=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1954>";
		t_i.p_renderme();
	}
	pop_err();
}
c_table_column.m_new=function(t_tab,t_paddingx,t_paddingy){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1935>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1936>";
	dbg_object(this).m_parent=(t_tab);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1937>";
	dbg_object(this).m_gadget_list=c_List.m_new.call(new c_List);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1938>";
	dbg_object(this).m_name="table column";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1939>";
	this.m_padding_x=t_paddingx;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1940>";
	this.m_padding_y=t_paddingy;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1941>";
	t_tab.p_add_column(this);
	pop_err();
	return this;
}
c_table_column.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1932>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1932>";
	pop_err();
	return this;
}
c_table_column.prototype.p_add_cell=function(t_t){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1959>";
	dbg_object(this).m_gadget_list.p_AddLast(t_t);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1960>";
	dbg_object(this).m_parent.p_update();
	pop_err();
}
c_table_column.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1945>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1945>";
	var t_=dbg_object(this).m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1945>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1945>";
		var t_t=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1946>";
		if(dbg_object(t_t).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1947>";
			t_t.p_update();
		}
	}
	pop_err();
}
function c_table_cell(){
	c_gui_element.call(this);
	this.m_border=false;
	this.m_parent_table=null;
}
c_table_cell.prototype=extend_class(c_gui_element);
c_table_cell.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1869>";
	if(dbg_object(this).m_hidden==false){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1870>";
		bb_graphics_PushMatrix();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1871>";
		bb_graphics_SetAlpha(dbg_object(this).m_alpha);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1873>";
		if(this.m_border==true){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1874>";
			bb_graphics_Scale(1.0,1.0);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1875>";
			bb_graphics_SetColor((dbg_object(c_gui_class.m_gui_pointer).m_textr),(dbg_object(c_gui_class.m_gui_pointer).m_textg),(dbg_object(c_gui_class.m_gui_pointer).m_textb));
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1876>";
			bb_graphics_SetColor(.0,.0,255.0);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1877>";
			bb_graphics_DrawLine((dbg_object(this).m_x-1),(dbg_object(this).m_y-1),(dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y-1));
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1878>";
			bb_graphics_DrawLine((dbg_object(this).m_x-1),(dbg_object(this).m_y-1),(dbg_object(this).m_x-1),(dbg_object(this).m_y)+dbg_object(this).m_height+1.0);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1879>";
			bb_graphics_DrawLine((dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y-1),(dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y)+dbg_object(this).m_height+1.0);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1880>";
			bb_graphics_DrawLine((dbg_object(this).m_x-1),(dbg_object(this).m_y)+dbg_object(this).m_height+1.0,(dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y)+dbg_object(this).m_height+1.0);
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1890>";
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1890>";
		var t_=this.m_gadget_list.p_ObjectEnumerator();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1890>";
		while(t_.p_HasNext()){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1890>";
			var t_i=t_.p_NextObject();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1891>";
			if(dbg_object(t_i).m_hidden==false){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1892>";
				dbg_object(t_i).m_x=dbg_object(this).m_x+2;
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1893>";
				dbg_object(t_i).m_y=dbg_object(this).m_y;
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1899>";
				t_i.p_renderme();
			}
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1902>";
		bb_graphics_PopMatrix();
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1904>";
	bb_graphics_SetAlpha(1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1905>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	pop_err();
}
c_table_cell.m_new=function(t_c,t_border){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1858>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1859>";
	dbg_object(this).m_parent=(t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1860>";
	dbg_object(this).m_name="table cell";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1861>";
	dbg_object(this).m_parent_table=object_downcast((dbg_object(t_c).m_parent),c_table);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1862>";
	dbg_object(this).m_gadget_list=c_List.m_new.call(new c_List);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1863>";
	dbg_object(this).m_border=t_border;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1864>";
	t_c.p_add_cell(this);
	pop_err();
	return this;
}
c_table_cell.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1814>";
	c_gui_element.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1814>";
	pop_err();
	return this;
}
c_table_cell.prototype.p_adjust_height_for_row=function(t_cell_iter){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1832>";
	var t_max_height=((dbg_object(this).m_height)|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1833>";
	var t_this_iter=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1834>";
	var t_heighty=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1835>";
	var t_yy=dbg_object(this.m_parent_table).m_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1837>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1837>";
	var t_=dbg_object(dbg_object(dbg_object(this).m_parent).m_parent).m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1837>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1837>";
		var t_go=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1838>";
		var t_co=object_downcast((t_go),c_table_column);
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1839>";
		t_this_iter=0;
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1840>";
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1840>";
		var t_2=dbg_object(t_co).m_gadget_list.p_ObjectEnumerator();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1840>";
		while(t_2.p_HasNext()){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1840>";
			var t_ge=t_2.p_NextObject();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1841>";
			var t_ce=object_downcast((t_ge),c_table_cell);
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1842>";
			if((t_ce)!=dbg_object(this).m_parent){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1843>";
				t_this_iter=t_this_iter+1;
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1844>";
				if(t_this_iter==t_cell_iter){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1845>";
					if(dbg_object(t_ce).m_height>(t_max_height)){
						err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1846>";
						t_max_height=((dbg_object(t_ce).m_height)|0);
					}
				}
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1854>";
	dbg_object(this).m_height=(t_max_height);
	pop_err();
}
c_table_cell.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1823>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1823>";
	var t_=dbg_object(this).m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1823>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1823>";
		var t_t=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1824>";
		if(dbg_object(t_t).m_hidden==false){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1825>";
			t_t.p_update();
		}
	}
	pop_err();
}
c_table_cell.prototype.p_add_gadget=function(t_g,t_radio,t_column){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1918>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1918>";
	var t_=dbg_object(this).m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1918>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1918>";
		var t_i=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1919>";
		t_i.p_destroy();
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1921>";
	dbg_object(this).m_gadget_list.p_Clear();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1922>";
	dbg_object(this).m_gadget_list.p_AddLast(t_g);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1923>";
	dbg_object(t_g).m_parent=(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1924>";
	dbg_object(this).m_width=dbg_object(t_g).m_width;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1925>";
	dbg_object(this).m_height=dbg_object(t_g).m_height;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1926>";
	dbg_object(dbg_object(this).m_parent).m_parent.p_update();
	pop_err();
}
c_table_cell.prototype.p_destroy=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1909>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1909>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1909>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1909>";
		var t_i=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1910>";
		t_i.p_destroy();
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<1912>";
	this.m_gadget_list.p_Clear();
	pop_err();
}
function c_arrow_chooser(){
	c_gui_element.call(this);
	this.m_option_list=null;
	this.m_current_option_number=0;
	this.m_current_option="";
	this.m_last_clicked_option="";
}
c_arrow_chooser.prototype=extend_class(c_gui_element);
c_arrow_chooser.prototype.p_renderme=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2011>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2012>";
	bb_graphics_Translate((this.m_x+bb_customgui_arrow_size),(this.m_y+1));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2013>";
	var t_scalex=(dbg_object(this).m_width-(bb_customgui_arrow_size*2))/(dbg_object(c_gui_class.m_gui_pointer).m_button_img.p_Width());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2014>";
	var t_scaley=(this.m_height-2.0)/(dbg_object(c_gui_class.m_gui_pointer).m_button_img.p_Height());
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2015>";
	bb_graphics_Scale(t_scalex,t_scaley);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2016>";
	bb_graphics_DrawImage(dbg_object(c_gui_class.m_gui_pointer).m_button_img,.0,.0,0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2017>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2019>";
	bb_graphics_PushMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2021>";
	bb_graphics_Scale(1.0,1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2023>";
	bb_graphics_SetColor((dbg_object(c_gui_class.m_gui_pointer).m_textr),(dbg_object(c_gui_class.m_gui_pointer).m_textg),(dbg_object(c_gui_class.m_gui_pointer).m_textb));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2024>";
	var t_line_position=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2025>";
	var t_iter=0;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2026>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2026>";
	var t_=this.m_option_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2026>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2026>";
		var t_a=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2027>";
		if(t_line_position==this.m_current_option_number){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2028>";
			this.m_current_option=t_a;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2029>";
			this.m_font.p_draw(t_a,dbg_object(this).m_x+bb_customgui_arrow_size,dbg_object(this).m_y+3,1.0);
		}
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2031>";
		t_line_position=t_line_position+1;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2034>";
	bb_graphics_SetColor(.0,.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2035>";
	bb_graphics_DrawLine((dbg_object(this).m_x-1),(dbg_object(this).m_y-1),(dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y-1));
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2036>";
	bb_graphics_DrawLine((dbg_object(this).m_x-1),(dbg_object(this).m_y-1),(dbg_object(this).m_x-1),(dbg_object(this).m_y)+dbg_object(this).m_height+1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2037>";
	bb_graphics_DrawLine((dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y-1),(dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y)+dbg_object(this).m_height+1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2038>";
	bb_graphics_DrawLine((dbg_object(this).m_x-1),(dbg_object(this).m_y)+dbg_object(this).m_height+1.0,(dbg_object(this).m_x)+dbg_object(this).m_width+1.0,(dbg_object(this).m_y)+dbg_object(this).m_height+1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2040>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2041>";
	bb_graphics_SetAlpha(1.0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2042>";
	bb_graphics_PopMatrix();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2046>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2046>";
	var t_2=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2046>";
	while(t_2.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2046>";
		var t_t=t_2.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2047>";
		t_t.p_renderme();
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2049>";
	dbg_object(this).m_up_arrow.p_renderme();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2050>";
	dbg_object(this).m_down_arrow.p_renderme();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2051>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	pop_err();
}
c_arrow_chooser.prototype.p_update=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2056>";
	dbg_object(dbg_object(this).m_up_arrow).m_x=this.m_x;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2057>";
	dbg_object(dbg_object(this).m_up_arrow).m_y=this.m_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2058>";
	dbg_object(dbg_object(this).m_down_arrow).m_x=(((this.m_x)+(this.m_width-(bb_customgui_arrow_size)))|0);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2059>";
	dbg_object(dbg_object(this).m_down_arrow).m_y=this.m_y;
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2062>";
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2062>";
	var t_=this.m_gadget_list.p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2062>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2062>";
		var t_t=t_.p_NextObject();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2063>";
		t_t.p_update();
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2065>";
	dbg_object(this).m_down_arrow.p_update();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2066>";
	dbg_object(this).m_up_arrow.p_update();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2068>";
	c_gui_element.prototype.p_update.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2070>";
	if(dbg_object(this).m_up_arrow.p_ispressed()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2071>";
		if(this.m_current_option_number>0){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2072>";
			this.m_current_option_number=this.m_current_option_number-1;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2073>";
			var t_line_position=0;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2074>";
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2074>";
			var t_2=this.m_option_list.p_ObjectEnumerator();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2074>";
			while(t_2.p_HasNext()){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2074>";
				var t_a=t_2.p_NextObject();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2075>";
				if(t_line_position==this.m_current_option_number){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2076>";
					this.m_last_clicked_option=t_a;
				}
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2078>";
				t_line_position=t_line_position+1;
			}
		}
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2083>";
	if(dbg_object(this).m_down_arrow.p_ispressed()){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2084>";
		if(this.m_current_option_number<this.m_option_list.p_Count()-1){
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2085>";
			this.m_current_option_number=this.m_current_option_number+1;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2086>";
			var t_line_position2=0;
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2087>";
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2087>";
			var t_3=this.m_option_list.p_ObjectEnumerator();
			err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2087>";
			while(t_3.p_HasNext()){
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2087>";
				var t_a2=t_3.p_NextObject();
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2088>";
				if(t_line_position2==this.m_current_option_number){
					err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2089>";
					this.m_last_clicked_option=t_a2;
				}
				err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<2091>";
				t_line_position2=t_line_position2+1;
			}
		}
	}
	pop_err();
}
var bb_app__updateRate=0;
function bb_app_SetUpdateRate(t_hertz){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<143>";
	bb_app__updateRate=t_hertz;
	err_info="/root/Dropbox/Monkey/modules/mojo/app.monkey<144>";
	bb_app__game.SetUpdateRate(t_hertz);
	pop_err();
	return 0;
}
function bb_autofit_SetVirtualDisplay(t_width,t_height,t_zoom){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<110>";
	c_VirtualDisplay.m_new.call(new c_VirtualDisplay,t_width,t_height,t_zoom);
	err_info="/root/Dropbox/Monkey/modules/keef/autofit/autofit.monkey<111>";
	pop_err();
	return 0;
}
function c_mediumarialfont(){
	c_keeffont.call(this);
}
c_mediumarialfont.prototype=extend_class(c_keeffont);
c_mediumarialfont.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<7>";
	c_keeffont.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<8>";
	dbg_object(this).m_img=bb_graphics_LoadImage("mediumarial.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<9>";
	this.m_charmap=c_StringMap.m_new.call(new c_StringMap);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<10>";
	this.m_width=256;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<11>";
	this.m_height=128;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<12>";
	this.m_fontheight=23;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<13>";
	var t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<14>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<15>";
	dbg_object(t_c).m_name=" ";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<16>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<17>";
	dbg_object(t_c).m_ascnum=32;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<18>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<19>";
	dbg_object(t_c).m_yoffset=19;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<20>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<21>";
	dbg_object(t_c).m_width=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<22>";
	dbg_object(t_c).m_height=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<23>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<24>";
	dbg_object(t_c).m_name="!";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<25>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<26>";
	dbg_object(t_c).m_ascnum=33;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<27>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<28>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<29>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<30>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<31>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<32>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<33>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<34>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<35>";
	dbg_object(t_c).m_name="\"";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<36>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<37>";
	dbg_object(t_c).m_ascnum=34;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<38>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<39>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<40>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<41>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<42>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<43>";
	dbg_object(t_c).m_x=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<44>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<45>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<46>";
	dbg_object(t_c).m_name="#";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<47>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<48>";
	dbg_object(t_c).m_ascnum=35;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<49>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<50>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<51>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<52>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<53>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<54>";
	dbg_object(t_c).m_x=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<55>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<56>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<57>";
	dbg_object(t_c).m_name="$";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<58>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<59>";
	dbg_object(t_c).m_ascnum=36;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<60>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<61>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<62>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<63>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<64>";
	dbg_object(t_c).m_height=20;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<65>";
	dbg_object(t_c).m_x=28;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<66>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<67>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<68>";
	dbg_object(t_c).m_name="%";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<69>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<70>";
	dbg_object(t_c).m_ascnum=37;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<71>";
	dbg_object(t_c).m_xadvance=18;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<72>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<73>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<74>";
	dbg_object(t_c).m_width=18;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<75>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<76>";
	dbg_object(t_c).m_x=41;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<77>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<78>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<79>";
	dbg_object(t_c).m_name="&";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<80>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<81>";
	dbg_object(t_c).m_ascnum=38;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<82>";
	dbg_object(t_c).m_xadvance=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<83>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<84>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<85>";
	dbg_object(t_c).m_width=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<86>";
	dbg_object(t_c).m_height=18;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<87>";
	dbg_object(t_c).m_x=60;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<88>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<89>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<90>";
	dbg_object(t_c).m_name="'";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<91>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<92>";
	dbg_object(t_c).m_ascnum=39;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<93>";
	dbg_object(t_c).m_xadvance=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<94>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<95>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<96>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<97>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<98>";
	dbg_object(t_c).m_x=75;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<99>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<100>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<101>";
	dbg_object(t_c).m_name="(";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<102>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<103>";
	dbg_object(t_c).m_ascnum=40;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<104>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<105>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<106>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<107>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<108>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<109>";
	dbg_object(t_c).m_x=80;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<110>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<111>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<112>";
	dbg_object(t_c).m_name=")";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<113>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<114>";
	dbg_object(t_c).m_ascnum=41;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<115>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<116>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<117>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<118>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<119>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<120>";
	dbg_object(t_c).m_x=87;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<121>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<122>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<123>";
	dbg_object(t_c).m_name="*";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<124>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<125>";
	dbg_object(t_c).m_ascnum=42;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<126>";
	dbg_object(t_c).m_xadvance=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<127>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<128>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<129>";
	dbg_object(t_c).m_width=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<130>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<131>";
	dbg_object(t_c).m_x=95;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<132>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<133>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<134>";
	dbg_object(t_c).m_name="+";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<135>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<136>";
	dbg_object(t_c).m_ascnum=43;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<137>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<138>";
	dbg_object(t_c).m_yoffset=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<139>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<140>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<141>";
	dbg_object(t_c).m_height=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<142>";
	dbg_object(t_c).m_x=105;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<143>";
	dbg_object(t_c).m_y=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<144>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<145>";
	dbg_object(t_c).m_name=",";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<146>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<147>";
	dbg_object(t_c).m_ascnum=44;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<148>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<149>";
	dbg_object(t_c).m_yoffset=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<150>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<151>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<152>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<153>";
	dbg_object(t_c).m_x=117;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<154>";
	dbg_object(t_c).m_y=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<155>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<156>";
	dbg_object(t_c).m_name="-";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<157>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<158>";
	dbg_object(t_c).m_ascnum=45;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<159>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<160>";
	dbg_object(t_c).m_yoffset=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<161>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<162>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<163>";
	dbg_object(t_c).m_height=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<164>";
	dbg_object(t_c).m_x=124;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<165>";
	dbg_object(t_c).m_y=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<166>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<167>";
	dbg_object(t_c).m_name=".";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<168>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<169>";
	dbg_object(t_c).m_ascnum=46;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<170>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<171>";
	dbg_object(t_c).m_yoffset=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<172>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<173>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<174>";
	dbg_object(t_c).m_height=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<175>";
	dbg_object(t_c).m_x=132;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<176>";
	dbg_object(t_c).m_y=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<177>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<178>";
	dbg_object(t_c).m_name="/";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<179>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<180>";
	dbg_object(t_c).m_ascnum=47;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<181>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<182>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<183>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<184>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<185>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<186>";
	dbg_object(t_c).m_x=138;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<187>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<188>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<189>";
	dbg_object(t_c).m_name="0";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<190>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<191>";
	dbg_object(t_c).m_ascnum=48;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<192>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<193>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<194>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<195>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<196>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<197>";
	dbg_object(t_c).m_x=146;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<198>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<199>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<200>";
	dbg_object(t_c).m_name="1";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<201>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<202>";
	dbg_object(t_c).m_ascnum=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<203>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<204>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<205>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<206>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<207>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<208>";
	dbg_object(t_c).m_x=158;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<209>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<210>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<211>";
	dbg_object(t_c).m_name="2";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<212>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<213>";
	dbg_object(t_c).m_ascnum=50;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<214>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<215>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<216>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<217>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<218>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<219>";
	dbg_object(t_c).m_x=169;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<220>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<221>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<222>";
	dbg_object(t_c).m_name="3";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<223>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<224>";
	dbg_object(t_c).m_ascnum=51;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<225>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<226>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<227>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<228>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<229>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<230>";
	dbg_object(t_c).m_x=182;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<231>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<232>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<233>";
	dbg_object(t_c).m_name="4";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<234>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<235>";
	dbg_object(t_c).m_ascnum=52;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<236>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<237>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<238>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<239>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<240>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<241>";
	dbg_object(t_c).m_x=195;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<242>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<243>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<244>";
	dbg_object(t_c).m_name="5";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<245>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<246>";
	dbg_object(t_c).m_ascnum=53;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<247>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<248>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<249>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<250>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<251>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<252>";
	dbg_object(t_c).m_x=208;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<253>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<254>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<255>";
	dbg_object(t_c).m_name="6";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<256>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<257>";
	dbg_object(t_c).m_ascnum=54;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<258>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<259>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<260>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<261>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<262>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<263>";
	dbg_object(t_c).m_x=221;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<264>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<265>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<266>";
	dbg_object(t_c).m_name="7";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<267>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<268>";
	dbg_object(t_c).m_ascnum=55;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<269>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<270>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<271>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<272>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<273>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<274>";
	dbg_object(t_c).m_x=234;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<275>";
	dbg_object(t_c).m_y=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<276>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<277>";
	dbg_object(t_c).m_name="8";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<278>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<279>";
	dbg_object(t_c).m_ascnum=56;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<280>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<281>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<282>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<283>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<284>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<285>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<286>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<287>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<288>";
	dbg_object(t_c).m_name="9";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<289>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<290>";
	dbg_object(t_c).m_ascnum=57;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<291>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<292>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<293>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<294>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<295>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<296>";
	dbg_object(t_c).m_x=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<297>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<298>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<299>";
	dbg_object(t_c).m_name=":";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<300>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<301>";
	dbg_object(t_c).m_ascnum=58;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<302>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<303>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<304>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<305>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<306>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<307>";
	dbg_object(t_c).m_x=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<308>";
	dbg_object(t_c).m_y=30;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<309>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<310>";
	dbg_object(t_c).m_name=";";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<311>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<312>";
	dbg_object(t_c).m_ascnum=59;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<313>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<314>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<315>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<316>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<317>";
	dbg_object(t_c).m_height=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<318>";
	dbg_object(t_c).m_x=32;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<319>";
	dbg_object(t_c).m_y=30;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<320>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<321>";
	dbg_object(t_c).m_name="<";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<322>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<323>";
	dbg_object(t_c).m_ascnum=60;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<324>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<325>";
	dbg_object(t_c).m_yoffset=5;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<326>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<327>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<328>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<329>";
	dbg_object(t_c).m_x=39;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<330>";
	dbg_object(t_c).m_y=28;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<331>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<332>";
	dbg_object(t_c).m_name="=";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<333>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<334>";
	dbg_object(t_c).m_ascnum=61;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<335>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<336>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<337>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<338>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<339>";
	dbg_object(t_c).m_height=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<340>";
	dbg_object(t_c).m_x=52;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<341>";
	dbg_object(t_c).m_y=30;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<342>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<343>";
	dbg_object(t_c).m_name=">";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<344>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<345>";
	dbg_object(t_c).m_ascnum=62;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<346>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<347>";
	dbg_object(t_c).m_yoffset=5;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<348>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<349>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<350>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<351>";
	dbg_object(t_c).m_x=64;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<352>";
	dbg_object(t_c).m_y=28;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<353>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<354>";
	dbg_object(t_c).m_name="?";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<355>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<356>";
	dbg_object(t_c).m_ascnum=63;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<357>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<358>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<359>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<360>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<361>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<362>";
	dbg_object(t_c).m_x=77;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<363>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<364>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<365>";
	dbg_object(t_c).m_name="@";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<366>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<367>";
	dbg_object(t_c).m_ascnum=64;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<368>";
	dbg_object(t_c).m_xadvance=20;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<369>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<370>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<371>";
	dbg_object(t_c).m_width=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<372>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<373>";
	dbg_object(t_c).m_x=90;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<374>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<375>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<376>";
	dbg_object(t_c).m_name="A";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<377>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<378>";
	dbg_object(t_c).m_ascnum=65;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<379>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<380>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<381>";
	dbg_object(t_c).m_xoffset=-2;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<382>";
	dbg_object(t_c).m_width=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<383>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<384>";
	dbg_object(t_c).m_x=111;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<385>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<386>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<387>";
	dbg_object(t_c).m_name="B";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<388>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<389>";
	dbg_object(t_c).m_ascnum=66;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<390>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<391>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<392>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<393>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<394>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<395>";
	dbg_object(t_c).m_x=127;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<396>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<397>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<398>";
	dbg_object(t_c).m_name="C";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<399>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<400>";
	dbg_object(t_c).m_ascnum=67;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<401>";
	dbg_object(t_c).m_xadvance=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<402>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<403>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<404>";
	dbg_object(t_c).m_width=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<405>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<406>";
	dbg_object(t_c).m_x=141;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<407>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<408>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<409>";
	dbg_object(t_c).m_name="D";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<410>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<411>";
	dbg_object(t_c).m_ascnum=68;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<412>";
	dbg_object(t_c).m_xadvance=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<413>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<414>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<415>";
	dbg_object(t_c).m_width=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<416>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<417>";
	dbg_object(t_c).m_x=156;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<418>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<419>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<420>";
	dbg_object(t_c).m_name="E";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<421>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<422>";
	dbg_object(t_c).m_ascnum=69;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<423>";
	dbg_object(t_c).m_xadvance=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<424>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<425>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<426>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<427>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<428>";
	dbg_object(t_c).m_x=171;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<429>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<430>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<431>";
	dbg_object(t_c).m_name="F";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<432>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<433>";
	dbg_object(t_c).m_ascnum=70;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<434>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<435>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<436>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<437>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<438>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<439>";
	dbg_object(t_c).m_x=185;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<440>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<441>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<442>";
	dbg_object(t_c).m_name="G";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<443>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<444>";
	dbg_object(t_c).m_ascnum=71;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<445>";
	dbg_object(t_c).m_xadvance=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<446>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<447>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<448>";
	dbg_object(t_c).m_width=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<449>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<450>";
	dbg_object(t_c).m_x=197;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<451>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<452>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<453>";
	dbg_object(t_c).m_name="H";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<454>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<455>";
	dbg_object(t_c).m_ascnum=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<456>";
	dbg_object(t_c).m_xadvance=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<457>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<458>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<459>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<460>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<461>";
	dbg_object(t_c).m_x=213;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<462>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<463>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<464>";
	dbg_object(t_c).m_name="I";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<465>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<466>";
	dbg_object(t_c).m_ascnum=73;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<467>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<468>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<469>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<470>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<471>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<472>";
	dbg_object(t_c).m_x=228;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<473>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<474>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<475>";
	dbg_object(t_c).m_name="J";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<476>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<477>";
	dbg_object(t_c).m_ascnum=74;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<478>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<479>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<480>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<481>";
	dbg_object(t_c).m_width=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<482>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<483>";
	dbg_object(t_c).m_x=234;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<484>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<485>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<486>";
	dbg_object(t_c).m_name="K";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<487>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<488>";
	dbg_object(t_c).m_ascnum=75;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<489>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<490>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<491>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<492>";
	dbg_object(t_c).m_width=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<493>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<494>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<495>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<496>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<497>";
	dbg_object(t_c).m_name="L";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<498>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<499>";
	dbg_object(t_c).m_ascnum=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<500>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<501>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<502>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<503>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<504>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<505>";
	dbg_object(t_c).m_x=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<506>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<507>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<508>";
	dbg_object(t_c).m_name="M";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<509>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<510>";
	dbg_object(t_c).m_ascnum=77;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<511>";
	dbg_object(t_c).m_xadvance=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<512>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<513>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<514>";
	dbg_object(t_c).m_width=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<515>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<516>";
	dbg_object(t_c).m_x=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<517>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<518>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<519>";
	dbg_object(t_c).m_name="N";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<520>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<521>";
	dbg_object(t_c).m_ascnum=78;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<522>";
	dbg_object(t_c).m_xadvance=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<523>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<524>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<525>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<526>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<527>";
	dbg_object(t_c).m_x=43;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<528>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<529>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<530>";
	dbg_object(t_c).m_name="O";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<531>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<532>";
	dbg_object(t_c).m_ascnum=79;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<533>";
	dbg_object(t_c).m_xadvance=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<534>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<535>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<536>";
	dbg_object(t_c).m_width=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<537>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<538>";
	dbg_object(t_c).m_x=58;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<539>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<540>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<541>";
	dbg_object(t_c).m_name="P";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<542>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<543>";
	dbg_object(t_c).m_ascnum=80;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<544>";
	dbg_object(t_c).m_xadvance=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<545>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<546>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<547>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<548>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<549>";
	dbg_object(t_c).m_x=75;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<550>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<551>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<552>";
	dbg_object(t_c).m_name="Q";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<553>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<554>";
	dbg_object(t_c).m_ascnum=81;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<555>";
	dbg_object(t_c).m_xadvance=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<556>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<557>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<558>";
	dbg_object(t_c).m_width=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<559>";
	dbg_object(t_c).m_height=18;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<560>";
	dbg_object(t_c).m_x=89;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<561>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<562>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<563>";
	dbg_object(t_c).m_name="R";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<564>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<565>";
	dbg_object(t_c).m_ascnum=82;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<566>";
	dbg_object(t_c).m_xadvance=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<567>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<568>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<569>";
	dbg_object(t_c).m_width=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<570>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<571>";
	dbg_object(t_c).m_x=106;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<572>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<573>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<574>";
	dbg_object(t_c).m_name="S";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<575>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<576>";
	dbg_object(t_c).m_ascnum=83;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<577>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<578>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<579>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<580>";
	dbg_object(t_c).m_width=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<581>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<582>";
	dbg_object(t_c).m_x=120;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<583>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<584>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<585>";
	dbg_object(t_c).m_name="T";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<586>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<587>";
	dbg_object(t_c).m_ascnum=84;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<588>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<589>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<590>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<591>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<592>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<593>";
	dbg_object(t_c).m_x=135;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<594>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<595>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<596>";
	dbg_object(t_c).m_name="U";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<597>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<598>";
	dbg_object(t_c).m_ascnum=85;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<599>";
	dbg_object(t_c).m_xadvance=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<600>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<601>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<602>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<603>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<604>";
	dbg_object(t_c).m_x=149;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<605>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<606>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<607>";
	dbg_object(t_c).m_name="V";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<608>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<609>";
	dbg_object(t_c).m_ascnum=86;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<610>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<611>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<612>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<613>";
	dbg_object(t_c).m_width=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<614>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<615>";
	dbg_object(t_c).m_x=164;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<616>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<617>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<618>";
	dbg_object(t_c).m_name="W";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<619>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<620>";
	dbg_object(t_c).m_ascnum=87;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<621>";
	dbg_object(t_c).m_xadvance=19;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<622>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<623>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<624>";
	dbg_object(t_c).m_width=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<625>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<626>";
	dbg_object(t_c).m_x=179;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<627>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<628>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<629>";
	dbg_object(t_c).m_name="X";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<630>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<631>";
	dbg_object(t_c).m_ascnum=88;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<632>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<633>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<634>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<635>";
	dbg_object(t_c).m_width=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<636>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<637>";
	dbg_object(t_c).m_x=200;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<638>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<639>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<640>";
	dbg_object(t_c).m_name="Y";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<641>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<642>";
	dbg_object(t_c).m_ascnum=89;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<643>";
	dbg_object(t_c).m_xadvance=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<644>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<645>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<646>";
	dbg_object(t_c).m_width=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<647>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<648>";
	dbg_object(t_c).m_x=215;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<649>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<650>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<651>";
	dbg_object(t_c).m_name="Z";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<652>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<653>";
	dbg_object(t_c).m_ascnum=90;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<654>";
	dbg_object(t_c).m_xadvance=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<655>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<656>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<657>";
	dbg_object(t_c).m_width=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<658>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<659>";
	dbg_object(t_c).m_x=231;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<660>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<661>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<662>";
	dbg_object(t_c).m_name="[";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<663>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<664>";
	dbg_object(t_c).m_ascnum=91;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<665>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<666>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<667>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<668>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<669>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<670>";
	dbg_object(t_c).m_x=245;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<671>";
	dbg_object(t_c).m_y=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<672>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<673>";
	dbg_object(t_c).m_name="\\";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<674>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<675>";
	dbg_object(t_c).m_ascnum=92;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<676>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<677>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<678>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<679>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<680>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<681>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<682>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<683>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<684>";
	dbg_object(t_c).m_name="]";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<685>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<686>";
	dbg_object(t_c).m_ascnum=93;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<687>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<688>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<689>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<690>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<691>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<692>";
	dbg_object(t_c).m_x=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<693>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<694>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<695>";
	dbg_object(t_c).m_name="^";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<696>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<697>";
	dbg_object(t_c).m_ascnum=94;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<698>";
	dbg_object(t_c).m_xadvance=9;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<699>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<700>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<701>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<702>";
	dbg_object(t_c).m_height=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<703>";
	dbg_object(t_c).m_x=15;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<704>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<705>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<706>";
	dbg_object(t_c).m_name="_";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<707>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<708>";
	dbg_object(t_c).m_ascnum=95;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<709>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<710>";
	dbg_object(t_c).m_yoffset=20;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<711>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<712>";
	dbg_object(t_c).m_width=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<713>";
	dbg_object(t_c).m_height=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<714>";
	dbg_object(t_c).m_x=26;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<715>";
	dbg_object(t_c).m_y=89;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<716>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<717>";
	dbg_object(t_c).m_name="`";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<718>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<719>";
	dbg_object(t_c).m_ascnum=96;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<720>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<721>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<722>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<723>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<724>";
	dbg_object(t_c).m_height=5;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<725>";
	dbg_object(t_c).m_x=40;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<726>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<727>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<728>";
	dbg_object(t_c).m_name="a";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<729>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<730>";
	dbg_object(t_c).m_ascnum=97;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<731>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<732>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<733>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<734>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<735>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<736>";
	dbg_object(t_c).m_x=49;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<737>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<738>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<739>";
	dbg_object(t_c).m_name="b";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<740>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<741>";
	dbg_object(t_c).m_ascnum=98;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<742>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<743>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<744>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<745>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<746>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<747>";
	dbg_object(t_c).m_x=61;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<748>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<749>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<750>";
	dbg_object(t_c).m_name="c";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<751>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<752>";
	dbg_object(t_c).m_ascnum=99;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<753>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<754>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<755>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<756>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<757>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<758>";
	dbg_object(t_c).m_x=73;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<759>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<760>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<761>";
	dbg_object(t_c).m_name="d";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<762>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<763>";
	dbg_object(t_c).m_ascnum=100;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<764>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<765>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<766>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<767>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<768>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<769>";
	dbg_object(t_c).m_x=84;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<770>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<771>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<772>";
	dbg_object(t_c).m_name="e";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<773>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<774>";
	dbg_object(t_c).m_ascnum=101;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<775>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<776>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<777>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<778>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<779>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<780>";
	dbg_object(t_c).m_x=96;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<781>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<782>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<783>";
	dbg_object(t_c).m_name="f";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<784>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<785>";
	dbg_object(t_c).m_ascnum=102;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<786>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<787>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<788>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<789>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<790>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<791>";
	dbg_object(t_c).m_x=108;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<792>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<793>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<794>";
	dbg_object(t_c).m_name="g";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<795>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<796>";
	dbg_object(t_c).m_ascnum=103;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<797>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<798>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<799>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<800>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<801>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<802>";
	dbg_object(t_c).m_x=116;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<803>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<804>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<805>";
	dbg_object(t_c).m_name="h";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<806>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<807>";
	dbg_object(t_c).m_ascnum=104;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<808>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<809>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<810>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<811>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<812>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<813>";
	dbg_object(t_c).m_x=128;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<814>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<815>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<816>";
	dbg_object(t_c).m_name="i";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<817>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<818>";
	dbg_object(t_c).m_ascnum=105;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<819>";
	dbg_object(t_c).m_xadvance=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<820>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<821>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<822>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<823>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<824>";
	dbg_object(t_c).m_x=140;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<825>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<826>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<827>";
	dbg_object(t_c).m_name="j";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<828>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<829>";
	dbg_object(t_c).m_ascnum=106;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<830>";
	dbg_object(t_c).m_xadvance=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<831>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<832>";
	dbg_object(t_c).m_xoffset=-3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<833>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<834>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<835>";
	dbg_object(t_c).m_x=145;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<836>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<837>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<838>";
	dbg_object(t_c).m_name="k";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<839>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<840>";
	dbg_object(t_c).m_ascnum=107;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<841>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<842>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<843>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<844>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<845>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<846>";
	dbg_object(t_c).m_x=153;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<847>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<848>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<849>";
	dbg_object(t_c).m_name="l";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<850>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<851>";
	dbg_object(t_c).m_ascnum=108;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<852>";
	dbg_object(t_c).m_xadvance=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<853>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<854>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<855>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<856>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<857>";
	dbg_object(t_c).m_x=164;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<858>";
	dbg_object(t_c).m_y=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<859>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<860>";
	dbg_object(t_c).m_name="m";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<861>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<862>";
	dbg_object(t_c).m_ascnum=109;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<863>";
	dbg_object(t_c).m_xadvance=16;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<864>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<865>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<866>";
	dbg_object(t_c).m_width=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<867>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<868>";
	dbg_object(t_c).m_x=169;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<869>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<870>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<871>";
	dbg_object(t_c).m_name="n";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<872>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<873>";
	dbg_object(t_c).m_ascnum=110;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<874>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<875>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<876>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<877>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<878>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<879>";
	dbg_object(t_c).m_x=186;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<880>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<881>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<882>";
	dbg_object(t_c).m_name="o";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<883>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<884>";
	dbg_object(t_c).m_ascnum=111;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<885>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<886>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<887>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<888>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<889>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<890>";
	dbg_object(t_c).m_x=198;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<891>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<892>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<893>";
	dbg_object(t_c).m_name="p";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<894>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<895>";
	dbg_object(t_c).m_ascnum=112;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<896>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<897>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<898>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<899>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<900>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<901>";
	dbg_object(t_c).m_x=211;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<902>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<903>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<904>";
	dbg_object(t_c).m_name="q";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<905>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<906>";
	dbg_object(t_c).m_ascnum=113;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<907>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<908>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<909>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<910>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<911>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<912>";
	dbg_object(t_c).m_x=223;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<913>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<914>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<915>";
	dbg_object(t_c).m_name="r";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<916>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<917>";
	dbg_object(t_c).m_ascnum=114;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<918>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<919>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<920>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<921>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<922>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<923>";
	dbg_object(t_c).m_x=235;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<924>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<925>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<926>";
	dbg_object(t_c).m_name="s";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<927>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<928>";
	dbg_object(t_c).m_ascnum=115;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<929>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<930>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<931>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<932>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<933>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<934>";
	dbg_object(t_c).m_x=243;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<935>";
	dbg_object(t_c).m_y=76;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<936>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<937>";
	dbg_object(t_c).m_name="t";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<938>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<939>";
	dbg_object(t_c).m_ascnum=116;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<940>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<941>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<942>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<943>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<944>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<945>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<946>";
	dbg_object(t_c).m_y=95;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<947>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<948>";
	dbg_object(t_c).m_name="u";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<949>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<950>";
	dbg_object(t_c).m_ascnum=117;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<951>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<952>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<953>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<954>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<955>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<956>";
	dbg_object(t_c).m_x=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<957>";
	dbg_object(t_c).m_y=99;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<958>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<959>";
	dbg_object(t_c).m_name="v";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<960>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<961>";
	dbg_object(t_c).m_ascnum=118;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<962>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<963>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<964>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<965>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<966>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<967>";
	dbg_object(t_c).m_x=20;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<968>";
	dbg_object(t_c).m_y=99;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<969>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<970>";
	dbg_object(t_c).m_name="w";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<971>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<972>";
	dbg_object(t_c).m_ascnum=119;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<973>";
	dbg_object(t_c).m_xadvance=14;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<974>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<975>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<976>";
	dbg_object(t_c).m_width=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<977>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<978>";
	dbg_object(t_c).m_x=32;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<979>";
	dbg_object(t_c).m_y=99;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<980>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<981>";
	dbg_object(t_c).m_name="x";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<982>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<983>";
	dbg_object(t_c).m_ascnum=120;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<984>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<985>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<986>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<987>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<988>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<989>";
	dbg_object(t_c).m_x=48;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<990>";
	dbg_object(t_c).m_y=99;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<991>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<992>";
	dbg_object(t_c).m_name="y";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<993>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<994>";
	dbg_object(t_c).m_ascnum=121;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<995>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<996>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<997>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<998>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<999>";
	dbg_object(t_c).m_height=17;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1000>";
	dbg_object(t_c).m_x=60;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1001>";
	dbg_object(t_c).m_y=99;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1002>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1003>";
	dbg_object(t_c).m_name="z";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1004>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1005>";
	dbg_object(t_c).m_ascnum=122;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1006>";
	dbg_object(t_c).m_xadvance=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1007>";
	dbg_object(t_c).m_yoffset=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1008>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1009>";
	dbg_object(t_c).m_width=11;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1010>";
	dbg_object(t_c).m_height=13;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1011>";
	dbg_object(t_c).m_x=72;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1012>";
	dbg_object(t_c).m_y=99;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1013>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1014>";
	dbg_object(t_c).m_name="{";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1015>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1016>";
	dbg_object(t_c).m_ascnum=123;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1017>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1018>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1019>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1020>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1021>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1022>";
	dbg_object(t_c).m_x=84;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1023>";
	dbg_object(t_c).m_y=95;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1024>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1025>";
	dbg_object(t_c).m_name="|";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1026>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1027>";
	dbg_object(t_c).m_ascnum=124;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1028>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1029>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1030>";
	dbg_object(t_c).m_xoffset=1;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1031>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1032>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1033>";
	dbg_object(t_c).m_x=92;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1034>";
	dbg_object(t_c).m_y=95;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1035>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1036>";
	dbg_object(t_c).m_name="}";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1037>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1038>";
	dbg_object(t_c).m_ascnum=125;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1039>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1040>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1041>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1042>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1043>";
	dbg_object(t_c).m_height=21;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1044>";
	dbg_object(t_c).m_x=98;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1045>";
	dbg_object(t_c).m_y=95;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1046>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1047>";
	dbg_object(t_c).m_name="~";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1048>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1049>";
	dbg_object(t_c).m_ascnum=126;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1050>";
	dbg_object(t_c).m_xadvance=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1051>";
	dbg_object(t_c).m_yoffset=8;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1052>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1053>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1054>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1055>";
	dbg_object(t_c).m_x=106;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1056>";
	dbg_object(t_c).m_y=100;
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1057>";
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1057>";
	var t_=this.m_charmap.p_Values().p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1057>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1057>";
		var t_de=(t_.p_NextObject());
		err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1058>";
		var t_d=object_downcast((t_de),c_Char);
		err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1059>";
		if(dbg_object(t_d).m_name!=" "){
			err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1060>";
			dbg_object(t_d).m_img=dbg_object(this).m_img.p_GrabImage(dbg_object(t_d).m_x,dbg_object(t_d).m_y,dbg_object(t_d).m_width,dbg_object(t_d).m_height,1,c_Image.m_DefaultFlags);
		}
	}
	pop_err();
	return this;
}
c_mediumarialfont.prototype.p_get_char=function(t_Chr){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/mediumarialclass/mediumarialclass.monkey<1065>";
	var t_=this.m_charmap.p_Get(t_Chr);
	pop_err();
	return t_;
}
function c_MapValues(){
	Object.call(this);
	this.m_map=null;
}
c_MapValues.m_new=function(t_map){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<519>";
	dbg_object(this).m_map=t_map;
	pop_err();
	return this;
}
c_MapValues.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<516>";
	pop_err();
	return this;
}
c_MapValues.prototype.p_ObjectEnumerator=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<523>";
	var t_=c_ValueEnumerator.m_new.call(new c_ValueEnumerator,this.m_map.p_FirstNode());
	pop_err();
	return t_;
}
function c_ValueEnumerator(){
	Object.call(this);
	this.m_node=null;
}
c_ValueEnumerator.m_new=function(t_node){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<481>";
	dbg_object(this).m_node=t_node;
	pop_err();
	return this;
}
c_ValueEnumerator.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<478>";
	pop_err();
	return this;
}
c_ValueEnumerator.prototype.p_HasNext=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<485>";
	var t_=this.m_node!=null;
	pop_err();
	return t_;
}
c_ValueEnumerator.prototype.p_NextObject=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<489>";
	var t_t=this.m_node;
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<490>";
	this.m_node=this.m_node.p_NextNode();
	err_info="/root/Dropbox/Monkey/modules/monkey/map.monkey<491>";
	pop_err();
	return dbg_object(t_t).m_value;
}
var bb_spriter_medium_font=null;
function c_arialfont(){
	c_keeffont.call(this);
}
c_arialfont.prototype=extend_class(c_keeffont);
c_arialfont.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<9>";
	c_keeffont.m_new.call(this);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<10>";
	dbg_object(this).m_img=bb_graphics_LoadImage("arialblack.png",1,c_Image.m_DefaultFlags);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<11>";
	if(dbg_object(this).m_img==null){
		err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<12>";
		error("font img is null");
	}
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<14>";
	this.m_charmap=c_StringMap.m_new.call(new c_StringMap);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<15>";
	this.m_width=128;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<16>";
	this.m_height=128;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<17>";
	this.m_fontheight=12;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<18>";
	var t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<19>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<20>";
	dbg_object(t_c).m_name=" ";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<21>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<22>";
	dbg_object(t_c).m_ascnum=32;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<23>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<24>";
	dbg_object(t_c).m_yoffset=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<25>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<26>";
	dbg_object(t_c).m_width=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<27>";
	dbg_object(t_c).m_height=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<28>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<29>";
	dbg_object(t_c).m_name="!";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<30>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<31>";
	dbg_object(t_c).m_ascnum=33;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<32>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<33>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<34>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<35>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<36>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<37>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<38>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<39>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<40>";
	dbg_object(t_c).m_name="\"";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<41>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<42>";
	dbg_object(t_c).m_ascnum=34;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<43>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<44>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<45>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<46>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<47>";
	dbg_object(t_c).m_height=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<48>";
	dbg_object(t_c).m_x=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<49>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<50>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<51>";
	dbg_object(t_c).m_name="#";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<52>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<53>";
	dbg_object(t_c).m_ascnum=35;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<54>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<55>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<56>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<57>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<58>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<59>";
	dbg_object(t_c).m_x=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<60>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<61>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<62>";
	dbg_object(t_c).m_name="$";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<63>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<64>";
	dbg_object(t_c).m_ascnum=36;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<65>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<66>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<67>";
	dbg_object(t_c).m_xoffset=-2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<68>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<69>";
	dbg_object(t_c).m_height=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<70>";
	dbg_object(t_c).m_x=18;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<71>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<72>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<73>";
	dbg_object(t_c).m_name="%";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<74>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<75>";
	dbg_object(t_c).m_ascnum=37;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<76>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<77>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<78>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<79>";
	dbg_object(t_c).m_width=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<80>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<81>";
	dbg_object(t_c).m_x=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<82>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<83>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<84>";
	dbg_object(t_c).m_name="&";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<85>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<86>";
	dbg_object(t_c).m_ascnum=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<87>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<88>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<89>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<90>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<91>";
	dbg_object(t_c).m_height=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<92>";
	dbg_object(t_c).m_x=37;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<93>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<94>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<95>";
	dbg_object(t_c).m_name="'";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<96>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<97>";
	dbg_object(t_c).m_ascnum=39;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<98>";
	dbg_object(t_c).m_xadvance=1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<99>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<100>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<101>";
	dbg_object(t_c).m_width=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<102>";
	dbg_object(t_c).m_height=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<103>";
	dbg_object(t_c).m_x=45;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<104>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<105>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<106>";
	dbg_object(t_c).m_name="(";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<107>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<108>";
	dbg_object(t_c).m_ascnum=40;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<109>";
	dbg_object(t_c).m_xadvance=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<110>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<111>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<112>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<113>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<114>";
	dbg_object(t_c).m_x=48;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<115>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<116>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<117>";
	dbg_object(t_c).m_name=")";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<118>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<119>";
	dbg_object(t_c).m_ascnum=41;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<120>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<121>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<122>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<123>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<124>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<125>";
	dbg_object(t_c).m_x=53;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<126>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<127>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<128>";
	dbg_object(t_c).m_name="*";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<129>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<130>";
	dbg_object(t_c).m_ascnum=42;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<131>";
	dbg_object(t_c).m_xadvance=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<132>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<133>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<134>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<135>";
	dbg_object(t_c).m_height=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<136>";
	dbg_object(t_c).m_x=58;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<137>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<138>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<139>";
	dbg_object(t_c).m_name="+";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<140>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<141>";
	dbg_object(t_c).m_ascnum=43;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<142>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<143>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<144>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<145>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<146>";
	dbg_object(t_c).m_height=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<147>";
	dbg_object(t_c).m_x=64;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<148>";
	dbg_object(t_c).m_y=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<149>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<150>";
	dbg_object(t_c).m_name=",";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<151>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<152>";
	dbg_object(t_c).m_ascnum=44;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<153>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<154>";
	dbg_object(t_c).m_yoffset=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<155>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<156>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<157>";
	dbg_object(t_c).m_height=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<158>";
	dbg_object(t_c).m_x=71;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<159>";
	dbg_object(t_c).m_y=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<160>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<161>";
	dbg_object(t_c).m_name="-";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<162>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<163>";
	dbg_object(t_c).m_ascnum=45;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<164>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<165>";
	dbg_object(t_c).m_yoffset=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<166>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<167>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<168>";
	dbg_object(t_c).m_height=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<169>";
	dbg_object(t_c).m_x=76;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<170>";
	dbg_object(t_c).m_y=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<171>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<172>";
	dbg_object(t_c).m_name=".";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<173>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<174>";
	dbg_object(t_c).m_ascnum=46;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<175>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<176>";
	dbg_object(t_c).m_yoffset=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<177>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<178>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<179>";
	dbg_object(t_c).m_height=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<180>";
	dbg_object(t_c).m_x=81;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<181>";
	dbg_object(t_c).m_y=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<182>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<183>";
	dbg_object(t_c).m_name="/";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<184>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<185>";
	dbg_object(t_c).m_ascnum=47;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<186>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<187>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<188>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<189>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<190>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<191>";
	dbg_object(t_c).m_x=86;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<192>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<193>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<194>";
	dbg_object(t_c).m_name="0";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<195>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<196>";
	dbg_object(t_c).m_ascnum=48;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<197>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<198>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<199>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<200>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<201>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<202>";
	dbg_object(t_c).m_x=91;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<203>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<204>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<205>";
	dbg_object(t_c).m_name="1";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<206>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<207>";
	dbg_object(t_c).m_ascnum=49;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<208>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<209>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<210>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<211>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<212>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<213>";
	dbg_object(t_c).m_x=98;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<214>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<215>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<216>";
	dbg_object(t_c).m_name="2";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<217>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<218>";
	dbg_object(t_c).m_ascnum=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<219>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<220>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<221>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<222>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<223>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<224>";
	dbg_object(t_c).m_x=105;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<225>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<226>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<227>";
	dbg_object(t_c).m_name="3";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<228>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<229>";
	dbg_object(t_c).m_ascnum=51;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<230>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<231>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<232>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<233>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<234>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<235>";
	dbg_object(t_c).m_x=112;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<236>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<237>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<238>";
	dbg_object(t_c).m_name="4";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<239>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<240>";
	dbg_object(t_c).m_ascnum=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<241>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<242>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<243>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<244>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<245>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<246>";
	dbg_object(t_c).m_x=119;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<247>";
	dbg_object(t_c).m_y=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<248>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<249>";
	dbg_object(t_c).m_name="5";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<250>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<251>";
	dbg_object(t_c).m_ascnum=53;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<252>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<253>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<254>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<255>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<256>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<257>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<258>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<259>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<260>";
	dbg_object(t_c).m_name="6";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<261>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<262>";
	dbg_object(t_c).m_ascnum=54;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<263>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<264>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<265>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<266>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<267>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<268>";
	dbg_object(t_c).m_x=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<269>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<270>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<271>";
	dbg_object(t_c).m_name="7";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<272>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<273>";
	dbg_object(t_c).m_ascnum=55;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<274>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<275>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<276>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<277>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<278>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<279>";
	dbg_object(t_c).m_x=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<280>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<281>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<282>";
	dbg_object(t_c).m_name="8";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<283>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<284>";
	dbg_object(t_c).m_ascnum=56;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<285>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<286>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<287>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<288>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<289>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<290>";
	dbg_object(t_c).m_x=21;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<291>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<292>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<293>";
	dbg_object(t_c).m_name="9";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<294>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<295>";
	dbg_object(t_c).m_ascnum=57;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<296>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<297>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<298>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<299>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<300>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<301>";
	dbg_object(t_c).m_x=28;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<302>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<303>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<304>";
	dbg_object(t_c).m_name=":";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<305>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<306>";
	dbg_object(t_c).m_ascnum=58;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<307>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<308>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<309>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<310>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<311>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<312>";
	dbg_object(t_c).m_x=35;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<313>";
	dbg_object(t_c).m_y=16;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<314>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<315>";
	dbg_object(t_c).m_name=";";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<316>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<317>";
	dbg_object(t_c).m_ascnum=59;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<318>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<319>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<320>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<321>";
	dbg_object(t_c).m_width=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<322>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<323>";
	dbg_object(t_c).m_x=40;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<324>";
	dbg_object(t_c).m_y=16;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<325>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<326>";
	dbg_object(t_c).m_name="<";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<327>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<328>";
	dbg_object(t_c).m_ascnum=60;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<329>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<330>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<331>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<332>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<333>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<334>";
	dbg_object(t_c).m_x=45;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<335>";
	dbg_object(t_c).m_y=15;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<336>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<337>";
	dbg_object(t_c).m_name="=";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<338>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<339>";
	dbg_object(t_c).m_ascnum=61;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<340>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<341>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<342>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<343>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<344>";
	dbg_object(t_c).m_height=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<345>";
	dbg_object(t_c).m_x=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<346>";
	dbg_object(t_c).m_y=16;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<347>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<348>";
	dbg_object(t_c).m_name=">";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<349>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<350>";
	dbg_object(t_c).m_ascnum=62;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<351>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<352>";
	dbg_object(t_c).m_yoffset=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<353>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<354>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<355>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<356>";
	dbg_object(t_c).m_x=60;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<357>";
	dbg_object(t_c).m_y=15;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<358>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<359>";
	dbg_object(t_c).m_name="?";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<360>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<361>";
	dbg_object(t_c).m_ascnum=63;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<362>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<363>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<364>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<365>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<366>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<367>";
	dbg_object(t_c).m_x=67;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<368>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<369>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<370>";
	dbg_object(t_c).m_name="@";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<371>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<372>";
	dbg_object(t_c).m_ascnum=64;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<373>";
	dbg_object(t_c).m_xadvance=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<374>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<375>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<376>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<377>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<378>";
	dbg_object(t_c).m_x=74;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<379>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<380>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<381>";
	dbg_object(t_c).m_name="A";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<382>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<383>";
	dbg_object(t_c).m_ascnum=65;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<384>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<385>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<386>";
	dbg_object(t_c).m_xoffset=-2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<387>";
	dbg_object(t_c).m_width=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<388>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<389>";
	dbg_object(t_c).m_x=86;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<390>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<391>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<392>";
	dbg_object(t_c).m_name="B";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<393>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<394>";
	dbg_object(t_c).m_ascnum=66;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<395>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<396>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<397>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<398>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<399>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<400>";
	dbg_object(t_c).m_x=96;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<401>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<402>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<403>";
	dbg_object(t_c).m_name="C";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<404>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<405>";
	dbg_object(t_c).m_ascnum=67;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<406>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<407>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<408>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<409>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<410>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<411>";
	dbg_object(t_c).m_x=103;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<412>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<413>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<414>";
	dbg_object(t_c).m_name="D";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<415>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<416>";
	dbg_object(t_c).m_ascnum=68;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<417>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<418>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<419>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<420>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<421>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<422>";
	dbg_object(t_c).m_x=112;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<423>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<424>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<425>";
	dbg_object(t_c).m_name="E";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<426>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<427>";
	dbg_object(t_c).m_ascnum=69;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<428>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<429>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<430>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<431>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<432>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<433>";
	dbg_object(t_c).m_x=120;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<434>";
	dbg_object(t_c).m_y=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<435>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<436>";
	dbg_object(t_c).m_name="F";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<437>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<438>";
	dbg_object(t_c).m_ascnum=70;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<439>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<440>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<441>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<442>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<443>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<444>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<445>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<446>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<447>";
	dbg_object(t_c).m_name="G";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<448>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<449>";
	dbg_object(t_c).m_ascnum=71;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<450>";
	dbg_object(t_c).m_xadvance=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<451>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<452>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<453>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<454>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<455>";
	dbg_object(t_c).m_x=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<456>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<457>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<458>";
	dbg_object(t_c).m_name="H";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<459>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<460>";
	dbg_object(t_c).m_ascnum=72;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<461>";
	dbg_object(t_c).m_xadvance=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<462>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<463>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<464>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<465>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<466>";
	dbg_object(t_c).m_x=17;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<467>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<468>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<469>";
	dbg_object(t_c).m_name="I";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<470>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<471>";
	dbg_object(t_c).m_ascnum=73;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<472>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<473>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<474>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<475>";
	dbg_object(t_c).m_width=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<476>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<477>";
	dbg_object(t_c).m_x=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<478>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<479>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<480>";
	dbg_object(t_c).m_name="J";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<481>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<482>";
	dbg_object(t_c).m_ascnum=74;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<483>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<484>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<485>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<486>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<487>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<488>";
	dbg_object(t_c).m_x=30;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<489>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<490>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<491>";
	dbg_object(t_c).m_name="K";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<492>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<493>";
	dbg_object(t_c).m_ascnum=75;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<494>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<495>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<496>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<497>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<498>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<499>";
	dbg_object(t_c).m_x=37;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<500>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<501>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<502>";
	dbg_object(t_c).m_name="L";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<503>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<504>";
	dbg_object(t_c).m_ascnum=76;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<505>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<506>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<507>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<508>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<509>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<510>";
	dbg_object(t_c).m_x=45;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<511>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<512>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<513>";
	dbg_object(t_c).m_name="M";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<514>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<515>";
	dbg_object(t_c).m_ascnum=77;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<516>";
	dbg_object(t_c).m_xadvance=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<517>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<518>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<519>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<520>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<521>";
	dbg_object(t_c).m_x=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<522>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<523>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<524>";
	dbg_object(t_c).m_name="N";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<525>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<526>";
	dbg_object(t_c).m_ascnum=78;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<527>";
	dbg_object(t_c).m_xadvance=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<528>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<529>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<530>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<531>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<532>";
	dbg_object(t_c).m_x=62;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<533>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<534>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<535>";
	dbg_object(t_c).m_name="O";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<536>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<537>";
	dbg_object(t_c).m_ascnum=79;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<538>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<539>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<540>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<541>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<542>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<543>";
	dbg_object(t_c).m_x=71;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<544>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<545>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<546>";
	dbg_object(t_c).m_name="P";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<547>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<548>";
	dbg_object(t_c).m_ascnum=80;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<549>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<550>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<551>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<552>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<553>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<554>";
	dbg_object(t_c).m_x=80;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<555>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<556>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<557>";
	dbg_object(t_c).m_name="Q";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<558>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<559>";
	dbg_object(t_c).m_ascnum=81;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<560>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<561>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<562>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<563>";
	dbg_object(t_c).m_width=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<564>";
	dbg_object(t_c).m_height=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<565>";
	dbg_object(t_c).m_x=88;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<566>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<567>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<568>";
	dbg_object(t_c).m_name="R";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<569>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<570>";
	dbg_object(t_c).m_ascnum=82;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<571>";
	dbg_object(t_c).m_xadvance=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<572>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<573>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<574>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<575>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<576>";
	dbg_object(t_c).m_x=97;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<577>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<578>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<579>";
	dbg_object(t_c).m_name="S";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<580>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<581>";
	dbg_object(t_c).m_ascnum=83;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<582>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<583>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<584>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<585>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<586>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<587>";
	dbg_object(t_c).m_x=106;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<588>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<589>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<590>";
	dbg_object(t_c).m_name="T";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<591>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<592>";
	dbg_object(t_c).m_ascnum=84;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<593>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<594>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<595>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<596>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<597>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<598>";
	dbg_object(t_c).m_x=115;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<599>";
	dbg_object(t_c).m_y=26;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<600>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<601>";
	dbg_object(t_c).m_name="U";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<602>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<603>";
	dbg_object(t_c).m_ascnum=85;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<604>";
	dbg_object(t_c).m_xadvance=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<605>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<606>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<607>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<608>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<609>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<610>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<611>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<612>";
	dbg_object(t_c).m_name="V";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<613>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<614>";
	dbg_object(t_c).m_ascnum=86;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<615>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<616>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<617>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<618>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<619>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<620>";
	dbg_object(t_c).m_x=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<621>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<622>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<623>";
	dbg_object(t_c).m_name="W";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<624>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<625>";
	dbg_object(t_c).m_ascnum=87;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<626>";
	dbg_object(t_c).m_xadvance=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<627>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<628>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<629>";
	dbg_object(t_c).m_width=12;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<630>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<631>";
	dbg_object(t_c).m_x=18;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<632>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<633>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<634>";
	dbg_object(t_c).m_name="X";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<635>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<636>";
	dbg_object(t_c).m_ascnum=88;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<637>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<638>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<639>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<640>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<641>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<642>";
	dbg_object(t_c).m_x=29;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<643>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<644>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<645>";
	dbg_object(t_c).m_name="Y";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<646>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<647>";
	dbg_object(t_c).m_ascnum=89;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<648>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<649>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<650>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<651>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<652>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<653>";
	dbg_object(t_c).m_x=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<654>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<655>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<656>";
	dbg_object(t_c).m_name="Z";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<657>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<658>";
	dbg_object(t_c).m_ascnum=90;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<659>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<660>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<661>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<662>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<663>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<664>";
	dbg_object(t_c).m_x=47;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<665>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<666>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<667>";
	dbg_object(t_c).m_name="[";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<668>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<669>";
	dbg_object(t_c).m_ascnum=91;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<670>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<671>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<672>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<673>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<674>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<675>";
	dbg_object(t_c).m_x=55;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<676>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<677>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<678>";
	dbg_object(t_c).m_name="\\";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<679>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<680>";
	dbg_object(t_c).m_ascnum=92;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<681>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<682>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<683>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<684>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<685>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<686>";
	dbg_object(t_c).m_x=59;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<687>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<688>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<689>";
	dbg_object(t_c).m_name="]";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<690>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<691>";
	dbg_object(t_c).m_ascnum=93;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<692>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<693>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<694>";
	dbg_object(t_c).m_xoffset=-2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<695>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<696>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<697>";
	dbg_object(t_c).m_x=64;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<698>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<699>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<700>";
	dbg_object(t_c).m_name="^";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<701>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<702>";
	dbg_object(t_c).m_ascnum=94;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<703>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<704>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<705>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<706>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<707>";
	dbg_object(t_c).m_height=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<708>";
	dbg_object(t_c).m_x=70;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<709>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<710>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<711>";
	dbg_object(t_c).m_name="_";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<712>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<713>";
	dbg_object(t_c).m_ascnum=95;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<714>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<715>";
	dbg_object(t_c).m_yoffset=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<716>";
	dbg_object(t_c).m_xoffset=-2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<717>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<718>";
	dbg_object(t_c).m_height=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<719>";
	dbg_object(t_c).m_x=77;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<720>";
	dbg_object(t_c).m_y=46;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<721>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<722>";
	dbg_object(t_c).m_name="`";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<723>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<724>";
	dbg_object(t_c).m_ascnum=96;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<725>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<726>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<727>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<728>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<729>";
	dbg_object(t_c).m_height=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<730>";
	dbg_object(t_c).m_x=86;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<731>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<732>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<733>";
	dbg_object(t_c).m_name="a";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<734>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<735>";
	dbg_object(t_c).m_ascnum=97;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<736>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<737>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<738>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<739>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<740>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<741>";
	dbg_object(t_c).m_x=91;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<742>";
	dbg_object(t_c).m_y=40;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<743>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<744>";
	dbg_object(t_c).m_name="b";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<745>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<746>";
	dbg_object(t_c).m_ascnum=98;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<747>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<748>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<749>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<750>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<751>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<752>";
	dbg_object(t_c).m_x=98;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<753>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<754>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<755>";
	dbg_object(t_c).m_name="c";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<756>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<757>";
	dbg_object(t_c).m_ascnum=99;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<758>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<759>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<760>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<761>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<762>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<763>";
	dbg_object(t_c).m_x=105;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<764>";
	dbg_object(t_c).m_y=40;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<765>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<766>";
	dbg_object(t_c).m_name="d";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<767>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<768>";
	dbg_object(t_c).m_ascnum=100;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<769>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<770>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<771>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<772>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<773>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<774>";
	dbg_object(t_c).m_x=112;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<775>";
	dbg_object(t_c).m_y=38;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<776>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<777>";
	dbg_object(t_c).m_name="e";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<778>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<779>";
	dbg_object(t_c).m_ascnum=101;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<780>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<781>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<782>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<783>";
	dbg_object(t_c).m_width=8;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<784>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<785>";
	dbg_object(t_c).m_x=120;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<786>";
	dbg_object(t_c).m_y=40;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<787>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<788>";
	dbg_object(t_c).m_name="f";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<789>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<790>";
	dbg_object(t_c).m_ascnum=102;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<791>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<792>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<793>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<794>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<795>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<796>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<797>";
	dbg_object(t_c).m_y=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<798>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<799>";
	dbg_object(t_c).m_name="g";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<800>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<801>";
	dbg_object(t_c).m_ascnum=103;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<802>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<803>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<804>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<805>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<806>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<807>";
	dbg_object(t_c).m_x=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<808>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<809>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<810>";
	dbg_object(t_c).m_name="h";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<811>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<812>";
	dbg_object(t_c).m_ascnum=104;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<813>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<814>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<815>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<816>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<817>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<818>";
	dbg_object(t_c).m_x=13;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<819>";
	dbg_object(t_c).m_y=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<820>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<821>";
	dbg_object(t_c).m_name="i";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<822>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<823>";
	dbg_object(t_c).m_ascnum=105;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<824>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<825>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<826>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<827>";
	dbg_object(t_c).m_width=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<828>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<829>";
	dbg_object(t_c).m_x=20;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<830>";
	dbg_object(t_c).m_y=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<831>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<832>";
	dbg_object(t_c).m_name="j";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<833>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<834>";
	dbg_object(t_c).m_ascnum=106;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<835>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<836>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<837>";
	dbg_object(t_c).m_xoffset=-2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<838>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<839>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<840>";
	dbg_object(t_c).m_x=24;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<841>";
	dbg_object(t_c).m_y=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<842>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<843>";
	dbg_object(t_c).m_name="k";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<844>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<845>";
	dbg_object(t_c).m_ascnum=107;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<846>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<847>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<848>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<849>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<850>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<851>";
	dbg_object(t_c).m_x=30;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<852>";
	dbg_object(t_c).m_y=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<853>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<854>";
	dbg_object(t_c).m_name="l";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<855>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<856>";
	dbg_object(t_c).m_ascnum=108;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<857>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<858>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<859>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<860>";
	dbg_object(t_c).m_width=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<861>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<862>";
	dbg_object(t_c).m_x=36;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<863>";
	dbg_object(t_c).m_y=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<864>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<865>";
	dbg_object(t_c).m_name="m";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<866>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<867>";
	dbg_object(t_c).m_ascnum=109;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<868>";
	dbg_object(t_c).m_xadvance=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<869>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<870>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<871>";
	dbg_object(t_c).m_width=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<872>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<873>";
	dbg_object(t_c).m_x=40;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<874>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<875>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<876>";
	dbg_object(t_c).m_name="n";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<877>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<878>";
	dbg_object(t_c).m_ascnum=110;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<879>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<880>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<881>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<882>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<883>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<884>";
	dbg_object(t_c).m_x=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<885>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<886>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<887>";
	dbg_object(t_c).m_name="o";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<888>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<889>";
	dbg_object(t_c).m_ascnum=111;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<890>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<891>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<892>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<893>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<894>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<895>";
	dbg_object(t_c).m_x=57;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<896>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<897>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<898>";
	dbg_object(t_c).m_name="p";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<899>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<900>";
	dbg_object(t_c).m_ascnum=112;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<901>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<902>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<903>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<904>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<905>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<906>";
	dbg_object(t_c).m_x=64;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<907>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<908>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<909>";
	dbg_object(t_c).m_name="q";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<910>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<911>";
	dbg_object(t_c).m_ascnum=113;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<912>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<913>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<914>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<915>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<916>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<917>";
	dbg_object(t_c).m_x=71;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<918>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<919>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<920>";
	dbg_object(t_c).m_name="r";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<921>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<922>";
	dbg_object(t_c).m_ascnum=114;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<923>";
	dbg_object(t_c).m_xadvance=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<924>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<925>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<926>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<927>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<928>";
	dbg_object(t_c).m_x=79;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<929>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<930>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<931>";
	dbg_object(t_c).m_name="s";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<932>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<933>";
	dbg_object(t_c).m_ascnum=115;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<934>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<935>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<936>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<937>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<938>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<939>";
	dbg_object(t_c).m_x=84;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<940>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<941>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<942>";
	dbg_object(t_c).m_name="t";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<943>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<944>";
	dbg_object(t_c).m_ascnum=116;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<945>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<946>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<947>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<948>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<949>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<950>";
	dbg_object(t_c).m_x=92;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<951>";
	dbg_object(t_c).m_y=50;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<952>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<953>";
	dbg_object(t_c).m_name="u";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<954>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<955>";
	dbg_object(t_c).m_ascnum=117;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<956>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<957>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<958>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<959>";
	dbg_object(t_c).m_width=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<960>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<961>";
	dbg_object(t_c).m_x=97;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<962>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<963>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<964>";
	dbg_object(t_c).m_name="v";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<965>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<966>";
	dbg_object(t_c).m_ascnum=118;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<967>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<968>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<969>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<970>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<971>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<972>";
	dbg_object(t_c).m_x=104;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<973>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<974>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<975>";
	dbg_object(t_c).m_name="w";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<976>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<977>";
	dbg_object(t_c).m_ascnum=119;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<978>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<979>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<980>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<981>";
	dbg_object(t_c).m_width=10;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<982>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<983>";
	dbg_object(t_c).m_x=111;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<984>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<985>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<986>";
	dbg_object(t_c).m_name="x";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<987>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<988>";
	dbg_object(t_c).m_ascnum=120;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<989>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<990>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<991>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<992>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<993>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<994>";
	dbg_object(t_c).m_x=120;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<995>";
	dbg_object(t_c).m_y=52;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<996>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<997>";
	dbg_object(t_c).m_name="y";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<998>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<999>";
	dbg_object(t_c).m_ascnum=121;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1000>";
	dbg_object(t_c).m_xadvance=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1001>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1002>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1003>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1004>";
	dbg_object(t_c).m_height=9;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1005>";
	dbg_object(t_c).m_x=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1006>";
	dbg_object(t_c).m_y=64;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1007>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1008>";
	dbg_object(t_c).m_name="z";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1009>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1010>";
	dbg_object(t_c).m_ascnum=122;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1011>";
	dbg_object(t_c).m_xadvance=6;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1012>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1013>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1014>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1015>";
	dbg_object(t_c).m_height=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1016>";
	dbg_object(t_c).m_x=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1017>";
	dbg_object(t_c).m_y=64;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1018>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1019>";
	dbg_object(t_c).m_name="{";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1020>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1021>";
	dbg_object(t_c).m_ascnum=123;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1022>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1023>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1024>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1025>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1026>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1027>";
	dbg_object(t_c).m_x=14;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1028>";
	dbg_object(t_c).m_y=62;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1029>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1030>";
	dbg_object(t_c).m_name="|";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1031>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1032>";
	dbg_object(t_c).m_ascnum=124;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1033>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1034>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1035>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1036>";
	dbg_object(t_c).m_width=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1037>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1038>";
	dbg_object(t_c).m_x=19;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1039>";
	dbg_object(t_c).m_y=62;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1040>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1041>";
	dbg_object(t_c).m_name="}";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1042>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1043>";
	dbg_object(t_c).m_ascnum=125;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1044>";
	dbg_object(t_c).m_xadvance=3;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1045>";
	dbg_object(t_c).m_yoffset=2;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1046>";
	dbg_object(t_c).m_xoffset=-1;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1047>";
	dbg_object(t_c).m_width=5;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1048>";
	dbg_object(t_c).m_height=11;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1049>";
	dbg_object(t_c).m_x=23;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1050>";
	dbg_object(t_c).m_y=62;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1051>";
	t_c=c_Char.m_new.call(new c_Char);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1052>";
	dbg_object(t_c).m_name="~";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1053>";
	this.m_charmap.p_Set(dbg_object(t_c).m_name,t_c);
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1054>";
	dbg_object(t_c).m_ascnum=126;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1055>";
	dbg_object(t_c).m_xadvance=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1056>";
	dbg_object(t_c).m_yoffset=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1057>";
	dbg_object(t_c).m_xoffset=0;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1058>";
	dbg_object(t_c).m_width=7;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1059>";
	dbg_object(t_c).m_height=4;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1060>";
	dbg_object(t_c).m_x=28;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1061>";
	dbg_object(t_c).m_y=64;
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1062>";
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1062>";
	var t_=this.m_charmap.p_Values().p_ObjectEnumerator();
	err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1062>";
	while(t_.p_HasNext()){
		err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1062>";
		var t_de=(t_.p_NextObject());
		err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1063>";
		var t_d=object_downcast((t_de),c_Char);
		err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1064>";
		if(dbg_object(t_d).m_name!=" "){
			err_info="/root/Dropbox/Monkey/modules/keef/arialclass/arialclass.monkey<1065>";
			dbg_object(t_d).m_img=dbg_object(this).m_img.p_GrabImage(dbg_object(t_d).m_x,dbg_object(t_d).m_y,dbg_object(t_d).m_width,dbg_object(t_d).m_height,1,c_Image.m_DefaultFlags);
		}
	}
	pop_err();
	return this;
}
var bb_spriter_small_font=null;
var bb_spriter_red_img=null;
var bb_spriter_green_img=null;
var bb_spriter_blue_img=null;
var bb_spriter_cyan_img=null;
var bb_spriter_magenta_img=null;
var bb_spriter_yellow_img=null;
var bb_spriter_white_img=null;
var bb_spriter_black_img=null;
function c_List3(){
	Object.call(this);
	this.m__head=(c_HeadNode3.m_new.call(new c_HeadNode3));
}
c_List3.m_new=function(){
	push_err();
	pop_err();
	return this;
}
c_List3.prototype.p_AddLast2=function(t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<126>";
	var t_=c_Node4.m_new.call(new c_Node4,this.m__head,dbg_object(this.m__head).m__pred,t_data);
	pop_err();
	return t_;
}
c_List3.m_new2=function(t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	var t_=t_data;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	var t_2=0;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
	while(t_2<t_.length){
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
		var t_t=dbg_array(t_,t_2)[dbg_index];
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<13>";
		t_2=t_2+1;
		err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<14>";
		this.p_AddLast2(t_t);
	}
	pop_err();
	return this;
}
function c_Node4(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data=null;
}
c_Node4.m_new=function(t_succ,t_pred,t_data){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<243>";
	this.m__succ=t_succ;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<244>";
	this.m__pred=t_pred;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<245>";
	dbg_object(this.m__succ).m__pred=this;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<246>";
	dbg_object(this.m__pred).m__succ=this;
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<247>";
	this.m__data=t_data;
	pop_err();
	return this;
}
c_Node4.m_new2=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<240>";
	pop_err();
	return this;
}
function c_HeadNode3(){
	c_Node4.call(this);
}
c_HeadNode3.prototype=extend_class(c_Node4);
c_HeadNode3.m_new=function(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<292>";
	c_Node4.m_new2.call(this);
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<293>";
	this.m__succ=(this);
	err_info="/root/Dropbox/Monkey/modules/monkey/list.monkey<294>";
	this.m__pred=(this);
	pop_err();
	return this;
}
var bb_customgui_current_screen=null;
var bb_customgui_previous_screen=null;
function bb_customgui_change_state(t_s){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<20>";
	if(bb_customgui_current_screen!=null){
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<21>";
		bb_customgui_current_screen.p_hide();
		err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<22>";
		bb_customgui_previous_screen=bb_customgui_current_screen;
	}
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<24>";
	t_s.p_show();
	err_info="/root/Dropbox/Monkey/modules/keef/customgui/customgui.monkey<25>";
	bb_customgui_current_screen=t_s;
	pop_err();
}
function bb_spriter_bin2int(t_this){
	push_err();
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<20>";
	var t_arr=t_this.split(",");
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<21>";
	var t_thisint=0;
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<22>";
	for(var t_x=0;t_x<=7;t_x=t_x+1){
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<23>";
		var t_str=dbg_array(t_arr,t_x)[dbg_index];
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<24>";
		if(t_x==0 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<25>";
			t_thisint=t_thisint+128;
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<27>";
		if(t_x==1 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<28>";
			t_thisint=t_thisint+64;
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<30>";
		if(t_x==2 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<31>";
			t_thisint=t_thisint+32;
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<33>";
		if(t_x==3 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<34>";
			t_thisint=t_thisint+16;
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<36>";
		if(t_x==4 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<37>";
			t_thisint=t_thisint+8;
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<39>";
		if(t_x==5 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<40>";
			t_thisint=t_thisint+4;
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<42>";
		if(t_x==6 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<43>";
			t_thisint=t_thisint+2;
		}
		err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<45>";
		if(t_x==7 && t_str=="1"){
			err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<46>";
			t_thisint=t_thisint+1;
		}
	}
	err_info="/root/Dropbox/monkeygames/spriter/spriter.monkey<50>";
	pop_err();
	return t_thisint;
}
var bb_spriter_current_bright=0;
function bb_input_GetChar(){
	push_err();
	err_info="/root/Dropbox/Monkey/modules/mojo/input.monkey<44>";
	var t_=bb_input_device.p_GetChar();
	pop_err();
	return t_;
}
function bbInit(){
	bb_app__app=null;
	bb_app__delegate=null;
	bb_app__game=BBGame.Game();
	bb_spriter_spr=null;
	bb_graphics_device=null;
	bb_graphics_context=c_GraphicsContext.m_new.call(new c_GraphicsContext);
	c_Image.m_DefaultFlags=0;
	bb_audio_device=null;
	bb_input_device=null;
	bb_graphics_renderDevice=null;
	bb_customgui_time=0;
	bb_customgui_mouse_hit1=false;
	bb_customgui_mouse_hit2=false;
	bb_customgui_mouse_down1=false;
	bb_customgui_mouse_down2=false;
	c_VirtualDisplay.m_Display=null;
	bb_customgui_mouse_x=0;
	bb_customgui_mouse_y=0;
	bb_spriter_sp=null;
	bb_spriter_current_ink=0;
	bb_spriter_current_paper=0;
	c_gui_element.m_clicked=false;
	c_gui_element.m_highlighted_any=false;
	c_gui_element.m_highlighted_element=null;
	c_gui_element.m_list=null;
	c_gui_class.m_gui_pointer=null;
	c_button.m_img=null;
	c_button.m_img2=null;
	bb_customgui_arrow_size=25;
	c_toggle_button.m_img=null;
	c_toggle_button.m_img2=null;
	bb_app__updateRate=0;
	bb_spriter_medium_font=null;
	bb_spriter_small_font=null;
	bb_spriter_red_img=null;
	bb_spriter_green_img=null;
	bb_spriter_blue_img=null;
	bb_spriter_cyan_img=null;
	bb_spriter_magenta_img=null;
	bb_spriter_yellow_img=null;
	bb_spriter_white_img=null;
	bb_spriter_black_img=null;
	c_screen.m_list=null;
	bb_customgui_current_screen=null;
	bb_customgui_previous_screen=null;
	bb_spriter_current_bright=0;
}
//${TRANSCODE_END}
