#DEFINE GENOMELENGTH 95
#DEFINE TOTALALIENS 64

#DEFINE DHP 0
#DEFINE DSPEED 1
#DEFINE DSTRENGTH 2
#DEFINE DARMOUR 3
#DEFINE DACCURACY 4
#DEFINE DDEFENCE 5
#DEFINE DDEFENSE 5
#DEFINE DCOUNTER 6
#DEFINE DCOLOUR 7
#DEFINE DCOLOR 7
#DEFINE DGRAPHIC 8

#DEFINE SCORE 0
#DEFINE GENOMEPOINTER 1

#include "64X32Print.bas"

DECLARE FUNCTION FASTCALL time() AS ULONG

DIM alien(TOTALALIENS,GENOMELENGTH) as uByte  ' 64 aliens at 96 byte genome

DIM alienRankings (TOTALALIENS,1) as uInteger
    REM point these at different genomes.
    FOR i=0 to TOTALALIENS
        alienRankings(i,GENOMEPOINTER)=i
    NEXT i


DIM tempAlien(GENOMELENGTH) as uByte
DIM tempStats(8) as uByte
DIM myAlienStats(8) as uByte
DIM myAlienHP, enemyAlienHP as uInteger
DIM alienGenerationsCount (TOTALALIENS) as uByte

DIM genome (15,1) as uByte => _
{_
{0,1},_    '+1 (+10 eventually) to HP 
{1,1},_    '+1 to Speed 
{2,1},_    '+1 to Strength
{3,1},_    '+1 to Armour
{4,1},_    '+1 To Accuracy
{5,1},_    '+1 To Defence
{254,1},_  'x1 (useless)
{254,2},_  'x2
{254,3},_  'x3
{254,4},_  'x4
{254,5},_  'x5
{254,0},_  'x0 (potentially damaging)
{255,0},_  'Extend Genome by 0 (useless)
{255,1},_  'Extend Genome by 1 
{255,2},_  'Extend Genome by 2 
{255,0}_   'Extend Genome by 0 (useless)
}

DIM statNames (5) as string
statNames(0)="HP"
statNames(1)="Speed"
statNames(2)="Strength"
statNames(3)="Armour"
statNames(4)="Accuracy"
statNames(5)="Defence"

SUB initializeGraphics ()
POKE UINTEGER 23675, @graphics
RETURN

graphics:
ASM
;TopLeft
DEFB	048,	104,	072,	073,	057,	006,	052,	072
DEFB	060,	070,	067,	067,	064,	076,	076,	064
DEFB	000,	000,	000,	001,	002,	020,	041,	065
DEFB	000,	064,	032,	023,	024,	048,	066,	064

;TopRight
DEFB	012,	022,	018,	146,	156,	096,	044,	018
DEFB	028,	098,	194,	194,	002,	050,	050,	002
DEFB	000,	000,	000,	128,	064,	040,	148,	130
DEFB	000,	002,	004,	232,	024,	012,	066,	002

;BottomLeft
DEFB	064,	064,	032,	016,	008,	007,	012,	024
DEFB	064,	064,	084,	074,	064,	081,	106,	068
DEFB	067,	065,	064,	072,	084,	035,	034,	102
DEFB	064,	064,	132,	131,	128,	135,	072,	048

;BottomRight
DEFB	002,	002,	004,	008,	016,	224,	048,	024
DEFB	002,	002,	042,	082,	002,	138,	086,	034
DEFB	194,	130,	002,	018,	042,	196,	068,	102
DEFB	002,	002,	033,	193,	001,	225,	018,	012

END ASM

END SUB

SUB printGraphic (n as uByte)
    print chr$(144+n);
END SUB

SUB printAlien (alien as uByte, row as uByte, column as uByte, inkCol as uByte)
    DIM oldColour as uByte
    oldColour=PEEK 23693
    
    ink inkCol
        print at row,column;
        printGraphic (i BAND 3)
        printGraphic (((i >> 2)BAND 3)+4)
        print at row+1,column;
        printGraphic (((i >> 4)BAND 3)+8)
        printGraphic (((i >> 6)BAND 3)+12)
        
    ink oldColour
END SUB
    
FUNCTION FASTCALL time() AS ULONG
ASM
    DI
    LD DE,(23674)
    LD D,0
    LD HL,(23672)
    EI
END ASM
END FUNCTION

FUNCTION FASTCALL randomBase () AS UBYTE
ASM
   random: 
   ld  hl,$A280       ; xz -> yw
   ld  de,$C0DE       ; yw -> zt
   ld  (random+1),de   ; x = y, z = w
   ld  a,e             ; w = w ^ ( w << 3 )
   add a,a
   add a,a
   add a,a
   XOR e
   ld  e,a
   ld  a,h             ; t = x ^ (x << 1)
   add a,a
   XOR h
   ld  d,a
   rra                 ; t = t ^ (t >> 1) ^ w
   XOR d
   XOR e
   ld  h,l             ; y = z
   ld  l,a             ; w = t
   ld  (random+4),hl
   ;ret (NOT necessary, since the compiler will add ret TO the END)
END ASM
END FUNCTION

SUB FASTCALL updateSeed()
REM Updates the random generator seed from the FRAMES system variable.
time()
ASM
   LD A,E
   EX DE,HL
   LD HL,random+2
   XOR (HL)
   AND A
   JR NZ,updateSeedNotZero
   INC A
   updateSeedNotZero:
   LD (HL),A
 
   LD HL,random+4
   LD A,E
   XOR (HL)
   LD (HL),A
   INC HL
   LD A,D
   XOR (HL)
   LD (HL),A
END ASM
 
END SUB

FUNCTION FASTCALL randomLimit(limit AS UBYTE) AS UBYTE
ASM
 
    AND A
    RET Z ; Input zero, output zero.
    LD B,A ; SAVE A
 
    LD C,255
    randomBinLoop:
    RLA
    JR C, randomBinLoopExit
    RR C
    JR randomBinLoop ; LOOP back UNTIL we find a bit.
    randomBinLoopExit:
 
    randomBinRedoCall:
    call random
    AND C
    CP B
    RET Z
    JR NC, randomBinRedoCall
 
END ASM
END FUNCTION


SUB generateAlien(alienNum as uByte)
    DIM i,genome as uByte
    genome=alienRankings(alienNum,GENOMEPOINTER)
    FOR i=0 to GENOMELENGTH
        alien(genome,i)=randomBase()
    NEXT i
    alienRankings(alienNum,SCORE)=0
END SUB

SUB generateAllAliens()
    DIM i as uByte
    
    FOR i=0 to TOTALALIENS -1
        generateAlien(i)
    NEXT i
END SUB

SUB breedAlien(me as uByte, BreedWith as uByte)
DIM i,j,left,right as uByte

FOR i=0 to GENOMELENGTH
    j=randomBase()
    IF j<115 then left=( alien(alienRankings(me,GENOMEPOINTER),i) BAND 240)
        ELSEIF j < 230 then left=( alien(alienRankings(BreedWith,GENOMEPOINTER),i) BAND 240)
    ELSE left = ( randomBase() BAND 240) 
    END IF
    
    j=randomBase()
    IF j<115 then right=( alien(alienRankings(me,GENOMEPOINTER),i) BAND 15)
        ELSEIF j < 230 then right=( alien(alienRankings(BreedWith,GENOMEPOINTER),i) BAND 15)
    ELSE right = ( randomBase() BAND 15) 
    END IF
    tempAlien(i)=( left BOR right )
NEXT i
END SUB

FUNCTION max(num1 as uInteger, num2 as uInteger) as uinteger
IF num1 > num2 then 
    return num1
ELSE 
    return num2
END IF
END FUNCTION

FUNCTION DEC2HEX(num as uByte) as string
dim left,right as uByte

left=(( num BAND 240 ) >>4 )
right=( num BAND 15 ) 

left=left+48
IF left>57 then left=left+7
END IF

right=right+48
IF right>57 then right=right+7
END IF

return chr$(left)+chr$(right)

END FUNCTION



SUB evaluateAlien(alienNum as uByte)
    dim i,left,right,multiplier as uByte
    dim count as integer


    dim expressedGenome as uLong=16

    'Clear out the temporary alien store.
    for i=0 to 5
        tempStats(i)=6
    next i


    for count=0 to 15
        left=(( alien(alienRankings(alienNum,GENOMEPOINTER),i) BAND 240 ) >>4 )
        right=( alien(alienRankings(alienNum,GENOMEPOINTER),i) BAND 15 ) 
        
        tempStats(8)=tempStats(8) BXOR ( alien (alienRankings (alienNum,GENOMEPOINTER) ,i) )
        
        IF genome(left,0)=255 then 
            expressedGenome = expressedGenome + genome (left,1)
            count=count-genome (left,1)
            count=count-genome (left,1)        
        END IF
    
        IF genome(right,0)=255 then expressedGenome = expressedGenome + genome (right,1)
            expressedGenome = expressedGenome + genome (right,1)
            count=count-genome (right,1)
            count=count-genome (right,1)        
        END IF
        i=i+1

        IF i=GENOMELENGTH then exit for
        END IF
    
    NEXT count
    'PAUSE 0

    IF expressedGenome > GENOMELENGTH then expressedGenome=GENOMELENGTH
    END IF
    
    tempStats(7)=expressedGenome / ((GENOMELENGTH - 15) / 8) -1
     
    'print "Expressed=";expressedGenome

    multiplier=1    
    for i=0 to (CAST (uByte,(expressedGenome-1)/2) ) 
        left=(( alien(alienRankings(alienNum,GENOMEPOINTER),i) BAND 240 ) >>4 )
        right=( alien(alienRankings(alienNum,GENOMEPOINTER),i) BAND 15 ) 
    
        'poke 22528+i, (peek (22528+i))+128
    
        'print at 10,0;"Gene ";i*2+1; " of ";expressedGenome;" [";left;"] ";
        IF genome(left,0) < 200 then 
            tempStats(genome(left,0))=tempStats(genome(left,0))+ (genome(left,1) * multiplier )
            'print statNames(genome(left,0));"+";multiplier;"               "            
            multiplier=1
        ELSEIF genome(left,0)=254 then 
            multiplier = genome (left,1)
            'print "mult=";multiplier;"               "
        
        ELSE
            multiplier=1
            'print "N/A";"               "
        END IF
    
        'poke 22528+i*2, (peek (22528+i*2))-64
    
        'printStats(12,0)
        'pause 0
    
        'poke 22528+i*2+1, (peek (22528+i*2+1))+128
        'print at 10,0;"Gene ";i*2+2; " of ";expressedGenome;" [";right;"] ";
        IF genome(right,0) < 200 then 
            tempStats(genome(right,0))=tempStats(genome(right,0))+ (genome(right,1) * multiplier )
            'print statNames(genome(right,0));"+";multiplier;"               "
            multiplier=1
       
        ELSEIF genome(right,0)=254 then 
            multiplier = genome (right,1)
            'print "mult=";multiplier;"               "
        ELSE
            multiplier=1
            'print "N/A";"               "
        END IF
        
        'poke 22528+i*2+1, (peek (22528+i*2+1))-64
        'pause 0
        'printStats(12,0)
    NEXT i
     
END SUB

FUNCTION rankAlien() as uByte
    'reference:
    '#DEFINE DHP 0
    '#DEFINE DSPEED 1
    '#DEFINE DSTRENGTH 2
    '#DEFINE DARMOUR 3
    '#DEFINE DACCURACY 4
    '#DEFINE DDEFENCE 5
    '#DEFINE DDEFENSE 5
    '#DEFINE DCOUNTER 6
    
    dim i as uByte
    dim rank as uInteger
    
    for i=0 to 5
    rank=rank+tempStats(i)
    next i
    
    return rank>>3
END FUNCTION


SUB printStats(y as uByte,x as uByte)
    dim i as ubyte =0
    print at y,x;statNames(i);" ";tempStats(i)*10
    for i=1 to 5
        print at y+i,x;statNames(i);" ";tempStats(i)
    next i
    print at y+6,x;"Rank:";rankAlien()
END SUB

SUB outputGenome(alienNum)
    for i=0 to GENOMELENGTH
        print DEC2HEX(alien(alienRankings(alienNum,GENOMEPOINTER),i));
    next i
END SUB

FUNCTION FASTCALL fastTimesTen(a as uInteger) as uInteger
asm
ADD HL,HL
LD E,L
LD D,H
ADD HL,HL
ADD HL,HL
ADD HL,DE 
end asm
end function

FUNCTION fightAliens (firstAlien as uByte, secondAlien as uByte)
' Arrange a fight between two aliens, return winner.
    DIM tempAlienStatBlocks (1,6) as Integer
    DIM i, maxSpeed as uByte
    DIM attackStrength as uByte

    ' Get stats on the two aliens:
    evaluateAlien(firstAlien)
    'printStats(16,0)
    tempAlienStatBlocks(0,DHP)=fastTimesTen(tempStats(DHP))
    for i=1 to 5
        tempAlienStatBlocks(0,i)=tempStats(i)
    next i

    evaluateAlien(secondAlien)
    'printStats(16,15)
    tempAlienStatBlocks(1,DHP)=fastTimesTen(tempStats(DHP))
    for i=1 to 5
        tempAlienStatBlocks(1,i)=tempStats(i)
    next i

    ' And now we fight!
    'To remind me:
    'statNames(0)="HP"
    'statNames(1)="Speed"
    'statNames(2)="Strength"
    'statNames(3)="Armour"
    'statNames(4)="Accuracy"
    'statNames(5)="Defence"
    '  6= current count
    '  7=Graphics
    
    maxSpeed=max( tempAlienStatBlocks(0,DSPEED), tempAlienStatBlocks(1,DSPEED) )

while tempAlienStatBlocks(0,DHP) > 0 AND tempAlienStatBlocks(1,DHP) > 0 
    FOR i=0 to 1 ' Once round to check for an attack each way.
        IF tempAlienStatBlocks(i,DCOUNTER) < tempAlienStatBlocks(i,DSPEED) then
            ' It's time to attack!
            IF ( randomBase() BAND 63 ) + tempAlienStatBlocks(i,DACCURACY) > tempAlienStatBlocks(1-i,DDEFENCE) then
                ' We hit!
                IF tempAlienStatBlocks(1-i,DARMOUR) > tempAlienStatBlocks(i,DSTRENGTH) then
                    attackStrength=1
                ELSE
                    attackStrength=tempAlienStatBlocks(i,DSTRENGTH) - tempAlienStatBlocks(1-i,DARMOUR)
                END IF
                'print at 23,0;i;" ";attackStrength
                tempAlienStatBlocks(1-i,DHP)=tempAlienStatBlocks(1-i,DHP)-attackStrength
                'print at 2,3+(15*(1-i));tempAlienStatBlocks(1-i,0);"   "
            END IF 
        'tempAlienStatBlocks(i,DCOUNTER) = 0
        'EXIT FOR        
        END IF
    NEXT i
    
    'PRINT AT 9,0;"Count ";tempAlienStatBlocks(0,DCOUNTER),"Count ";tempAlienStatBlocks(1,DCOUNTER);" "
    tempAlienStatBlocks(0,DCOUNTER) = tempAlienStatBlocks(0,DCOUNTER) - tempAlienStatBlocks(0,DSPEED) ' count=count-speed
    
    IF tempAlienStatBlocks(0,DCOUNTER) < 0 then tempAlienStatBlocks(0,DCOUNTER) = tempAlienStatBlocks(0,DCOUNTER) + maxSpeed
    END IF
    
    tempAlienStatBlocks(1,DCOUNTER) = tempAlienStatBlocks(1,DCOUNTER) - tempAlienStatBlocks(1,DSPEED) ' count=count-speed
    IF tempAlienStatBlocks(1,DCOUNTER) < 0 then tempAlienStatBlocks(1,DCOUNTER) = tempAlienStatBlocks(1,DCOUNTER) + maxSpeed
    END IF
    
    'PRINT AT 10,0;"Count ";tempAlienStatBlocks(0,DCOUNTER),"Count ";tempAlienStatBlocks(1,DCOUNTER);" "
end while
    'print tempAlienStatBlocks(0,0)    
    'print tempAlienStatBlocks(0,0)>0
    'print tempAlienStatBlocks(1,0)    
    'print tempAlienStatBlocks(1,0)>0
     
    return (tempAlienStatBlocks(0,0)>0) '; returns a true value for firstAlienwin, false for second.  
END FUNCTION

SUB fightAllAliensExceptPlayer()
DIM i as uByte
for i=0 to TOTALALIENS -1 step 2
    print at 0,10;"ROUND ";i/2
    print at 21,17,"-"
    'evaluateAlien(i)
    'printStats(2,0)
    
    'evaluateAlien(i+1)
    'printStats(2,15)
    'Print "Fight between "; i; " and ";i+1
    
    IF fightAliens(i,i+1) then 
'        print at 12,5;"WIN","LOSE"
        print at 21,16;1
        alienRankings(i,SCORE)=alienRankings(i,SCORE)+1
    ELSE
'        print at 12,5;"LOSE","WIN"
        print at 21,16;2
        alienRankings(i+1,SCORE)=alienRankings(i+1,SCORE)+1
    END IF
    print at 21,17,"+"
NEXT i
END SUB

SUB sortAliens()
DIM i,j as uByte
DIM swappedFlag as uByte
DIM tempScore as uInteger
'DIM tempAllele  as uByte
 
sortAliensStartLoop:
DO
swappedFlag=0
    FOR i=0 to TOTALALIENS -2
    poke 16384,i
        IF alienRankings(i,SCORE) < alienRankings (i+1,SCORE) then
            tempScore=alienRankings(i,SCORE)
            'for j=0 to GENOMELENGTH
            '    tempAllele=alien(i,j)
            '    alien(i,j)=alien(i+1,j)
            '    alien(i+1,j)=tempAllele
            'next j
            alienRankings(i,SCORE)=alienRankings(i+1,SCORE)
            alienRankings(i+1,SCORE)=tempScore
            
            tempScore=alienRankings(i,GENOMEPOINTER)
            alienRankings(i,GENOMEPOINTER)=alienRankings(i+1,GENOMEPOINTER)
            alienRankings(i+1,GENOMEPOINTER)=tempScore
            
            swappedFlag=swappedFlag+1
        END IF
    NEXT i
    print at 10,10;swappedFlag;"  "
LOOP WHILE swappedFlag              
END SUB

REM Start:
CLS
Print"Generating initial Aliens"
generateAllAliens()
Print "Done Doing first pass for fight."

REM main loop:

initializeGraphics ()

print time()/50.0
fightAllAliensExceptPlayer()
print "END:";time()/50.0
print time()/50.0
sortAliens()
print time()/50.0
Print "Done"
print time()/50.0
sortAliens()
print time()/50.0

DIM loopCountValue as uLong

DO
CLS

print loopCountValue
loopCountValue=loopCountValue+1
print
for i = 0 to 6
    print "Alien ";i
    evaluateAlien(i)
    print "(";tempStats(7);",";rankAlien();")";
next i
print at 23,0;"Anykey": pause 0
print at 15,0;"Regenerating lowest ranked aliens"
for i = 56 to 63
    generateAlien(i)
    print at 23,0;63-i;" "
next i
print at 23,0;"        "
print at 16,0;"Done. Now fighting all aliens"
fightAllAliensExceptPlayer()
print at 17,0;"Fight done. Sorting Aliens"
sortAliens()
print at 18,0;"Sort Done: Press a key"

LOOP
