
;==============================================================
; WLA-DX banking setup
;==============================================================
.memorymap
	defaultslot     0
	; rom area
	slotsize        $4000
	slot            0       $0000
	slot            1       $4000
	slot            2       $8000
	; ram area
	slotsize        $2000
	slot            3       $C000
	slot            4       $E000
.endme

.rombankmap
	bankstotal 2
	banksize $4000
	banks 2
.endro

;==============================================================
; SDSC tag and SMS rom header
;==============================================================
.sdsctag 0.0,"ZX Basic program","Generated by zxb2wla 0.04 alpha","guest"
.smstag


.include "../lib/wla/boot.inc"


;==============================================================
; Includes
;==============================================================
.include "../lib/wla/Useful functions.inc"
.include "../lib/wla/BBC Micro font.inc"
.include "../lib/wla/sprite.inc"
.include "../lib/wla/resource.inc"



.section "ZX Basic code" free
zb__START_PROGRAM:
    	jp zb__LABEL__end01
zb__LABEL__patterns:
zb__LABEL__typeface:
;#line 4
		.db 000h,000h,000h,000h,000h,000h,000h,000h
		.db 018h,03ch,03ch,018h,018h,000h,018h,000h
		.db 036h,036h,036h,000h,000h,000h,000h,000h
		.db 036h,036h,07fh,036h,07fh,036h,036h,000h
		.db 018h,03eh,060h,03ch,006h,07ch,018h,000h
		.db 000h,063h,066h,00ch,018h,033h,063h,000h
		.db 01ch,036h,01ch,03bh,06eh,066h,03bh,000h
		.db 00ch,00ch,018h,000h,000h,000h,000h,000h
		.db 00ch,018h,030h,030h,030h,018h,00ch,000h
		.db 030h,018h,00ch,00ch,00ch,018h,030h,000h
		.db 000h,066h,03ch,0ffh,03ch,066h,000h,000h
		.db 000h,018h,018h,07eh,018h,018h,000h,000h
		.db 000h,000h,000h,000h,018h,008h,010h,000h
		.db 000h,000h,000h,07eh,000h,000h,000h,000h
		.db 000h,000h,000h,000h,000h,018h,018h,000h
		.db 003h,006h,00ch,018h,030h,060h,0c0h,000h
		.db 01ch,026h,063h,063h,063h,032h,01ch,000h
		.db 00ch,01ch,00ch,00ch,00ch,00ch,03fh,000h
		.db 03eh,063h,007h,01eh,03ch,070h,07fh,000h
		.db 03fh,006h,00ch,01eh,003h,063h,03eh,000h
		.db 00eh,01eh,036h,066h,07fh,006h,006h,000h
		.db 07eh,060h,07eh,003h,003h,063h,03eh,000h
		.db 01ch,030h,060h,07eh,063h,063h,03eh,000h
		.db 07fh,063h,006h,00ch,018h,018h,018h,000h
		.db 03ch,062h,072h,03ch,04fh,043h,03eh,000h
		.db 03eh,063h,063h,03fh,003h,006h,03ch,000h
		.db 000h,000h,018h,018h,000h,018h,018h,000h
		.db 000h,018h,018h,000h,038h,018h,030h,000h
		.db 00ch,018h,030h,060h,030h,018h,00ch,000h
		.db 000h,000h,07eh,000h,07eh,000h,000h,000h
		.db 030h,018h,00ch,006h,00ch,018h,030h,000h
		.db 07ch,0c6h,006h,01ch,030h,000h,030h,000h
		.db 03eh,063h,06fh,06fh,06fh,060h,03ch,000h
		.db 01ch,036h,063h,063h,07fh,063h,063h,000h
		.db 07eh,063h,063h,07eh,063h,063h,07eh,000h
		.db 01eh,033h,060h,060h,060h,033h,01eh,000h
		.db 07ch,066h,063h,063h,063h,066h,07ch,000h
		.db 03fh,030h,030h,03eh,030h,030h,03fh,000h
		.db 07fh,060h,060h,07eh,060h,060h,060h,000h
		.db 01fh,030h,060h,067h,063h,033h,01fh,000h
		.db 063h,063h,063h,07fh,063h,063h,063h,000h
		.db 03fh,00ch,00ch,00ch,00ch,00ch,03fh,000h
		.db 003h,003h,003h,003h,003h,063h,03eh,000h
		.db 063h,066h,06ch,078h,07ch,06eh,067h,000h
		.db 030h,030h,030h,030h,030h,030h,03fh,000h
		.db 063h,077h,07fh,07fh,06bh,063h,063h,000h
		.db 063h,073h,07bh,07fh,06fh,067h,063h,000h
		.db 03eh,063h,063h,063h,063h,063h,03eh,000h
		.db 07eh,063h,063h,063h,07eh,060h,060h,000h
		.db 03eh,063h,063h,063h,06fh,066h,03dh,000h
		.db 07eh,063h,063h,067h,07ch,06eh,067h,000h
		.db 03ch,066h,060h,03eh,003h,063h,03eh,000h
		.db 03fh,00ch,00ch,00ch,00ch,00ch,00ch,000h
		.db 063h,063h,063h,063h,063h,063h,03eh,000h
		.db 063h,063h,063h,077h,03eh,01ch,008h,000h
		.db 063h,063h,06bh,07fh,07fh,077h,063h,000h
		.db 063h,077h,03eh,01ch,03eh,077h,063h,000h
		.db 033h,033h,033h,01eh,00ch,00ch,00ch,000h
		.db 07fh,007h,00eh,01ch,038h,070h,07fh,000h
		.db 000h,000h,000h,03ch,03ch,000h,000h,000h
		.db 000h,000h,000h,07fh,07fh,000h,000h,000h
		.db 000h,000h,000h,000h,000h,018h,018h,000h
		.db 018h,03ch,03ch,018h,018h,000h,018h,000h
		.db 03ch,042h,09dh,0a1h,0a1h,09dh,042h,03ch
		.db 030h,018h,00ch,000h,000h,000h,000h,000h
		.db 01ch,036h,063h,063h,07fh,063h,063h,000h
		.db 07eh,063h,063h,07eh,063h,063h,07eh,000h
		.db 01eh,033h,060h,060h,060h,033h,01eh,000h
		.db 07ch,066h,063h,063h,063h,066h,07ch,000h
		.db 03fh,030h,030h,03eh,030h,030h,03fh,000h
		.db 07fh,060h,060h,07eh,060h,060h,060h,000h
		.db 01fh,030h,060h,067h,063h,033h,01fh,000h
		.db 063h,063h,063h,07fh,063h,063h,063h,000h
		.db 03fh,00ch,00ch,00ch,00ch,00ch,03fh,000h
		.db 003h,003h,003h,003h,003h,063h,03eh,000h
		.db 063h,066h,06ch,078h,07ch,06eh,067h,000h
		.db 030h,030h,030h,030h,030h,030h,03fh,000h
		.db 063h,077h,07fh,07fh,06bh,063h,063h,000h
		.db 063h,073h,07bh,07fh,06fh,067h,063h,000h
		.db 03eh,063h,063h,063h,063h,063h,03eh,000h
		.db 07eh,063h,063h,063h,07eh,060h,060h,000h
		.db 03eh,063h,063h,063h,06fh,066h,03dh,000h
		.db 07eh,063h,063h,067h,07ch,06eh,067h,000h
		.db 03ch,066h,060h,03eh,003h,063h,03eh,000h
		.db 03fh,00ch,00ch,00ch,00ch,00ch,00ch,000h
		.db 063h,063h,063h,063h,063h,063h,03eh,000h
		.db 063h,063h,063h,077h,03eh,01ch,008h,000h
		.db 063h,063h,06bh,07fh,07fh,077h,063h,000h
		.db 063h,077h,03eh,01ch,03eh,077h,063h,000h
		.db 033h,033h,033h,01eh,00ch,00ch,00ch,000h
		.db 07fh,007h,00eh,01ch,038h,070h,07fh,000h
		.db 000h,000h,000h,03ch,03ch,000h,000h,000h
		.db 000h,000h,000h,07fh,07fh,000h,000h,000h
		.db 000h,000h,000h,000h,000h,018h,018h,000h
		.db 018h,03ch,03ch,018h,018h,000h,018h,000h
		.db 03ch,042h,09dh,0a1h,0a1h,09dh,042h,03ch
;#line 100
zb__LABEL__end01:
	ld hl, 16383
	push hl
	xor a
	push af
	ld hl, 0
	push hl
	call zb_smsfilvrm
	jp zb__LABEL__text1end
zb__LABEL__text1:
;#line 23
		.db "Lorem ipsum dolor sit amet"
;#line 24
zb__LABEL__text1end:
	ld a, 32
	push af
	xor a
	push af
	call zb_smsvdp
	ld a, 66
	push af
	ld a, 1
	push af
	call zb_smsvdp
	ld a, 4
	push af
	ld a, 6
	push af
	call zb_smsvdp
	ld a, 4
	push af
	ld a, 7
	push af
	call zb_smsvdp
	ld hl, 768
	push hl
	ld hl, 1024
	push hl
	ld hl, zb__LABEL__typeface
	push hl
	call zb_smsldirmvx4
	xor a
	push af
	ld a, 46
	push af
	call zb_smscls
	ld hl, 1365
	call zb_smsfromhexcolourasm
	push af
	ld hl, 0
	push hl
	call zb_smssetpalette
	ld hl, 1370
	call zb_smsfromhexcolourasm
	push af
	ld hl, 1
	push hl
	call zb_smssetpalette
	ld hl, 2645
	call zb_smsfromhexcolourasm
	push af
	ld hl, 2
	push hl
	call zb_smssetpalette
	ld hl, 2650
	call zb_smsfromhexcolourasm
	push af
	ld hl, 3
	push hl
	call zb_smssetpalette
	ld hl, 1445
	call zb_smsfromhexcolourasm
	push af
	ld hl, 4
	push hl
	call zb_smssetpalette
	ld hl, 1450
	call zb_smsfromhexcolourasm
	push af
	ld hl, 5
	push hl
	call zb_smssetpalette
	ld hl, 2725
	call zb_smsfromhexcolourasm
	push af
	ld hl, 6
	push hl
	call zb_smssetpalette
	ld hl, 2730
	call zb_smsfromhexcolourasm
	push af
	ld hl, 7
	push hl
	call zb_smssetpalette
	ld hl, 0
	call zb_smsfromhexcolourasm
	push af
	ld hl, 8
	push hl
	call zb_smssetpalette
	ld hl, 15
	call zb_smsfromhexcolourasm
	push af
	ld hl, 9
	push hl
	call zb_smssetpalette
	ld hl, 3840
	call zb_smsfromhexcolourasm
	push af
	ld hl, 10
	push hl
	call zb_smssetpalette
	ld hl, 3855
	call zb_smsfromhexcolourasm
	push af
	ld hl, 11
	push hl
	call zb_smssetpalette
	ld hl, 240
	call zb_smsfromhexcolourasm
	push af
	ld hl, 12
	push hl
	call zb_smssetpalette
	ld hl, 255
	call zb_smsfromhexcolourasm
	push af
	ld hl, 13
	push hl
	call zb_smssetpalette
	ld hl, 4080
	call zb_smsfromhexcolourasm
	push af
	ld hl, 14
	push hl
	call zb_smssetpalette
	ld hl, 4095
	call zb_smsfromhexcolourasm
	push af
	ld hl, 15
	push hl
	call zb_smssetpalette
	ld hl, 5
	call zb_smsfromhexcolourasm
	push af
	ld hl, 16
	push hl
	call zb_smssetpalette
	ld hl, 10
	call zb_smsfromhexcolourasm
	push af
	ld hl, 17
	push hl
	call zb_smssetpalette
	ld hl, 2560
	call zb_smsfromhexcolourasm
	push af
	ld hl, 18
	push hl
	call zb_smssetpalette
	ld hl, 2570
	call zb_smsfromhexcolourasm
	push af
	ld hl, 19
	push hl
	call zb_smssetpalette
	ld hl, 160
	call zb_smsfromhexcolourasm
	push af
	ld hl, 20
	push hl
	call zb_smssetpalette
	ld hl, 170
	call zb_smsfromhexcolourasm
	push af
	ld hl, 21
	push hl
	call zb_smssetpalette
	ld hl, 2720
	call zb_smsfromhexcolourasm
	push af
	ld hl, 22
	push hl
	call zb_smssetpalette
	ld hl, 2735
	call zb_smsfromhexcolourasm
	push af
	ld hl, 23
	push hl
	call zb_smssetpalette
	ld hl, 1360
	call zb_smsfromhexcolourasm
	push af
	ld hl, 24
	push hl
	call zb_smssetpalette
	ld hl, 1375
	call zb_smsfromhexcolourasm
	push af
	ld hl, 25
	push hl
	call zb_smssetpalette
	ld hl, 3925
	call zb_smsfromhexcolourasm
	push af
	ld hl, 26
	push hl
	call zb_smssetpalette
	ld hl, 3935
	call zb_smsfromhexcolourasm
	push af
	ld hl, 27
	push hl
	call zb_smssetpalette
	ld hl, 1525
	call zb_smsfromhexcolourasm
	push af
	ld hl, 28
	push hl
	call zb_smssetpalette
	ld hl, 1535
	call zb_smsfromhexcolourasm
	push af
	ld hl, 29
	push hl
	call zb_smssetpalette
	ld hl, 4085
	call zb_smsfromhexcolourasm
	push af
	ld hl, 30
	push hl
	call zb_smssetpalette
	ld hl, 4090
	call zb_smsfromhexcolourasm
	push af
	ld hl, 31
	push hl
	call zb_smssetpalette
	ld hl, 1362
	call zb_smsfromhexcolourasm
	push af
	ld hl, 0
	push hl
	call zb_smssetpalette
	ld a, 136
	push af
	ld hl, 8191
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8195
	push hl
	call zb_smsvpoke
	ld a, 136
	push af
	ld hl, 8199
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8203
	push hl
	call zb_smsvpoke
	ld a, 136
	push af
	ld hl, 8207
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8211
	push hl
	call zb_smsvpoke
	ld a, 136
	push af
	ld hl, 8215
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8219
	push hl
	call zb_smsvpoke
	ld a, 136
	push af
	ld hl, 8223
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8227
	push hl
	call zb_smsvpoke
	ld a, 136
	push af
	ld hl, 8231
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8235
	push hl
	call zb_smsvpoke
	ld a, 136
	push af
	ld hl, 8239
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8243
	push hl
	call zb_smsvpoke
	ld a, 136
	push af
	ld hl, 8247
	push hl
	call zb_smsvpoke
	ld a, 34
	push af
	ld hl, 8251
	push hl
	call zb_smsvpoke
	ld a, 65
	push af
	ld hl, 47344
	push hl
	call zb_smsvpoke
	ld a, 66
	push af
	ld hl, 47346
	push hl
	call zb_smsvpoke
	ld a, 85
	push af
	ld hl, 2115
	push hl
	call zb_smsvpoke
	ld a, 51
	push af
	ld hl, 2116
	push hl
	call zb_smsvpoke
	ld a, 15
	push af
	ld hl, 2117
	push hl
	call zb_smsvpoke
	xor a
	push af
	ld hl, 2118
	push hl
	call zb_smsvpoke
	ld a, 85
	push af
	ld hl, 2119
	push hl
	call zb_smsvpoke
	ld a, 51
	push af
	ld hl, 2120
	push hl
	call zb_smsvpoke
	ld a, 15
	push af
	ld hl, 2121
	push hl
	call zb_smsvpoke
	ld a, 255
	push af
	ld hl, 2122
	push hl
	call zb_smsvpoke
	ld hl, 0
	ld (zb_x), hl
	jp zb__LABEL0
zb__LABEL4:
	ld hl, (zb_x)
	ld a, l
	push af
	ld hl, (zb_x)
	add hl, hl
	ld de, 47104
	add hl, de
	push hl
	call zb_smsvpoke
	xor a
	call zb_ScrollY
	xor a
	call zb_ScrollX
	call zb_smswaitvbl
zb__LABEL5:
	ld hl, (zb_x)
	inc hl
	ld (zb_x), hl
zb__LABEL0:
	ld hl, 255
	ld de, (zb_x)
	or a
	sbc hl, de
	jp nc, zb__LABEL4
zb__LABEL3:
	ld hl, 0
	ld (zb_x), hl
	jp zb__LABEL6
zb__LABEL10:
	ld de, zb__LABEL__text1
	ld hl, (zb_x)
	add hl, de
	ld b, h
	ld c, l
	ld a, (bc)
	push af
	ld hl, (zb_x)
	add hl, hl
	ld de, 47510
	add hl, de
	push hl
	call zb_smsvpoke
zb__LABEL11:
	ld hl, (zb_x)
	inc hl
	ld (zb_x), hl
zb__LABEL6:
	ld hl, 25
	ld de, (zb_x)
	or a
	sbc hl, de
	jp nc, zb__LABEL10
zb__LABEL9:
	ld a, 63
	push af
	ld hl, 47104
	push hl
	call zb_smsvpoke
	ld a, 128
	ld (zb_pxsp), a
	ld a, 96
	ld (zb_pysp), a
	ld hl, 0
	ld (zb_x), hl
zb__LABEL12:
	ld hl, (zb_x)
	inc hl
	ld (zb_x), hl
	ld hl, 191
	ld de, (zb_x)
	or a
	sbc hl, de
	jp nc, zb__LABEL15
	ld hl, 0
	ld (zb_x), hl
zb__LABEL15:
	call zb_ReadJoypad1
	ld (zb_jp1), a
	call zb_ReadJoypad2
	ld (zb_jp2), a
	ld hl, (zb_jp2 - 1)
	ld a, (zb_jp1)
	or h
	ld (zb_jpo), a
	xor a
	push af
	ld hl, (zb_x)
	inc hl
	inc hl
	ld a, l
	push af
	ld hl, (zb_x)
	ld a, l
	push af
	xor a
	call zb_smsputsprite
	xor a
	push af
	ld hl, (zb_x)
	inc hl
	inc hl
	ld a, l
	push af
	ld hl, (zb_x)
	ld de, 8
	add hl, de
	ld a, l
	push af
	ld a, 1
	call zb_smsputsprite
	xor a
	push af
	ld hl, (zb_x)
	inc hl
	inc hl
	ld a, l
	push af
	ld hl, (zb_x)
	ld de, 24
	add hl, de
	ld a, l
	push af
	ld a, 2
	call zb_smsputsprite
	xor a
	push af
	ld hl, (zb_x)
	inc hl
	inc hl
	ld a, l
	push af
	ld hl, (zb_x)
	ld de, 32
	add hl, de
	ld a, l
	push af
	ld a, 3
	call zb_smsputsprite
	xor a
	push af
	ld hl, (zb_x)
	inc hl
	inc hl
	ld a, l
	push af
	ld hl, (zb_x)
	ld de, 48
	add hl, de
	ld a, l
	push af
	ld a, 4
	call zb_smsputsprite
	xor a
	push af
	ld hl, (zb_x)
	inc hl
	inc hl
	ld a, l
	push af
	ld hl, (zb_x)
	ld de, 56
	add hl, de
	ld a, l
	push af
	ld a, 5
	call zb_smsputsprite
	xor a
	push af
	ld a, (zb_pysp)
	push af
	ld a, (zb_pxsp)
	push af
	ld a, 9
	call zb_smsputsprite
	xor a
	push af
	ld a, (zb_pysp)
	push af
	ld a, (zb_pxsp)
	add a, 8
	push af
	ld a, 10
	call zb_smsputsprite
	ld a, (zb_jp1)
	add a, 32
	push af
	ld hl, 47348
	push hl
	call zb_smsvpoke
	ld a, (zb_jp2)
	add a, 32
	push af
	ld hl, 47350
	push hl
	call zb_smsvpoke
	ld h, 1
	ld a, (zb_jpo)
	and h
	ld h, a
	ld a, (zb_pysp)
	sub h
	ld (zb_pysp), a
	ld h, 2
	ld a, (zb_jpo)
	and h
	srl a
	ld h, a
	ld a, (zb_pysp)
	add a, h
	ld (zb_pysp), a
	ld h, 4
	ld a, (zb_jpo)
	and h
	ld h, 4
	call zb__DIVU8_FAST
	ld h, a
	ld a, (zb_pxsp)
	sub h
	ld (zb_pxsp), a
	ld h, 8
	ld a, (zb_jpo)
	and h
	ld h, 8
	call zb__DIVU8_FAST
	ld h, a
	ld a, (zb_pxsp)
	add a, h
	ld (zb_pxsp), a
	call zb_smswaitvbl
	ld a, (zb_pxsp)
	call zb_ScrollX
	ld a, (zb_pysp)
	call zb_ScrollY
	call zb_smsupdatesprites
	jp zb__LABEL12
zb__LABEL13:
zb_smswaitvbl:
;#line 3
		jp WaitForVBlankNoInt
;#line 4
zb_smswaitvbl__leave:
	ret
zb_smsupdatesprites:
;#line 3
		jp UpdateSprites
;#line 4
zb_smsupdatesprites__leave:
	ret
zb_smsputsprite:
;#line 3
		exx
		pop hl
		exx
		ld d,0
		ld e,a
		pop bc
		ld hl,hw_sprites_y
		add hl, de
		pop af
		ld (hl),a
		ld hl,hw_sprites_xc
		add hl,de
		add hl,de
		ld (hl),b
		inc hl
		pop af
		ld (hl),a
		exx
		push hl
		exx
;#line 23
zb_smsputsprite__leave:
	ret
zb_Random:
;#line 7
		ld	hl, (zb_randomSeed)
		ld	d, h
		ld	e, l
		ld	a, d
		ld	h, e
		ld	l, 253
		or	a
		sbc	hl, de
		sbc	a, 0
		sbc	hl, de
		ld	d, 0
		sbc	a, d
		ld	e, a
		sbc	hl, de
		jr	nc, Random_2
		inc	hl
Random_2:
		ld	 (zb_randomSeed), hl
		ret
;#line 26
zb_Random__leave:
	ret
zb_smsvdp:
	push ix
	ld ix, 0
	add ix, sp
	ld a, (ix+7)
	ld bc, 191
	out (c), a
	ld a, (ix+5)
	push af
	ld h, 15
	pop af
	and h
	ld h, a
	ld a, 128
	or h
	ld bc, 191
	out (c), a
zb_smsvdp__leave:
	ld sp, ix
	pop ix
	exx
	pop hl
	pop bc
	ex (sp), hl
	exx
	ret
zb_smsfilvrm:
	push ix
	ld ix, 0
	add ix, sp
	ld hl, 0
	push hl
	ld l, (ix+4)
	ld h, (ix+5)
	push hl
	ld de, 255
	pop hl
	call zb__BAND16
	ld a, l
	ld bc, 191
	out (c), a
	ld l, (ix+4)
	ld h, (ix+5)
	ld de, 256
	call zb__DIVU16
	ld de, 0
	ld a, l
	ld bc, 191
	out (c), a
	ld (ix-2), 0
	ld (ix-1), 0
	jp zb__LABEL16
zb__LABEL20:
	ld a, (ix+7)
	ld bc, 190
	out (c), a
zb__LABEL21:
	ld l, (ix-2)
	ld h, (ix-1)
	inc hl
	ld (ix-2), l
	ld (ix-1), h
zb__LABEL16:
	ld l, (ix-2)
	ld h, (ix-1)
	push hl
	ld l, (ix+8)
	ld h, (ix+9)
	dec hl
	pop de
	or a
	sbc hl, de
	jp nc, zb__LABEL20
zb__LABEL19:
zb_smsfilvrm__leave:
	ld sp, ix
	pop ix
	exx
	pop hl
	pop bc
	pop bc
	ex (sp), hl
	exx
	ret
zb_smsvpoke:
	push ix
	ld ix, 0
	add ix, sp
	ld l, (ix+4)
	ld h, (ix+5)
	push hl
	ld de, 255
	pop hl
	call zb__BAND16
	ld a, l
	ld bc, 191
	out (c), a
	ld l, (ix+4)
	ld h, (ix+5)
	ld de, 256
	call zb__DIVU16
	ld de, 0
	ld a, l
	ld bc, 191
	out (c), a
	ld a, (ix+7)
	ld bc, 190
	out (c), a
zb_smsvpoke__leave:
	ld sp, ix
	pop ix
	exx
	pop hl
	pop bc
	ex (sp), hl
	exx
	ret
zb_smscls:
	push ix
	ld ix, 0
	add ix, sp
	ld hl, 0
	push hl
	ld a, 0
	ld bc, 191
	out (c), a
	ld a, 184
	ld bc, 191
	out (c), a
	ld (ix-2), 0
	ld (ix-1), 0
	jp zb__LABEL22
zb__LABEL26:
	ld a, (ix+5)
	ld bc, 190
	out (c), a
	ld a, (ix+7)
	ld bc, 190
	out (c), a
zb__LABEL27:
	ld l, (ix-2)
	ld h, (ix-1)
	inc hl
	ld (ix-2), l
	ld (ix-1), h
zb__LABEL22:
	ld l, (ix-2)
	ld h, (ix-1)
	push hl
	ld hl, 895
	pop de
	or a
	sbc hl, de
	jp nc, zb__LABEL26
zb__LABEL25:
zb_smscls__leave:
	ld sp, ix
	pop ix
	exx
	pop hl
	pop bc
	ex (sp), hl
	exx
	ret
zb_smssetpalette:
	push ix
	ld ix, 0
	add ix, sp
	ld hl, 0
	push hl
	ld l, (ix+4)
	ld h, (ix+5)
	push hl
	ld de, 31
	pop hl
	call zb__BAND16
	ld de, 49152
	add hl, de
	ld (ix-2), l
	ld (ix-1), h
	ld l, (ix-2)
	ld h, (ix-1)
	push hl
	ld de, 255
	pop hl
	call zb__BAND16
	ld a, l
	ld bc, 191
	out (c), a
	ld l, (ix-2)
	ld h, (ix-1)
	ld de, 256
	call zb__DIVU16
	ld de, 0
	ld a, l
	ld bc, 191
	out (c), a
	ld a, (ix+7)
	ld bc, 190
	out (c), a
zb_smssetpalette__leave:
	ld sp, ix
	pop ix
	exx
	pop hl
	pop bc
	ex (sp), hl
	exx
	ret
zb_smsldirmvx4:
	push ix
	ld ix, 0
	add ix, sp
	ld l, (ix+6)
	ld h, (ix+7)
	dec hl
	push hl
	ld de, 255
	pop hl
	call zb__BAND16
	ld a, l
	ld bc, 191
	out (c), a
	ld l, (ix+6)
	ld h, (ix+7)
	dec hl
	ld de, 256
	call zb__DIVU16
	ld de, 0
	ld a, l
	ld bc, 191
	out (c), a
	ld l, (ix+4)
	ld h, (ix+5)
	ld (zb_tmpr), hl
	jp zb__LABEL28
zb__LABEL32:
	ld bc, (zb_tmpr)
	ld a, (bc)
	ld bc, 190
	out (c), a
	ld bc, (zb_tmpr)
	ld a, (bc)
	ld bc, 190
	out (c), a
	ld bc, (zb_tmpr)
	ld a, (bc)
	ld bc, 190
	out (c), a
	ld bc, (zb_tmpr)
	ld a, (bc)
	ld bc, 190
	out (c), a
zb__LABEL33:
	ld hl, (zb_tmpr)
	inc hl
	ld (zb_tmpr), hl
zb__LABEL28:
	ld l, (ix+4)
	ld h, (ix+5)
	push hl
	ld l, (ix+8)
	ld h, (ix+9)
	ex de, hl
	pop hl
	add hl, de
	dec hl
	ld de, (zb_tmpr)
	or a
	sbc hl, de
	jp nc, zb__LABEL32
zb__LABEL31:
zb_smsldirmvx4__leave:
	ld sp, ix
	pop ix
	exx
	pop hl
	pop bc
	pop bc
	ex (sp), hl
	exx
	ret
zb_ScrollY:
;#line 2
		out ($bf),a
		ld a,$89
		out ($bf),a
;#line 5
zb_ScrollY__leave:
	ret
zb_ScrollX:
;#line 10
		out ($bf),a
		ld a,$88
		out ($bf),a
;#line 13
zb_ScrollX__leave:
	ret
zb_ScrollXY:
;#line 18
		out ($bf),a
		ld a,$88
		out ($bf),a
		pop af
		out ($bf),a
		ld a,$89
		out ($bf),a
;#line 25
zb_ScrollXY__leave:
	ret
zb_ReadJoypad1:
;#line 2
		in	a, ($dc)
		cpl
;#line 4
zb_ReadJoypad1__leave:
	ret
zb_ReadJoypad2:
;#line 9
		in	a, ($dc)
		cpl
		rla
		rla
		rla
		and	$03
		ld	l, a
		in	a, ($dd)
		cpl
		add	a, a
		add	a, a
		or	l
;#line 21
zb_ReadJoypad2__leave:
	ret
zb_smsfromhexcolourasm:
;#line 2
		ld d,l
		ld a,12
		and h
		ld h,a
		ld a,192
		and l
		ld l,a
		ld a,12
		and d
		ld d,a
		rr h
		rr h
		rr l
		rr l
		rr l
		rr l
		rl d
		rl d
		ld a,h
		or l
		or d
;#line 23
zb_smsfromhexcolourasm__leave:
	ret
;#line 1 "div8.asm"
				; --------------------------------
zb__DIVU8:	; 8 bit unsigned integer division
				; Divides (Top of stack, High Byte) / A
		pop hl	; --------------------------------
		ex (sp), hl	; CALLEE

zb__DIVU8_FAST:	; Does A / H
		ld l, h
		ld h, a		; At this point do H / L

		ld b, 8
		xor a		; A = 0, Carry Flag = 0

zb__DIV8LOOP:
		sla	h
		rla
		cp	l
		jr	c, zb__DIV8NOSUB
		sub	l
		inc	h

zb__DIV8NOSUB:
		djnz zb__DIV8LOOP

		ld	l, a		; save remainder
		ld	a, h		;

		ret			; a = Quotient,


					; --------------------------------
zb__DIVI8:		; 8 bit signed integer division Divides (Top of stack) / A
		pop hl		; --------------------------------
		ex (sp), hl

zb__DIVI8_FAST:
		ld e, a		; store operands for later
		ld c, h

		or a		; negative?
		jp p, zb__DIV8A
		neg			; Make it positive

zb__DIV8A:
		ex af, af'
		ld a, h
		or a
		jp p, zb__DIV8B
		neg
		ld h, a		; make it positive

zb__DIV8B:
		ex af, af'

		call zb__DIVU8_FAST

		ld a, c
		xor l		; bit 7 of A = 1 if result is negative

		ld a, h		; Quotient
		ret p		; return if positive

		neg
		ret


zb__MODU8:		; 8 bit module. REturns A mod (Top of stack) (unsigned operands)
		pop hl
		ex (sp), hl	; CALLEE

zb__MODU8_FAST:	; zb__FASTCALL__ entry
		call zb__DIVU8_FAST
		ld a, l		; Remainder

		ret		; a = Modulus


zb__MODI8:		; 8 bit module. REturns A mod (Top of stack) (For singed operands)
		pop hl
		ex (sp), hl	; CALLEE

zb__MODI8_FAST:	; zb__FASTCALL__ entry
		call zb__DIVI8_FAST
		ld a, l		; remainder

		ret		; a = Modulus

;#line 1154 "test6.zxb"
;#line 1 "div16.asm"
	; 16 bit division and modulo functions
	; for both signed and unsigned values

;#line 1 "neg16.asm"
	; Negates HL value (16 bit)
zb__ABS16:
		bit 7, h
		ret z

zb__NEGHL:
		ld a, l			; HL = -HL
		cpl
		ld l, a
		ld a, h
		cpl
		ld h, a
		inc hl
		ret

;#line 5 "div16.asm"

zb__DIVU16:    ; 16 bit unsigned division
	             ; HL = Dividend, Stack Top = Divisor

		;   -- OBSOLETE ; Now uses FASTCALL convention
		;   ex de, hl
	    ;	pop hl      ; Return address
	    ;	ex (sp), hl ; CALLEE Convention

zb__DIVU16_FAST:
	    ld a, h
	    ld c, l
	    ld hl, 0
	    ld b, 16

zb__DIV16LOOP:
	    sll c
	    rla
	    adc hl,hl
	    sbc hl,de
	    jr  nc, zb__DIV16NOADD
	    add hl,de
	    dec c

zb__DIV16NOADD:
	    djnz zb__DIV16LOOP

	    ex de, hl
	    ld h, a
	    ld l, c

	    ret     ; HL = quotient, DE = Mudulus



zb__MODU16:    ; 16 bit modulus
	             ; HL = Dividend, Stack Top = Divisor

	    ;ex de, hl
	    ;pop hl
	    ;ex (sp), hl ; CALLEE Convention

	    call zb__DIVU16_FAST
	    ex de, hl	; hl = reminder (modulus)
					; de = quotient

	    ret


zb__DIVI16:	; 16 bit signed division
		;	--- The following is OBSOLETE ---
		;	ex de, hl
		;	pop hl
		;	ex (sp), hl 	; CALLEE Convention

zb__DIVI16_FAST:
		ld a, d
		xor h
		ex af, af'		; BIT 7 of a contains result

		bit 7, d		; DE is negative?
		jr z, zb__DIVI16A

		ld a, e			; DE = -DE
		cpl
		ld e, a
		ld a, d
		cpl
		ld d, a
		inc de

zb__DIVI16A:
		bit 7, h		; HL is negative?
		call nz, zb__NEGHL

zb__DIVI16B:
		call zb__DIVU16_FAST
		ex af, af'

		or a
		ret p	; return if positive
	    jp zb__NEGHL


zb__MODI16:    ; 16 bit modulus
	             ; HL = Dividend, Stack Top = Divisor

	    ;ex de, hl
	    ;pop hl
	    ;ex (sp), hl ; CALLEE Convention

	    call zb__DIVI16_FAST
	    ex de, hl	; hl = reminder (modulus)
					; de = quotient

	    ret

;#line 1155 "test6.zxb"
;#line 1 "band16.asm"
; vim:ts=4:et:
	; FASTCALL bitwise and16 version.
	; result in hl
; zb__FASTCALL__ version (operands: A, H)
	; Performs 16bit or 16bit and returns the boolean
; Input: HL, DE
; Output: HL <- HL AND DE

zb__BAND16:
		ld a, h
		and d
	    ld h, a

	    ld a, l
	    and e
	    ld l, a

	    ret

;#line 1156 "test6.zxb"
;#line 1 "and8.asm"
	; FASTCALL boolean and 8 version.
	; result in Accumulator (0 False, not 0 True)
; zb__FASTCALL__ version (operands: A, H)
	; Performs 8bit and 8bit and returns the boolean

zb__AND8:
		or a
		ret z
		ld a, h
		ret

;#line 1157 "test6.zxb"

    ret
.ends

.section "ZXB variable init values" free
ZXBASIC_USER_DATA_VALUES:
    ; zb_randomSeed
	.db 00, 00
; zb_pxsp
	.db 00
; zb_jpo
	.db 00
; zb_pysp
	.db 00
; zb_jp1
	.db 00
; zb_jp2
	.db 00
; zb_tmpr
	.db 00, 00
; zb_smcp1
	.db 00
; zb_x
	.db 00, 00    
ZXBASIC_USER_DATA_VALUES_END:
.ends


.ramsection "ZXBasic Variables" slot 3
ZXBASIC_USER_DATA ds 0
    	zb_randomSeed ds 2
	zb_pxsp ds 1
	zb_jpo ds 1
	zb_pysp ds 1
	zb_jp1 ds 1
	zb_jp2 ds 1
	zb_tmpr ds 2
	zb_smcp1 ds 1
	zb_x ds 2
ZXBASIC_USER_DATA_END ds 0    
.ends




