' Locs
' (c) 2022/25 Reveni Baltasar MIT License <baltasarq@gmail.com>


#pragma once


const NUM_LOCS                         as ubyte = 17

const EXIT_NORTH                       as ubyte = 0
const EXIT_SOUTH                       as ubyte = 1
const EXIT_EAST                        as ubyte = 2
const EXIT_WEST                        as ubyte = 3
const EXIT_UP                          as ubyte = 4
const EXIT_DOWN                        as ubyte = 5
const NUM_EXITS                        as ubyte = 6


dim EXIT_NAMES(5) as string
EXIT_NAMES(0) = "norte"
EXIT_NAMES(1) = "sur"
EXIT_NAMES(2) = "este"
EXIT_NAMES(3) = "oeste"
EXIT_NAMES(4) = "arriba"
EXIT_NAMES(5) = "abajo"

dim current_loc    as ubyte = 1

dim loc_descs(NUM_LOCS - 1)            as string
dim loc_exits(NUM_LOCS, NUM_EXITS - 1) as integer


sub init_locs()
    restore LocData
    
    for i = 0 to NUM_LOCS - 1
        ' Read the desc
        read loc_descs( i )
                
        ' Read the exits
        for j = 0 to NUM_EXITS - 1
            read loc_exits(i, j)
        next
    next
end sub


LocData:
    ' Loc 0 - Limbo - where objects live when are not still born,
    '                 and rest after dying.'
    data "The limbo, where objects play lingo"
    '    n  s  e  w  u  d
    data 0, 0, 0, 0, 0, 0
     
    ' Loc 1 - Landing
    data "El lugar del alunizaje. La vaina abierta y sin " _
            + "contenido parece una triste parodia de ella misma. " _
            + "Un valle natural conduce al sur."
    '    n  s  e  w  u  d
    data 0, 2, 0, 0, 0, 0
    
    ' Loc 2 - Valley
    data "El lugar del alunizaje. La vaina abierta y sin  " _
            + "contenido parece una triste parodia de ella misma. " _
            + "Un valle natural conduce al sur."
    '    n  s  e  w  u  d
    data 1, 0, 0, 0, 0, 0

    ' Loc 3 - Spires valley
    data "Un estrecho valle se extiende de norte a sur, " _
            + "aunque dos llamativas agujas impiden el paso " _
            + "hacia el sur."
    '    n  s  e  w  u  d
    data 2, 0, 0, 0, 0, 0
    
    ' Loc 4 - Amonia lake west side
    data "El extremo de un reducido pero impracticable lago de " _
             + "amoniaco se extiende hacia el este. Se puede ir " _
             + "hacia el sur."
    '    n  s  e  w  u  d
    data 0, 8, 0, 0, 0, 0

    ' Loc 5 - Amonia lake east side
    data "Un lago de amoníaco se extiende hacia el oeste. " _
            + "Es posible volver al oeste por encima " _
            + "de la aguja."
    '    n  s  e  w  u  d
    data 0, 0, 0, 2, 0, 0
    
    ' Loc 6 - North-east valley: first cryo-geiser
    data "Un valle sigue de norte a este. " _
            + "Ves un raro agujero en el suelo hacia el sur, " _
            + "notando un gran aumento de temperatura " _
            + "a medida que te acercas."
    '    n  s  e  w  u  d
    data 2, 0, 6, 0, 0, 0
    
    ' Loc 7 - West-south valley (hill to the east)
    data "Un llano permite avanzar de oeste a sur. " _
            + "Hacia el este puedes ver una colina."
    '    n  s  e  w  u  d
    data 0, 12, 0, 5, 0, 0

    ' Loc 8 - Canyon to the north
    data "Un desfiladero se extiende hacia el norte. La " _
             + "pared oeste es una colina practicable, " _
             + "mientras que al este ves una pared rocosa. La " _
             + "luz se reduce mucho por zonas en este lugar " _
             + "casi cavernoso."
    '    n  s  e  w  u  d
    data 7, 0, 0, 6, 0, 0

    ' Loc 9 - Cave entry
    data "El desfiladero termina en una pared al norte, " _
             + "en la que se abre la entrada de una gruta. Es " _
             + "posible volver al sur."
    '    n  s  e  w  u  d
    data 15, 7, 0, 0, 0, 0

    ' Loc 10 - North-east plain
    data "Una zona llana entre grandes rocas permite " _
             + "moverse de norte a este."
    '    n  s  e  w  u  d
    data 3, 0, 10, 0, 0, 0
    
    ' Loc 11 - North-south plain
    data "Una llanura se extiende de este a oeste, "_
             + "con elevaciones al norte y sur."
    '    n  s  e  w  u  d
    data 0, 0, 10, 9, 0, 0
    
    ' Loc 12 - Cryo-geiser, south side
    data "Un zona baja alberga un agujero al norte y " _
            + "sendas colinas pedregosas al este y al oeste. " _
            + "Te das cuenta de que el agujero no es sino " _
            + "el geiser que encontraste antes: te has " _
            + "desplazado hacia el sur del mismo dando un " _
            + "amplio rodeo."
    '    n  s   e   w  u  d
    data 0, 0, 15, 10, 0, 0

    ' Loc 13 - Under the arc
    data "Esta zona es realmente extraordinaria; un " _
            + "arco por encima de tu cabeza, inalcanzable, " _
            + "une dos paredes al este y oeste, mientras " _
            + "solo puedes moverte de norte a sur por un " _
            + "paso abovedado."
    '    n   s  e  w  u  d
    data 6, 14, 0, 0, 0, 0

    ' Loc 14 - North-west valley
    data "Un suave valle con dos salidas, al norte y " _
            + "al oeste, se extiende por delante. El suelo " _
            + "pedregoso da paso en este punto a suave " _
            + "tierra arenosa."
    '    n   s  e   w  u  d
    data 7,  0, 0, 15, 0, 0
    
    ' Loc 15 - Crest over the crack
    data "El paisaje se vuelve pedregoso en derredor de " _
            + "forma que solo se puede ir al norte. " _
            + "Una cresta se asoma sobre una grieta que se " _
            + "se extiende de este a oeste hasta donde " _
            + "alcanza la vista."
    '    n   s  e   w  u  d
    data 7,  0, 0,  0, 0, 0

    ' Loc 16 - Over the arc
    data "Un arco a tu altura se extiende de este a " _
            + "oeste, mientras puedes ver un pasaje " _
            + "norte a sur por debajo."
    '    n   s   e   w  u  d
    data 0,  0, 12, 11, 0, 0
