' IO
' (c) 2022/25 Reveni Baltasar MIT License <baltasarq@gmail.com>


#pragma once


#include <string.bas>
#include <print64.bas>

#include "util.bas"


const COLOR_BLACK             as ubyte = 0
const COLOR_BLUE              as ubyte = 1
const COLOR_RED               as ubyte = 2
const COLOR_MAGENTA           as ubyte = 3
const COLOR_GREEN             as ubyte = 4
const COLOR_CYAN              as ubyte = 5
const COLOR_YELLOW            as ubyte = 6
const COLOR_WHITE             as ubyte = 7
const SCR_FIRST_LINE_TEXT     as ubyte = 8
const SCR_FIRST_LINE_ANSWER   as ubyte = 14
const SCR_FIRST_LINE_CMDS     as ubyte = 20
const SCR_MAX_LINES           as ubyte = 23
const SCR_FIRST_LINE_CMD_OBJS as ubyte = 21
const SCR_MAX_COLS            as ubyte = 64
dim CR                        as string = chr(13)

const PROMPT_WAIT as string = "<...>"


sub clrscr()
    border 0
    set_colors( COLOR_WHITE, COLOR_BLACK )
    cls 
end sub


sub set_colors(i as ubyte, p as ubyte)
    paper p
    ink i
end sub


sub set_default_colors()
    ink COLOR_WHITE
end sub


sub set_highlighted_colors()
    ink COLOR_CYAN
end sub


function read_key() as string
    ' Wait for a key
    dim toret as string = inkey()

    while toret = ""
        toret = inkey()
    end while
    
    ' Wait for no key pressed
    while inkey() <> ""
    end while
    
    return toret
end function


' Reads a key for a commands in the game
function read_cmd_key() as string
	dim toret as string = lcase( read_key() )

	while not( isletter( toret ) )
		toret = lcase( read_key() )
	end while

	return toret
end function


sub wait_for_key()
    cprint( PROMPT_WAIT )
    pause 0
end sub


sub clear_cmds_answer()
    ' Prepare suitable string
    dim cleaner as string = "  "
    
    while len( cleaner ) < SCR_MAX_COLS
        cleaner = cleaner + cleaner 
    end while

    ' Sweep screen
    for i = SCR_FIRST_LINE_ANSWER to SCR_MAX_LINES
        cprint( cleaner )
    next
end sub


sub print_word_marked_initial(word as string)
    inverse( 1 )
    cprint( word( 0 ) )
    inverse( 0 )
    cprint( word( 1 to ) )
end sub


sub print_marked_initial_objs_ids_in_vector(words() as ubyte)
    set_highlighted_colors()
    cursor_to( SCR_FIRST_LINE_CMD_OBJS, 0 )
    
    for i = 0 to ubound(words) - 1
        print_word_marked_initial( obj_id( i ) )
        cprint( " " )
    next
end sub


sub cursor_to(row as ubyte, col as ubyte)
    printat64( row, col )
end sub


sub cprint(s as string)
    print64( s )
end sub


sub lf()
    cprint( CR )
end sub


sub println(t as string)
    dim num_chs as uinteger = len( t )
    dim pos as uinteger = SCR_MAX_COLS - 1
    dim base_pos as uinteger = 0
    
    while( pos < num_chs )
        while( pos > 2 _
            and t( pos ) <> " "  )
            pos = pos - 1
        end while

        cprint( t( base_pos to pos - 1 ) )
        lf()
        base_pos = pos + 1
        pos = pos + ( SCR_MAX_COLS - 1 )
    end while
    
    cprint( t( base_pos to ) )
    lf()
end sub


' Shows a message to the user
' It waits for a key afterwards.
sub show(msg as string)
    cursor_to( SCR_FIRST_LINE_ANSWER, 0 )
    println( msg )
    wait_for_key()
end sub
