' Cmds
' (c) 2022/25 Reveni Baltasar MIT License <baltasarq@gmail.com>


#pragma once


#include "io.bas"
#include "locs.bas"
#include "objs.bas"


' Cmds
const CMD_NOP         as ubyte =  0
const CMD_NORTH       as ubyte =  1
const CMD_SOUTH       as ubyte =  2
const CMD_EAST        as ubyte =  3
const CMD_WEST        as ubyte =  4
const CMD_UP          as ubyte =  5
const CMD_DOWN        as ubyte =  6
const CMD_END         as ubyte =  7
const CMD_INVENTORY   as ubyte =  8
const CMD_EXAMINE     as ubyte =  9 
const CMD_EXITS       as ubyte = 10
const CMD_TAKE        as ubyte = 11 
const CMD_DROP        as ubyte = 12
const CMD_WEAR        as ubyte = 13
const CMD_DISROBE     as ubyte = 14
const CMD_WAIT        as ubyte = 15
const CMD_BREAK       as ubyte = 16
const CMD_PUSH        as ubyte = 17
const CMD_PULL        as ubyte = 18
const CMD_LOOK_AROUND as ubyte = 19
const NUM_CMDS        as ubyte = 20


declare function ask_yes_no(msg as string) as ubyte


' Fixed answers
const MSG_CANT_DO          as string = "No puedes hacer eso."
const MSG_IMPOSSIBLE       as string = "No tiene sentido."
const MSG_ALREADY_CARRIED  as string = "Ya lo estás llevando."
const MSG_NOT_CARRIED      as string = "No lo llevas contigo."
const MSG_DONE             as string = "Hecho."
const MSG_CANT_SEE         as string = "No puedo ver eso."
const MSG_SPECIFY_CLOTHING as string = "No es una prenda."
const MSG_ALREADY_DONE     as string = "Ya estaba hecho."


' Values after parsing
dim obj1 as ubyte
dim cmd as ubyte


' Actions
sub do_cmd_nop()
    show( MSG_CANT_DO )
end sub


sub do_cmd_go(cmd as ubyte)
    dim dest_loc as ubyte = loc_exits( current_loc, cmd )

	if dest_loc < NUM_LOCS
		current_loc = dest_loc
		do_loc_desc()
	else
		show( "No se puede tomar ese rumbo." )
	end if
end sub


sub do_cmd_end()
    if ask_yes_no( "Confirma que deseas terminar (s/n): " )
        clrscr()
        new
    else
        lf()
    end if
end sub


sub do_cmd_inventory()
    dim num as ubyte = 0
	dim i as ubyte = 0

	println( "Llevas contigo: " )
	num = list_objs_in( NUM_LOC_PLAYER )

	if num = 0
		println( "Nada." )
	end if

	lf()
    show( "" )
end sub


sub do_cmd_examine()
    dim msg as string = "No ves eso en derredor. " _
                        + "O no te parece importante."

	if obj1 > 0 _
    and ( obj_loc( obj1 ) = NUM_LOC_PLAYER _
	   or current_loc = obj_loc( obj1 ) )
		msg = obj_desc( obj1 )
	end if

	show( msg )
end sub


sub do_cmd_exits()
    dim exists_exist as ubyte = 0    

    cprint( "Salidas visibles: " )
    for i = 0 TO NUM_EXITS - 1
        if loc_exits( current_loc, i ) < NUM_LOCS
          exists_exist = 1
          cprint( EXIT_NAMES( i ) )
          cprint( " " )
        end if
    next

    if not( exists_exist )
        cprint( "ninguna." )
    end if

    lf()
    show( "" )
end sub


sub do_cmd_take()
	dim msg as string = MSG_CANT_SEE

	if obj1 > 0
		if obj_loc( obj1 ) = current_loc
			if obj_atr( obj1 ) <> OBJ_ATR_STATIC
				msg = MSG_DONE
				obj_loc( obj1 ) = NUM_LOC_PLAYER
				do_loc_desc()      
                cursor_to( SCR_FIRST_LINE_ANSWER, 0 )
                set_highlighted_colors()
			else
				msg = MSG_IMPOSSIBLE
			end if
		elseif obj_loc( obj1 ) = NUM_LOC_PLAYER
			msg = MSG_ALREADY_CARRIED
		end if
	end if

	show( msg )
end sub


sub do_cmd_drop()
    dim msg as string = MSG_NOT_CARRIED

	if obj1 > 0
		if obj_loc( obj1 ) = NUM_LOC_PLAYER
            if not( obj_worn( obj1 ) )
    			msg = MSG_DONE
    			obj_loc( obj1 ) = current_loc
    			do_loc_desc()
                cursor_to( SCR_FIRST_LINE_ANSWER, 0 )
                set_highlighted_colors()
            else
                msg = "No puedes, lo llevas puesto."
            end if
		end if
	end if

	show( msg )
end sub


sub do_cmd_wear()
    dim msg as string
    
	if  obj1 > 0 _
    and obj_atr( obj1 ) = OBJ_ATR_CLOTHING
		if obj_loc( obj1 ) = NUM_LOC_PLAYER
			if not( obj_worn( obj1 ) )
				msg = MSG_DONE
				obj_worn( obj1 ) = 1
			else
				msg = MSG_ALREADY_DONE
			end if
		else
			msg = MSG_NOT_CARRIED
		end if
	else
		msg = MSG_SPECIFY_CLOTHING
	end if

    show( msg )
end sub


sub do_cmd_disrobe()
    dim msg as string
    
	if obj1 > 0
		if obj_loc( obj1 ) = NUM_LOC_PLAYER
			if obj_worn( obj1 )
				msg = MSG_DONE
				obj_worn( obj1 ) = 0
			else
				msg = MSG_ALREADY_DONE
			end if
		else
			msg = MSG_NOT_CARRIED
		end if
	else
		msg = MSG_SPECIFY_CLOTHING
	end if

    show( msg )
end sub


sub do_cmd_wait()
    show( "Pasa el tiempo..." )
end sub


sub do_cmd_break()
    show( "La simple violencia no soluciona nada en este caso." )
end sub


sub do_cmd_push()
    show( MSG_IMPOSSIBLE )
end sub


sub do_cmd_pull()
    show( MSG_IMPOSSIBLE )
end sub


sub do_cmd_look_around()
    do_loc_desc()
end sub


' Executes the corresponding cmd
sub execute_cmd(cmd as ubyte)
    if cmd = CMD_NOP
        do_cmd_nop()
    elseif cmd >= CMD_NORTH _
       and cmd <= CMD_DOWN
        do_cmd_go( cmd )
    elseif cmd = CMD_END
        do_cmd_end()
    elseif cmd = CMD_INVENTORY
        do_cmd_inventory()
    elseif cmd = CMD_EXAMINE
        do_cmd_examine()
    elseif cmd = CMD_EXITS
        do_cmd_exits()
    elseif cmd = CMD_TAKE
        do_cmd_take()
    elseif cmd = CMD_DROP
        do_cmd_drop()
    elseif cmd = CMD_WEAR
        do_cmd_wear()
    elseif cmd = CMD_DISROBE
        do_cmd_disrobe()
    elseif cmd = CMD_WAIT
        do_cmd_wait()
    elseif cmd = CMD_BREAK
        do_cmd_break()
    elseif cmd = CMD_PUSH
        do_cmd_push()
    elseif cmd = CMD_PULL
        do_cmd_pull()
    elseif cmd = CMD_LOOK_AROUND
        do_cmd_look_around()  
    end if
end sub


sub print_cmds()
	' Print basic options
	cursor_to( SCR_FIRST_LINE_CMDS, 0 )
	print_word_marked_initial( "Inv " )
	print_word_marked_initial( "Mira alrededor " )
	cprint( "E" ): print_word_marked_initial( "xamina... " )
	print_word_marked_initial( "Norte " )
	print_word_marked_initial( "Sur " )
	print_word_marked_initial( "Este " )
	print_word_marked_initial( "Oeste " )
	print_word_marked_initial( "Arriba " )
	cprint( "A" )
    print_word_marked_initial( "bajo" )
    lf()

	' Print object manipulation options
	print_word_marked_initial( "Coge... " )
	print_word_marked_initial( "Deja... " )
	cprint( "Em" ): print_word_marked_initial( "puja... " )
	print_word_marked_initial( "Tira de... " )
	print_word_marked_initial( "Rompe... " )
end sub


const ExitCmds as string = "nseoab"

sub input_cmd()
    cmd = CMD_NOP
    obj1 = 0

	' Ask cmd
	print_cmds()
	dim key as string = read_cmd_key()

    ' "Parse" key presses
	if   key = "x" _
	  or key = "c" _
	  or key = "d" _
	  or key = "p" _
	  or key = "t" _
	  or key = "r"
		' Infer command
		cmd = CMD_EXAMINE

        if  key = "c"
            cmd = CMD_TAKE
        elseif key = "d"
            cmd = CMD_DROP
        elseif key = "p"
            cmd = CMD_PUSH
        elseif key = "t"
            cmd = CMD_PULL
        elseif key = "r"
            cmd = CMD_BREAK
        end if

		' Show objects
		get_objs_in_player_and( current_loc )
		print_marked_initial_objs_ids_in_vector( objs )

		' Which one?
		key = read_cmd_key()

		' Which object?
        dim i as ubyte = 0
        
		while i < ubound( objs ) _
          and obj_id( i )( 0 ) <> key
            i = i + 1
		end while
        
        if i < ubound( objs )
            obj1 = i
        end if
	elseif key = "i"
		cmd = CMD_INVENTORY
	elseif key = "m"
		cmd = CMD_LOOK_AROUND
	elseif key = "n" _
	    or key = "s" _
	    or key = "e" _
	    or key = "o" _
	    or key = "a" _
	    or key = "b"

		cmd = inStr( ExitCmds, key ) + 1
	end if

	clear_cmds_answer()
end sub
