' Player
' (c) 2022/25 Reveni Baltasar MIT License <baltasarq@gmail.com>


#pragma once


#include "io.bas"
#include "locs.bas"
#include "util.bas"


const MAX_INV_OBJS as ubyte = 4
dim current_loc    as ubyte = 1
dim num_turns      as ubyte
dim o2             as ubyte
dim timer          as ubyte
dim energy         as ubyte


' Prepares the game
sub init_game()
	init_locs()
	init_objs()

	current_loc = 0
	num_turns = 0
    o2 = 42
    energy = 0
    timer = 21
end sub


' Asks yes o no to the user, given a message
' @param msg The message to show to the user.
' @return false if the first letter of the user's reply is 'n',
'         true otherwise.
function ask_yes_no(msg as string) as ubyte
    dim toret as ubyte = 0

	cursor_to( SCR_FIRST_LINE_CMDS, 0 )
    println( msg )

	print_word_marked_initial( "Positivo " )
	print_word_marked_initial( "Negativo " )
    toret = read_cmd_key()

    return ( toret <> code( "n" ) )
end function


' Ends the game
sub end_game(msg as string)
    set_highlighted_colors()
    cursor_to( SCR_FIRST_LINE_ANSWER, 0 )
	println( msg )

    set_default_colors()
    wait_for_key()

    clear_cmds_answer()
    cursor_to( SCR_FIRST_LINE_CMDS, 0 )
    if not( ask_yes_no( "Volver a jugar: " ) )
        clrscr()
        stop
    else
        restart()
    end if
end sub


' Shows the hud info.
sub show_hud()
    dim o2_ink     as ubyte = COLOR_GREEN
    dim energy_ink as ubyte = COLOR_GREEN
    dim timer_ink  as ubyte = COLOR_GREEN

    if o2 < 15
        o2_ink = COLOR_RED
    end if

    if energy < 15
        energy_ink = COLOR_RED
    end if

    if timer < 15
        timer_ink = COLOR_RED
    end if

    cursor_to( 2, 55 )
    set_colors( o2_ink, COLOR_BLACK )
    cprint( "O2 : " + FormatStr( o2, 2, "0" ) )

    cursor_to( 3, 55 )
    set_colors( energy_ink, COLOR_BLACK )
    cprint( "ENG: " + FormatStr( energy, 2, "0" ) )

    cursor_to( 4, 55 )
    set_colors( timer_ink, COLOR_BLACK )
    cprint( "TIM: " + FormatStr( timer / 2, 2, "0" ) )

    set_default_colors()
end sub


' Executed just after describing the current loc
sub proc1()
    dim obj_cryo_geiser as ubyte = locate_obj_by_id( "agujero" )
    dim obj_floor       as ubyte = locate_obj_by_id( "suelo" )
    dim obj_rocks       as ubyte = locate_obj_by_id( "rocas" )
    dim obj_arc         as ubyte = locate_obj_by_id( "arco" )
    dim obj_tunnel      as ubyte = locate_obj_by_id( "pasaje" )

    if current_loc <> 13
        ' Take the floor with you
        obj_loc( obj_floor ) = current_loc

        ' Take the rocks with you
        obj_loc( obj_rocks ) = current_loc
    end if

    if current_loc = 12 _
    or current_loc = 15
        obj_loc( obj_tunnel ) = current_loc
        obj_loc( obj_arc ) = current_loc
    end if

	' Take the geiser with you where appropriate
	if current_loc = 5 _
    or current_loc = 11
		obj_loc( 5 ) = current_loc
	end if

	' Warning of the cryo-geiser
    if ( current_loc = 4 _
     or  current_loc = 10 ) _
    and num_turns mod 3 = 0
        cursor_to( SCR_FIRST_LINE_ANSWER, 0 )
        set_highlighted_colors()
        println( "Un repentino temblor parece surgir del agujero, " _
                 + "de forma que se extiende por todo el suelo." )
        set_default_colors()
    end if

    ' Cryo-geiser
    if  ( current_loc = 5 _
      or  current_loc = 11 ) _
      and num_turns mod 4 = 0
        cursor_to( SCR_FIRST_LINE_ANSWER, 0 )
        set_highlighted_colors()
        println( "El geiser estalla en una columna furiosa de vapor " _
                 + "de agua... Notas el calor atravesando tu traje." )

        if current_loc = 5
            println( "Afortunadamente, la chimenea se asienta bastante " _
                     + "al sur, por lo que solo es una mera molestia." )
        else
            end_game( "Notas el calor abrasando tu cuerpo, " _
                      + "hasta el punto de dejar tu traje " _
                      + "reducido a una amalgama " _
                      + "derretida que produce graves " _
                      + "quemaduras en tu piel. Tus pulmones " _
                      + "pronto arden y notas la certeza de " _
                      + "la muerte." )
        end if

        set_default_colors()
    end if

    ' End of game?
    if current_loc = 254
        end_game( "Lo has conseguido. Te introduces en el " _
                  + "complejo de rescate con todo lo necesario " _
                  + "para poder aguantar hasta que llegue la " _
                  + "caballería. Activas la radio-baliza para que " _
                  + "sepan el sitio en el que te encuentras... " _
                  + "Ahora solo resta esperar." )
    end if
end sub


' Executed after resp() answered to a successful command
sub proc2()
    ' Breathing
    if o2 > 0
        o2 = o2 - 1
    end if

    if o2 < 1
        wait_for_key()
        end_game( "Al principio, te parece que no pasa nada, " _
                  + "que aunque el contador de o2 haya llegado " _
                  + "a cero puedes seguir respirando " _
                  + "sin problema. Pero entonces te das cuenta " _
                  + "de que inspirar se complica por momentos, " _
                  + "inhalando como un sabor rancio que hace " _
                  + "que te marees y caigas al suelo. Cansado." _
                  + "Solo un rato... un ratito..." )
    end if

    ' Timer
    if timer > 0
        timer = timer - 1
    end if
    
    if timer < 1
        wait_for_key()
        end_game( "Notas como a tu alrededor, todo empieza a " _
                  + "arder. La tierra parece convertirse en " _
                  + "vapor que se eleva en grandes columnas " _
                  + "para dejar entrever un magma " _
                  + "blanco y rojo. Pronto caes en uno de " _
                  + "tantos agujeros mientras tu carne se " _
                  + "derrite." )
    end if

    ' Energy
    if energy > 0
        energy = energy - 1
    end if
    
    if energy = 1
        wait_for_key()
        println( "Los potentes focos en los laterales de tu casco " _
                 + "parpadean y finalmente se apagan." )
    end if
    
    if energy = 5
        wait_for_key()
        println( "Los focos en los laterales de tu casco " _
                 + "parpadean brevemente... se agotan lentamente..." )
    end if

    show_hud()
end sub


' Executed after user's prompt.
sub resp(cmd as ubyte)
    dim ObjVaina    as ubyte = locate_obj_by_id( "vaina" )
    dim ObjHill     as ubyte = locate_obj_by_id( "colina" )
    dim ObjWall     as ubyte = locate_obj_by_id( "pared" )
    dim ObjSuit     as ubyte = locate_obj_by_id( "traje" )
    dim ObjRubber   as ubyte = locate_obj_by_id( "caucho" )
    dim ObjAgujas   as ubyte = locate_obj_by_id( "agujas" )
    dim intercepted as ubyte = 0

    if  cmd = CmdBreak _
    and obj1 = ObjVaina
        intercepted = 1
        println( "El alunizaje ya la ha roto..." )
    elseif cmd = CmdDrop _
       and obj1 = ObjRubber _
       and current_loc = 5
        intercepted = 1
        println( "Dejas el caucho tan cerca como te es posible " _
                 + "del geiser, en un punto en el que apenas soportas " _
                 + "el calor. " )
        println( "Cuando vuelves, te das cuenta de " _
                 + "que se ha derretido y sin querer lo has pisado, " _
                 + "dejando tus botas envueltas en una capa de goma." )
    elseif ( cmd = CmdBreak _
          or cmd = CmdDrop ) _
       and obj1 = ObjSuit
        intercepted = 1
        end_game( "Frustrado, rasgas el traje con la primera roca " _
                  + "afilada que encuentras. Notas como el precioso " _
                  + "aire sale silbando por la fisura, y como poco a " _
                  + "poco, te cuesta respirar y te sientes ahogado.\n" _
                  + "Incluso antes de perder el conocimiento, " _
                  + "te das cuenta de que vas a morir." )
    elseif ( cmd = CmdPush _
          or cmd = CmdBreak _
          or cmd = CmdPull ) _
      and obj1 = ObjAgujas
    	intercepted = 1

    	if loc_exits( 2, EXIT_SOUTH ) > 0
    		obj_desc( ObjAgujas ) = "Rotas. Docenas de piedras " _
    						        + "yacen por todo el suelo."

    		println( "Mueves las agujas, cuyas piedras, " _
    			     + "crujen, ceden y caen. " _
    		   	     + "Ha sido sorprendentemente sencillo, pese a su fuerte " _
    		   	     + "apariencia." )
            set_default_colors()
            wait_for_key()

            loc_descs( 2 ) = "Un valle se extiende de norte a sur. " _
                           + "Reducidos montones de piedras se desperdigan " _
                           + "en derredor."
            loc_exits( 2, EXIT_SOUTH ) = 5
            do_loc_desc()
    	else
    		println( "No tiene sentido seguir destruyendo." )
    	end if
    elseif cmd = CmdExamine _
       and obj1 = ObjHill
        loc_exits( 6, EXIT_EAST ) = 7
    elseif cmd = CmdExamine _
       and obj1 = ObjWall
        loc_exits( 7, EXIT_EAST ) = 14
    elseif   cmd = CmdEast _
         and current_loc = 7 _
         and loc_exits( 7, EXIT_EAST ) > 0
        intercepted = 1

        println( "Escalas las rocas de terraza en terraza, de manera " _
               + "que acabas por desplazarte hacia el sur siguiendo " _
               + "una de ellas, al no encontrar ninguna otra salida " _
               + "practicable." )
        set_default_colors()
        wait_for_key()

        current_loc = 13
		do_loc_desc()
    elseif cmd = CmdNorth _
       and current_loc = 13
        intercepted = 1

        println( "Sorteas las rocas para descender por las " _
               + "terrazas hasta el fondo de la profunda grieta." )
        set_default_colors()
        wait_for_key()

        current_loc = 7
		do_loc_desc()
    end if

    if not( intercepted )
        execute_cmd( cmd )
    end if
end sub


' Describes the current loc
sub do_loc_desc()
	dim num_objs as ubyte = how_many_objs_in( current_loc )

	' Show loc desc
	clrscr()
    ' draw_pic( loc->pic_data )
	cursor_to( SCR_FIRST_LINE_TEXT, 0 )
    println( loc_descs( current_loc ) )

	' Show objects here
	if num_objs > 0
		print( CR + "Puedes ver:" )
		list_objs_in( current_loc )
	end if

	lf()
    lf()
end sub


' Restarts the game.
sub restart()
    init_game()
    play_intro()
    do_loc_desc()
end sub
