' Cmds
' (c) 2022/25 Reveni Baltasar MIT License <baltasarq@gmail.com>


#pragma once


' Cmds
const CmdNop        as ubyte =  0
const CmdNorth      as ubyte =  1
const CmdSouth      as ubyte =  2
const CmdEast       as ubyte =  3
const CmdWest       as ubyte =  4
const CmdUp         as ubyte =  5
const CmdDown       as ubyte =  6
const CmdEnd        as ubyte =  7
const CmdInventory  as ubyte =  8
const CmdExamine    as ubyte =  9 
const CmdExits      as ubyte = 10
const CmdTake       as ubyte = 11 
const CmdDrop       as ubyte = 12
const CmdWear       as ubyte = 13
const CmdDisrobe    as ubyte = 14
const CmdWait       as ubyte = 15
const CmdBreak      as ubyte = 16
const CmdPush       as ubyte = 17
const CmdPull       as ubyte = 18
const CmdLookAround as ubyte = 19
const NumCmds       as ubyte = 20 


' Fixed answers
const MSG_CANT_DO   as string = "No puedes hacer eso."


sub do_cmd_nop()
    println( MSG_CANT_DO )
end sub


sub do_cmd_go(cmd as ubyte)
    println( MSG_CANT_DO )
end sub


sub do_cmd_end()
    println( MSG_CANT_DO )
end sub


sub do_cmd_inventory()
    println( MSG_CANT_DO )
end sub


sub do_cmd_examine()
    println( MSG_CANT_DO )
end sub


sub do_cmd_exits()
    println( MSG_CANT_DO )
end sub


sub do_cmd_take()
    println( MSG_CANT_DO )
end sub


sub do_cmd_drop()
    println( MSG_CANT_DO )
end sub


sub do_cmd_wear()
    println( MSG_CANT_DO )
end sub


sub do_cmd_disrobe()
    println( MSG_CANT_DO )
end sub


sub do_cmd_wait()
    println( MSG_CANT_DO )
end sub


sub do_cmd_break()
    println( MSG_CANT_DO )
end sub


sub do_cmd_push()
    println( MSG_CANT_DO )
end sub


sub do_cmd_pull()
    println( MSG_CANT_DO )
end sub


sub do_cmd_look_around()
    println( MSG_CANT_DO )
end sub


' Executes the corresponding cmd
sub execute_cmd(cmd as ubyte)
    if cmd = CmdNop
        do_cmd_nop()
    elseif cmd >= CmdNorth _
       and cmd <= CmdDown
        do_cmd_go( cmd )
    elseif cmd = CmdEnd
        do_cmd_end()
    elseif cmd = CmdInventory
        do_cmd_inventory()
    elseif cmd = CmdExamine
        do_cmd_examine()
    elseif cmd = CmdExits
        do_cmd_exits()
    elseif cmd = CmdTake
        do_cmd_take()
    elseif cmd = CmdDrop
        do_cmd_drop()
    elseif cmd = CmdWear
        do_cmd_wear()
    elseif cmd = CmdDisrobe
        do_cmd_disrobe()
    elseif cmd = CmdWait
        do_cmd_wait()
    elseif cmd = CmdBreak
        do_cmd_break()
    elseif cmd = CmdPush
        do_cmd_push()
    elseif cmd = CmdPull
        do_cmd_pull()
    elseif cmd = CmdLookAround
        do_cmd_look_around()  
    end if
end sub
