' Objs
' (c) 2022/25 Reveni Baltasar MIT License <baltasarq@gmail.com>


#pragma once


declare sub lf
declare sub cprint(s as string)


const NUM_LOC_PLAYER         as ubyte = 255
const NUM_LOC_LIMBO          as ubyte = 0
const NUM_OBJS               as ubyte = 15
const OBJ_ATR_STATIC         as ubyte = 111
const OBJ_ATR_PORTABLE       as ubyte = 112
const OBJ_ATR_CLOTHING       as ubyte = 113


dim obj_id( NUM_OBJS - 1 )   as string
dim obj_loc( NUM_OBJS - 1 )  as ubyte
dim obj_atr( NUM_OBJS - 1 )  as ubyte
dim obj_worn( NUM_OBJS - 1 ) as ubyte
dim obj_desc( NUM_OBJS - 1 ) as string


' This is used in order to return an array
dim objs(NUM_OBJS - 1) as ubyte


' Inits everything related to objects
sub init_objs()
    restore ObjData
    
    for i = 0 to NUM_OBJS
        read obj_id( i )
        read obj_loc( i )
        read obj_atr( i )
        read obj_worn( i )
        read obj_desc( i )
    next
end sub


' @return the number of objects in a given location
' @param num_loc the loc to consider (NUM_LOC_PLAYER for player).
function how_many_objs_in(num_loc as ubyte) as ubyte
	dim toret as ubyte = 0

	for i = 0 to NUM_OBJS - 1
		if ( obj_atr( i ) <> OBJ_ATR_STATIC _
         and obj_loc( i ) = num_loc )
            toret = toret + 1
		end if
	next

	return toret
end function


' Lists all objects pertaining to a location (outputs to console)
' @param num_loc the loc to consider (NUM_LOC_PLAYER for player).
' @return the number of objects found.
function list_objs_in(num_loc as ubyte) as ubyte
	dim toret as ubyte = 0
    
    for i = 0 to NUM_OBJS - 1
		if   obj_atr( i ) <> OBJ_ATR_STATIC _
         and obj_loc( i ) = num_loc
            lf()
            cprint( obj_id( i ) )
            
            if   obj_worn( i ) <> 0 _
             and num_loc = NUM_LOC_PLAYER
                cprint( " (puesto)" )
            end if
            
            toret = toret + 1
		end if
	next

	return toret
end function


' @return a vector with all objects in a given location.
' @param num_loc the loc to consider (NUM_LOC_PLAYER for player).
function get_objs_in(num_loc as ubyte) as ubyte
	dim num as ubyte = 0

	for i = 0 to NUM_OBJS - 1
		if obj_loc( i ) = num_loc
            objs( num ) = i
			num = num + 1
		end if
	next

    ' Mark the end and return
	objs( num ) = 0
	return num
end function


' Get objects in a loc and in player
' @return a vector with all objects in a given location,
'		  and carried by the player (in objs).
'         It directly returns the number of objects.
' @param num_loc the loc to consider (don't use NUM_LOC_PLAYER).
function get_objs_in_player_and(num_loc as ubyte) as ubyte
	dim num as ubyte = 0

	for i = 0 to NUM_OBJS - 1
		if ( obj_loc( i ) = num_loc _
		  or obj_loc( i ) = NUM_LOC_PLAYER )
			objs( num ) = i
			num = num + 1
		end if
	next

	objs( num ) = 0
	return num
end function


' @return the object corresponding to a given id,
'         or crashes and never returns.
function locate_obj_by_id(id as string) as ubyte
    dim toret as ubyte = 0
    dim i as ubyte = 0
    
	while i < NUM_OBJS _
      and obj_id( i ) <> id
    end while
    
    if i < NUM_OBJS
        toret = i
    end if

    if i = 0
        cprint( "*** ERROR: Unable to find: '" )
        cprint( id )
        cprint( "'" )
        lf()
        stop
    end if

    return toret
end function


ObjData:
    '    id    loc atr                              worn
    '   desc
    ' The NULL object
    data "kk", 0, OBJ_ATR_PORTABLE,                 0
    data "La fría nada." 

    ' Spacial suite
    data "traje", NUM_LOC_PLAYER, OBJ_ATR_CLOTHING, 0
    data "Fino, pero resistente y protector."

    ' Vaina: landing capsule
    data "vaina", 1, OBJ_ATR_STATIC,                0
    data "Yace destrozada contra el polvoriento suelo de Ceres." 

    ' Spires: they initially stop the player
    data "agujas", 2, OBJ_ATR_STATIC,               0
    data "Se levantan imponentes desde el suelo." 

    ' Spire: by the lake, like an obelisc
    data "aguja", 3, OBJ_ATR_STATIC,                0
    data "Cual obelisco, situada justo al borde del lago." 

    ' First cryo-geiser
    data "agujero", 5, OBJ_ATR_STATIC,              0
    data "Ves un fondo licuoso."

    ' Hill
    data "colina", 6, OBJ_ATR_STATIC,               0
    data "Se eleva hacia el este. Te das cuenta de que es superable."

    ' Wall
    data "pared", 7, OBJ_ATR_STATIC,                0
    data "Aunque es una pared casi vertical, puedes ver " _
            + "que es aterrazada, de manera que entre " _
            + "las rocas se puede avanzar hacia el este."

    ' Cave
    data "entrada de la gruta", 8, OBJ_ATR_STATIC,  0
    data "Apenas se aprecia nada desde fuera."

    ' Floor - nearly all locs
    data "suelo", 0, OBJ_ATR_STATIC,                0
    data "El suelo es pedregoso y arenoso. Grandes rocas " _
            + "se esparcen en derredor."
            
    ' Rocks - nearly all locs
    data "rocas", 0, OBJ_ATR_STATIC,                0
    data "Grandes rocas se elevan en ciertos lugares."

    ' Floor
    data "suelo", 13, OBJ_ATR_STATIC,               0
    data "El suelo es de fina arena gris."

    ' Creek
    data "grieta", 14, OBJ_ATR_STATIC,              0
    data "Descarnadamente profunda, aunque relativamente estrecha."

    ' Arc
    data "arco", 15, OBJ_ATR_STATIC,                0
    data "Irregular, se asienta sobre dos pilares, " _
            + "uno estrecho y otro grueso."

    ' Passage
    data "pasaje", 15, OBJ_ATR_STATIC,              0
    data "Atraviesa el arco por su parte inferior, " _
            + "de manera que este es su techo abovedado."

    ' Rubber
    data "caucho", 2, OBJ_ATR_STATIC,               0
    data "Restos de caucho del exterior de la vaina."
