' IO
' (c) 2022/25 Reveni Baltasar MIT License <baltasarq@gmail.com>


#pragma once


#include <keys.bas>
#include <string.bas>
#include <print64.bas>

#include "cmd.bas"
#include "objs.bas"
#include "locs.bas"
#include "util.bas"


const COLOR_BLACK             as ubyte = 0
const COLOR_BLUE              as ubyte = 1
const COLOR_RED               as ubyte = 2
const COLOR_MAGENTA           as ubyte = 3
const COLOR_GREEN             as ubyte = 4
const COLOR_CYAN              as ubyte = 5
const COLOR_YELLOW            as ubyte = 6
const COLOR_WHITE             as ubyte = 7
const SCR_FIRST_LINE_TEXT     as ubyte = 8
const SCR_FIRST_LINE_ANSWER   as ubyte = 14
const SCR_FIRST_LINE_CMDS     as ubyte = 20
const SCR_MAX_LINES           as ubyte = 23
const SCR_FIRST_LINE_CMD_OBJS as ubyte = 21
const SCR_MAX_COLS            as ubyte = 64
dim CR                        as string = chr(13)

const PROMPT_WAIT as string = "<...>"


sub clrscr()
    border 0
    set_colors( COLOR_WHITE, COLOR_BLACK )
    cls 
end sub


sub set_colors(i as ubyte, p as ubyte)
    paper p
    ink i
end sub


sub set_default_colors()
    ink COLOR_WHITE
end sub


sub set_highlighted_colors()
    ink COLOR_CYAN
end sub


function read_key() as ubyte
    ' Wait for a key
    dim toret as ubyte = GetKey()
    while toret = 0
        toret = GetKey()
    end while
    
    ' Wait for no key pressed
    while GetKey() <> 0
    end while
    
    return toret
end function


sub wait_for_key()
    cprint( PROMPT_WAIT )
    pause 0
end sub


sub clear_cmds_answer()
    ' Prepare suitable string
    dim cleaner as string = "  "
    
    while len( cleaner ) < SCR_MAX_COLS
        cleaner = cleaner + cleaner 
    end while

    ' Sweep screen
    for i = SCR_FIRST_LINE_ANSWER to SCR_MAX_LINES
        cprint( cleaner )
    next
end sub


sub print_word_marked_initial(word as string)
    inverse( 1 )
    cprint( word( 0 ) )
    inverse( 0 )
    cprint( word( 1 to ) )
end sub


sub print_marked_initial_objs_ids_in_vector(words() as ubyte)
    set_highlighted_colors()
    cursor_to( SCR_FIRST_LINE_CMD_OBJS, 0 )
    
    for i = 0 to ubound(words) - 1
        print_word_marked_initial( obj_id( i ) )
        cprint( " " )
    next
end sub


sub cursor_to(row as ubyte, col as ubyte)
    printat64( row, col )
end sub


sub cprint(s as string)
    print64( s )
end sub


sub lf()
    cprint( CR )
end sub


sub println(t as string)
    dim num_chs as uinteger = len( t )
    dim pos as uinteger = SCR_MAX_COLS - 1
    dim base_pos as uinteger = 0
    
    while( pos < num_chs )
        while( pos > 2 _
            and t( pos ) <> " "  )
            pos = pos - 1
        end while

        cprint( t( base_pos to pos - 1 ) )
        lf()
        base_pos = pos + 1
        pos = pos + ( SCR_MAX_COLS - 1 )
    end while
    
    cprint( t( base_pos to ) )
    lf()
end sub


function read_cmd_key() as ubyte
	dim key as ubyte = read_key()

	while not( is_asc_letter( key ) )
		key = code( lcase( str( read_key() ) ) )
	end while

	return key
end function


sub print_cmds()
	' Print basic options
	cursor_to( SCR_FIRST_LINE_CMDS, 0 )
	print_word_marked_initial( "Inv " )
	print_word_marked_initial( "Mira alrededor " )
	cprint( "E" ): print_word_marked_initial( "xamina... " )
	print_word_marked_initial( "Norte " )
	print_word_marked_initial( "Sur " )
	print_word_marked_initial( "Este " )
	print_word_marked_initial( "Oeste " )
	print_word_marked_initial( "Arriba " )
	cprint( "A" )
    print_word_marked_initial( "bajo" )
    lf()

	' Print object manipulation options
	print_word_marked_initial( "Coge... " )
	print_word_marked_initial( "Deja... " )
	cprint( "Em" ): print_word_marked_initial( "puja... " )
	print_word_marked_initial( "Tira de... " )
	print_word_marked_initial( "Rompe... " )
end sub


const ExitCmds as string = "nseoab"
dim obj1 as ubyte
dim cmd as ubyte

sub input_cmd()
    cmd = CmdNop
    obj1 = 0

	' Ask cmd
	print_cmds()
	dim key as string = chr( read_cmd_key() )

    ' "Parse" key presses
	if   key = "x" _
	  or key = "c" _
	  or key = "d" _
	  or key = "p" _
	  or key = "t" _
	  or key = "r"
		' Infer command
		cmd = CmdExamine

        if  key = "c"
            cmd = CmdTake
        elseif key = "d"
            cmd = CmdDrop
        elseif key = "p"
            cmd = CmdPush
        elseif key = "t"
            cmd = CmdPull
        elseif key = "r"
            cmd = CmdBreak
        end if

		' Show objects
		get_objs_in_player_and( current_loc )
		print_marked_initial_objs_ids_in_vector( objs )

		' Which one?
		key = str( read_cmd_key() )

		' Which object?
        dim i as ubyte = 0
        
		while i < ubound( objs ) _
          and obj_id( i )( 0 ) <> key
            i = i + 1
		end while
        
        if i < ubound( objs )
            obj1 = i
        end if
	elseif key = "i"
		cmd = CmdInventory
	elseif key = "m"
		cmd = CmdLookAround
	elseif key = "n" _
	    or key = "s" _
	    or key = "e" _
	    or key = "o" _
	    or key = "a" _
	    or key = "b"

		cmd = inStr( ExitCmds, key ) + 1
	end if

	clear_cmds_answer()
end sub


' Shows a message to the user
' It waits for a key afterwards.
sub show(msg as string)
    cursor_to( SCR_FIRST_LINE_ANSWER, 0 )
    println( msg )
    wait_for_key()
end sub
