;; -------------------------------------------------------------------------
;;                    Mojon Twins' F O U R S P R I T E R
;; -------------------------------------------------------------------------
;; Biblioteca simple de sprites de 16x16 que se mueven de 8 en 8 para BASIC
;; la idea es usarlo desde BASIC compilado.
;; -------------------------------------------------------------------------
;; Copyleft 2009 The Mojon Twins.
;; Pergreado por na_th_an
;; -------------------------------------------------------------------------
;; salo y modifcalo como te de la gana, pero "porfa", mencinanos :-)
;; -------------------------------------------------------------------------

;; -------------------------------------------------------------------------
;; Histrico de versiones
;; -------------------------------------------------------------------------
;; Versin 1.0 :: Funcionalidad completa, usa UDG.
;; Versin 1.1 :: Usa chars (23606+256*23607+256) en lugar de UDG.
;; Versin 2.0 :: Recode completo para ms velocidad.
;; -------------------------------------------------------------------------

;; Ensamblar con:
;; pasmo fsp2.0.asm fsp2.0.bin fsp2.0.txt
;; Generar fsp2.0.bin con el binario y fsp2.0.txt con la tabla de smbolos.

;; A ver qu tal sale.

            org     51500           ; Esto lo ajustar adnde ms me convenga luego.
            
;; Aqu vienen todos los datos. Se pokean desde BASIC

datap:                              ; Cada bloque ocupa 50 bytes.

;; Las etiquetas empleadas ms abajo son puramente orientativas y no se
;; emplean desde el cdigo. Sin embargo, aparecern en un archivo de tabla
;; de smbolos, lo cual puede resultar til si no se tiene ganas de calcular
;; cosas.

;; Sprite 1

act1:       defb    0               ; Define si el sprite est activo
flags1:     defb    0               ; Por ahora sin uso.
x_pos1:     defb    0               ; Posicin X en chars.
y_pos1:     defb    0               ; Posicin Y en chars.
cx_pos1:    defb    0               ; Anterior posicin X en chars.
cy_pos1:    defb    0               ; Anterior posicin Y en chars.
udg1:       defb    0, 0, 0, 0      ; Los cuatro CHAR del primer sprite.
buffer1:    defs    32, 0           ; Buffer de lo que haba en la pantalla.
attrs1:     defb    7, 7, 7, 7      ; Cuatro atributos
buffatrs1:  defs    4, 0            ; Buffer de los atributos

;; Sprite 2

act2:       defb    0               ; Define si el sprite est activo
flags2:     defb    0               ; Por ahora sin uso.
x_pos2:     defb    0               ; Posicin X en chars.
y_pos2:     defb    0               ; Posicin Y en chars.
cx_pos2:    defb    0               ; Anterior posicin X en chars.
cy_pos2:    defb    0               ; Anterior posicin Y en chars.
udg2:       defb    0, 0, 0, 0      ; Los cuatro CHAR del segundo sprite.
buffer2:    defs    32, 0           ; Buffer de lo que haba en la pantalla.
attrs2:     defb    7, 7, 7, 7      ; Cuatro atributos
buffatrs2:  defs    4, 0            ; Buffer de los atributos

;; Sprite 3

act3:       defb    0               ; Define si el sprite est activo
flags3:     defb    0               ; Por ahora sin uso.
x_pos3:     defb    0               ; Posicin X en chars.
y_pos3:     defb    0               ; Posicin Y en chars.
cx_pos3:    defb    0               ; Anterior posicin X en chars.
cy_pos3:    defb    0               ; Anterior posicin Y en chars.
udg3:       defb    0, 0, 0, 0      ; Los cuatro CHAR del tercer sprite.
buffer3:    defs    32, 0           ; Buffer de lo que haba en la pantalla.
attrs3:     defb    7, 7, 7, 7      ; Cuatro atributos
buffatrs3:  defs    4, 0            ; Buffer de los atributos

;; Sprite 4

act4:       defb    0               ; Define si el sprite est activo
flags4:     defb    0               ; Por ahora sin uso.
x_pos4:     defb    0               ; Posicin X en chars.
y_pos4:     defb    0               ; Posicin Y en chars.
cx_pos4:    defb    0               ; Anterior posicin X en chars.
cy_pos4:    defb    0               ; Anterior posicin Y en chars.
udg4:       defb    0, 0, 0, 0      ; Los cuatro CHAR del cuarto sprite.
buffer4:    defs    32, 0           ; Buffer de lo que haba en la pantalla.
attrs4:     defb    7, 7, 7, 7      ; Cuatro atributos
buffatrs4:  defs    4, 0            ; Buffer de los atributos

;; General y guarro, que todava estoy empezando:

xpos:       defb    0
ypos:       defb    0
cxpos:      defb    0
cypos:      defb    0

;; ---------------------------------------------------------------------------
;; rutina init_sprites
;; ---------------------------------------------------------------------------

;; Primero tendremos que llamar a esta funcin que escribe lo que haya en
;; en fondo en el buffer de cada sprite.

init_sprites:

            ld      de, datap       ; Apuntamos a la zona de datos

            ld      b,  4           ; 4 iteraciones
init_loop:  push    bc

            ;; Primero vemos si el sprite est activo
            ld      a,  (de)
            cp      0
            jr      z,  init_adv    ; Si no est activo, nos lo saltamos
            inc     de
            
            ;; Por ahora nos saltamos los flags
            inc     de              ; Ahora DE->X
            
            ;; Obtenemos las coordenadas X e Y
            ld      hl, xpos        ; HL->XPOS
            ex      de, hl          ; Cambiamos HL por DE. Ahora DE->XPOS, HL->X
            ldi                     ; XPOS = X; DE->YPOS, HL->Y
            ldi                     ; YPOS = Y; DE->YPOS+1, HL->Y+1
            ex      de, hl          ; Deshacemos el cambio. Ahora DE->Y+1=CX
            
            ; Nos saltamos CX y CY:
            inc     de              ; Ahora DE->CY
            inc     de              ; Ahora DE->UDG
            
            ;; Tenemos en nuestras variables XPOS e YPOS las coordenadas.
            ;; Ahora tenemos que copiar los cuatro chars del bitmap al buffer
            
            ;; Avanzamos DE al buffer, para ello nos saltamos los 4 UDG
            inc     de
            inc     de
            inc     de
            inc     de              ; Ahora DE->BUFFER
            
            call scr2buf
                
            ;; Ahora DE->ATTRS. Hay que avanzar hasta BUFATRS, 4 bytes ms all
            inc     de
            inc     de
            inc     de
            inc     de
            
            ;; reposicionamos las coordenadas xpos e ypos restando 1 a cada una:
            
            ; xpos --
            ld      hl, xpos
            dec     (hl)
            
            ; ypos --
            inc     hl
            dec     (hl)
            
            ; Calculamos la direccin de los atributos en HL
            call    getatraddr      ; HL->atributos, DE->buffer_atributos
            
            ;; Copiamos los cuatro atributos
            ldi                     ; Primer carcter
            ldi                     ; Segundo carcter
            ld      bc, 30
            add     hl, bc
            ldi                     ; Tercer carcter
            ldi                     ; Cuarto carcter
            
            ; Ahora DE apunta al principio del siguiente sprite.

init_nxt:   pop     bc
            djnz    init_loop
            
            ret
            
init_adv:   ld      hl, 50          ; Sumamos 50 a de y seguimos
            add     hl, de
            ex      de, hl
            jp      init_nxt

;; ---------------------------------------------------------------------------
;; rutina borra_sprites
;; ---------------------------------------------------------------------------
            
;; Esta rutina restaura el fondo almacenado en los sprites en las coordenadas
;; CX,CY (anteriores coordenadas)
            
borra_sprites:

            ld      de, datap       ; Apuntamos a la zona de datos

            ld      b,  4           ; 4 iteraciones
borra_loop: push    bc

            ;; Primero vemos si el sprite est activo
            ld      a,  (de)
            or      a
            jp      z,  borra_adv   ; Si no est activo, nos lo saltamos
            inc     de
            
            ;; Por ahora nos saltamos los flags
            inc     de              ; Ahora DE->X
            
            ;; Obtenemos las coordenadas CX y CY
            inc     de              ; Nos saltamos X, ahora DE->Y
            inc     de              ; Nos saltamos Y, ahora DE->CX
            ld      hl, xpos        ; HL->XPOS
            ex      de, hl          ; Cambiamos HL por DE. Ahora DE->XPOS, HL->CX
            ldi                     ; XPOS = CX; DE->YPOS, HL->CY
            ldi                     ; YPOS = CY; DE->YPOS+1, HL->CY+1
            ex      de, hl          ; Deshacemos el cambio. Ahora DE->CY+1=UDG
            
            ;; Tenemos en nuestras variables XPOS e YPOS las coordenadas.
            ;; Ahora tenemos que copiar los cuatro chars del buffer al bitmap
            
            ;; Avanzamos DE al buffer, para ello nos saltamos los 4 UDG
            inc     de
            inc     de
            inc     de
            inc     de              ; Ahora DE->BUFFER
            
            call buf2scr
            
            ;; Ahora DE->ATTRS. Hay que avanzar hasta BUFATRS, 4 bytes ms all
            inc     de
            inc     de
            inc     de
            inc     de
            
            ;; reposicionamos las coordenadas xpos e ypos restando 1 a cada una:
            
            ; xpos --
            ld      hl, xpos
            dec     (hl)
            
            ; ypos --
            inc     hl
            dec     (hl)
            
            ; Calculamos la direccin de los atributos en HL
            call    getatraddr      ; HL->atributos, DE->buffer_atributos
            
            ;; Copiamos los cuatro atributos
            ex      de, hl          ; HL->buffer_atributos, DE->atributos
            ldi                     ; Primer carcter
            ldi                     ; Segundo carcter
            ex      de, hl          
            ld      bc, 30
            add     hl, bc
            ex      de, hl          
            ldi                     ; Tercer carcter
            ldi                     ; Cuarto carcter
            ex      de, hl          ; DE vuelve a apuntar a los datos...
            
            ; Ahora DE apunta al principio del siguiente sprite.            

borra_nxt:  pop     bc
            djnz    borra_loop
            
            ret
            
borra_adv:  ld      hl, 50          ; Sumamos 50 a de y seguimos
            add     hl, de
            ex      de, hl
            jp      borra_nxt

;; ---------------------------------------------------------------------------
;; rutina pinta_sprites
;; ---------------------------------------------------------------------------
            
;; Esta rutina restaura pinta los chars especificados en la tabla UDG
;; En las coordenadas X, Y del sprite
            
pinta_sprites:

            ld      de, datap       ; Apuntamos a la zona de datos

            ld      b,  4           ; 4 iteraciones
pinta_loop: push    bc

            ;; Primero vemos si el sprite est activo
            ld      a,  (de)
            or      a
            jp      z,  pinta_adv   ; Si no est activo, nos lo saltamos
            inc     de
            
            ;; Por ahora nos saltamos los flags
            inc     de              ; Ahora DE->X
            
            ;; Obtenemos las coordenadas X e Y
            ld      hl, xpos        ; HL->XPOS
            ex      de, hl          ; Cambiamos HL por DE. Ahora DE->XPOS, HL->X
            ldi                     ; XPOS = X; DE->YPOS, HL->Y
            ldi                     ; YPOS = Y; DE->YPOS+1, HL->Y+1
            ex      de, hl          ; Deshacemos el cambio. Ahora DE->Y+1=CX
            
            ; Nos saltamos CX y CY:
            inc     de              ; Ahora DE->CY
            inc     de              ; Ahora DE->UDG
            
            ;; DE->UDG. Ahora hay que pintar los cuatro carcteres indexados ah.
            
            call    char2scr
            
            ;; DE->BUFFER. Tenemos que saltarnos 32 bytes para acceder
            ;; a los atributos del sprite:
            
            ld      hl, 32
            add     hl, de
            ex      de, hl          ; Ahora DE->ATTRS
            
            ;; Pintamos los 4 atributos
            
            ;; reposicionamos las coordenadas xpos e ypos restando 1 a cada una:
            
            ; xpos --
            ld      hl, xpos
            dec     (hl)
            
            ; ypos --
            inc     hl
            dec     (hl)
            
            ; Calculamos la direccin de los atributos en HL
            call    getatraddr      ; HL->atributos, DE->ATTRS
            
            ;; Copiamos los cuatro atributos
            ex      de, hl          ; HL->ATTRS, DE->atributos
            ldi                     ; Primer carcter
            ldi                     ; Segundo carcter
            ex      de, hl          
            ld      bc, 30
            add     hl, bc
            ex      de, hl          ; HL->ATTRS, DE->atributos
            ldi                     ; Tercer carcter
            ldi                     ; Cuarto carcter
            ex      de, hl          ; DE vuelve a apuntar a los datos...
            
            ;; Avanzamos DE hasta el siguiente carcter:
            inc     de
            inc     de
            inc     de
            inc     de
            
            ; Ahora DE apunta al principio del siguiente sprite.

pinta_nxt:  pop     bc
            djnz    pinta_loop
            
            ret
            
pinta_adv:  ld      hl, 50          ; Sumamos 50 a de y seguimos
            add     hl, de
            ex      de, hl
            jp      pinta_nxt

;; ---------------------------------------------------------------------------
;; rutina upd_coord
;; ---------------------------------------------------------------------------
            
;; Esta rutina hace CX = X, CY = Y.
            
upd_coord:  ld      de, datap + 2   ; Apuntamos a la zona de datos
            ld      hl, datap + 2   ; Apuntamos a la zona de datos

            ld      b,  4           ; 4 iteraciones
upd_loop:   
            inc     de
            inc     de              ; DE->CX
            ldi                     ; CX=X; HL->Y, DE->CY
            ldi                     ; CY=Y; HL->CX, DE->UDG
            inc     bc
            inc     bc
            
            ; avanzar hasta el siguiente sprite:
            
            ;; DE = DATAP+6, sumamos 44
            
            ld      hl, 46
            add     hl, de
            ld      d,  h
            ld      e,  l

            ; Ahora DE apunta al principio del siguiente sprite.

upd_nxt:    
            djnz    upd_loop
            
            ret

;; ---------------------------------------------------------------------------
;; rutina upd_sprites
;; ---------------------------------------------------------------------------
            
;; Esta rutina llama a las cuatro anteriores para hacer la animacin
;; sincronizando con el retrazo

upd_sprites:
            halt
            call    borra_sprites
            call    init_sprites
            call    pinta_sprites
            call    upd_coord
            ret
            
;; ---------------------------------------------------------------------------
;; subrutinas
;; ---------------------------------------------------------------------------
                            
;; Esta subrutina copia el rectngulo del bitmap al buffer apuntado por DE.
                
scr2buf: 
            call    getscraddr1      ; HL = Direccin en el bitamp de XPOS,YPOS
            
            ; xpos++
            ld      hl, xpos
            inc     (hl)
            
            ;; Segundo char
            call    getscraddr1      ; HL = Direccin en el bitamp de XPOS,YPOS
            
            ; xpos--
            ld      hl, xpos
            dec     (hl)
            
            ; ypos++
            inc     hl
            inc     (hl)
            
            ;; Tercer char
            call    getscraddr1      ; HL = Direccin en el bitamp de XPOS,YPOS
            
            ; xpos++
            ld      hl, xpos
            inc     (hl)
            
            ;; Cuarto char
            jp    getscraddr1      ; HL = Direccin en el bitamp de XPOS,YPOS

;; Esta subrutina copia el buffer apuntado por DE al bitmap 
                
buf2scr:    ;; Primer char
            call    getscraddr1     ; HL = Direccin en el bitamp de XPOS,YPOS
            
            ; xpos++
            ld      hl, xpos
            inc     (hl)
            ;; Segundo char
            call    getscraddr1     ; HL = Direccin en el bitamp de XPOS,YPOS
            
            ; xpos--
            ld      hl, xpos
            dec     (hl)
            ; ypos++
            inc     hl
            inc     (hl)
            ;; Tercer char
            call    getscraddr1      ; HL = Direccin en el bitamp de XPOS,YPOS
            
            ; xpos++
            ld      hl, xpos
            inc     (hl)
            ;; Cuarto char

getscraddr1:
            ld      a, (de)         ; En A el # del carcter
            push    de              ; Nos guardamos DE para luego
            call    getcharaddr     ; En HL tenemos la direccin del carcter
            ex      de, hl          ; En DE tenemos la direccin del carcter

            ld      a,  (xpos)
            and     31
            ld      l,  a
            ld      a,  (ypos)
            ld      c,  a
            and     24
            add     a,  64
            ld      h,  a
            ld      a,  c
            and     7
            rrca
            rrca
            rrca
            or      l
            ld      l,  a

            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            
            ret
        
;; Esta rutina apunta los chars en el buffer apuntado por DE a pantalla.
                
char2scr:   ;; Primer carcter
            call    getscraddr2

            ; xpos++
            ld      hl, xpos
            inc     (hl)
            ;; Segundo carcter
            call    getscraddr2

            ; xpos--
            ld      hl, xpos
            dec     (hl)
            ; ypos ++
            inc     hl
            inc     (hl)
            ;; Tercer carcter
            call    getscraddr2

            ; xpos++
            ld      hl, xpos
            inc     (hl)
            ;; Cuarto carcter
getscraddr2:
            ld      a, (de)         ; En A el # del carcter
            push    de              ; Nos guardamos DE para luego
            call    getcharaddr     ; En HL tenemos la direccin del carcter
            ex      de, hl          ; En DE tenemos la direccin del carcter

            ld      a,  (xpos)
            and     31
            ld      l,  a
            ld      a,  (ypos)
            ld      c,  a
            and     24
            add     a,  64
            ld      h,  a
            ld      a,  c
            and     7
            rrca
            rrca
            rrca
            or      l
            ld      l,  a

            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a
            inc     h
            inc     de
            ld      a,  (de)
            ld      (hl), a         ; Copiamos los 8 bytes del char
            
            pop     de              ; Restauramos de
            inc     de              ; Fin de los UDG
            
            ret
                

;; Esta subrutina devuelve en HL la direccin de memoria del atributo en las
;; coordenadas XPOS,YPOS.
            
getatraddr: ld      a,  (ypos)      ; Cogemos y
            rrca
            rrca
            rrca                    ; La multiplicamos por 32
            ld      l,  a           ; nos lo guardamos en l
            and     3               ; ponemos una mascarita 00000011
            add     a,  88          ; 88 * 256 = 22528, aqu empieza el tema
            ld      h,  a           ; Hecho el bite superior.
            ld      a,  l           ; Nos volvemos a traer y * 32
            and     224             ; Mascarita 11100000
            ld      l,  a           ; Lo volvemos a poner en l
            ld      a,  (xpos)      ; Cogemos x
            add     a,  l           ; Le sumamos lo que tenamos antes.
            ld      l,  a           ; Listo. Ya tenemos en HL la direccin.
            
            ret
            
;; Esta subrutina calcula la posicin de memoria del carcter en A
;; y la devuelve en HL
                        
getcharaddr:

            ld      b,  a
            ld      hl, 23606
            ld      a,  (hl)
            ld      e,  a
            ld      hl, 23607
            ld      a,  (hl)
            ld      d,  a
            ld      a,  b
            
            ld      h,  0
            ld      l,  a
            add     hl, hl
            add     hl, hl
            add     hl, hl
            add     hl, de
            inc     h
            
            ret

spare:  
            defs    5,87
