#include "library/rx78header.bas"
#include "library/smsrnd.bas"
#include "library/b1r0f1_charmapdday01.zxi"
#include "library/smsdelay.bas"
#include "library/rx78ldirxor24b.bas"

dim eee as uinteger at $B010
dim seed as uinteger at $B012 '- seed is for random numbers, not being used now
dim ee0 as uinteger at $B014
dim ee1 as uinteger at $B016
dim ee2 as uinteger at $B018
dim ee3 as uinteger at $B01A
dim eex as uinteger at $B01C
dim eey as uinteger at $B01E

sub rx78putchar(txp1 as uinteger,typ1 as uinteger,tch1 as uinteger,tad1 as uinteger):
  dim tlp1 as uinteger at $B000  
  for tlp1=0 to 7
    poke $EEC0+(tlp1*24)+(typ1*192)+txp1,peek(tad1+(tch1*8)+tlp1)
    next
  end sub

sub rx78putcharxor(txp1 as uinteger,typ1 as uinteger,tch1 as uinteger,tad1 as uinteger,txv1 as ubyte):
  rx78ldirxor24b($EEC0+(typ1*192)+txp1,tad1+(tch1*8),8,txv1)
  'dim tlp1 as uinteger at $B000  
  'for tlp1=0 to 7
  '  poke $EEC0+(tlp1*24)+(typ1*192)+txp1,peek(tad1+(tch1*8)+tlp1)
  '  next
  end sub


for ee1=0 to 22

    seed=smsrnd(seed):out $F5,seed
    seed=smsrnd(seed):out $F6,seed
    seed=smsrnd(seed):out $F7,seed
    seed=smsrnd(seed):out $F8,seed
    seed=smsrnd(seed):out $F9,seed
    seed=smsrnd(seed):out $FA,seed
    seed=smsrnd(seed):out $FC,seed


  for ee0=0 to 23
    ee2=seed:seed=smsrnd(seed)
    rx78putcharxor(ee0,ee1,96+(ee2 mod 9),@charmap01-256,$FF)

    seed=smsrnd(seed):out $F2,seed

    smsdelay(5000)
    next:next

for ee1=2 to 6
  for ee0=0 to 15
    rx78putcharxor(ee0+7,ee1+15,ee1*16+ee0,@charmap01-256,$FF)
    smsdelay(1000)
    next:next

eee=0:eex=8:eey=8
do

rx78putcharxor(1,1,48+(int(eee/10000) mod 10),@charmap01-256,$FF)
rx78putcharxor(2,1,48+(int(eee/1000) mod 10),@charmap01-256,$FF)
rx78putcharxor(3,1,48+(int(eee/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,1,48+(int(eee/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,1,48+(eee mod 10),@charmap01-256,$FF)

out $F4,1
ee0=in($F4)
rx78putcharxor(3,3,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,3,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,3,48+(ee0 mod 10),@charmap01-256,$FF)

out $F4,2
ee0=in($F4)
rx78putcharxor(3,4,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,4,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,4,48+(ee0 mod 10),@charmap01-256,$FF)

out $F4,3
ee0=in($F4)
rx78putcharxor(3,5,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,5,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,5,48+(ee0 mod 10),@charmap01-256,$FF)

out $F4,4
ee0=in($F4)
rx78putcharxor(3,6,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,6,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,6,48+(ee0 mod 10),@charmap01-256,$FF)

out $F4,5
ee0=in($F4)
rx78putcharxor(3,7,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,7,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,7,48+(ee0 mod 10),@charmap01-256,$FF)

out $F4,6
ee0=in($F4)
rx78putcharxor(3,8,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,8,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,8,48+(ee0 mod 10),@charmap01-256,$FF)

out $F4,7
ee0=in($F4)
rx78putcharxor(3,9,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,9,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,9,48+(ee0 mod 10),@charmap01-256,$FF)

eey=eey+((ee0 band 2)/2)-((ee0 band 4)/4)
eex=eex+((ee0 band 8)/8)-((ee0 band 16)/16)

rx78putcharxor(eex,eey,32+(eee mod 74),@charmap01-256,$FF)

out $F4,8
ee0=in($F4)
rx78putcharxor(3,10,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,10,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,10,48+(ee0 mod 10),@charmap01-256,$FF)

out $F4,9
ee0=in($F4)
rx78putcharxor(3,11,48+(int(ee0/100) mod 10),@charmap01-256,$FF)
rx78putcharxor(4,11,48+(int(ee0/10) mod 10),@charmap01-256,$FF)
rx78putcharxor(5,11,48+(ee0 mod 10),@charmap01-256,$FF)

seed=smsrnd(seed):out $F2,seed


if (eee band 15)=0 then
seed=smsrnd(seed):out $F5,seed
seed=smsrnd(seed):out $F6,seed
seed=smsrnd(seed):out $F7,seed
seed=smsrnd(seed):out $F8,seed
seed=smsrnd(seed):out $F9,seed
seed=smsrnd(seed):out $FA,seed
seed=smsrnd(seed):out $FC,seed
end if

eee=eee+1
loop


do:loop

do
ee0=seed:seed=smsrnd(seed)
ee1=seed:seed=smsrnd(seed)
ee2=seed:seed=smsrnd(seed)
rx78putchar(ee0 mod 24,ee1 mod 23,32+(ee2 mod 74),@charmap01-256)
loop

do:loop

for eee=0 to 7
  poke $EEC0+(eee*24),peek(@tile01+eee)
  next

do:loop

tile01:
asm
defb %00111111
defb %01100011
defb %01100011
defb %01100011
defb %00111111
defb %00000011
defb %00000011
defb %00000000
end asm

'--------??xxxbgr
'out $F5,%10001100
'out $F6,%00101101
'out $F7,%00110011
'out $F8,%00110011
'out $F9,%00101101
'out $FA,%00011110


