	org 24576
	; Defines HEAP SIZE
ZXBASIC_HEAP_SIZE EQU 1024
__START_PROGRAM:
	di
	push ix
	push iy
	exx
	push hl
	exx
	ld hl, 0
	add hl, sp
	ld (__CALL_BACK__), hl
	ei
	call __MEM_INIT
	call __PRINT_INIT
	ld a, 6
	call INK
	call COPY_ATTR
	ld a, 1
	call PAPER
	call COPY_ATTR
	xor a
	call FLASH
	call COPY_ATTR
	ld a, 1
	call BRIGHT
	call COPY_ATTR
	xor a
	call OVER
	call COPY_ATTR
	xor a
	call INVERSE
	call COPY_ATTR
	xor a
	ld (_tn), a
	xor a
	ld (_mt), a
	xor a
	ld (_rn), a
	xor a
	ld (_znw), a
	ld a, 16
	ld (_znh), a
	ld a, 255
	ld (_gw), a
	ld a, (_znh)
	add a, 175
	ld (_gh), a
	ld a, 1
	call BORDER
	call CLS
	ld a, 10
	push af
	ld a, 5
	call PRINT_AT
	ld hl, __LABEL0
	xor a
	call __PRINTSTR
	ld a, 1
	ld (_tn), a
	ld a, 4
	ld (_mt), a
	ld a, (_znw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_znh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gw)
	srl a
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_znh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	call __LABEL__FirstPoint
	ld a, (_tn)
	inc a
	ld (_tn), a
	ld a, (_znw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gw)
	srl a
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_znh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	call __LABEL__FirstPoint
	ld a, (_tn)
	inc a
	ld (_tn), a
	ld a, (_znw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gh)
	srl a
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_znw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_znh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	call __LABEL__FirstPoint
	ld a, (_tn)
	inc a
	ld (_tn), a
	ld a, (_gw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 0
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_znw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gh)
	srl a
	ld l, a
	ld h, 0
	push hl
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_gw)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld a, (_znh)
	ld l, a
	ld h, 0
	push hl
	ld hl, 2
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	call __LABEL__FirstPoint
	ld a, 1
	ld (_tn), a
	ld a, 12
	push af
	ld a, 4
	call PRINT_AT
	ld hl, __LABEL1
	xor a
	call __PRINTSTR
__LABEL__ScanAnyKey:
	call INKEY
	ld de, __LABEL4
	ld a, 1
	call __STREQ
	or a
	jp z, __LABEL3
	jp __LABEL__ScanAnyKey
__LABEL3:
	ld de, 0
	ld hl, 0
	call RANDOMIZE
	call CLS
__LABEL__DrawTriangles:
	call RND
	push bc
	push de
	push af
	ld a, 082h
	ld de, 00040h
	ld bc, 00000h
	call __MULF
	call __FTOU32REG
	inc hl
	ld a, l
	ld (_rn), a
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl
	push hl
	ld a, (_rn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	pop hl
	add hl, de
	srl h
	rr l
	push hl
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl
	push hl
	ld a, (_rn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	pop hl
	add hl, de
	srl h
	rr l
	push hl
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl
	ld a, l
	push af
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl
	ld a, l
	call PLOT
	ld a, (_tn)
	inc a
	ld (_tn), a
	ld a, (_mt)
	ld hl, (_tn - 1)
	cp h
	jp nc, __LABEL6
	ld a, 1
	ld (_tn), a
__LABEL6:
	jp __LABEL__DrawTriangles
__LABEL__FirstPoint:
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl
	push hl
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _x
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ld hl, 1
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	ld e, (hl)
	inc hl
	ld d, (hl)
	ex de, hl
	push hl
	ld hl, 3
	push hl
	ld a, (_tn)
	ld l, a
	ld h, 0
	dec hl
	push hl
	ld hl, _y
	call __ARRAY
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ret
	ld hl, 0
	ld b, h
	ld c, l
__END_PROGRAM:
	di
	ld hl, (__CALL_BACK__)
	ld sp, hl
	exx
	pop hl
	pop iy
	pop ix
	exx
	ei
	ret
__CALL_BACK__:
	DEFW 0
__LABEL4:
	DEFW 0000h
__LABEL0:
	DEFW 0017h
	DEFB 54h
	DEFB 68h
	DEFB 65h
	DEFB 20h
	DEFB 53h
	DEFB 69h
	DEFB 65h
	DEFB 72h
	DEFB 70h
	DEFB 69h
	DEFB 6Eh
	DEFB 73h
	DEFB 6Bh
	DEFB 69h
	DEFB 20h
	DEFB 54h
	DEFB 72h
	DEFB 69h
	DEFB 61h
	DEFB 6Eh
	DEFB 67h
	DEFB 6Ch
	DEFB 65h
__LABEL1:
	DEFW 0019h
	DEFB 50h
	DEFB 72h
	DEFB 65h
	DEFB 73h
	DEFB 73h
	DEFB 20h
	DEFB 61h
	DEFB 6Eh
	DEFB 79h
	DEFB 20h
	DEFB 6Bh
	DEFB 65h
	DEFB 79h
	DEFB 20h
	DEFB 74h
	DEFB 6Fh
	DEFB 20h
	DEFB 63h
	DEFB 6Fh
	DEFB 6Eh
	DEFB 74h
	DEFB 69h
	DEFB 6Eh
	DEFB 75h
	DEFB 65h
#line 1 "cls.asm"
	; JUMPS directly to spectrum CLS
	; This routine does not clear lower screen
	
	;CLS	EQU	0DAFh
	
	; Our faster implementation
	
#line 1 "sposn.asm"
	; Printing positioning library.
			PROC
			LOCAL ECHO_E 
	
__LOAD_S_POSN:		; Loads into DE current ROW, COL print position from S_POSN mem var.
			ld de, (S_POSN)
			ld hl, (MAXX)
			or a
			sbc hl, de
			ex de, hl
			ret
		
	
__SAVE_S_POSN:		; Saves ROW, COL from DE into S_POSN mem var.
			ld hl, (MAXX)
			or a
			sbc hl, de
			ld (S_POSN), hl ; saves it again
			ret
	
	
	ECHO_E	EQU 23682
	MAXX	EQU ECHO_E   ; Max X position + 1
	MAXY	EQU MAXX + 1 ; Max Y position + 1
	
	S_POSN	EQU 23688 
	POSX	EQU S_POSN		; Current POS X
	POSY	EQU S_POSN + 1	; Current POS Y
	
			ENDP
	
#line 9 "cls.asm"
	
CLS:
		PROC
	
		LOCAL COORDS
		LOCAL __CLS_SCR
		LOCAL ATTR_P
		LOCAL SCREEN
	
		ld hl, 0
		ld (COORDS), hl
	    ld hl, 1821h
		ld (S_POSN), hl
__CLS_SCR:
		ld hl, SCREEN
		ld (hl), 0
		ld d, h
		ld e, l
		inc de
		ld bc, 6144
		ldir
	
		; Now clear attributes
	
		ld a, (ATTR_P)
		ld (hl), a
		ld bc, 767
		ldir
		ret
	
	COORDS	EQU	23677
	SCREEN	EQU 16384 ; Default start of the screen (can be changed)
	ATTR_P	EQU 23693
	;you can poke (SCREEN_SCRADDR) to change CLS, DRAW & PRINTing address
	
	SCREEN_ADDR EQU (__CLS_SCR + 1) ; Address used by print and other screen routines
								    ; to get the start of the screen
		ENDP
	
#line 770 "dark3.bas"
#line 1 "print.asm"
	; PRINT command routine
	; Does not print attribute. Use PRINT_STR or PRINT_NUM for that
	
	
	
#line 1 "in_screen.asm"
	
#line 1 "error.asm"
	; Simple error control routines
; vim:ts=4:et:
	
	ERR_NR    EQU    23610    ; Error code system variable
	
	
	; Error code definitions (as in ZX spectrum manual)
	
; Set error code with:
	;    ld a, ERROR_CODE
	;    ld (ERR_NR), a
	
	
	ERROR_Ok                EQU    -1
	ERROR_SubscriptWrong    EQU     2
	ERROR_OutOfMemory       EQU     3
	ERROR_OutOfScreen       EQU     4
	ERROR_NumberTooBig      EQU     5
	ERROR_InvalidArg        EQU     9
	ERROR_IntOutOfRange     EQU    10
	ERROR_InvalidColour     EQU    19
	ERROR_BreakIntoProgram  EQU    20
	ERROR_TapeLoadingErr    EQU    26
	
	
	; Raises error using RST #8
__ERROR:
	    ld (__ERROR_CODE), a
	    rst 8
__ERROR_CODE:
	    nop
	    ret
	
	; Sets the error system variable, but keeps running.
	; Usually this instruction if followed by the END intermediate instruction.
__STOP:
	    ld (ERR_NR), a
	    ret
#line 3 "in_screen.asm"
	
__IN_SCREEN:
		; Returns NO carry if current coords (D, E)
		; are OUT of the screen limits (MAXX, MAXY)
	
		PROC
		LOCAL __IN_SCREEN_ERR
	
		ld hl, MAXX
		ld a, e
		cp (hl)
		jr nc, __IN_SCREEN_ERR	; Do nothing and return if out of range
	
		ld a, d
		inc hl
		cp (hl)
		;; jr nc, __IN_SCREEN_ERR	; Do nothing and return if out of range
		;; ret
	    ret c                       ; Return if carry (OK)
	
__IN_SCREEN_ERR:
__OUT_OF_SCREEN_ERR:
		; Jumps here if out of screen
		ld a, ERROR_OutOfScreen
		ld (ERR_NR), a	; Saves error code
	
		ret
	
		ENDP
#line 7 "print.asm"
#line 1 "table_jump.asm"
	
JUMP_HL_PLUS_2A: ; Does JP (HL + A*2) Modifies DE. Modifies A
		add a, a
	
JUMP_HL_PLUS_A:	 ; Does JP (HL + A) Modifies DE
		ld e, a
		ld d, 0
	
JUMP_HL_PLUS_DE: ; Does JP (HL + DE)
		add hl, de
		ld e, (hl)
		inc hl
		ld d, (hl)
		ex de, hl
CALL_HL:
		jp (hl)
	
#line 8 "print.asm"
#line 1 "ink.asm"
	; Sets ink color in ATTR_P permanently
; Parameter: Paper color in A register
	
#line 1 "const.asm"
	; Global constants
	
	P_FLAG	EQU 23697
	FLAGS2	EQU 23681
	ATTR_P	EQU 23693	; permanet ATTRIBUTES
	ATTR_T	EQU 23695	; temporary ATTRIBUTES
	CHARS	EQU 23606 ; Pointer to ROM/RAM Charset
	UDG	EQU 23675 ; Pointer to UDG Charset
	MEM0	EQU 5C92h ; Temporary memory buffer used by ROM chars
	
#line 5 "ink.asm"
	
INK:
		PROC
		LOCAL __SET_INK
		LOCAL __SET_INK2
	
		ld de, ATTR_P
	
__SET_INK:
		cp 8
		jr nz, __SET_INK2
	
		inc de ; Points DE to MASK_T or MASK_P
		ld a, (de)
		or 7 ; Set bits 0,1,2 to enable transparency
		ld (de), a
		ret
	
__SET_INK2:
		; Another entry. This will set the ink color at location pointer by DE
		and 7	; # Gets color mod 8
		ld b, a	; Saves the color
		ld a, (de)
		and 0F8h ; Clears previous value
		or b
		ld (de), a
		inc de ; Points DE to MASK_T or MASK_P
		ld a, (de)
		and 0F8h ; Reset bits 0,1,2 sign to disable transparency
		ld (de), a ; Store new attr
		ret
	
	; Sets the INK color passed in A register in the ATTR_T variable
INK_TMP:
		ld de, ATTR_T
		jp __SET_INK
	
		ENDP
	
#line 9 "print.asm"
#line 1 "paper.asm"
	; Sets paper color in ATTR_P permanently
; Parameter: Paper color in A register
	
	
	
PAPER:
		PROC
		LOCAL __SET_PAPER
		LOCAL __SET_PAPER2
		
		ld de, ATTR_P
	
__SET_PAPER:
		cp 8	
		jr nz, __SET_PAPER2
		inc de
		ld a, (de)
		or 038h
		ld (de), a
		ret
	
		; Another entry. This will set the paper color at location pointer by DE
__SET_PAPER2:
		and 7	; # Remove 
		rlca
		rlca
		rlca		; a *= 8
	
		ld b, a	; Saves the color
		ld a, (de)
		and 0C7h ; Clears previous value
		or b
		ld (de), a
		inc de ; Points to MASK_T or MASK_P accordingly
		ld a, (de)
		and 0C7h  ; Resets bits 3,4,5
		ld (de), a
		ret
	
	
	; Sets the PAPER color passed in A register in the ATTR_T variable
PAPER_TMP:
		ld de, ATTR_T
		jp __SET_PAPER
		ENDP
	
#line 10 "print.asm"
#line 1 "flash.asm"
	; Sets flash flag in ATTR_P permanently
; Parameter: Paper color in A register
	
	
	
FLASH:
		ld de, ATTR_P
__SET_FLASH:
		; Another entry. This will set the flash flag at location pointer by DE
		and 1	; # Convert to 0/1
	
		rrca
		ld b, a	; Saves the color
		ld a, (de)
		and 07Fh ; Clears previous value
		or b
		ld (de), a
		ret
	
	
	; Sets the FLASH flag passed in A register in the ATTR_T variable
FLASH_TMP:
		ld de, ATTR_T
		jr __SET_FLASH
	
#line 11 "print.asm"
#line 1 "bright.asm"
	; Sets bright flag in ATTR_P permanently
; Parameter: Paper color in A register
	
	
	
BRIGHT:
		ld de, ATTR_P
	
__SET_BRIGHT:
		; Another entry. This will set the bright flag at location pointer by DE
		and 1	; # Convert to 0/1
	
		rrca
		rrca
		ld b, a	; Saves the color
		ld a, (de)
		and 0BFh ; Clears previous value
		or b
		ld (de), a
		ret
	
	
	; Sets the BRIGHT flag passed in A register in the ATTR_T variable
BRIGHT_TMP:
		ld de, ATTR_T
		jr __SET_BRIGHT
	
#line 12 "print.asm"
#line 1 "over.asm"
	; Sets OVER flag in P_FLAG permanently
; Parameter: OVER flag in bit 0 of A register
#line 1 "copy_attr.asm"
	
	
#line 4 "/home/boriel/src/zxb/trunk/library-asm/copy_attr.asm"
	
	
	
COPY_ATTR:
		; Just copies current permanent attribs to temporal attribs
		; and sets print mode 
		PROC
	
		LOCAL INVERSE1
		LOCAL __REFRESH_TMP
	
	INVERSE1 EQU 02Fh
	
		ld hl, (ATTR_P)
		ld (ATTR_T), hl
	
		ld hl, FLAGS2
		call __REFRESH_TMP
		
		ld hl, P_FLAG
		call __REFRESH_TMP
	
	
__SET_ATTR_MODE:		; Another entry to set print modes. A contains (P_FLAG)
	
	
		LOCAL TABLE	
		LOCAL CONT2
	
		rra					; Over bit to carry
		ld a, (FLAGS2)
		rla					; Over bit in bit 1, Over2 bit in bit 2
		and 3				; Only bit 0 and 1 (OVER flag)
	
		ld c, a
		ld b, 0
	
		ld hl, TABLE
		add hl, bc
		ld a, (hl)
		ld (PRINT_MODE), a
	
		ld hl, (P_FLAG)
		xor a			; NOP -> INVERSE0
		bit 2, l
		jr z, CONT2
		ld a, INVERSE1 	; CPL -> INVERSE1
	
CONT2:
		ld (INVERSE_MODE), a
		ret
	
TABLE:
		nop				; NORMAL MODE
		xor (hl)		; OVER 1 MODE
		and (hl)		; OVER 2 MODE
		or  (hl)		; OVER 3 MODE 
	
#line 65 "/home/boriel/src/zxb/trunk/library-asm/copy_attr.asm"
	
__REFRESH_TMP:
		ld a, (hl)
		and 10101010b
		ld c, a
		rra
		or c
		ld (hl), a
		ret
	
		ENDP
	
#line 4 "over.asm"
	
	
OVER:
		PROC
	
		ld c, a ; saves it for later
		and 2
		ld hl, FLAGS2
		res 1, (HL)
		or (hl)
		ld (hl), a
	
		ld a, c	; Recovers previous value
		and 1	; # Convert to 0/1
		add a, a; # Shift left 1 bit for permanent
	
		ld hl, P_FLAG
		res 1, (hl)
		or (hl)
		ld (hl), a
		ret
	
	; Sets OVER flag in P_FLAG temporarily
OVER_TMP:
		ld c, a ; saves it for later
		and 2	; gets bit 1; clears carry
		rra
		ld hl, FLAGS2
		res 0, (hl)
		or (hl)
		ld (hl), a
	
		ld a, c	; Recovers previous value
		and 1
		ld hl, P_FLAG
		res 0, (hl)
		ld (hl), a
		jp __SET_ATTR_MODE
	
		ENDP
	
#line 13 "print.asm"
#line 1 "inverse.asm"
	; Sets INVERSE flag in P_FLAG permanently
; Parameter: INVERSE flag in bit 0 of A register
	
	
	
INVERSE:
		PROC
	
		and 1	; # Convert to 0/1
		add a, a; # Shift left 3 bits for permanent
		add a, a
		add a, a
		ld hl, P_FLAG
		res 3, (hl)
		or (hl)
		ld (hl), a
		ret
	
	; Sets INVERSE flag in P_FLAG temporarily
INVERSE_TMP:
		and 1
		add a, a
		add a, a; # Shift left 2 bits for temporary
		ld hl, P_FLAG
		res 2, (hl)
		or (hl)
		ld (hl), a
		jp __SET_ATTR_MODE
	
		ENDP
	
#line 14 "print.asm"
#line 1 "bold.asm"
	; Sets BOLD flag in P_FLAG permanently
; Parameter: BOLD flag in bit 0 of A register
	
	
BOLD:
		PROC
	
		and 1
		rlca
	    rlca
	    rlca
		ld hl, FLAGS2
		res 3, (HL)
		or (hl)
		ld (hl), a
		ret
	
	; Sets BOLD flag in P_FLAG temporarily
BOLD_TMP:
		and 1
		rlca
		rlca
		ld hl, FLAGS2
		res 2, (hl)
		or (hl)
		ld (hl), a
		ret
	
		ENDP
	
#line 15 "print.asm"
#line 1 "italic.asm"
	; Sets ITALIC flag in P_FLAG permanently
; Parameter: ITALIC flag in bit 0 of A register
	
	
ITALIC:
		PROC
	
		and 1
	    rrca
	    rrca
	    rrca
		ld hl, FLAGS2
		res 5, (HL)
		or (hl)
		ld (hl), a
		ret
	
	; Sets ITALIC flag in P_FLAG temporarily
ITALIC_TMP:
		and 1
		rrca
		rrca
		rrca
		rrca
		ld hl, FLAGS2
		res 4, (hl)
		or (hl)
		ld (hl), a
		ret
	
		ENDP
	
#line 16 "print.asm"
	
#line 1 "attr.asm"
	; Attribute routines
; vim:ts=4:et:sw:
	
	
	
	
	
	
	
__ATTR_ADDR:
	    ; calc start address in DE (as (32 * d) + e)
    ; Contributed by Santiago Romero at http://www.speccy.org
	    ld h, 0                     ;  7 T-States
	    ld a, d                     ;  4 T-States
	    add a, a     ; a * 2        ;  4 T-States
	    add a, a     ; a * 4        ;  4 T-States
	    ld l, a      ; HL = A * 4   ;  4 T-States
	
	    add hl, hl   ; HL = A * 8   ; 15 T-States
	    add hl, hl   ; HL = A * 16  ; 15 T-States
	    add hl, hl   ; HL = A * 32  ; 15 T-States
	    
    ld d, 18h ; DE = 6144 + E. Note: 6144 is the screen size (before attr zone)
	    add hl, de
	
	    ld de, (SCREEN_ADDR)    ; Adds the screen address
	    add hl, de
	    
	    ; Return current screen address in HL
	    ret
	
	
	; Sets the attribute at a given screen coordinate (D, E).
	; The attribute is taken from the ATTR_T memory variable
	; Used by PRINT routines
SET_ATTR:
	
	    ; Checks for valid coords
	    call __IN_SCREEN
	    ret nc
	
__SET_ATTR:
	    ; Internal __FASTCALL__ Entry used by printing routines
	    PROC 
	
	    call __ATTR_ADDR
	    ld de, (ATTR_T)    ; E = ATTR_T, D = MASK_T
	
	    ld a, d
	    and (hl)
	    ld c, a    ; C = current screen color, masked
	
	    ld a, d
	    cpl        ; Negate mask
	    and e    ; Mask current attributes
	    or c    ; Mix them
	    ld (hl), a ; Store result in screen
	    
	    ret
	    
	    ENDP
	
	
#line 18 "print.asm"
	
	; Putting a comment starting with @INIT <address> 
	; will make the compiler to add a CALL to <address>
	; It is useful for initialization routines.
	
	
__PRINT_INIT: ; To be called before program starts (initializes library)
			PROC
	
			ld hl, __PRINT_START
			ld (PRINT_JUMP_STATE), hl
	
			ld hl, 1821h
			ld (MAXX), hl  ; Sets current maxX and maxY
	
			xor a
			ld (FLAGS2), a
	
			ret
	
	
__PRINTCHAR: ; Print character store in accumulator (A register)
				 ; Modifies H'L', B'C', A'F', D'E', A
	
			LOCAL PO_GR_1
	
			LOCAL __PRCHAR
			LOCAL __PRINT_CONT
			LOCAL __PRINT_CONT2
			LOCAL __PRINT_JUMP
			LOCAL __SRCADDR
			LOCAL __PRINT_UDG
			LOCAL __PRGRAPH
			LOCAL __PRINT_START
	
	PRINT_JUMP_STATE EQU __PRINT_JUMP + 1
	
__PRINT_JUMP:
			jp __PRINT_START	; Where to jump. If we print 22 (AT), next two calls jumps to AT1 and AT2 respectively
	
__PRINT_START:
			cp ' '
			jp c, __PRINT_SPECIAL	; Characters below ' ' are special ones
	
			exx			; Switch to alternative registers
			ex af, af'		; Saves a value (char to print) for later
	
			call __LOAD_S_POSN
	
	; At this point we have the new coord
			ld hl, (SCREEN_ADDR)
	
			ld a, d
			ld c, a		; Saves it for later
			
			and 0F8h	; Masks 3 lower bit ; zy
			ld d, a
	
			ld a, c		; Recovers it
			and 07h 	; MOD 7 ; y1
			rrca
			rrca
			rrca
	
			or e
			ld e, a
			add hl, de	; HL = Screen address + DE
			ex de, hl 	; DE = Screen address
			
			ex af, af'
	
			cp 80h	; Is it an UDG or a ? 
			jp c, __SRCADDR
	
			cp 90h
			jp nc, __PRINT_UDG
	
			; Print a 8 bit pattern (80h to 8Fh)
	
			ld b, a
			call PO_GR_1 ; This ROM routine will generate the bit pattern at MEM0
			ld hl, MEM0
			jp __PRGRAPH
	
	PO_GR_1 EQU 0B38h
	
__PRINT_UDG:
			sub 90h ; Sub ASC code
			ld bc, (UDG)
			jp __PRGRAPH0
	
	__SOURCEADDR EQU (__SRCADDR + 1)	; Address of the pointer to chars source
__SRCADDR:
			ld bc, (CHARS)
	
__PRGRAPH0:
		add a, a	; A = a * 2 (since a < 80h) ; Thanks to Metalbrain at http://foro.speccy.org
			ld l, a
			ld h, 0		; HL = a * 2 (accumulator)
			add hl, hl 
			add hl, hl ; HL = a * 8
			add hl, bc ; HL = CHARS address
	
__PRGRAPH:
			ex de, hl  ; HL = Write Address, DE = CHARS address
			bit 2, (iy + $47)
			call nz, __BOLD
			bit 4, (iy + $47)
			call nz, __ITALIC
			ld b, 8 ; 8 bytes per char
__PRCHAR:
			ld a, (de) ; DE *must* be ALWAYS source, and HL destiny
	
PRINT_MODE:		; Which operation is used to write on the screen
				; Set it with:
					; LD A, <OPERATION>
					; LD (PRINT_MODE), A
					;
				; Available opertions:
				; NORMAL: 0h  --> NOP	; OVER 0
				; XOR	: AEh --> XOR (HL)		; OVER 1
				; OR	: B6h --> OR (HL)		; PUTSPRITE
				; AND   : A6h --> AND (HL)		; PUTMASK
			nop		;
	
INVERSE_MODE:	; 00 -> NOP -> INVERSE 0
			nop		; 2F -> CPL -> INVERSE 1
	
			ld (hl), a
	
			inc de 
			inc h 	; Next line
			djnz __PRCHAR	
	
			call __LOAD_S_POSN
			inc e			; COL = COL + 1
			ld hl, (MAXX)
			ld a, e
			dec l			; l = MAXX
			cp l			; Lower than max?
			jp c, __PRINT_CONT; Nothing to do
			call __PRINT_EOL1
			exx			; counteracts __PRINT_EOL1 exx
			jp __PRINT_CONT2
	
__PRINT_CONT:
			call __SAVE_S_POSN
	
__PRINT_CONT2:
			call __SET_ATTR
			exx
			ret
	
	; ------------- SPECIAL CHARS (< 32) -----------------
	
__PRINT_SPECIAL:	; Jumps here if it is a special char
			exx
			ld hl, __PRINT_TABLE
			jp JUMP_HL_PLUS_2A
	
	
PRINT_EOL:		; Called WHENEVER there is no ";" at end of PRINT sentence
			exx
	
__PRINT_0Dh:		; Called WHEN printing CHR$(13)
			call __LOAD_S_POSN
	
__PRINT_EOL1:		; Another entry called from PRINT when next line required
			ld e, 0
	
__PRINT_EOL2:
			ld a, d
			inc a
	
__PRINT_AT1_END:
			ld hl, (MAXY)
			cp l
			jr c, __PRINT_EOL_END	; Carry if (MAXY) < d
			xor a
	
__PRINT_EOL_END:
			ld d, a	
	
__PRINT_AT2_END:
			call __SAVE_S_POSN
			exx
			ret
	
__PRINT_COM:
			exx
			push hl
			push de
			push bc
			call PRINT_COMMA
			pop bc
			pop de
			pop hl
			ret
	
__PRINT_TAB:
			ld hl, __PRINT_TAB1
			jp __PRINT_SET_STATE
	
__PRINT_TAB1:
			ld (MEM0), a		 
			ld hl, __PRINT_TAB2
			ld (PRINT_JUMP_STATE), hl
			ret
	
__PRINT_TAB2:
			ld a, (MEM0)		; Load tab code (ignore the current one)
			push hl
			push de
			push bc
			ld hl, __PRINT_START
			ld (PRINT_JUMP_STATE), hl
			call PRINT_TAB
			pop bc
			pop de
			pop hl
			ret
	
__PRINT_NOP:
__PRINT_RESTART:
			ld hl, __PRINT_START
			jp __PRINT_SET_STATE
	
__PRINT_AT:
			ld hl, __PRINT_AT1
	
__PRINT_SET_STATE:
			ld (PRINT_JUMP_STATE), hl	; Saves next entry call
			exx
			ret
	
__PRINT_AT1:	; Jumps here if waiting for 1st parameter
			exx
			ld hl, __PRINT_AT2
			ld (PRINT_JUMP_STATE), hl	; Saves next entry call
			call __LOAD_S_POSN
			jp __PRINT_AT1_END
	
__PRINT_AT2:
			exx
			ld hl, __PRINT_START
			ld (PRINT_JUMP_STATE), hl	; Saves next entry call
			call __LOAD_S_POSN
			ld e, a
			ld hl, (MAXX)
			cp e
			jr c, __PRINT_AT2_END
			ld e, 0
			jp __PRINT_AT2_END
	
__PRINT_DEL:
			call __LOAD_S_POSN		; Gets current screen position
			dec e
			ld a, -1
			cp e
			jp nz, __PRINT_AT2_END
			ld hl, (MAXX)
			ld e, l
			dec e
			dec e
			dec d
			cp d
			jp nz, __PRINT_AT2_END
			ld d, h
			dec d
			jp __PRINT_AT2_END
	
__PRINT_INK:
			ld hl, __PRINT_INK2
			jp __PRINT_SET_STATE
	
__PRINT_INK2:
			exx
			call INK_TMP
			jp __PRINT_RESTART
	
__PRINT_PAP:
			ld hl, __PRINT_PAP2
			jp __PRINT_SET_STATE
			
__PRINT_PAP2:
			exx
			call PAPER_TMP
			jp __PRINT_RESTART
	
__PRINT_FLA:
			ld hl, __PRINT_FLA2
			jp __PRINT_SET_STATE
	
__PRINT_FLA2:
			exx
			call FLASH_TMP
			jp __PRINT_RESTART
	
__PRINT_BRI:
			ld hl, __PRINT_BRI2
			jp __PRINT_SET_STATE
	
__PRINT_BRI2:
			exx
			call BRIGHT_TMP
			jp __PRINT_RESTART
	
__PRINT_INV:
			ld hl, __PRINT_INV2
			jp __PRINT_SET_STATE
	
__PRINT_INV2:
			exx
			call INVERSE_TMP
			jp __PRINT_RESTART
	
__PRINT_OVR:
			ld hl, __PRINT_OVR2
			jp __PRINT_SET_STATE
	
__PRINT_OVR2:
			exx
			call OVER_TMP
			jp __PRINT_RESTART
	
__PRINT_BOLD:
			ld hl, __PRINT_BOLD2
			jp __PRINT_SET_STATE
	
__PRINT_BOLD2:
			exx
			call BOLD_TMP
			jp __PRINT_RESTART
	
__PRINT_ITA:
			ld hl, __PRINT_ITA2
			jp __PRINT_SET_STATE
	
__PRINT_ITA2:
			exx
			call ITALIC_TMP
			jp __PRINT_RESTART
	
	
__BOLD:
			push hl
			ld hl, MEM0
			ld b, 8
__BOLD_LOOP:
			ld a, (de)
			ld c, a
			rlca
			or c
			ld (hl), a
			inc hl
			inc de
			djnz __BOLD_LOOP
			pop hl
			ld de, MEM0
			ret
		    	
	
__ITALIC:
			push hl
			ld hl, MEM0
			ex de, hl
			ld bc, 8
			ldir
			ld hl, MEM0
			srl (hl)
			inc hl
			srl (hl)
			inc hl
			srl (hl)
			inc hl
			inc hl
			inc hl
			sla (hl)
			inc hl
			sla (hl)
			inc hl
			sla (hl)
			pop hl
			ld de, MEM0
			ret
	
PRINT_COMMA:
			call __LOAD_S_POSN
			ld a, e
			inc a
			and 16
			add a, 16
	
PRINT_TAB:
			PROC
			LOCAL LOOP, CONTINUE
	
			call __LOAD_S_POSN ; e = current row
			ld d, a
			ld a, e
			cp 21h
			jr nz, CONTINUE
			ld e, -1
CONTINUE:
			ld a, d
			inc e
			sub e  ; A = A - E 
			and 31 ;
			ret z  ; Already at position E
			ld b, a
LOOP:
			ld a, ' '
			call __PRINTCHAR
			djnz LOOP
			ret
			ENDP
	
PRINT_AT: ; CHanges cursor to ROW, COL
			 ; COL in A register
			 ; ROW in stack 
	
			pop hl	; Ret address
			ex (sp), hl ; callee H = ROW
			ld l, a
			ex de, hl
	
			call __IN_SCREEN
			ret nc	; Return if out of screen
	
			jp __SAVE_S_POSN
	
			LOCAL __PRINT_COM
			LOCAL __BOLD
			LOCAL __BOLD_LOOP
			LOCAL __ITALIC
			LOCAL __PRINT_EOL1
			LOCAL __PRINT_EOL2
			LOCAL __PRINT_AT1
			LOCAL __PRINT_AT2
			LOCAL __PRINT_AT2_END
			LOCAL __PRINT_BOLD
			LOCAL __PRINT_BOLD2
			LOCAL __PRINT_ITA
			LOCAL __PRINT_ITA2
			LOCAL __PRINT_INK
			LOCAL __PRINT_PAP
			LOCAL __PRINT_SET_STATE
			LOCAL __PRINT_TABLE
			LOCAL __PRINT_TAB, __PRINT_TAB1, __PRINT_TAB2
				
__PRINT_TABLE:	; Jump table for 0 .. 22 codes
			
			DW __PRINT_NOP	;  0
			DW __PRINT_NOP	;  1
			DW __PRINT_NOP	;  2
			DW __PRINT_NOP	;  3
			DW __PRINT_NOP	;  4
			DW __PRINT_NOP	;  5
			DW __PRINT_COM	;  6 COMMA
			DW __PRINT_NOP	;  7
			DW __PRINT_DEL	;  8 DEL
			DW __PRINT_NOP	;  9
			DW __PRINT_NOP	; 10
			DW __PRINT_NOP	; 11
			DW __PRINT_NOP	; 12
			DW __PRINT_0Dh	; 13
			DW __PRINT_BOLD	; 14
			DW __PRINT_ITA	; 15
			DW __PRINT_INK	; 16
			DW __PRINT_PAP	; 17
			DW __PRINT_FLA	; 18
			DW __PRINT_BRI	; 19
			DW __PRINT_INV	; 20
			DW __PRINT_OVR	; 21
			DW __PRINT_AT	; 22 AT
			DW __PRINT_TAB  ; 23 TAB
	
			ENDP
			
	
#line 771 "dark3.bas"
	
#line 1 "mulf.asm"
#line 1 "stackf.asm"
	; -------------------------------------------------------------
	; Functions to manage FP-Stack of the ZX Spectrum ROM CALC
	; -------------------------------------------------------------
	
	
	__FPSTACK_PUSH EQU 2AB6h	; Stores an FP number into the ROM FP stack (A, ED CB)
	__FPSTACK_POP  EQU 2BF1h	; Pops an FP number out of the ROM FP stack (A, ED CB)
	
__FPSTACK_PUSH2: ; Pushes Current A ED CB registers and top of the stack on (SP + 4)
	                 ; Second argument to push into the stack calculator is popped out of the stack
	                 ; Since the caller routine also receives the parameters into the top of the stack
	                 ; For bytes must be removed from SP before pop them out
	
	    call __FPSTACK_PUSH ; Pushes A ED CB into the FP-STACK
	    exx
	    pop hl       ; Caller-Caller return addr
	    exx
	    pop hl       ; Caller return addr
	
	    pop af
	    pop de
	    pop bc
	
	    push hl      ; Caller return addr
	    exx
	    push hl      ; Caller-Caller return addr
	    exx
	 
	    jp __FPSTACK_PUSH
	
	
__FPSTACK_I16:	; Pushes 16 bits integer in HL into the FP ROM STACK
					; This format is specified in the ZX 48K Manual
					; You can push a 16 bit signed integer as
					; 0 SS LL HH 0, being SS the sign and LL HH the low
					; and High byte respectively
		ld a, h
		rla			; sign to Carry
		sbc	a, a	; 0 if positive, FF if negative
		ld e, a
		ld d, l
		ld c, h
		xor a
		ld b, a
		jp __FPSTACK_PUSH
#line 2 "mulf.asm"
	
	; -------------------------------------------------------------
	; Floating point library using the FP ROM Calculator (ZX 48K)
	; All of them uses A EDCB registers as 1st paramter.
	; For binary operators, the 2n operator must be pushed into the
	; stack, in the order A DE BC.
	;
	; Uses CALLEE convention
	; -------------------------------------------------------------
	
__MULF:	; Multiplication
		call __FPSTACK_PUSH2
		
		; ------------- ROM MUL
		rst 28h
		defb 04h	; 
		defb 38h;   ; END CALC
	
		jp __FPSTACK_POP
	
#line 773 "dark3.bas"
	
#line 1 "random.asm"
	; RANDOM functions
	
#line 1 "mul32.asm"
#line 1 "_mul32.asm"
	
; Ripped from: http://www.andreadrian.de/oldcpu/z80_number_cruncher.html#moztocid784223
	; Used with permission.
	; Multiplies 32x32 bit integer (DEHL x D'E'H'L')
	; 64bit result is returned in H'L'H L B'C'A C
	
	
__MUL32_64START:
			push hl
			exx
			ld b, h
			ld c, l		; BC = Low Part (A)
			pop hl		; HL = Load Part (B)
			ex de, hl	; DE = Low Part (B), HL = HightPart(A) (must be in B'C')
			push hl
	
			exx
			pop bc		; B'C' = HightPart(A)
			exx			; A = B'C'BC , B = D'E'DE
	
				; multiply routine 32 * 32bit = 64bit
				; h'l'hlb'c'ac = b'c'bc * d'e'de
				; needs register a, changes flags
				;
				; this routine was with tiny differences in the
				; sinclair zx81 rom for the mantissa multiply
	
__LMUL:
	        and     a               ; reset carry flag
	        sbc     hl,hl           ; result bits 32..47 = 0
	        exx
	        sbc     hl,hl           ; result bits 48..63 = 0
	        exx
	        ld      a,b             ; mpr is b'c'ac
	        ld      b,33            ; initialize loop counter
	        jp      __LMULSTART  
	
__LMULLOOP:
	        jr      nc,__LMULNOADD  ; JP is 2 cycles faster than JR. Since it's inside a LOOP
	                                ; it can save up to 33 * 2 = 66 cycles
	                                ; But JR if 3 cycles faster if JUMP not taken!
	        add     hl,de           ; result += mpd
	        exx
	        adc     hl,de
	        exx
	
__LMULNOADD:
	        exx
	        rr      h               ; right shift upper
	        rr      l               ; 32bit of result
	        exx
	        rr      h
	        rr      l
	
__LMULSTART:
	        exx
	        rr      b               ; right shift mpr/
	        rr      c               ; lower 32bit of result
	        exx
	        rra                     ; equivalent to rr a
	        rr      c
	        djnz    __LMULLOOP
	
			ret						; result in h'l'hlb'c'ac
	       
#line 2 "mul32.asm"
	
__MUL32:	; multiplies 32 bit un/signed integer.
				; First operand stored in DEHL, and 2nd onto stack
				; Lowest part of 2nd operand on top of the stack
				; returns the result in DE.HL
			exx
			pop hl	; Return ADDRESS
			pop de	; Low part
			ex (sp), hl ; CALLEE -> HL = Hight part
			ex de, hl
			call __MUL32_64START
	
__TO32BIT:  ; Converts H'L'HLB'C'AC to DEHL (Discards H'L'HL)
			exx
			push bc
			exx
			pop de
			ld h, a
			ld l, c
			ret
	
	
#line 4 "random.asm"
	
RANDOMIZE:
		; Randomize with 32 bit seed in DE HL
		; if SEED = 0, calls ROM to take frames as seed
		PROC
	
		LOCAL TAKE_FRAMES
		LOCAL FRAMES
		
		ld a, h
		or l
		or d
		or e
		jr z, TAKE_FRAMES
	
		ld (RANDOM_SEED_LOW), hl
		ld (RANDOM_SEED_HIGH), de
		ret
	
TAKE_FRAMES:
		; Takes the seed from frames
		ld hl, (FRAMES)
		ld (RANDOM_SEED_LOW), hl
		ld hl, (FRAMES + 2)
		ld (RANDOM_SEED_HIGH), hl
		ret
	
	FRAMES EQU	23672
		ENDP
	
RANDOM_SEED_HIGH:	; RANDOM seed, 16 higher bits
		DEFW 0000h		; HIGH RANDOM SEED
	
	RANDOM_SEED_LOW 	EQU 23670	; RANDOM seed, 16 lower bits
	
	
RAND:
		; Returns a 32 bit random integer based on seed.
		; This is a very fast and interesting generator
		; See Numerical Recipes, 2nd ED
	
		ld de, 25
		ld hl, 26125
		push de
		push hl		; PUSH 32bit value 1664525
	
		ld de, (RANDOM_SEED_HIGH)
		ld hl, (RANDOM_SEED_LOW)
		call __MUL32	; DE HL = 166425 * SEED
	
		ld bc, 62303	; DEHL = 1013904223 = 15470 * 65536 + 62303
		add hl, bc
		ld (RANDOM_SEED_LOW), hl
	
		ex de, hl
		ld bc, 15470
		adc hl, bc
		ld (RANDOM_SEED_HIGH), hl
		ex de, hl
		ret
	
RND:
		; Returns a FLOATING point integer
		; using RAND as a mantissa
		PROC
		LOCAL RND_LOOP
		LOCAL RND_END
	
		call RAND	
		ld a, d	
		or e
		or h
		or l
	    ld b, h
		ld c, l
		ret z		; Return 0 if 0
	
		; We already have a random 32 bit mantissa in ED CB
		ld l, 81h	; Exponent
		set 7, e	; Recover highest mantissa bit
		; At this point we have 1 .. 2) FP number;
		; We subtract 1 to obtain the 0..1) Range
	
		; To subtract 1, we only have to subtract the highest byte (40h)
		ld a, e
		sub	40h
		ld e, a
	
		; Now we must shift left until highest bit is 1
RND_LOOP:
		dec l
		sla b
		rl c
		rl d
		rla
		jp p, RND_LOOP	; Loop if bit 7 is not one
	
RND_END:
		and 7Fh		; Clear highest bit (positive sign)
		ld e, a
	    ld a, l     ; saves exponent in A
		ret
	
		ENDP
	
#line 775 "dark3.bas"
#line 1 "string.asm"
	; String library
	
#line 1 "free.asm"
; vim: ts=4:et:sw=4:
	; Copyleft (K) by Jose M. Rodriguez de la Rosa
	;  (a.k.a. Boriel) 
;  http://www.boriel.com
	;
	; This ASM library is licensed under the BSD license
	; you can use it for any purpose (even for commercial
	; closed source programs).
	;
	; Please read the BSD license on the internet
	
	; ----- IMPLEMENTATION NOTES ------
	; The heap is implemented as a linked list of free blocks.
	
; Each free block contains this info:
	; 
	; +----------------+ <-- HEAP START 
	; | Size (2 bytes) |
	; |        0       | <-- Size = 0 => DUMMY HEADER BLOCK
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   | <-- If Size > 4, then this contains (size - 4) bytes
	; | (0 if Size = 4)|   |
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   |
	; | (0 if Size = 4)|   |
	; +----------------+   |
	;   <Allocated>        | <-- This zone is in use (Already allocated)
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   |
	; | (0 if Size = 4)|   |
	; +----------------+ <-+ 
	; | Next (2 bytes) |--> NULL => END OF LIST
	; |    0 = NULL    |
	; +----------------+
	; | <free bytes...>|
	; | (0 if Size = 4)|
	; +----------------+
	
	
	; When a block is FREED, the previous and next pointers are examined to see
	; if we can defragment the heap. If the block to be breed is just next to the
	; previous, or to the next (or both) they will be converted into a single
	; block (so defragmented).
	
	
	;   MEMORY MANAGER
	;
	; This library must be initialized calling __MEM_INIT with 
	; HL = BLOCK Start & DE = Length.
	
	; An init directive is useful for initialization routines.
	; They will be added automatically if needed.
	
#line 1 "heapinit.asm"
; vim: ts=4:et:sw=4:
	; Copyleft (K) by Jose M. Rodriguez de la Rosa
	;  (a.k.a. Boriel) 
;  http://www.boriel.com
	;
	; This ASM library is licensed under the BSD license
	; you can use it for any purpose (even for commercial
	; closed source programs).
	;
	; Please read the BSD license on the internet
	
	; ----- IMPLEMENTATION NOTES ------
	; The heap is implemented as a linked list of free blocks.
	
; Each free block contains this info:
	; 
	; +----------------+ <-- HEAP START 
	; | Size (2 bytes) |
	; |        0       | <-- Size = 0 => DUMMY HEADER BLOCK
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   | <-- If Size > 4, then this contains (size - 4) bytes
	; | (0 if Size = 4)|   |
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   |
	; | (0 if Size = 4)|   |
	; +----------------+   |
	;   <Allocated>        | <-- This zone is in use (Already allocated)
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   |
	; | (0 if Size = 4)|   |
	; +----------------+ <-+ 
	; | Next (2 bytes) |--> NULL => END OF LIST
	; |    0 = NULL    |
	; +----------------+
	; | <free bytes...>|
	; | (0 if Size = 4)|
	; +----------------+
	
	
	; When a block is FREED, the previous and next pointers are examined to see
	; if we can defragment the heap. If the block to be breed is just next to the
	; previous, or to the next (or both) they will be converted into a single
	; block (so defragmented).
	
	
	;   MEMORY MANAGER
	;
	; This library must be initialized calling __MEM_INIT with 
	; HL = BLOCK Start & DE = Length.
	
	; An init directive is useful for initialization routines.
	; They will be added automatically if needed.
	
	
	
	
	; ---------------------------------------------------------------------
	;  __MEM_INIT must be called to initalize this library with the
	; standard parameters
	; ---------------------------------------------------------------------
__MEM_INIT: ; Initializes the library using (RAMTOP) as start, and
	        ld hl, ZXBASIC_MEM_HEAP  ; Change this with other address of heap start
	        ld de, ZXBASIC_HEAP_SIZE ; Change this with your size
	
	; ---------------------------------------------------------------------
	;  __MEM_INIT2 initalizes this library 
; Parameters:
;   HL : Memory address of 1st byte of the memory heap
;   DE : Length in bytes of the Memory Heap
	; ---------------------------------------------------------------------
__MEM_INIT2:     
	        ; HL as TOP            
	        PROC
	
	        dec de
	        dec de
	        dec de
	        dec de        ; DE = length - 4; HL = start
	        ; This is done, because we require 4 bytes for the empty dummy-header block
	
	        xor a
	        ld (hl), a
	        inc hl
        ld (hl), a ; First "free" block is a header: size=0, Pointer=&(Block) + 4
	        inc hl
	
	        ld b, h
	        ld c, l
	        inc bc
	        inc bc      ; BC = starts of next block
	
	        ld (hl), c
	        inc hl
	        ld (hl), b
	        inc hl      ; Pointer to next block
	
	        ld (hl), e
	        inc hl
	        ld (hl), d
	        inc hl      ; Block size (should be length - 4 at start); This block contains all the available memory
	
	        ld (hl), a ; NULL (0000h) ; No more blocks (a list with a single block)
	        inc hl
	        ld (hl), a
	
	        ld a, 201
	        ld (__MEM_INIT), a; "Pokes" with a RET so ensure this routine is not called again
	        ret
	
	        ENDP
	
#line 69 "free.asm"
	
	; ---------------------------------------------------------------------
	; MEM_FREE
	;  Frees a block of memory
	;
; Parameters:
	;  HL = Pointer to the block to be freed. If HL is NULL (0) nothing
	;  is done
	; ---------------------------------------------------------------------
	
MEM_FREE:
__MEM_FREE: ; Frees the block pointed by HL
	            ; HL DE BC & AF modified
	        PROC
	
	        LOCAL __MEM_LOOP2
	        LOCAL __MEM_LINK_PREV
	        LOCAL __MEM_JOIN_TEST
	        LOCAL __MEM_BLOCK_JOIN
	
	        ld a, h
	        or l
	        ret z       ; Return if NULL pointer
	
	        dec hl
	        dec hl
	        ld b, h
	        ld c, l    ; BC = Block pointer
	
	        ld hl, ZXBASIC_MEM_HEAP  ; This label point to the heap start
	
__MEM_LOOP2:
	        inc hl
	        inc hl     ; Next block ptr
	
	        ld e, (hl)
	        inc hl
	        ld d, (hl) ; Block next ptr
	        ex de, hl  ; DE = &(block->next); HL = block->next
	
	        ld a, h    ; HL == NULL?
	        or l
	        jp z, __MEM_LINK_PREV; if so, link with previous
	
	        or a       ; Clear carry flag
	        sbc hl, bc ; Carry if BC > HL => This block if before
	        add hl, bc ; Restores HL, preserving Carry flag
	        jp c, __MEM_LOOP2 ; This block is before. Keep searching PASS the block
	
	;------ At this point current HL is PAST BC, so we must link (DE) with BC, and HL in BC->next
	
__MEM_LINK_PREV:    ; Link (DE) with BC, and BC->next with HL
	        ex de, hl
	        push hl
	        dec hl
	
	        ld (hl), c
	        inc hl
	        ld (hl), b ; (DE) <- BC
	
	        ld h, b    ; HL <- BC (Free block ptr)
	        ld l, c
	        inc hl     ; Skip block length (2 bytes)
	        inc hl
	        ld (hl), e ; Block->next = DE
	        inc hl
	        ld (hl), d
	        ; --- LINKED ; HL = &(BC->next) + 2
	
	        call __MEM_JOIN_TEST
	        pop hl
	
__MEM_JOIN_TEST:   ; Checks for fragmented contiguous blocks and joins them
	                   ; hl = Ptr to current block + 2
	        ld d, (hl)
	        dec hl
	        ld e, (hl)
	        dec hl     
	        ld b, (hl) ; Loads block length into BC
	        dec hl
	        ld c, (hl) ;
	        
	        push hl    ; Saves it for later
	        add hl, bc ; Adds its length. If HL == DE now, it must be joined
	        or a
	        sbc hl, de ; If Z, then HL == DE => We must join
	        pop hl
	        ret nz
	
__MEM_BLOCK_JOIN:  ; Joins current block (pointed by HL) with next one (pointed by DE). HL->length already in BC
	        push hl    ; Saves it for later
	        ex de, hl
	        
	        ld e, (hl) ; DE -> block->next->length
	        inc hl
	        ld d, (hl)
	        inc hl
	
	        ex de, hl  ; DE = &(block->next)
	        add hl, bc ; HL = Total Length
	
	        ld b, h
	        ld c, l    ; BC = Total Length
	
	        ex de, hl
	        ld e, (hl)
	        inc hl
	        ld d, (hl) ; DE = block->next
	
	        pop hl     ; Recovers Pointer to block
	        ld (hl), c
	        inc hl
	        ld (hl), b ; Length Saved
	        inc hl
	        ld (hl), e
	        inc hl
	        ld (hl), d ; Next saved
	        ret
	
	        ENDP
	
#line 4 "string.asm"
	
__STR_ISNULL:	; Returns A = FF if HL is 0, 0 otherwise
			ld a, h
			or l
			sub 1		; Only CARRY if HL is NULL
			sbc a, a	; Only FF if HL is NULL (0 otherwise)
			ret
	
	
__STRCMP:	; Compares strings at HL, DE: Returns 0 if EQual, -1 if HL < DE, +1 if HL > DE
				; A register is preserved and returned in A'
			PROC ; __FASTCALL__
	
			LOCAL __STRCMPZERO
			LOCAL __STRCMPEXIT
			LOCAL __STRCMPLOOP
			LOCAL __NOPRESERVEBC
			LOCAL __EQULEN
			LOCAL __EQULEN1
			LOCAL __HLZERO
	
			ex af, af'	; Saves current A register in A' (it's used by STRXX comparison functions)
	
			ld a, h
			or l
			jr z, __HLZERO
	
			ld a, d
			or e
			ld a, 1
			ret z		; Returns +1 if HL is not NULL and DE is NULL
	
			ld c, (hl)
			inc hl
			ld b, (hl)
			inc hl		; BC = LEN(a$)
			push hl		; HL = &a$, saves it
	
			ex de, hl
			ld e, (hl)
			inc hl
			ld d, (hl)
			inc hl
			ex de, hl	; HL = LEN(b$), de = &b$
	
			; At this point Carry is cleared, and A reg. = 1
			sbc hl, bc	; Carry if len(b$) > len(a$)
			jr z, __EQULEN	; Jump if they have the same length so A reg. = 0
			jr c, __EQULEN1 ; Jump if len(b$) > len(a$) so A reg. = 1
__NOPRESERVEBC:
			add hl, bc	; Restore HL (original length)
			ld b, h		; len(b$) <= len(a$)
			ld c, l		; so BC = hl
			dec a		; At this point A register = 0, it must be -1 since len(a$) > len(b$)	
__EQULEN:
			dec a		; A = 0 if len(a$) = len(b$), -1 otherwise
__EQULEN1:
			pop hl		; Recovers A$ pointer
			push af		; Saves A for later (Value to return if strings reach the end)
	        ld a, b
	        or c
	        jr z, __STRCMPZERO ; empty string being compared
	
		; At this point: BC = lesser length, DE and HL points to b$ and a$ chars respectively
__STRCMPLOOP:
			ld a, (de)
			cpi
			jr nz, __STRCMPEXIT ; (HL) != (DE). Examine carry
			jp po, __STRCMPZERO ; END of string (both are equal)
			inc de
			jp __STRCMPLOOP
	
__STRCMPZERO:
			pop af		; This is -1 if len(a$) < len(b$), +1 if len(b$) > len(a$), 0 otherwise
			ret
	
__STRCMPEXIT:		; Sets A with the following value
			dec hl		; Get back to the last char
			cp (hl)
			sbc a, a	; A = -1 if carry => (DE) < (HL); 0 otherwise (DE) > (HL)
			cpl			; A = -1 if (HL) < (DE), 0 otherwise
			add a, a    ; A = A * 2 (thus -2 or 0)
			inc a		; A = A + 1 (thus -1 or 1)
	
			pop bc		; Discard top of the stack
			ret
	
__HLZERO:
			or d
			or e
			ret z		; Returns 0 (EQ) if HL == DE == NULL
			ld a, -1
			ret			; Returns -1 if HL is NULL and DE is not NULL
	
			ENDP
	
			; The following routines perform string comparison operations (<, >, ==, etc...)
			; On return, A will contain 0 for False, other value for True
			; Register A' will determine whether the incoming strings (HL, DE) will be freed
		; from dynamic memory on exit:
			;		Bit 0 => 1 means HL will be freed.
			;		Bit 1 => 1 means DE will be freed.
	
__STREQ:	; Compares a$ == b$ (HL = ptr a$, DE = ptr b$). Returns FF (True) or 0 (False)
			push hl
			push de
			call __STRCMP
			pop de
			pop hl
	
			;inc a		; If A == -1, return 0
			;jp z, __FREE_STR 
		
			;dec a		; 
			;dec a		; Return -1 if a = 0 (True), returns 0 if A == 1 (False)
	        sub 1
	        sbc a, a
			jp __FREE_STR
	
	
__STRNE:	; Compares a$ != b$ (HL = ptr a$, DE = ptr b$). Returns FF (True) or 0 (False)
			push hl
			push de
			call __STRCMP
			pop de
			pop hl
	
			;jp z, __FREE_STR 
	
			;ld a, 0FFh	; Returns 0xFFh (True)
			jp __FREE_STR
	
	
__STRLT:	; Compares a$ < b$ (HL = ptr a$, DE = ptr b$). Returns FF (True) or 0 (False)
			push hl
			push de
			call __STRCMP
			pop de
			pop hl
	
			jp z, __FREE_STR ; Returns 0 if A == B
	
			dec a		; Returns 0 if A == 1 => a$ > b$
			;jp z, __FREE_STR 
	
			;inc a		; A = FE now (-2). Set it to FF and return
			jp __FREE_STR
	
	
__STRLE:	; Compares a$ <= b$ (HL = ptr a$, DE = ptr b$). Returns FF (True) or 0 (False)
			push hl
			push de
			call __STRCMP
			pop de
			pop hl
	
			dec a		; Returns 0 if A == 1 => a$ < b$
			;jp z, __FREE_STR 
	
			;ld a, 0FFh	; A = FE now (-2). Set it to FF and return
			jp __FREE_STR
	
	
__STRGT:	; Compares a$ > b$ (HL = ptr a$, DE = ptr b$). Returns FF (True) or 0 (False)
			push hl
			push de
			call __STRCMP
			pop de
			pop hl
	
			jp z, __FREE_STR		; Returns 0 if A == B
	
			inc a		; Returns 0 if A == -1 => a$ < b$
			;jp z, __FREE_STR		; Returns 0 if A == B
	
			;ld a, 0FFh	; A = FE now (-2). Set it to FF and return
			jp __FREE_STR
	
	
__STRGE:	; Compares a$ >= b$ (HL = ptr a$, DE = ptr b$). Returns FF (True) or 0 (False)
			push hl
			push de
			call __STRCMP
			pop de
			pop hl
	
			inc a		; Returns 0 if A == -1 => a$ < b$
			;jr z, __FREE_STR
	
			;ld a, 0FFh	; A = FE now (-2). Set it to FF and return
	
__FREE_STR: ; This exit point will test A' for bits 0 and 1
				; If bit 0 is 1 => Free memory from HL pointer
				; If bit 1 is 1 => Free memory from DE pointer
				; Finally recovers A, to return the result
			PROC
	
			LOCAL __FREE_STR2
			LOCAL __FREE_END
	
			ex af, af'
			bit 0, a
			jr z, __FREE_STR2
	
			push af
			push de
			call __MEM_FREE
			pop de
			pop af
	
__FREE_STR2:
			bit 1, a
			jr z, __FREE_END
	
			ex de, hl
			call __MEM_FREE
	
__FREE_END:
			ex af, af'
			ret
			
			ENDP
	
#line 776 "dark3.bas"
#line 1 "border.asm"
	; __FASTCALL__ Routine to change de border
	; Parameter (color) specified in A register
	
	BORDER EQU 229Bh
	
	; Nothing to do! (Directly from the ZX Spectrum ROM)
	
#line 777 "dark3.bas"
	
#line 1 "printstr.asm"
	
	
	
	
	
	; PRINT command routine
	; Prints string pointed by HL
	
PRINT_STR:
__PRINTSTR:		; __FASTCALL__ Entry to print_string
			PROC
			LOCAL __PRINT_STR_LOOP
	        LOCAL __PRINT_STR_END
	
	        ld d, a ; Saves A reg (Flag) for later
	
			ld a, h
			or l
			ret z	; Return if the pointer is NULL
	
	        push hl
	
			ld c, (hl)
			inc hl
			ld b, (hl)
			inc hl	; BC = LEN(a$); HL = &a$
	
__PRINT_STR_LOOP:
			ld a, b
			or c
			jr z, __PRINT_STR_END 	; END if BC (counter = 0)
	
			ld a, (hl)
			call __PRINTCHAR
			inc hl
			dec bc
			jp __PRINT_STR_LOOP
	
__PRINT_STR_END:
	        pop hl
	        ld a, d ; Recovers A flag
	        or a   ; If not 0 this is a temporary string. Free it
	        ret z
	        jp __MEM_FREE ; Frees str from heap and return from there
	
__PRINT_STR:
	        ; Fastcall Entry
	        ; It ONLY prints strings
	        ; HL = String start
	        ; BC = String length (Number of chars)
	        push hl ; Push str address for later
	        ld d, a ; Saves a FLAG
	        jp __PRINT_STR_LOOP
	
			ENDP
	
#line 779 "dark3.bas"
	
#line 1 "array.asm"
	; Simple array Index routine
	; Number of total indexes dimensions - 1 at beginning of memory
	; HL = Start of array memory (First two bytes contains N-1 dimensions)
	; Dimension values on the stack, (top of the stack, highest dimension)
	; E.g. A(2, 4) -> PUSH <4>; PUSH <2>
	
	; For any array of N dimension A(aN-1, ..., a1, a0)
	; and dimensions D[bN-1, ..., b1, b0], the offset is calculated as
	; O = [a0 + b0 * (a1 + b1 * (a2 + ... bN-2(aN-1)))]
; What I will do here is to calculate the following sequence:
	; ((aN-1 * bN-2) + aN-2) * bN-3 + ...
	
	
#line 1 "mul16.asm"
__MUL16:	; Mutiplies HL with the last value stored into de stack
				; Works for both signed and unsigned
	
			PROC
	
			LOCAL __MUL16LOOP
	        LOCAL __MUL16NOADD
			
			ex de, hl
			pop hl		; Return address
			ex (sp), hl ; CALLEE caller convention
	
;;__MUL16_FAST:	; __FASTCALL ENTRY: HL = 1st operand, DE = 2nd Operand
	;;		ld c, h
	;;		ld a, l	 ; C,A => 1st Operand
	;;
	;;		ld hl, 0 ; Accumulator
	;;		ld b, 16
	;;
;;__MUL16LOOP:
	;;		sra c	; C,A >> 1  (Arithmetic)
	;;		rra
	;;
	;;		jr nc, __MUL16NOADD
	;;		add hl, de
	;;
;;__MUL16NOADD:
	;;		sla e
	;;		rl d
	;;			
	;;		djnz __MUL16LOOP
	
__MUL16_FAST:
	        ld b, 16
	        ld a, d
	        ld c, e
	        ex de, hl
	        ld hl, 0
	
__MUL16LOOP:
	        add hl, hl  ; hl << 1
	        sla c
	        rla         ; a,c << 1
	        jp nc, __MUL16NOADD
	        add hl, de
	
__MUL16NOADD:
	        djnz __MUL16LOOP
	
			ret	; Result in hl (16 lower bits)
	
			ENDP
	
#line 15 "array.asm"
	
#line 19 "/home/boriel/src/zxb/trunk/library-asm/array.asm"
	
__ARRAY:
		PROC
	
		LOCAL LOOP
		LOCAL ARRAY_END
		LOCAL RET_ADDRESS ; Stores return address
	
		pop de		; Return address
		ld (RET_ADDRESS), de ; Stores it for later
	
		push hl		; Indexes pointer goes to H'L'
		exx
		pop hl		; Will use H'L' as the pointer
		ld c, (hl)	; Loads Number of dimensions from (hl)
		inc hl
		ld b, (hl)
		inc hl		; Ready
		exx
			
		ld hl, 0	; BC = Offset "accumulator"
	
#line 44 "/home/boriel/src/zxb/trunk/library-asm/array.asm"
	
LOOP:
		pop bc		; Get next index (Ai) from the stack
	
#line 56 "/home/boriel/src/zxb/trunk/library-asm/array.asm"
	
		add hl, bc	; Adds current index
	
		exx			; Checks if B'C' = 0
		ld a, b		; Which means we must exit (last element is not multiplied by anything)
		or c
		jr z, ARRAY_END		; if B'Ci == 0 we are done
	
		ld e, (hl)			; Loads next dimension into D'E'
		inc hl
		ld d, (hl)
		inc hl
		push de
		dec bc				; Decrements loop counter
		exx
		pop de				; DE = Max bound Number (i-th dimension)
	
#line 76 "/home/boriel/src/zxb/trunk/library-asm/array.asm"
		;call __MUL16_FAST	; HL *= DE
	    call __FNMUL
#line 82 "/home/boriel/src/zxb/trunk/library-asm/array.asm"
		jp LOOP
		
ARRAY_END:
		ld e, (hl)
		inc hl
		ld d, c			; C = 0 => DE = E = Element size
		push hl
		push de
		exx
	
#line 96 "/home/boriel/src/zxb/trunk/library-asm/array.asm"
	    LOCAL ARRAY_SIZE_LOOP
	
	    ex de, hl
	    ld hl, 0
	    pop bc
	    ld b, c
ARRAY_SIZE_LOOP: 
	    add hl, de
	    djnz ARRAY_SIZE_LOOP
	
	    ;; Even faster
	    ;pop bc
	
	    ;ld d, h
	    ;ld e, l
	    
	    ;dec c
	    ;jp z, __ARRAY_FIN
	
	    ;add hl, hl
	    ;dec c
	    ;jp z, __ARRAY_FIN
	
	    ;add hl, hl
	    ;dec c
	    ;dec c
	    ;jp z, __ARRAY_FIN
	
	    ;add hl, de
    ;__ARRAY_FIN:    
#line 127 "/home/boriel/src/zxb/trunk/library-asm/array.asm"
	
		pop de
		add hl, de  ; Adds element start
	
		ld de, (RET_ADDRESS)
		push de
		ret			; HL = (Start of Elements + Offset)
	
	    ;; Performs a faster multiply for little 16bit numbs
	    LOCAL __FNMUL, __FNMUL2
	
__FNMUL:
	    xor a
	    or d
	    jp nz, __MUL16_FAST
	
	    or e
	    ex de, hl
	    ret z
	
	    cp 33
	    jp nc, __MUL16_FAST
	
	    ld b, l
	    ld l, h  ; HL = 0
	
__FNMUL2:
	    add hl, de
	    djnz __FNMUL2
	    ret
	
	RET_ADDRESS	EQU	23563	; DEFADD variable. 
	
		ENDP
		
#line 781 "dark3.bas"
	
	
	
#line 1 "plot.asm"
	; MIXED __FASTCAL__ / __CALLE__ PLOT Function
	; Plots a point into the screen calling the ZX ROM PLOT routine
	
	; Y in A (accumulator)
	; X in top of the stack
	
	
	
	
	
PLOT:
		PROC
	
		LOCAL PLOT_SUB
		LOCAL PIXEL_ADDR
		LOCAL COORDS
		LOCAL __PLOT_ERR
	    LOCAL P_FLAG
	    LOCAL __PLOT_OVER1
	
	P_FLAG EQU 23697
	
		pop hl
		ex (sp), hl ; Callee
	
		ld b, a
		ld c, h	
	
		ld a, 191
		cp b
		jr c, __PLOT_ERR ; jr is faster here (#1)
	
__PLOT:			; __FASTCALL__ entry (b, c) = pixel coords (y, x)
		ld (COORDS), bc	; Saves current point
		ld a, 191 ; Max y coord
		call PIXEL_ADDR
	    res 6, h    ; Starts from 0
	    ld bc, (SCREEN_ADDR)
	    add hl, bc  ; Now current offset
	
	    ld b, a
	    inc b
	    ld a, 0FEh
	LOCAL __PLOT_LOOP
__PLOT_LOOP:
	    rrca
	    djnz __PLOT_LOOP
	
	    ld b, a
	    ld a, (P_FLAG)
	    ld c, a
	    ld a, (hl)
	    bit 0, c        ; is it OVER 1
	    jr nz, __PLOT_OVER1
	    and b
	
__PLOT_OVER1:
	    bit 2, c        ; is it inverse 1
	    jr nz, __PLOT_END
	
	    xor b
	    cpl
	
	LOCAL __PLOT_END
__PLOT_END:
	    ld (hl), a
	
	;; gets ATTR position with offset given in SCREEN_ADDR
	    ld a, h
	    rrca
	    rrca
	    rrca
	    and 3
	    or 18h
	    ld h, a
	    ld de, (SCREEN_ADDR)
	    add hl, de  ;; Final screen addr
	
	LOCAL PO_ATTR_2
	PO_ATTR_2 EQU 0BE4h  ; Another entry to PO_ATTR
	    jp PO_ATTR_2   ; This will update attr accordingly. Beware, uses IY
	
__PLOT_ERR:
	    jp __OUT_OF_SCREEN_ERR ; Spent 3 bytes, but saves 3 T-States at (#1)
	
	PLOT_SUB EQU 22ECh
	PIXEL_ADDR EQU 22ACh 
	COORDS EQU 5C7Dh
		ENDP
#line 785 "dark3.bas"
#line 1 "ftou32reg.asm"
#line 1 "neg32.asm"
__ABS32:
		bit 7, d
		ret z
	
__NEG32: ; Negates DEHL (Two's complement)
		ld a, l
		cpl
		ld l, a
	
		ld a, h
		cpl
		ld h, a
	
		ld a, e
		cpl
		ld e, a
		
		ld a, d
		cpl
		ld d, a
	
		inc l
		ret nz
	
		inc h
		ret nz
	
		inc de
		ret
	
#line 2 "ftou32reg.asm"
	
__FTOU32REG:	; Converts a Float to (un)signed 32 bit integer (NOTE: It's ALWAYS 32 bit signed)
					; Input FP number in A EDCB (A exponent, EDCB mantissa)
				; Output: DEHL 32 bit number (signed)
		PROC
	
		LOCAL __IS_FLOAT
	
		or a
		jr nz, __IS_FLOAT 
		; Here if it is a ZX ROM Integer
	
		ld h, c
		ld l, d
	ld a, e	 ; Takes sign: FF = -, 0 = +
		ld de, 0
		inc a
		jp z, __NEG32	; Negates if negative
		ret
	
__IS_FLOAT:  ; Jumps here if it is a true floating point number
		ld h, e	
		push hl  ; Stores it for later (Contains Sign in H)
	
		push de
		push bc
	
		exx
		pop de   ; Loads mantissa into C'B' E'D' 
		pop bc	 ; 
	
		set 7, c ; Highest mantissa bit is always 1
		exx
	
		ld hl, 0 ; DEHL = 0
		ld d, h
		ld e, l
	
		;ld a, c  ; Get exponent
		sub 128  ; Exponent -= 128
		jr z, __FTOU32REG_END	; If it was <= 128, we are done (Integers must be > 128)
		jr c, __FTOU32REG_END	; It was decimal (0.xxx). We are done (return 0)
	
		ld b, a  ; Loop counter = exponent - 128
	
__FTOU32REG_LOOP:
		exx 	 ; Shift C'B' E'D' << 1, output bit stays in Carry
		sla d
		rl e
		rl b
		rl c
	
	    exx		 ; Shift DEHL << 1, inserting the carry on the right
		rl l
		rl h
		rl e
		rl d
	
		djnz __FTOU32REG_LOOP
	
__FTOU32REG_END:
		pop af   ; Take the sign bit
		or a	 ; Sets SGN bit to 1 if negative
		jp m, __NEG32 ; Negates DEHL
		
		ret
	
		ENDP
	
	
__FTOU8:	; Converts float in C ED LH to Unsigned byte in A
		call __FTOU32REG
		ld a, l
		ret
	
#line 786 "dark3.bas"
#line 1 "inkey.asm"
	; INKEY Function
	; Returns a string allocated in dynamic memory
	; containing the string.
	; An empty string otherwise.
	
#line 1 "alloc.asm"
; vim: ts=4:et:sw=4:
	; Copyleft (K) by Jose M. Rodriguez de la Rosa
	;  (a.k.a. Boriel) 
;  http://www.boriel.com
	;
	; This ASM library is licensed under the BSD license
	; you can use it for any purpose (even for commercial
	; closed source programs).
	;
	; Please read the BSD license on the internet
	
	; ----- IMPLEMENTATION NOTES ------
	; The heap is implemented as a linked list of free blocks.
	
; Each free block contains this info:
	; 
	; +----------------+ <-- HEAP START 
	; | Size (2 bytes) |
	; |        0       | <-- Size = 0 => DUMMY HEADER BLOCK
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   | <-- If Size > 4, then this contains (size - 4) bytes
	; | (0 if Size = 4)|   |
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   |
	; | (0 if Size = 4)|   |
	; +----------------+   |
	;   <Allocated>        | <-- This zone is in use (Already allocated)
	; +----------------+ <-+ 
	; | Size (2 bytes) |
	; +----------------+
	; | Next (2 bytes) |---+
	; +----------------+   |
	; | <free bytes...>|   |
	; | (0 if Size = 4)|   |
	; +----------------+ <-+ 
	; | Next (2 bytes) |--> NULL => END OF LIST
	; |    0 = NULL    |
	; +----------------+
	; | <free bytes...>|
	; | (0 if Size = 4)|
	; +----------------+
	
	
	; When a block is FREED, the previous and next pointers are examined to see
	; if we can defragment the heap. If the block to be breed is just next to the
	; previous, or to the next (or both) they will be converted into a single
	; block (so defragmented).
	
	
	;   MEMORY MANAGER
	;
	; This library must be initialized calling __MEM_INIT with 
	; HL = BLOCK Start & DE = Length.
	
	; An init directive is useful for initialization routines.
	; They will be added automatically if needed.
	
	
	
	
	
	; ---------------------------------------------------------------------
	; MEM_ALLOC
	;  Allocates a block of memory in the heap.
	;
	; Parameters
	;  BC = Length of requested memory block
	;
; Returns:
	;  HL = Pointer to the allocated block in memory. Returns 0 (NULL)
	;       if the block could not be allocated (out of memory)
	; ---------------------------------------------------------------------
	
MEM_ALLOC:
__MEM_ALLOC: ; Returns the 1st free block found of the given length (in BC)
	        PROC
	
	        LOCAL __MEM_LOOP
	        LOCAL __MEM_DONE
	        LOCAL __MEM_SUBTRACT
	        LOCAL __MEM_START
	        LOCAL TEMP
	
	        ld hl, 0
	        ld (TEMP), hl
	
__MEM_START:
	        ld hl, ZXBASIC_MEM_HEAP  ; This label point to the heap start
	        inc bc
	        inc bc  ; BC = BC + 2 ; block size needs 2 extra bytes for hidden pointer
	        
__MEM_LOOP:  ; Loads lengh at (HL, HL+). If Lenght >= BC, jump to __MEM_DONE
	        ld a, h ;  HL = NULL (No memory available?)
	        or l
#line 109 "/home/boriel/src/zxb/trunk/library-asm/alloc.asm"
	        ret z ; NULL
#line 111 "/home/boriel/src/zxb/trunk/library-asm/alloc.asm"
	        ; HL = Pointer to Free block
	        ld e, (hl)
	        inc hl
	        ld d, (hl)
	        inc hl          ; DE = Block Length
	        
	        push hl         ; HL = *pointer to -> next block
	        ex de, hl
	        or a            ; CF = 0
	        sbc hl, bc      ; FREE >= BC (Length)  (HL = BlockLength - Length)
	        jp nc, __MEM_DONE
	        pop hl
	        ld (TEMP), hl
	
	        ex de, hl
	        ld e, (hl)
	        inc hl
	        ld d, (hl)
	        ex de, hl
	        jp __MEM_LOOP
	        
__MEM_DONE:  ; A free block has been found. 
	             ; Check if at least 4 bytes remains free (HL >= 4)
	        push hl
	        exx  ; exx to preserve bc
	        pop hl
	        ld bc, 4
	        or a
	        sbc hl, bc
	        exx
	        jp nc, __MEM_SUBTRACT
	        ; At this point...
	        ; less than 4 bytes remains free. So we return this block entirely
	        ; We must link the previous block with the next to this one
	        ; (DE) => Pointer to next block
	        ; (TEMP) => &(previous->next)
	        pop hl     ; Discard current block pointer
	        push de
	        ex de, hl  ; DE = Previous block pointer; (HL) = Next block pointer
	        ld a, (hl)
	        inc hl
	        ld h, (hl)
	        ld l, a    ; HL = (HL)
	        ex de, hl  ; HL = Previous block pointer; DE = Next block pointer
	        ld hl, (TEMP) ; Pre-previous block pointer
	
	        ld (hl), e
	        inc hl
	        ld (hl), d ; LINKED
	        pop hl ; Returning block.
	        
	        ret
	
__MEM_SUBTRACT:
	        ; At this point we have to store HL value (Length - BC) into (DE - 2)
	        ex de, hl
	        dec hl
	        ld (hl), d
	        dec hl
	        ld (hl), e ; Store new block length
	        
	        add hl, de ; New length + DE => free-block start
	        pop de     ; Remove previous HL off the stack
	
	        ld (hl), c ; Store length on its 1st word
	        inc hl
	        ld (hl), b
	        inc hl     ; Return hl
	        ret
	            
	TEMP    EQU 23563   ; DEFADD variable
	
	        ENDP
	
	
#line 7 "inkey.asm"
	
INKEY:
		PROC 
		LOCAL __EMPTY_INKEY
		LOCAL KEY_SCAN
		LOCAL KEY_TEST
		LOCAL KEY_CODE
	
		ld bc, 3	; 1 char length string 
		call __MEM_ALLOC
	
		ld a, h
		or l
		ret z	; Return if NULL (No memory)
	
		push hl ; Saves memory pointer
	
		call KEY_SCAN
		jp nz, __EMPTY_INKEY
		
		call KEY_TEST
		jp nc, __EMPTY_INKEY
	
		dec d	; D is expected to be FLAGS so set bit 3 $FF
				; 'L' Mode so no keywords.
		ld e, a	; main key to A
				; C is MODE 0 'KLC' from above still.
		call KEY_CODE ; routine K-DECODE
		pop hl
	
		ld (hl), 1
		inc hl
		ld (hl), 0
		inc hl
		ld (hl), a
		dec hl
		dec hl	; HL Points to string result
		ret
	
__EMPTY_INKEY:
		pop hl
		xor a
		ld (hl), a
		inc hl
		ld (hl), a
		dec hl
		ret
	
	KEY_SCAN	EQU 028Eh
	KEY_TEST	EQU 031Eh
	KEY_CODE	EQU 0333h
	
		ENDP
	
#line 787 "dark3.bas"
	
ZXBASIC_USER_DATA:
_gw:
	DEFB 00
_znh:
	DEFB 00
_tn:
	DEFB 00
_mt:
	DEFB 00
_znw:
	DEFB 00
_rn:
	DEFB 00
_gh:
	DEFB 00
_y:
	DEFW 0001h
	DEFW 0004h
	DEFB 02h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
_x:
	DEFW 0001h
	DEFW 0004h
	DEFB 02h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
	DEFB 00h
ZXBASIC_MEM_HEAP:
	; Defines DATA END
ZXBASIC_USER_DATA_END EQU ZXBASIC_MEM_HEAP + ZXBASIC_HEAP_SIZE
	; Defines USER DATA Length in bytes
ZXBASIC_USER_DATA_LEN EQU ZXBASIC_USER_DATA_END - ZXBASIC_USER_DATA
	END
